#include "FilterDesign.h"
#include "Filter.h"

    // Notch 25 Hz 
    double v1_25 = 0, v2_25 = 0;
    const double a1_25 = -1.52753439307, a2_25 = 0.60559524000;
    const double b0_25 = 1.00000000000, b1_25 = -1.90211303259, b2_25 = 1.00000000000;
    const double gain_25 = 0.80000000000;
    
    // Notch 50 Hz 
    double v1_50 = 0, v2_50 = 0;
    const double a1_50 = -1.53713228931, a2_50 = 0.90250000000;
    const double b0_50 = 1.00000000000, b1_50 = -1.61803398875, b2_50 = 1.00000000000;
    const double gain_50 = 0.95500000000;
    
    // High pass 10 Hz
    double v1_HP = 0, v2_HP = 0;
    const double a1_HP = -1.91258127190, a2_HP = 0.91680625000;
    const double b0_HP = 1.00000000000, b1_HP = -2.00000000000, b2_HP = 1.00000000000;
    const double gain_HP = 0.95500000000;

    // Low pass 2 Hz
    double v1_LP = 0, v2_LP = 0;
    const double a1_LP =  -1.99277224437, a2_LP = 0.99281296000;
    const double b0_LP = 1.00000000000, b1_LP = 2.00000000000, b2_LP = 1.00000000000;
    const double gain_LP = 0.0001000000000;

double FilterDesign(double u_E)
{
    double y_25 = Filter(u_E,v1_25,v2_25,a1_25,a2_25,b0_25,b1_25,b2_25,gain_25);
    double y_50 = Filter(y_25,v1_50,v2_50,a1_50,a2_50,b0_50,b1_50,b2_50,gain_50);
    double y_HP = Filter(y_50,v1_HP,v2_HP,a1_HP,a2_HP,b0_HP,b1_HP,b2_HP,gain_HP);
    double y_abs = fabs(y_HP);
    double y_LP = Filter(y_abs,v1_LP,v2_LP,a1_LP,a2_LP,b0_LP,b1_LP,b2_LP,gain_LP);
    
    double y_E = y_LP;
    
    return y_E; 
    
}