// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#include "mbed.h"
#include <stddef.h>
#include "azure_c_shared_utility/tcpsocketconnection_c.h"
#include "azure_c_shared_utility/platform.h"

typedef struct {
    TCPSocket* socket;
    bool connected;
} TCPSOCKETCONNECTION_HANDLE_T;

TCPSOCKETCONNECTION_HANDLE tcpsocketconnection_create(void)
{
    TCPSOCKETCONNECTION_HANDLE_T* conn = new TCPSOCKETCONNECTION_HANDLE_T;
    conn->socket = new TCPSocket(platform_get_network_stack());
    conn->connected = false;
    return conn;
}

void tcpsocketconnection_set_blocking(TCPSOCKETCONNECTION_HANDLE tcpSocketConnectionHandle, bool blocking, unsigned int timeout)
{
    TCPSOCKETCONNECTION_HANDLE_T* tsc = (TCPSOCKETCONNECTION_HANDLE_T*)tcpSocketConnectionHandle;
    tsc->socket->set_blocking(blocking);
    tsc->socket->set_timeout(timeout);
}

void tcpsocketconnection_destroy(TCPSOCKETCONNECTION_HANDLE tcpSocketConnectionHandle)
{
    delete (TCPSOCKETCONNECTION_HANDLE_T*)tcpSocketConnectionHandle;
}

int tcpsocketconnection_connect(TCPSOCKETCONNECTION_HANDLE tcpSocketConnectionHandle, const char* host, const int port)
{
    TCPSOCKETCONNECTION_HANDLE_T* tsc = (TCPSOCKETCONNECTION_HANDLE_T*)tcpSocketConnectionHandle;
    // TODO: so, we set this but we really need to kill it if we get an error later too.....
    auto rv = tsc->socket->connect(host, port);
    if(rv == 0) { tsc->connected = true; }
    return rv;
}

bool tcpsocketconnection_is_connected(TCPSOCKETCONNECTION_HANDLE tcpSocketConnectionHandle)
{
    TCPSOCKETCONNECTION_HANDLE_T* tsc = (TCPSOCKETCONNECTION_HANDLE_T*)tcpSocketConnectionHandle;
    return tsc->connected;
}

void tcpsocketconnection_close(TCPSOCKETCONNECTION_HANDLE tcpSocketConnectionHandle)
{
    TCPSOCKETCONNECTION_HANDLE_T* tsc = (TCPSOCKETCONNECTION_HANDLE_T*)tcpSocketConnectionHandle;
    tsc->socket->close();
}

int tcpsocketconnection_send(TCPSOCKETCONNECTION_HANDLE tcpSocketConnectionHandle, const char* data, int length)
{
    TCPSOCKETCONNECTION_HANDLE_T* tsc = (TCPSOCKETCONNECTION_HANDLE_T*)tcpSocketConnectionHandle;
    return tsc->socket->send((char*)data, length);
}

int tcpsocketconnection_send_all(TCPSOCKETCONNECTION_HANDLE tcpSocketConnectionHandle, const char* data, int length)
{
    TCPSOCKETCONNECTION_HANDLE_T* tsc = (TCPSOCKETCONNECTION_HANDLE_T*)tcpSocketConnectionHandle;
    // TODO: this is shonky and quickly done....

    auto rv = tsc->socket->send((char*)data, length);

    if(rv < 0 || rv == length) {
        return rv;
    }

    auto remain = length - rv;

    while(rv > 0 && remain > 0) {
        data = data + rv;
        rv = tsc->socket->send((char*)data, length);
        remain = length - rv;
    }

    return rv;
}

int tcpsocketconnection_receive(TCPSOCKETCONNECTION_HANDLE tcpSocketConnectionHandle, char* data, int length)
{
    TCPSOCKETCONNECTION_HANDLE_T* tsc = (TCPSOCKETCONNECTION_HANDLE_T*)tcpSocketConnectionHandle;
    return tsc->socket->recv(data, length);
}

int tcpsocketconnection_receive_all(TCPSOCKETCONNECTION_HANDLE tcpSocketConnectionHandle, char* data, int length)
{
    TCPSOCKETCONNECTION_HANDLE_T* tsc = (TCPSOCKETCONNECTION_HANDLE_T*)tcpSocketConnectionHandle;
    // TODO: this is shonky and quickly done....

    auto rv = tsc->socket->recv((char*)data, length);

    if(rv < 0 || rv == length) {
        return rv;
    }

    auto remain = length - rv;

    while(rv > 0 && remain > 0) {
        data = data + rv;
        rv = tsc->socket->recv((char*)data, length);
        remain = length - rv;
    }

    return rv;
}
