// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#ifndef PLATFORM_H
#define PLATFORM_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "azure_c_shared_utility/strings.h"
#include "azure_c_shared_utility/xio.h"
#include "azure_c_shared_utility/umock_c_prod.h"

    typedef struct NetworkInterface NetworkInterface;

    MOCKABLE_FUNCTION(, int, platform_init, NetworkInterface*, net);
    MOCKABLE_FUNCTION(, void, platform_deinit);
    MOCKABLE_FUNCTION(, const IO_INTERFACE_DESCRIPTION*, platform_get_default_tlsio);
    MOCKABLE_FUNCTION(, STRING_HANDLE, platform_get_platform_info);

    MOCKABLE_FUNCTION(, NetworkInterface*, platform_get_network_stack);
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* PLATFORM_H */
