// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.

#include "azure_c_shared_utility/platform.h"
#include "EthernetInterface.h"
#include "NetworkInterface.h"

#include "azure_c_shared_utility/optimize_size.h"
#include "azure_c_shared_utility/xio.h"
#include "azure_c_shared_utility/tlsio_wolfssl.h"

static NetworkInterface* _platform_mbed_network;

int platform_init(NetworkInterface* net)
{
    int result = 0;
    _platform_mbed_network = net;
    return result;
}

const IO_INTERFACE_DESCRIPTION* platform_get_default_tlsio(void)
{
    return tlsio_wolfssl_get_interface_description();
}

STRING_HANDLE platform_get_platform_info(void)
{
    return STRING_construct("(mbed)");
}

void platform_deinit(void) {}

NetworkInterface* platform_get_network_stack() {
    return _platform_mbed_network;
}
