#include "Led_Lcd.h"

LCD_DISCO_F429ZI lcd;

#define RECTANGLE_SIZE 80

LedLcd::LedLcd(unsigned char ucButtonPos): ucButtonDisplayMode(ucButtonPos){}

void LedLcd::Column(void)
{
    switch(ucButtonDisplayMode)
    {
        case 0:
            uiXpos=0;
            break;
        case 1:
            uiXpos=80;
            break;
        default:
            uiXpos=160;
            
    }
}

void LedLcd::On(unsigned char ucLedNr)
{
    Column();
    char cNr[2] ="0";
    for(unsigned int uiButtonCtr=0;uiButtonCtr<4;uiButtonCtr++)
    {
        if(ucLedNr==uiButtonCtr)
        {
            lcd.SetTextColor(LCD_COLOR_YELLOW);
        }else
        {
            lcd.SetTextColor(LCD_COLOR_BLUE);
        }
        lcd.FillRect(uiXpos, uiButtonCtr*RECTANGLE_SIZE, RECTANGLE_SIZE, RECTANGLE_SIZE);
        lcd.SetTextColor(LCD_COLOR_GREEN);
        lcd.DrawRect(uiXpos, uiButtonCtr*RECTANGLE_SIZE, RECTANGLE_SIZE, RECTANGLE_SIZE);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.DisplayStringAt(uiXpos, uiButtonCtr*RECTANGLE_SIZE, (uint8_t *)cNr , LEFT_MODE);
        cNr[0]=cNr[0] + 1;
    }
}
