#include "Keyboard_Ts.h"
#include "TS_DISCO_F429ZI.h"

TS_DISCO_F429ZI ts;

TS_StateTypeDef TS_State;

#define RECTANGLE_SIZE 80

KeyboardTs::KeyboardTs(unsigned char ucColumnPos): ucColumnPos(ucColumnPos){}

KeyboardState enumTab[]={ BUTTON_0, BUTTON_1, BUTTON_2, BUTTON_3 };

enum KeyboardState KeyboardTs::eRead(void)
{
    ts.GetState(&TS_State);
    unsigned int uiX;
    unsigned int uiY;
    if (TS_State.TouchDetected)
    {
        uiX=TS_State.X;
        uiY=TS_State.Y;
        
        if((uiX > (RECTANGLE_SIZE * ucColumnPos)) && (uiX < (RECTANGLE_SIZE * (ucColumnPos+1))))
        {
            return enumTab[uiY/RECTANGLE_SIZE];
        }
    }
    return RELASED;
}



