#ifndef __KEYBOARDTSLCD_H
#define __KEYBOARDTSLCD_H

#include "KeyboardTsLcd.h"

extern LCD_DISCO_F429ZI lcd;


KeyboardTsLcd::KeyboardTsLcd(unsigned char _ucColumn)
{
    
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    pKeyboard = new KeyboardTs(_ucColumn);
    pLed = new LedLcd(_ucColumn);
    pLed_2 = new LedLcd(2);
};

void KeyboardTsLcd::eRead(void)
{
    switch(pKeyboard -> eRead()) 
    {
        case BUTTON_0:
            pLed -> On(0);
            pLed_2 -> On(3);
            break;
        case BUTTON_1:
            pLed -> On(1);
            pLed_2 -> On(2);
            break;
        case BUTTON_2:
            pLed -> On(2);
            pLed_2 -> On(1);
            break;
        case BUTTON_3:
            pLed -> On(3);
            pLed_2 -> On(0);
            break;
        default :
            pLed -> On(4);
            pLed_2 -> On(4);
            break;
    }
}




#endif