#include "mbed.h"
#include "BLE_API/ble/BLE.h"
#include "X_NUCLEO_IKS01A2/XNucleoIKS01A2.h"
#include "BLE_API/ble/services/EnvironmentalService.h"
#include "BLE_API/ble/services/DeviceInformationService.h"
//create a DigitalOut object for the LED
DigitalOut led(LED1, 1);
//two Ticker object for interrupts
Ticker update;
Ticker aliveness;
//create varaibles for sensors
float TEMPERATURE_C = 20;
float PRESSURE = 1000;
//create a serial objects to communicate via USB
Serial pc(USBTX, USBRX);
//device name specific
const static char     DEVICE_NAME[]        = "WEATHER_STATION";
static const uint16_t uuid16_list[]        = {GattService::UUID_ENVIRONMENTAL_SERVICE,
                                              GattService::UUID_DEVICE_INFORMATION_SERVICE};
//bool variable for control updating of ble
static volatile bool  triggerSensorPolling = false;

/* Instantiate the sensor expansion board */
static XNucleoIKS01A2 *sensor = XNucleoIKS01A2::instance(D14, D15, D4, D5);


void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    (void)params;
    BLE::Instance().gap().startAdvertising(); // restart advertising
}

void update_handler(void)
{    triggerSensorPolling = true;}

void aliveness_handler (void)
{   led = !led; }


void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

    if (ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }

    ble.gap().onDisconnection(disconnectionCallback);

    /* Setup primary service. */
    EnvironmentalService environment(ble);
    DeviceInformationService deviceInfo(ble, "ST", "Nucleo", "SN1" );

    /* Setup advertising. */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::GENERIC_THERMOMETER);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(1000); /* 1000ms */
    ble.gap().startAdvertising();

    // infinite loop
    while (true) {
        // check for trigger from periodicCallback()
        if (triggerSensorPolling && ble.getGapState().connected) {
            triggerSensorPolling = false;
            /* Read enviornmental sensor */
            sensor->ht_sensor->get_temperature((float *)&TEMPERATURE_C);
            sensor->pt_sensor->get_pressure((float *)&PRESSURE);
            


            //pass the parameter through Serial by USB
            pc.printf("Temperature:\t %.2f C%\r\n", TEMPERATURE_C);
            pc.printf("Pressure:\t %.2f hPa\r\n", PRESSURE); 
            
            // update bps
            environment.updateTemperature(TEMPERATURE_C);
            environment.updatePressure(PRESSURE);

            
        } else {
            ble.waitForEvent(); // low power wait for event
        }
    }
}

int main(void)
{
    update.attach(update_handler, 1);
    aliveness.attach(aliveness_handler,0.5);
    BLE::Instance().init(bleInitComplete);
}
