/* Includes */
#include "mbed.h"
#include "XNucleoIKS01A2.h"

// create a DigitalOut objects for the LED
DigitalOut led(LED1);

/* Instantiate the expansion board */
static XNucleoIKS01A2 *sensor = XNucleoIKS01A2::instance(D14, D15, D4, D5);


// Create 2 Ticker objects for a recurring interrupts. One for blink a LED and the other one to update the sensor lectures periodicly.
Ticker blinky; 
Ticker update;

/* create a serial objects to communicate via USB */
Serial pc(USBTX, USBRX);

volatile float TEMPERATURE_C;
volatile float TEMPERATURE_F;
volatile float TEMPERATURE_K;
volatile float HUMIDITY;
volatile float PRESSURE;

bool measurement_update = false;

void blinky_handler()
{
    led = !led;   
}

void sensor_handler()
{
    measurement_update = true;    
}

int main()
{
    /* Attach a function to be called by the Ticker objects at a specific interval in seconds*/
    blinky.attach(&blinky_handler, 0.5);
    update.attach(&sensor_handler, 3);
    
    while(1){
        if (measurement_update == true){
            /* read the enviornmental data from sensors */
            sensor->ht_sensor->get_temperature((float *)&TEMPERATURE_C);
            sensor->ht_sensor->get_humidity((float *)&HUMIDITY);
            sensor->pt_sensor->get_pressure((float *)&PRESSURE);
        
            TEMPERATURE_F = (TEMPERATURE_C * 1.8f) + 32.0f; //Convert the temperature from Celsius to Fahrenheit
            TEMPERATURE_K = (TEMPERATURE_C + 273.15f);          //Convert the temperature from Celsius to Kelvin
            pc.printf("Temperature:\t %.2f C / %.2f F / %.2f K\r\n", TEMPERATURE_C, TEMPERATURE_F, TEMPERATURE_K);
            pc.printf("Humidity:\t %.2f%%\r\n", HUMIDITY);
            pc.printf("Pressure:\t %.2f hPa\r\n", PRESSURE); 
            pc.printf("\r\n");        
            measurement_update = false;
        }
        __wfi();
    }
}