// /*******************************************************************************
// * Copyright (C) 2020 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */ * MANUAL EDITS PRESENT *
#include "CmdLine.h"
#include "MaximTinyTester.h"
// CODE GENERATOR: class declaration and docstrings
// CODE GENERATOR: example code includes
// example code includes
// standard include for target platform -- Platform_Include_Boilerplate
#include "mbed.h"
// Platforms:
//   - MAX32625MBED
//      - supports mbed-os-5.11, requires USBDevice library
//      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32600MBED
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
//   - NUCLEO_F446RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - NUCLEO_F401RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32630FTHR
//      - #include "max32630fthr.h"
//      - add http://os.mbed.org/teams/MaximIntegrated/code/max32630fthr/
//      - remove MAX32620FTHR library (if present)
//   - MAX32620FTHR
//      - #include "MAX32620FTHR.h"
//      - remove max32630fthr library (if present)
//      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
//      - not tested yet
//   - MAX32625PICO
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - not tested yet
//
// end Platform_Include_Boilerplate
#include "MAX11043.h"
#include "CmdLine.h"
#include "MaximTinyTester.h"
// CODE GENERATOR: class declaration statement open

// CODE GENERATOR: Test_Menu externs
#include "MAX11043.h"
extern MAX11043 g_MAX11043_device; // defined in main.cpp

//--------------------------------------------------
// Diagnostic: Read 4 command -- Single 4-channel read: CONVRUN pulsed H then L, EOC ignored.
#ifndef Has_Read4Command_Command
#define Has_Read4Command_Command 1
#endif // Has_Read4Command_Command
#if Has_Read4Command_Command
#endif // Has_Read4Command_Command
//--------------------------------------------------
// Diagnostic: Read 4 command -- Single 4-channel read: CONVRUN pulsed H then L, EOC ignored.
#ifndef Use_Read4Command_Thread
#define Use_Read4Command_Thread 1
#endif // Use_Read4Command_Thread
#if Use_Read4Command_Thread
#endif // Use_Read4Command_Thread

//--------------------------------------------------
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
#ifndef MAX11043_ScopeTrigger_MAX32625MBED_D5
#define MAX11043_ScopeTrigger_MAX32625MBED_D5 1
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
// WIP MAX11043 interrupt EOC echo - moving DigitalOut ScopeTrigger to global scope, it compiles but there is no activity on scope
extern DigitalInOut digitalInOut5; // declared in Test_Main_MAX11043.cpp (D5, PIN_INPUT, PullUp, 1) 
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5

#if Use_Read4Command_Thread
#define MYTIMEREVENTFLAG_ENABLE_SPI     (1UL << 0)
#define MYTIMEREVENTFLAG_RESET_MINMAX   (1UL << 1)
#define MYTIMEREVENTFLAG_FAKE_DATA      (1UL << 2)
EventFlags Read4Command_Thread_event_flags;
Thread Read4Command_Thread;
int adca_newest = 0;
int adcb_newest = 0;
int adcc_newest = 0;
int adcd_newest = 0;
int adcX_MIN_SEEN_INIT_INT16_MAX = 0x7FFF; // INT16_MAX
int adcX_MAX_SEEN_INIT_INT16_MIN = 0x8000; // INT16_MIN
int adca_MIN_SEEN = adcX_MIN_SEEN_INIT_INT16_MAX;
int adca_MAX_SEEN = adcX_MAX_SEEN_INIT_INT16_MIN;
int adcb_MIN_SEEN = adcX_MIN_SEEN_INIT_INT16_MAX;
int adcb_MAX_SEEN = adcX_MAX_SEEN_INIT_INT16_MIN;
int adcc_MIN_SEEN = adcX_MIN_SEEN_INIT_INT16_MAX;
int adcc_MAX_SEEN = adcX_MAX_SEEN_INIT_INT16_MIN;
int adcd_MIN_SEEN = adcX_MIN_SEEN_INIT_INT16_MAX;
int adcd_MAX_SEEN = adcX_MAX_SEEN_INIT_INT16_MIN;
#endif // Use_Read4Command_Thread
#if Use_Read4Command_Thread
void Read4Command_Thread_handler()
{
    const int convrun_pulse_width_us = 30;
    const int convrun_stop_us = 10;
    // running in thread context in Thread Read4Command_Thread
    // operate the SPI interface at specified sample rate
    // shared read only: periodicInterruptTimer_interval_usec
    while (true) {
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
        //~ digitalInOut5.write(0); // ScopeTrigger
        digitalInOut5.write(1); // ScopeTrigger
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
        //signal_wait(int32_t signals, uint32_t millisec=osWaitForever)
        //flags_read = Read4Command_Thread_event_flags.wait_any(MYTIMEREVENTFLAG_ENABLE_SPI);
        Read4Command_Thread_event_flags.wait_any(MYTIMEREVENTFLAG_ENABLE_SPI, osWaitForever, false); // clear=false: don't auto clear the flag
        //
        if (Read4Command_Thread_event_flags.get() & MYTIMEREVENTFLAG_RESET_MINMAX)
        {
            adca_MIN_SEEN = +32767; // adcX_MIN_SEEN_INIT_INT16_MAX
            adcb_MIN_SEEN = +32767; // adcX_MIN_SEEN_INIT_INT16_MAX
            adcc_MIN_SEEN = +32767; // adcX_MIN_SEEN_INIT_INT16_MAX
            adcd_MIN_SEEN = +32767; // adcX_MIN_SEEN_INIT_INT16_MAX
            //
            adca_MAX_SEEN = -32768; // adcX_MAX_SEEN_INIT_INT16_MIN
            adcb_MAX_SEEN = -32768; // adcX_MAX_SEEN_INIT_INT16_MIN
            adcc_MAX_SEEN = -32768; // adcX_MAX_SEEN_INIT_INT16_MIN
            adcd_MAX_SEEN = -32768; // adcX_MAX_SEEN_INIT_INT16_MIN
            //
            Read4Command_Thread_event_flags.clear(MYTIMEREVENTFLAG_RESET_MINMAX);
        }
        //
        // CONVRUN = H -- perform ADC conversions (EOC will pulse, and data registers will update)
        g_MAX11043_device.CONVRUNoutputValue(1);
        //
        // delay at least 9us to ensure at least one converion happens
        wait_us(convrun_pulse_width_us);
        //
        // CONVRUN = L -- stop ADC conversions
        g_MAX11043_device.CONVRUNoutputValue(0);
        //
        // delay at least 9us to ensure final converion complete
        wait_us(convrun_stop_us);
        //
        // run SPI to capture 4 channels
        if (Read4Command_Thread_event_flags.get() & MYTIMEREVENTFLAG_FAKE_DATA)
        {
            // raw uint32_t result code
            g_MAX11043_device.adca = 0x7FFF; // +32767 adcX_MIN_SEEN_INIT_INT16_MAX;
            g_MAX11043_device.adcb = 0x000A; // +10
            g_MAX11043_device.adcc = 0xFFF6; // -10
            g_MAX11043_device.adcd = 0x8000; // -32768 adcX_MAX_SEEN_INIT_INT16_MIN;
            
            // are the initial MIN/MAX swapped? adcX_MAX_SEEN_INIT_INT16_MIN adcX_MIN_SEEN_INIT_INT16_MAX
            adca_MIN_SEEN = +32767; // adcX_MIN_SEEN_INIT_INT16_MAX
            adcb_MIN_SEEN = +32767; // adcX_MIN_SEEN_INIT_INT16_MAX
            adcc_MIN_SEEN = +32767; // adcX_MIN_SEEN_INIT_INT16_MAX
            adcd_MIN_SEEN = +32767; // adcX_MIN_SEEN_INIT_INT16_MAX
            //
            adca_MAX_SEEN = -32768; // adcX_MAX_SEEN_INIT_INT16_MIN
            adcb_MAX_SEEN = -32768; // adcX_MAX_SEEN_INIT_INT16_MIN
            adcc_MAX_SEEN = -32768; // adcX_MAX_SEEN_INIT_INT16_MIN
            adcd_MAX_SEEN = -32768; // adcX_MAX_SEEN_INIT_INT16_MIN
        }
        else
        {
            g_MAX11043_device.Read_ADCabcd();
        }
        // post: g_MAX11043_device.adca was updated
        // post: g_MAX11043_device.adcb was updated
        // post: g_MAX11043_device.adcc was updated
        // post: g_MAX11043_device.adcd was updated
        //
        // TODO: capture min/max 2's complement value each channel
        // #define SIGN_EXTEND_INT16_VALUE(x) (((x)&(0x8000))?((x)-65536):(x))
        // adca_newest = SIGN_EXTEND_INT16_VALUE(g_MAX11043_device.adca);
        // adcb_newest = SIGN_EXTEND_INT16_VALUE(g_MAX11043_device.adcb);
        // adcc_newest = SIGN_EXTEND_INT16_VALUE(g_MAX11043_device.adcc);
        // adcd_newest = SIGN_EXTEND_INT16_VALUE(g_MAX11043_device.adcd);
        adca_newest = g_MAX11043_device.adca; // if (adca_newest & 0x8000) { adca_newest = adca_newest - 65536; }
        adcb_newest = g_MAX11043_device.adcb; // if (adcb_newest & 0x8000) { adcb_newest = adcb_newest - 65536; }
        adcc_newest = g_MAX11043_device.adcc; // if (adcc_newest & 0x8000) { adcc_newest = adcc_newest - 65536; }
        adcd_newest = g_MAX11043_device.adcd; // if (adcd_newest & 0x8000) { adcd_newest = adcd_newest - 65536; }
        // 2020-02-26 this fails because using LDRHI instruction (unsigned comparison), must use signed instead.
        // Try SIGN_EXTEND_INT16_VALUE to force signed comparison (ldrGE, ldrLT, ldrGT, ldrLE) instead of unsigned comparision (ldrHS, ldrLO, ldrHI, ldrLS)
        if (adca_MAX_SEEN < adca_newest) {
            adca_MAX_SEEN = adca_newest;
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
            if (Read4Command_Thread_event_flags.get() & MYTIMEREVENTFLAG_FAKE_DATA == 0)
            {
            digitalInOut5.write(0); // ScopeTrigger
            wait_us(5);
            digitalInOut5.write(1); // ScopeTrigger
            }
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
        }
        if (adca_MIN_SEEN > adca_newest) {
            adca_MIN_SEEN = adca_newest;
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
            if (Read4Command_Thread_event_flags.get() & MYTIMEREVENTFLAG_FAKE_DATA == 0)
            {
            digitalInOut5.write(0); // ScopeTrigger
            wait_us(10);
            digitalInOut5.write(1); // ScopeTrigger
            }
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
        }
        if (adcb_MAX_SEEN < adcb_newest) {
            adcb_MAX_SEEN = adcb_newest;
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
            if (Read4Command_Thread_event_flags.get() & MYTIMEREVENTFLAG_FAKE_DATA == 0)
            {
            digitalInOut5.write(0); // ScopeTrigger
            wait_us(15);
            digitalInOut5.write(1); // ScopeTrigger
            }
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
        }
        if (adcb_MIN_SEEN > adcb_newest) {
            adcb_MIN_SEEN = adcb_newest;
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
            if (Read4Command_Thread_event_flags.get() & MYTIMEREVENTFLAG_FAKE_DATA == 0)
            {
            digitalInOut5.write(0); // ScopeTrigger
            wait_us(20);
            digitalInOut5.write(1); // ScopeTrigger
            }
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
        }
        if (adcc_MAX_SEEN < adcc_newest) {
            adcc_MAX_SEEN = adcc_newest;
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
            if (Read4Command_Thread_event_flags.get() & MYTIMEREVENTFLAG_FAKE_DATA == 0)
            {
            digitalInOut5.write(0); // ScopeTrigger
            wait_us(15);
            digitalInOut5.write(1); // ScopeTrigger
            }
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
        }
        if (adcc_MIN_SEEN > adcc_newest) {
            adcc_MIN_SEEN = adcc_newest;
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
            if (Read4Command_Thread_event_flags.get() & MYTIMEREVENTFLAG_FAKE_DATA == 0)
            {
            digitalInOut5.write(0); // ScopeTrigger
            wait_us(20);
            digitalInOut5.write(1); // ScopeTrigger
            }
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
        }
        if (adcd_MAX_SEEN < adcd_newest) {
            adcd_MAX_SEEN = adcd_newest;
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
            if (Read4Command_Thread_event_flags.get() & MYTIMEREVENTFLAG_FAKE_DATA == 0)
            {
            digitalInOut5.write(0); // ScopeTrigger
            wait_us(15);
            digitalInOut5.write(1); // ScopeTrigger
            }
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
        }
        if (adcd_MIN_SEEN > adcd_newest) {
            adcd_MIN_SEEN = adcd_newest;
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
            if (Read4Command_Thread_event_flags.get() & MYTIMEREVENTFLAG_FAKE_DATA == 0)
            {
            digitalInOut5.write(0); // ScopeTrigger
            wait_us(20);
            digitalInOut5.write(1); // ScopeTrigger
            }
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
        }
        // TODO: compare with thresholds, report if exceeded
        //
        // blocking delay time us_timestamp_t periodicInterruptTimer_interval_usec
        //~ const us_timestamp_t overhead_usec = 24;
        //~ if (periodicInterruptTimer_interval_usec > overhead_usec) {
            //~ wait_us(periodicInterruptTimer_interval_usec - overhead_usec);
        //~ }
    }
}
#endif // Use_Read4Command_Thread
#if Use_Read4Command_Thread
    //~ Read4Command_Thread_event_flags.set(MYTIMEREVENTFLAG_ENABLE_SPI);
#endif // Use_Read4Command_Thread
#if Use_Read4Command_Thread
    //~ Read4Command_Thread_event_flags.clear(MYTIMEREVENTFLAG_ENABLE_SPI);
#endif // Use_Read4Command_Thread
#if Use_Read4Command_Thread
    // init
    //~ Read4Command_Thread.start(Read4Command_Thread_handler);
#endif // Use_Read4Command_Thread

// CODE GENERATOR: build testMenuCommand list
// CODE GENERATOR: build testMenuGlobalArgsDict common/global argument list
// CODE GENERATOR: class member function declarations
// CODE GENERATOR: MAX11043 Command Name = Init (void) --> uint8_t
// CODE GENERATOR: Menu item hint description Menu item '!'
// CODE GENERATOR: Menu item '!' -- Menu item !
// CODE GENERATOR: test menu case '!':
// CODE GENERATOR:           helpString '! -- Init'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Init'
// CODE GENERATOR:           CommandParamIn 'void'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn ''
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR: MAX11043 Command Name = RegWrite (MAX11043_CMD_enum_t commandByte, uint32_t regData) --> uint8_t
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11043 Command Name = RegRead (MAX11043_CMD_enum_t commandByte, uint32_t* ptrRegData) --> uint8_t
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11043 Command Name = RegSize (MAX11043_CMD_enum_t commandByte) --> uint8_t
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11043 Command Name = DecodeCommand (MAX11043_CMD_enum_t commandByte) --> MAX11043::MAX11043_CMDOP_enum_t
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11043 Command Name = RegAddrOfCommand (MAX11043_CMD_enum_t commandByte) --> uint8_t
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11043 Command Name = IsRegReadCommand (MAX11043_CMD_enum_t commandByte) --> uint8_t
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11043 Command Name = RegName (MAX11043_CMD_enum_t commandByte) --> const char*
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11043 Command Name = Read_ADCabcd (void) --> uint8_t
// CODE GENERATOR: Menu item hint description Menu item '$' -> adca, adcb, adcc, adcd
// CODE GENERATOR: Menu item '$' -> adca, adcb, adcc, adcd -- Menu item $
// CODE GENERATOR: test menu case '$':
// CODE GENERATOR:           helpString '$ -- Read_ADCabcd'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Read_ADCabcd'
// CODE GENERATOR:           CommandParamIn 'void'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn ''
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR: MAX11043 Command Name = Write_AGain (uint32_t gain) --> uint8_t
// CODE GENERATOR: Menu item hint description Menu item 'GA'
// CODE GENERATOR: Menu item 'GA' -- Menu item GA
// CODE GENERATOR: MAX11043 help: GA uint32_t gain -- Write_AGain
// CODE GENERATOR: MAX11043 helpString: 'GA gain=? -- Write_AGain'
// CODE GENERATOR: test menu case 'GA':
// CODE GENERATOR:           helpString 'GA gain=? -- Write_AGain'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Write_AGain'
// CODE GENERATOR:           CommandParamIn 'uint32_t gain'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn '@param[in] gain 2's complement, 0x800=0.25V/V, 0x1000=0.5V/V, 0x2000=1V/V, 0x4000=2V/V, default=0x2000'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR: MAX11043 Command Name = Configure_Demo (void) --> void
// CODE GENERATOR: Menu item hint description Menu item 'XD'
// CODE GENERATOR: Menu item 'XD' -- Menu item XD
// CODE GENERATOR: test menu case 'XD':
// CODE GENERATOR:           helpString 'XD -- Configure_Demo'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_Demo'
// CODE GENERATOR:           CommandParamIn 'void'
// CODE GENERATOR:           CommandReturnType 'void'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn ''
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn ''
// CODE GENERATOR: MAX11043 Command Name = Configure_XXXXX (uint8_t linef, uint8_t rate) --> uint8_t
// CODE GENERATOR: Menu item hint description Menu item 'XX'
// CODE GENERATOR: Menu item 'XX' -- Menu item XX
// CODE GENERATOR: MAX11043 help: XX uint8_t linef, uint8_t rate -- Configure_XXXXX
// CODE GENERATOR: MAX11043 helpString: 'XX linef=? rate=? -- Configure_XXXXX'
// CODE GENERATOR: test menu case 'XX':
// CODE GENERATOR:           helpString 'XX linef=? rate=? -- Configure_XXXXX'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_XXXXX'
// CODE GENERATOR:           CommandParamIn 'uint8_t linef, uint8_t rate'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn ''
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR: MAX11043 Command Name = Configure_XXXXY (uint8_t linef, uint8_t rate) --> uint8_t
// CODE GENERATOR: Menu item hint description Menu item 'XY'
// CODE GENERATOR: Menu item 'XY' -- Menu item XY
// CODE GENERATOR: MAX11043 help: XY uint8_t linef, uint8_t rate -- Configure_XXXXY
// CODE GENERATOR: MAX11043 helpString: 'XY linef=? rate=? -- Configure_XXXXY'
// CODE GENERATOR: test menu case 'XY':
// CODE GENERATOR:           helpString 'XY linef=? rate=? -- Configure_XXXXY'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_XXXXY'
// CODE GENERATOR:           CommandParamIn 'uint8_t linef, uint8_t rate'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn ''
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR: testMenuGlobalArgsDict scan global property list g_MAX11043_device

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.VRef
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.VRef argname = VRef
// CODE GENERATOR: testMenuGlobalArgsDict['VRef']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['VRef']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['VRef']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['VRef']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.config
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.config shadow of argname = config
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.config argname = config
// CODE GENERATOR: testMenuGlobalArgsDict['config']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['config']['argtype'] = 'uint16_t'
// CODE GENERATOR: testMenuGlobalArgsDict['config']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['config']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.status
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.status shadow of argname = status
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.status argname = status
// CODE GENERATOR: testMenuGlobalArgsDict['status']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['status']['argtype'] = 'uint8_t'
// CODE GENERATOR: testMenuGlobalArgsDict['status']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['status']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.adca
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.adca shadow of argname = ADCa
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.adca argname = ADCa
// CODE GENERATOR: testMenuGlobalArgsDict['ADCa']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCa']['argtype'] = 'int'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCa']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCa']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.adcb
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.adcb shadow of argname = ADCb
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.adcb argname = ADCb
// CODE GENERATOR: testMenuGlobalArgsDict['ADCb']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCb']['argtype'] = 'int'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCb']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCb']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.adcc
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.adcc shadow of argname = ADCc
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.adcc argname = ADCc
// CODE GENERATOR: testMenuGlobalArgsDict['ADCc']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCc']['argtype'] = 'int'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCc']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCc']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.adcd
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.adcd shadow of argname = ADCd
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11043_device.adcd argname = ADCd
// CODE GENERATOR: testMenuGlobalArgsDict['ADCd']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCd']['argtype'] = 'int'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCd']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCd']['usedBytestMenuItemName'] = 'None'


// CODE GENERATOR: scan testMenuCommand list for items that can be shortened to single character
// CODE GENERATOR: multiple commands begin with character 'X'
// CODE GENERATOR: multiple commands begin with character 'X'
// CODE GENERATOR: shorten testMenuCommand to single character if unambiguous
// CODE GENERATOR: testMenuCommand '!' already single character
// CODE GENERATOR: testMenuCommand '$' already single character
// CODE GENERATOR: shorten testMenuCommand 'GA' to single character 'G'
// CODE GENERATOR: re.sub pattern:'GA' with repl:'G' in helpString 'GA gain=? -- Write_AGain'
// CODE GENERATOR: updated 'G' help string to 'G gain=? -- Write_AGain'
// CODE GENERATOR: cannot shorten testMenuCommand 'XD' to single character due to duplicates
// CODE GENERATOR: cannot shorten testMenuCommand 'XX' to single character due to duplicates
// CODE GENERATOR: cannot shorten testMenuCommand 'XY' to single character due to duplicates

// CODE GENERATOR: help menu
bool MAX11043_menu_help(CmdLine & cmdLine)
{
    // CODE GENERATOR: command: !
    // CODE GENERATOR: help: ! -- Init
    cmdLine.serial().printf("\r\n ! -- Init");
    // CODE GENERATOR: command: $
    // CODE GENERATOR: help: $ -- Read_ADCabcd
    cmdLine.serial().printf("\r\n $ -- Read_ADCabcd");
    // CODE GENERATOR: command: G
    // CODE GENERATOR: help: G gain=? -- Write_AGain
    cmdLine.serial().printf("\r\n G gain=? -- Write_AGain");
    // CODE GENERATOR: command: XD
    // CODE GENERATOR: help: XD -- Configure_Demo
    cmdLine.serial().printf("\r\n XD -- Configure_Demo");
    // CODE GENERATOR: command: XX
    // CODE GENERATOR: help: XX linef=? rate=? -- Configure_XXXXX
    cmdLine.serial().printf("\r\n XX linef=? rate=? -- Configure_XXXXX");
    // CODE GENERATOR: command: XY
    // CODE GENERATOR: help: XY linef=? rate=? -- Configure_XXXXY
    cmdLine.serial().printf("\r\n XY linef=? rate=? -- Configure_XXXXY");
    //
    cmdLine.serial().printf("\r\n @ -- print MAX11043 configuration");

// CODE GENERATOR: help menu if has_register_write_command: *regname? -- read register; *regname=regvalue -- write register
    cmdLine.serial().printf("\r\n *regname? -- read register\r\n *regname=regvalue -- write register");

    //
// CODE GENERATOR: TODO1: generate GPIO commands for LDAC, CLR, etc. based on device driver function names (menu_help)
        // case 'G'..'Z','g'..'z' are reserved for GPIO commands
        // case 'A'..'F','a'..'f' may be available if not claimed by bitstream commands
// CODE GENERATOR: TODO1: prevent conflict ExternFunctionGPIOPinCommand with reserved case 'A'..'F','a'..'f'
// CODE GENERATOR: testMenuGPIOItemsDict['CONVRUN']['PinName'] = 'CONVRUN'
// CODE GENERATOR: testMenuGPIOItemsDict['CONVRUN']['Direction'] = 'output'
// CODE GENERATOR: testMenuGPIOItemsDict['CONVRUN']['Operation'] = 'Value'
// CODE GENERATOR: testMenuGPIOItemsDict['CONVRUN']['FunctionName'] = 'CONVRUNoutputValue'

// CODE GENERATOR: warning: conflict testMenuGPIOItemsDict['CONVRUN']['PinName'] = 'CONVRUN'
#warning "No command case for 'CONVRUN' 'PinName' 'CONVRUN' due to conflict with reserved commands A-F, try changing pin name"
#warning "Randomly assigned command 'H' for 'CONVRUN' due to name conflict"
// CODE GENERATOR: testMenuGPIOItemsDict['DACSTEP']['PinName'] = 'DACSTEP'
// CODE GENERATOR: testMenuGPIOItemsDict['DACSTEP']['Direction'] = 'output'
// CODE GENERATOR: testMenuGPIOItemsDict['DACSTEP']['Operation'] = 'Value'
// CODE GENERATOR: testMenuGPIOItemsDict['DACSTEP']['FunctionName'] = 'DACSTEPoutputValue'

// CODE GENERATOR: warning: conflict testMenuGPIOItemsDict['DACSTEP']['PinName'] = 'DACSTEP'
#warning "No command case for 'DACSTEP' 'PinName' 'DACSTEP' due to conflict with reserved commands A-F, try changing pin name"
#warning "Randomly assigned command 'I' for 'DACSTEP' due to name conflict"
// CODE GENERATOR: testMenuGPIOItemsDict['EOC']['PinName'] = 'EOC'
// CODE GENERATOR: testMenuGPIOItemsDict['EOC']['Direction'] = 'input'
// CODE GENERATOR: testMenuGPIOItemsDict['EOC']['Operation'] = 'Value'
// CODE GENERATOR: testMenuGPIOItemsDict['EOC']['FunctionName'] = 'EOCinputValue'

// CODE GENERATOR: warning: conflict testMenuGPIOItemsDict['EOC']['PinName'] = 'EOC'
#warning "No command case for 'EOC' 'PinName' 'EOC' due to conflict with reserved commands A-F, try changing pin name"
#warning "Randomly assigned command 'J' for 'EOC' due to name conflict"
// CODE GENERATOR: testMenuGPIOItemsDict['SHDN']['PinName'] = 'SHDN'
// CODE GENERATOR: testMenuGPIOItemsDict['SHDN']['Direction'] = 'output'
// CODE GENERATOR: testMenuGPIOItemsDict['SHDN']['Operation'] = 'Value'
// CODE GENERATOR: testMenuGPIOItemsDict['SHDN']['FunctionName'] = 'SHDNoutputValue'

// CODE GENERATOR: testMenuGPIOItemsDict['UP_slash_DWNb']['PinName'] = 'UP_slash_DWNb'
// CODE GENERATOR: testMenuGPIOItemsDict['UP_slash_DWNb']['Direction'] = 'output'
// CODE GENERATOR: testMenuGPIOItemsDict['UP_slash_DWNb']['Operation'] = 'Value'
// CODE GENERATOR: testMenuGPIOItemsDict['UP_slash_DWNb']['FunctionName'] = 'UP_slash_DWNboutputValue'

// CODE GENERATOR: ExternFunctionGPIOPinCommand 'H' 'CONVRUN'
// CODE GENERATOR: testMenuGPIOItemsDict['CONVRUN']['PinName'] = 'CONVRUN'
// CODE GENERATOR: testMenuGPIOItemsDict['CONVRUN']['Direction'] = 'output'
// CODE GENERATOR: testMenuGPIOItemsDict['CONVRUN']['Operation'] = 'Value'
// CODE GENERATOR: testMenuGPIOItemsDict['CONVRUN']['FunctionName'] = 'CONVRUNoutputValue'
    cmdLine.serial().printf("\r\n H -- CONVRUN output HH high HL low"); // TODO: ExternFunctionGPIOPinCommand testMenuGPIOItemsDict
// CODE GENERATOR: ExternFunctionGPIOPinCommand 'I' 'DACSTEP'
// CODE GENERATOR: testMenuGPIOItemsDict['DACSTEP']['PinName'] = 'DACSTEP'
// CODE GENERATOR: testMenuGPIOItemsDict['DACSTEP']['Direction'] = 'output'
// CODE GENERATOR: testMenuGPIOItemsDict['DACSTEP']['Operation'] = 'Value'
// CODE GENERATOR: testMenuGPIOItemsDict['DACSTEP']['FunctionName'] = 'DACSTEPoutputValue'
    cmdLine.serial().printf("\r\n I -- DACSTEP output IH high IL low"); // TODO: ExternFunctionGPIOPinCommand testMenuGPIOItemsDict
// CODE GENERATOR: ExternFunctionGPIOPinCommand 'J' 'EOC'
// CODE GENERATOR: testMenuGPIOItemsDict['EOC']['PinName'] = 'EOC'
// CODE GENERATOR: testMenuGPIOItemsDict['EOC']['Direction'] = 'input'
// CODE GENERATOR: testMenuGPIOItemsDict['EOC']['Operation'] = 'Value'
// CODE GENERATOR: testMenuGPIOItemsDict['EOC']['FunctionName'] = 'EOCinputValue'
    cmdLine.serial().printf("\r\n J -- EOC input value"); // TODO: ExternFunctionGPIOPinCommand testMenuGPIOItemsDict
// CODE GENERATOR: ExternFunctionGPIOPinCommand 'S' 'SHDN'
// CODE GENERATOR: testMenuGPIOItemsDict['SHDN']['PinName'] = 'SHDN'
// CODE GENERATOR: testMenuGPIOItemsDict['SHDN']['Direction'] = 'output'
// CODE GENERATOR: testMenuGPIOItemsDict['SHDN']['Operation'] = 'Value'
// CODE GENERATOR: testMenuGPIOItemsDict['SHDN']['FunctionName'] = 'SHDNoutputValue'
    cmdLine.serial().printf("\r\n S -- SHDN output SH high SL low"); // TODO: ExternFunctionGPIOPinCommand testMenuGPIOItemsDict
// CODE GENERATOR: ExternFunctionGPIOPinCommand 'U' 'UP_slash_DWNb'
// CODE GENERATOR: testMenuGPIOItemsDict['UP_slash_DWNb']['PinName'] = 'UP_slash_DWNb'
// CODE GENERATOR: testMenuGPIOItemsDict['UP_slash_DWNb']['Direction'] = 'output'
// CODE GENERATOR: testMenuGPIOItemsDict['UP_slash_DWNb']['Operation'] = 'Value'
// CODE GENERATOR: testMenuGPIOItemsDict['UP_slash_DWNb']['FunctionName'] = 'UP_slash_DWNboutputValue'
    cmdLine.serial().printf("\r\n U -- UP_slash_DWNb output UH high UL low"); // TODO: ExternFunctionGPIOPinCommand testMenuGPIOItemsDict

#if Has_Read4Command_Command
// Read 4 command -- Single 4-channel read: CONVRUN pulsed H then L, EOC ignored.
    cmdLine.serial().printf("\r\n ^ -- Single 4-channel read: CONVRUN pulsed H then L, EOC ignored.");
#endif // Has_Read4Command_Command

    //
    return true; // why is MAXxxxxx_menu_help() function bool not void?
}

bool MAX11043_menu_onEOLcommandParser(CmdLine & cmdLine)
{

// CODE GENERATOR: testMenuGlobalArgsDict Consolidate common/global argument parsing

// CODE GENERATOR: testMenuGlobalArgsDict['ADCa']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCa']['argtype'] = 'int'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCa']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCa']['usedBytestMenuItemName'] = 'None'
                    // parse argument int ADCa
        //int ADCa = 0; // ~~~ g_MAX11043_device.__WARNING_no_match_for_argname_ADCa_in_MAX11043_device_t__; // default to global property value
        //if (cmdLine.parse_int16_dec("ADCa", ADCa))
        // [Error] Test_Menu_MAX11043.cpp@627,49: invalid initialization of non-const reference of type 'int16_t& {aka short int&}' from an rvalue of type 'int16_t {aka short int}'
        //{
            // g_MAX11043_device.__WARNING_no_match_for_argname_ADCa_in_MAX11043_device_t__ = ADCa; // update global property value
        //}

// CODE GENERATOR: testMenuGlobalArgsDict['ADCb']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCb']['argtype'] = 'int'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCb']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCb']['usedBytestMenuItemName'] = 'None'
                    // parse argument int ADCb
        //int ADCb = 0; // ~~~ g_MAX11043_device.__WARNING_no_match_for_argname_ADCb_in_MAX11043_device_t__; // default to global property value
        //if (cmdLine.parse_int16_dec("ADCb", ADCb))
        //{
        //    // g_MAX11043_device.__WARNING_no_match_for_argname_ADCb_in_MAX11043_device_t__ = ADCb; // update global property value
        //}

// CODE GENERATOR: testMenuGlobalArgsDict['ADCc']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCc']['argtype'] = 'int'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCc']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCc']['usedBytestMenuItemName'] = 'None'
                    // parse argument int ADCc
        //int ADCc = 0; // ~~~ g_MAX11043_device.__WARNING_no_match_for_argname_ADCc_in_MAX11043_device_t__; // default to global property value
        //if (cmdLine.parse_int16_dec("ADCc", ADCc))
        //{
        //    // g_MAX11043_device.__WARNING_no_match_for_argname_ADCc_in_MAX11043_device_t__ = ADCc; // update global property value
        //}

// CODE GENERATOR: testMenuGlobalArgsDict['ADCd']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCd']['argtype'] = 'int'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCd']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ADCd']['usedBytestMenuItemName'] = 'None'
                    // parse argument int ADCd
        //int ADCd = 0; // ~~~ g_MAX11043_device.__WARNING_no_match_for_argname_ADCd_in_MAX11043_device_t__; // default to global property value
        //if (cmdLine.parse_int16_dec("ADCd", ADCd))
        //{
        //    // g_MAX11043_device.__WARNING_no_match_for_argname_ADCd_in_MAX11043_device_t__ = ADCd; // update global property value
        //}

// CODE GENERATOR: testMenuGlobalArgsDict['VRef']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['VRef']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['VRef']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['VRef']['usedBytestMenuItemName'] = 'None'
                    // parse argument double VRef
        double VRef = g_MAX11043_device.VRef; // default to global property value
        if (cmdLine.parse_double("VRef", VRef))
        {
            g_MAX11043_device.VRef = VRef; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['config']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['config']['argtype'] = 'uint16_t'
// CODE GENERATOR: testMenuGlobalArgsDict['config']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['config']['usedBytestMenuItemName'] = 'None'
                    // parse argument uint16_t config
        uint16_t config = g_MAX11043_device.config; // default to global property value
        if (cmdLine.parse_uint16_dec("config", config))
        {
            g_MAX11043_device.config = config; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['status']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['status']['argtype'] = 'uint8_t'
// CODE GENERATOR: testMenuGlobalArgsDict['status']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['status']['usedBytestMenuItemName'] = 'None'
                    // parse argument uint8_t status
        uint8_t status = g_MAX11043_device.status; // default to global property value
        if (cmdLine.parse_uint8_dec("status", status))
        {
            g_MAX11043_device.status = status; // update global property value
        }

    switch (cmdLine[0])
    {
#if Has_Read4Command_Command
// Read 4 command -- Single 4-channel read: CONVRUN pulsed H then L, EOC ignored.
        case '^':
        {
            // cmdLine.serial().printf("\r\n ^ -- Single 4-channel read: CONVRUN pulsed H then L, EOC ignored.");
#if Use_Read4Command_Thread
            Callback<void(size_t, uint8_t*, uint8_t*)> saved_onSPIprint_handler = g_MAX11043_device.onSPIprint;
            g_MAX11043_device.onSPIprint = NULL; // temporarily suppress SPI diagnostic messages
            //~ int convrun_pulse_width_us = 30;
            //~ int convrun_stop_us = 10;
            cmdLine.serial().printf(" Testing CONVRUN pulsed H then L, EOC ignored.\r\n");
            cmdLine.serial().printf(" press D to display min/max limits (based on data seen)\r\n");
            cmdLine.serial().printf(" press R to reset min/max limits (force scope trigger)\r\n");
            cmdLine.serial().printf(" press F for fake data +32767, +1, -1, -32768 (internal 2's complement test) \r\n");
            cmdLine.serial().printf(" press X to stop...\r\n");
            //~ cmdLine.serial().printf(" Testing, press RESET to stop...\r\n");
            //~ int serial_is_blocking = cmdLine.serial().is_blocking();
            //~ cmdLine.serial().set_blocking(0);
            //
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
            digitalInOut5.output(); // ScopeTrigger
            digitalInOut5.write(1); // ScopeTrigger
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
            //
            // reset min/max limits
            adca_MIN_SEEN = adcX_MIN_SEEN_INIT_INT16_MAX;
            adca_MAX_SEEN = adcX_MAX_SEEN_INIT_INT16_MIN;
            adcb_MIN_SEEN = adcX_MIN_SEEN_INIT_INT16_MAX;
            adcb_MAX_SEEN = adcX_MAX_SEEN_INIT_INT16_MIN;
            //
            // init thread
            Read4Command_Thread.start(Read4Command_Thread_handler);
            // TODO: is there any harm in multiple start?
            //
            // Start the test
            Read4Command_Thread_event_flags.set(MYTIMEREVENTFLAG_ENABLE_SPI);
            // Work will be done inside Read4Command_Thread_handler
            while (1)
            {
                char ch = cmdLine.serial().getc(); // blocking read
                if (ch == '\r') { cmdLine.serial().printf(" (ignored \\r) "); continue; }
                if (ch == '\n') { cmdLine.serial().printf(" (ignored \\n) "); continue; }
                if (ch == '?') {
                    cmdLine.serial().printf(" Testing CONVRUN pulsed H then L, EOC ignored.\r\n");
                    cmdLine.serial().printf(" press D to display min/max limits (based on data seen)\r\n");
                    cmdLine.serial().printf(" press R to reset min/max limits (force scope trigger)\r\n");
                    cmdLine.serial().printf(" press F for fake data +32767, +1, -1, -32768 (internal 2's complement test) \r\n");
                    cmdLine.serial().printf(" press X to stop...\r\n");
                    continue;
                }
                if (ch == 'R' || ch == 'r') {
                    // reset min/max limits
                    Read4Command_Thread_event_flags.clear(MYTIMEREVENTFLAG_FAKE_DATA);
                    Read4Command_Thread_event_flags.set(MYTIMEREVENTFLAG_RESET_MINMAX);
                    cmdLine.serial().printf(" Reset limts \r\n");
                    wait_us(100);
                }
                if (ch == 'F' || ch == 'f') {
                    // fake data
                    Read4Command_Thread_event_flags.set(MYTIMEREVENTFLAG_FAKE_DATA);
                    // g_MAX11043_device.adca = 0x7FFF; // +32767 adcX_MIN_SEEN_INIT_INT16_MAX;
                    // g_MAX11043_device.adcb = 0x0001; // +1
                    // g_MAX11043_device.adcc = 0xFFFF; // -1
                    // g_MAX11043_device.adcd = 0x8000; // -32768 adcX_MAX_SEEN_INIT_INT16_MIN;
                    cmdLine.serial().printf(" fake data +32767, +1, -1, -32768 (internal 2's complement test) \r\n");
                    wait_us(100);
                }
                if (ch == 'D' || ch == 'd' || ch == 'F' || ch == 'f' || ch == 'R' || ch == 'r' || ch == 'X' || ch == 'x' || ch == '\x03') {
                    // display min/max limits
                    cmdLine.serial().printf(" %s\tNEW 0x%4.4x %+6d \tMIN 0x%4.4x %+6d \tMAX 0x%4.4x %+6d \r\n",
                        "adca",
                        (adca_newest   & 0xFFFF),
                        (adca_newest           ),
                        (adca_MIN_SEEN & 0xFFFF),
                        (adca_MIN_SEEN         ),
                        (adca_MAX_SEEN & 0xFFFF),
                        (adca_MAX_SEEN         )
                    );
                    cmdLine.serial().printf(" %s\tNEW 0x%4.4x %+6d \tMIN 0x%4.4x %+6d \tMAX 0x%4.4x %+6d \r\n",
                        "adcb",
                        (adcb_newest   & 0xFFFF),
                        (adcb_newest           ),
                        (adcb_MIN_SEEN & 0xFFFF),
                        (adcb_MIN_SEEN         ),
                        (adcb_MAX_SEEN & 0xFFFF),
                        (adcb_MAX_SEEN         )
                    );
                    cmdLine.serial().printf(" %s\tNEW 0x%4.4x %+6d \tMIN 0x%4.4x %+6d \tMAX 0x%4.4x %+6d \r\n",
                        "adcc",
                        (adcc_newest   & 0xFFFF),
                        (adcc_newest           ),
                        (adcc_MIN_SEEN & 0xFFFF),
                        (adcc_MIN_SEEN         ),
                        (adcc_MAX_SEEN & 0xFFFF),
                        (adcc_MAX_SEEN         )
                    );
                    cmdLine.serial().printf(" %s\tNEW 0x%4.4x %+6d \tMIN 0x%4.4x %+6d \tMAX 0x%4.4x %+6d \r\n",
                        "adcd__",
                        (adcd_newest   & 0xFFFF),
                        (adcd_newest           ),
                        (adcd_MIN_SEEN & 0xFFFF),
                        (adcd_MIN_SEEN         ),
                        (adcd_MAX_SEEN & 0xFFFF),
                        (adcd_MAX_SEEN         )
                    );
                    cmdLine.serial().printf("\r\n");
                }
                if (ch == 'D' || ch == 'd' || ch == 'F' || ch == 'f' || ch == 'R' || ch == 'r') {
                    continue;
                }
                if (ch == 'X' || ch == 'x' || ch == '\x03') {
                    break;
                }
                cmdLine.serial().printf(" (ignored \\x%2.2x)\r\nD:Display F:Fake R:Reset X:Exit\r\n", (int)ch);
            }
            // Stop the test
            Read4Command_Thread_event_flags.clear(MYTIMEREVENTFLAG_ENABLE_SPI);
            wait_us(200);
            //~ cmdLine.serial().set_blocking(serial_is_blocking);
            cmdLine.serial().printf(" Stopped.\r\n");
            g_MAX11043_device.onSPIprint = saved_onSPIprint_handler;
#else // Use_Read4Command_Thread
            int convrun_pulse_width_us = 30;
            int convrun_stop_us = 10;
            //~ cmdLine.serial().printf(" Testing, press X to stop...\r\n");
            cmdLine.serial().printf(" Testing, press RESET to stop...\r\n");
            //~ int serial_is_blocking = cmdLine.serial().is_blocking();
            //~ cmdLine.serial().set_blocking(0);
            while (1)
            {
                // TODO: CONVRUN = H -- perform ADC conversions (EOC will pulse, and data registers will update)
                g_MAX11043_device.CONVRUNoutputValue(1);
                //
                // TODO: delay at least 9us to ensure at least one converion happens
                wait_us(convrun_pulse_width_us);
                //
                // TODO: CONVRUN = L -- stop ADC conversions
                g_MAX11043_device.CONVRUNoutputValue(0);
                //
                // TODO: delay at least 9us to ensure final converion complete
                wait_us(convrun_stop_us);
                //
                // TODO: run SPI to capture 4 channels
                // TODO: get rid of the other interrupt/thread, only to read here
                g_MAX11043_device.Read_ADCabcd();
                // post: g_MAX11043_device.adca was updated
                // post: g_MAX11043_device.adcb was updated
                // post: g_MAX11043_device.adcc was updated
                // post: g_MAX11043_device.adcd was updated
                //
                // TODO: compare with thresholds, report if exceeded
                //
                // TODO: break on keypress
                // TODO: this isn't working, serial().getc() is blocking and .readable() always returns 1 so we stall in getc().
                unsigned int num_read_available = cmdLine.serial().readable();
                if (num_read_available > 1) // should test >0; but always returns 1?
                {
                    cmdLine.serial().printf(" (num_read_available %u) ", num_read_available);
                    char ch = cmdLine.serial().getc(); // blocking read
                    if (ch == '\r') { cmdLine.serial().printf(" (ignored \\r) "); continue; }
                    if (ch == '\n') { cmdLine.serial().printf(" (ignored \\n) "); continue; }
                    if (ch == '\x03') break; // CTRL+C break
                    if (ch == 'x') break;
                    if (ch == 'X') break;
                    cmdLine.serial().printf(" (ignored \\x%2.2x) ", (int)ch);
                }
            }
            //~ cmdLine.serial().set_blocking(serial_is_blocking);
            cmdLine.serial().printf(" Stopped.\r\n");
#endif // Use_Read4Command_Thread
            return true; // command handled by MAX11043
        }
        break;
#endif // Has_Read4Command_Command
// CODE GENERATOR: generate * command read/write reg *reg? *reg=value
        case '*':
        {
            // if buffer starts with a regName:
            // for each reg value (0..n) if(cmdLine.has_keyword(device.regName(r))):
            cmdLine.serial().printf(" scan RegName...\r\n");
            for (uint8_t regAddress = 0; regAddress < 0x80; regAddress++)
            {
                uint32_t regData = 0;
                bool is_regname_query = false;
                bool is_regname_assignment = false;
                if (cmdLine.parse_uint32_dec(g_MAX11043_device.RegName((MAX11043::MAX11043_CMD_enum_t)regAddress), regData))
                {
                    cmdLine.serial().printf(" regAddress=0x%2.2X\r\n", (regAddress & 0xFF));
                    cmdLine.serial().printf(" RegName=%s\r\n", g_MAX11043_device.RegName((MAX11043::MAX11043_CMD_enum_t)regAddress));
                    // accept regName "?" as "RegRead" by name
                    is_regname_query = (cmdLine.chSeparator == '?');
                    is_regname_assignment = (cmdLine.chSeparator == '=');
                    if (is_regname_query)
                    {
                        cmdLine.serial().printf(" RegRead");
                        g_MAX11043_device.RegRead((MAX11043::MAX11043_CMD_enum_t)regAddress, &regData);
                        cmdLine.serial().printf("regData=0x%6.6x\r\n", (regData & 0x00FFFFFF));
                        return true; // command handled by MAX11043
                    }
                    // accept regName "=0x123456" as "RegWrite" by name
                    if (is_regname_assignment)
                    {
                        cmdLine.serial().printf(" RegWrite");
                        cmdLine.serial().printf("regData=0x%6.6x\r\n", (regData & 0x00FFFFFF));
                        g_MAX11043_device.RegWrite((MAX11043::MAX11043_CMD_enum_t)regAddress, regData);
                        return true; // command handled by MAX11043
                    }
                }
            } // end for regAddr
            // not a valid register name
            Callback<void(size_t, uint8_t*, uint8_t*)> saved_onSPIprint_handler = g_MAX11043_device.onSPIprint;
            g_MAX11043_device.onSPIprint = NULL; // temporarily suppress SPI diagnostic messages
            // read "all" registers by name
            // TODO: KLUDGE: this constant array should live in the device driver, not the menu
            const MAX11043::MAX11043_CMD_enum_t readAllStatusList[] = {
                    MAX11043::CMD_0000_0010_d16o8_Rd00_ADCa,
                    MAX11043::CMD_0000_0110_d16o8_Rd01_ADCb,
                    MAX11043::CMD_0000_1010_d16o8_Rd02_ADCc,
                    MAX11043::CMD_0000_1110_d16o8_Rd03_ADCd,
                    MAX11043::CMD_0001_1110_d8_Rd07_Status,
                    MAX11043::CMD_0010_0010_d16_Rd08_Configuration,
                    MAX11043::CMD_0010_0110_d16_Rd09_DAC,
                    MAX11043::CMD_0010_1010_d16_Rd0A_DACStep,
                    MAX11043::CMD_0010_1110_d16_Rd0B_DACHDACL,
                    MAX11043::CMD_0011_0010_d16_Rd0C_ConfigA,
                    MAX11043::CMD_0011_0110_d16_Rd0D_ConfigB,
                    MAX11043::CMD_0011_1010_d16_Rd0E_ConfigC,
                    MAX11043::CMD_0011_1110_d16_Rd0F_ConfigD,
                    MAX11043::CMD_0100_0010_d16_Rd10_Reference,
                    MAX11043::CMD_0100_0110_d16_Rd11_AGain,
                    MAX11043::CMD_0100_1010_d16_Rd12_BGain,
                    MAX11043::CMD_0100_1110_d16_Rd13_CGain,
                    MAX11043::CMD_0101_0010_d16_Rd14_DGain,
                };
            for (uint8_t readAllStatusIndex = 0; readAllStatusIndex < (sizeof(readAllStatusList)/sizeof(MAX11043::MAX11043_CMD_enum_t)); readAllStatusIndex++)
            {
                MAX11043::MAX11043_CMD_enum_t regAddress = readAllStatusList[readAllStatusIndex];
                uint32_t regData = 0;
                if (g_MAX11043_device.RegSize(regAddress) == 0) continue; // skip undefined regs
                if (g_MAX11043_device.RegRead(regAddress, &regData) == 0) continue; // skip unreadable regs
                cmdLine.serial().printf("%s=0x%6.6x\r\n", g_MAX11043_device.RegName(regAddress), regData);
            } // end for regAddr
            g_MAX11043_device.onSPIprint = saved_onSPIprint_handler;
            return true; // command handled by MAX11043
        }
        break;

// CODE GENERATOR: generate @ command print global property values of  g_MAX11043_device
        case '@':
        {
// CODE GENERATOR: @ command print double g_MAX11043_device.VRef
                    cmdLine.serial().printf("VRef = ");
                    cmdLine.serial().printf("%f\r\n", g_MAX11043_device.VRef);
// CODE GENERATOR: @ command print uint16_t g_MAX11043_device.config
                    cmdLine.serial().printf("config = ");
                    cmdLine.serial().printf("%d = 0x%4.4x\r\n", g_MAX11043_device.config, g_MAX11043_device.config);
// CODE GENERATOR: @ command print uint8_t g_MAX11043_device.status
                    cmdLine.serial().printf("status = ");
                    cmdLine.serial().printf("%d = 0x%2.2x\r\n", g_MAX11043_device.status, g_MAX11043_device.status);
// CODE GENERATOR: @ command print int g_MAX11043_device.adca
                    cmdLine.serial().printf("adca = ");
                    cmdLine.serial().printf("%d = 0x%8.8x\r\n", g_MAX11043_device.adca, g_MAX11043_device.adca);
// CODE GENERATOR: @ command print int g_MAX11043_device.adcb
                    cmdLine.serial().printf("adcb = ");
                    cmdLine.serial().printf("%d = 0x%8.8x\r\n", g_MAX11043_device.adcb, g_MAX11043_device.adcb);
// CODE GENERATOR: @ command print int g_MAX11043_device.adcc
                    cmdLine.serial().printf("adcc = ");
                    cmdLine.serial().printf("%d = 0x%8.8x\r\n", g_MAX11043_device.adcc, g_MAX11043_device.adcc);
// CODE GENERATOR: @ command print int g_MAX11043_device.adcd
                    cmdLine.serial().printf("adcd = ");
                    cmdLine.serial().printf("%d = 0x%8.8x\r\n", g_MAX11043_device.adcd, g_MAX11043_device.adcd);
                    return true; // command handled by MAX11043
            break;
        }
// CODE GENERATOR: TODO1: generate GPIO commands for LDAC, CLR, etc. based on device driver function names
        // case 'G'..'Z','g'..'z' are reserved for GPIO commands
        // case 'A'..'F','a'..'f' may be available if not claimed by bitstream commands
// CODE GENERATOR: ExternFunctionGPIOPinCommand 'H' 'CONVRUN'
// CODE GENERATOR: testMenuGPIOItemsDict['CONVRUN']['PinName'] = 'CONVRUN'
// CODE GENERATOR: testMenuGPIOItemsDict['CONVRUN']['Direction'] = 'output'
// CODE GENERATOR: testMenuGPIOItemsDict['CONVRUN']['Operation'] = 'Value'
// CODE GENERATOR: testMenuGPIOItemsDict['CONVRUN']['FunctionName'] = 'CONVRUNoutputValue'
        case 'H':
        {
            switch (cmdLine[1])
            {
                case 'H':
                {
                    g_MAX11043_device.CONVRUNoutputValue(1);
                    break;
                }
                case 'L':
                {
                    g_MAX11043_device.CONVRUNoutputValue(0);
                    break;
                }
            }
                    return true; // command handled by MAX11043
            break;
        }

// CODE GENERATOR: ExternFunctionGPIOPinCommand 'I' 'DACSTEP'
// CODE GENERATOR: testMenuGPIOItemsDict['DACSTEP']['PinName'] = 'DACSTEP'
// CODE GENERATOR: testMenuGPIOItemsDict['DACSTEP']['Direction'] = 'output'
// CODE GENERATOR: testMenuGPIOItemsDict['DACSTEP']['Operation'] = 'Value'
// CODE GENERATOR: testMenuGPIOItemsDict['DACSTEP']['FunctionName'] = 'DACSTEPoutputValue'
        case 'I':
        {
            switch (cmdLine[1])
            {
                case 'H':
                {
                    g_MAX11043_device.DACSTEPoutputValue(1);
                    break;
                }
                case 'L':
                {
                    g_MAX11043_device.DACSTEPoutputValue(0);
                    break;
                }
            }
                    return true; // command handled by MAX11043
            break;
        }

// CODE GENERATOR: ExternFunctionGPIOPinCommand 'J' 'EOC'
// CODE GENERATOR: testMenuGPIOItemsDict['EOC']['PinName'] = 'EOC'
// CODE GENERATOR: testMenuGPIOItemsDict['EOC']['Direction'] = 'input'
// CODE GENERATOR: testMenuGPIOItemsDict['EOC']['Operation'] = 'Value'
// CODE GENERATOR: testMenuGPIOItemsDict['EOC']['FunctionName'] = 'EOCinputValue'
        case 'J':
        {
                // TODO capture and print input Value
                cmdLine.serial().printf("%d", g_MAX11043_device.EOCinputValue());
                    return true; // command handled by MAX11043
            break;
        }

// CODE GENERATOR: ExternFunctionGPIOPinCommand 'S' 'SHDN'
// CODE GENERATOR: testMenuGPIOItemsDict['SHDN']['PinName'] = 'SHDN'
// CODE GENERATOR: testMenuGPIOItemsDict['SHDN']['Direction'] = 'output'
// CODE GENERATOR: testMenuGPIOItemsDict['SHDN']['Operation'] = 'Value'
// CODE GENERATOR: testMenuGPIOItemsDict['SHDN']['FunctionName'] = 'SHDNoutputValue'
        case 'S':
        {
            switch (cmdLine[1])
            {
                case 'H':
                {
                    g_MAX11043_device.SHDNoutputValue(1);
                    break;
                }
                case 'L':
                {
                    g_MAX11043_device.SHDNoutputValue(0);
                    break;
                }
            }
                    return true; // command handled by MAX11043
            break;
        }

// CODE GENERATOR: ExternFunctionGPIOPinCommand 'U' 'UP_slash_DWNb'
// CODE GENERATOR: testMenuGPIOItemsDict['UP_slash_DWNb']['PinName'] = 'UP_slash_DWNb'
// CODE GENERATOR: testMenuGPIOItemsDict['UP_slash_DWNb']['Direction'] = 'output'
// CODE GENERATOR: testMenuGPIOItemsDict['UP_slash_DWNb']['Operation'] = 'Value'
// CODE GENERATOR: testMenuGPIOItemsDict['UP_slash_DWNb']['FunctionName'] = 'UP_slash_DWNboutputValue'
        case 'U':
        {
            switch (cmdLine[1])
            {
                case 'H':
                {
                    g_MAX11043_device.UP_slash_DWNboutputValue(1);
                    break;
                }
                case 'L':
                {
                    g_MAX11043_device.UP_slash_DWNboutputValue(0);
                    break;
                }
            }
                    return true; // command handled by MAX11043
            break;
        }


// CODE GENERATOR: test menu
        // case '0'..'9','A'..'F','a'..'f' letters are reserved for bitstream commands
        // has_register_write_command: case '0'..'9','A'..'F','a'..'f' letters are reserved for bitstream commands
// CODE GENERATOR: top of loop: testMenuCommand="!", testMenuFirstCharHandler="None"
// CODE GENERATOR: test menu case '!':
// CODE GENERATOR:           helpString '! -- Init'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Init'
// CODE GENERATOR:           CommandParamIn 'void'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn ''
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
        // case '!': // (single character) (testMenuFirstCharHandler="None")
        case '!':
        {
                    // test menu command '!' handler:
                    // helpString='! -- Init'
                    // CMD_='None'
                    // CommandName='Init'
                    // CommandParamIn='void'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return='@return 1 on success; 0 on failure'
                    cmdLine.serial().printf("Init");
                    // call function Init
                    uint8_t result = g_MAX11043_device.Init();
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX11043
// CODE GENERATOR: bottom of loop: testMenuCommand="!", testMenuFirstCharHandler="None"
        } // end case '!'
        break;

// CODE GENERATOR: top of loop: testMenuCommand="$", testMenuFirstCharHandler="None"
// CODE GENERATOR: test menu case '$':
// CODE GENERATOR:           helpString '$ -- Read_ADCabcd'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Read_ADCabcd'
// CODE GENERATOR:           CommandParamIn 'void'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn ''
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
        // case '$': // (single character) (testMenuFirstCharHandler="None")
        case '$':
        {
                    // test menu command '$' handler:
                    // helpString='$ -- Read_ADCabcd'
                    // CMD_='None'
                    // CommandName='Read_ADCabcd'
                    // CommandParamIn='void'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // displayPost='adca, adcb, adcc, adcd'
                    // @Return='@return 1 on success; 0 on failure'
                    cmdLine.serial().printf("Read_ADCabcd");
                    // call function Read_ADCabcd
                    uint8_t result = g_MAX11043_device.Read_ADCabcd();
                    cmdLine.serial().printf(" =%d\r\n", result);
                    // Menu item '$' -> adca, adcb, adcc, adcd
                    cmdLine.serial().printf("%s=%d\r\n", "adca", g_MAX11043_device.adca);
                    cmdLine.serial().printf("%s=%d\r\n", "adcb", g_MAX11043_device.adcb);
                    cmdLine.serial().printf("%s=%d\r\n", "adcc", g_MAX11043_device.adcc);
                    cmdLine.serial().printf("%s=%d\r\n", "adcd", g_MAX11043_device.adcd);
                    return true; // command handled by MAX11043
// CODE GENERATOR: bottom of loop: testMenuCommand="$", testMenuFirstCharHandler="None"
        } // end case '$'
        break;

// CODE GENERATOR: top of loop: testMenuCommand="G", testMenuFirstCharHandler="None"
// CODE GENERATOR: test menu case 'G':
// CODE GENERATOR:           helpString 'G gain=? -- Write_AGain'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Write_AGain'
// CODE GENERATOR:           CommandParamIn 'uint32_t gain'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn '@param[in] gain 2's complement, 0x800=0.25V/V, 0x1000=0.5V/V, 0x2000=1V/V, 0x4000=2V/V, default=0x2000'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
        // case 'G': // (single character) (testMenuFirstCharHandler="None")
        case 'G':
        {
                    // test menu command 'G' handler:
                    // helpString='G gain=? -- Write_AGain'
                    // CMD_='None'
                    // CommandName='Write_AGain'
                    // CommandParamIn='uint32_t gain'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]='@param[in] gain 2's complement, 0x800=0.25V/V, 0x1000=0.5V/V, 0x2000=1V/V, 0x4000=2V/V, default=0x2000'
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return='@return 1 on success; 0 on failure'
                    // parse argument list
                    // argname default_argvalue numeric literal specified in CommandDocParamIn @Param[in]='@param[in] gain 2's complement, 0x800=0.25V/V, 0x1000=0.5V/V, 0x2000=1V/V, 0x4000=2V/V, default=0x2000'
                    // parse argument uint32_t gain
                    uint32_t gain = (uint32_t)0x2000; // --- g_MAX11043_device.__WARNING_no_match_for_argname_gain_in_MAX11043_device_t__; // default to global property value
                    if (cmdLine.parse_uint32_dec("gain", gain))
                    {
                        // g_MAX11043_device.__WARNING_no_match_for_argname_gain_in_MAX11043_device_t__ = gain; // update global property value
                    }
                    // print arguments
                    cmdLine.serial().printf("Write_AGain");
                    cmdLine.serial().printf(" gain=%d", gain);
                    cmdLine.serial().printf("\r\n");
                    // call function Write_AGain(gain)
                    uint8_t result = g_MAX11043_device.Write_AGain(gain);
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX11043
// CODE GENERATOR: bottom of loop: testMenuCommand="G", testMenuFirstCharHandler="None"
        } // end case 'G'
        break;

// CODE GENERATOR: top of loop: testMenuCommand="XD", testMenuFirstCharHandler="None"
// CODE GENERATOR: test menu case 'XD':
// CODE GENERATOR:           helpString 'XD -- Configure_Demo'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_Demo'
// CODE GENERATOR:           CommandParamIn 'void'
// CODE GENERATOR:           CommandReturnType 'void'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn ''
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn ''
        case 'X': // (multiple characters) (testMenuFirstCharHandler="X"):
        {
            switch (cmdLine[1])
            {
                case 'D': // (nested inside case 'X')
                {
                    // test menu command 'XD' handler:
                    // helpString='XD -- Configure_Demo'
                    // CMD_='None'
                    // CommandName='Configure_Demo'
                    // CommandParamIn='void'
                    // CommandReturnType='void'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return=''
                    cmdLine.serial().printf("Configure_Demo");
                    // call function Configure_Demo
                    g_MAX11043_device.Configure_Demo();
                    return true; // command handled by MAX11043
// CODE GENERATOR: bottom of loop: testMenuCommand="XD", testMenuFirstCharHandler="X"
                } // end nested case 'XD'
                break;

// CODE GENERATOR: top of loop: testMenuCommand="XX", testMenuFirstCharHandler="X"
// CODE GENERATOR: top of loop: nested switch "X" is currently open
// CODE GENERATOR: test menu case 'XX':
// CODE GENERATOR:           helpString 'XX linef=? rate=? -- Configure_XXXXX'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_XXXXX'
// CODE GENERATOR:           CommandParamIn 'uint8_t linef, uint8_t rate'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn ''
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
                case 'X': // (nested inside case 'X')
                {
                    // test menu command 'XX' handler:
                    // helpString='XX linef=? rate=? -- Configure_XXXXX'
                    // CMD_='None'
                    // CommandName='Configure_XXXXX'
                    // CommandParamIn='uint8_t linef, uint8_t rate'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return='@return 1 on success; 0 on failure'
                    // parse argument list
                    // parse argument uint8_t linef
                    uint8_t linef = 0; // --- g_MAX11043_device.__WARNING_no_match_for_argname_linef_in_MAX11043_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("linef", linef))
                    {
                        // g_MAX11043_device.__WARNING_no_match_for_argname_linef_in_MAX11043_device_t__ = linef; // update global property value
                    }
                    // parse argument uint8_t rate
                    uint8_t rate = 0; // --- g_MAX11043_device.__WARNING_no_match_for_argname_rate_in_MAX11043_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("rate", rate))
                    {
                        // g_MAX11043_device.__WARNING_no_match_for_argname_rate_in_MAX11043_device_t__ = rate; // update global property value
                    }
                    // print arguments
                    cmdLine.serial().printf("Configure_XXXXX");
                    cmdLine.serial().printf(" linef=%d", linef);
                    cmdLine.serial().printf(" rate=%d", rate);
                    cmdLine.serial().printf("\r\n");
                    // call function Configure_XXXXX(linef, rate)
                    uint8_t result = g_MAX11043_device.Configure_XXXXX(linef, rate);
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX11043
// CODE GENERATOR: bottom of loop: testMenuCommand="XX", testMenuFirstCharHandler="X"
                } // end nested case 'XX'
                break;

// CODE GENERATOR: top of loop: testMenuCommand="XY", testMenuFirstCharHandler="X"
// CODE GENERATOR: top of loop: nested switch "X" is currently open
// CODE GENERATOR: test menu case 'XY':
// CODE GENERATOR:           helpString 'XY linef=? rate=? -- Configure_XXXXY'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_XXXXY'
// CODE GENERATOR:           CommandParamIn 'uint8_t linef, uint8_t rate'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn ''
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
                case 'Y': // (nested inside case 'X')
                {
                    // test menu command 'XY' handler:
                    // helpString='XY linef=? rate=? -- Configure_XXXXY'
                    // CMD_='None'
                    // CommandName='Configure_XXXXY'
                    // CommandParamIn='uint8_t linef, uint8_t rate'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return='@return 1 on success; 0 on failure'
                    // parse argument list
                    // parse argument uint8_t linef
                    uint8_t linef = 0; // --- g_MAX11043_device.__WARNING_no_match_for_argname_linef_in_MAX11043_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("linef", linef))
                    {
                        // g_MAX11043_device.__WARNING_no_match_for_argname_linef_in_MAX11043_device_t__ = linef; // update global property value
                    }
                    // parse argument uint8_t rate
                    uint8_t rate = 0; // --- g_MAX11043_device.__WARNING_no_match_for_argname_rate_in_MAX11043_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("rate", rate))
                    {
                        // g_MAX11043_device.__WARNING_no_match_for_argname_rate_in_MAX11043_device_t__ = rate; // update global property value
                    }
                    // print arguments
                    cmdLine.serial().printf("Configure_XXXXY");
                    cmdLine.serial().printf(" linef=%d", linef);
                    cmdLine.serial().printf(" rate=%d", rate);
                    cmdLine.serial().printf("\r\n");
                    // call function Configure_XXXXY(linef, rate)
                    uint8_t result = g_MAX11043_device.Configure_XXXXY(linef, rate);
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX11043
// CODE GENERATOR: bottom of loop: testMenuCommand="XY", testMenuFirstCharHandler="X"
                } // end nested case 'XY'
                break;

            } // end nested switch (cmdLine[1]) inside case 'X'
            break;
        } // end case 'X'
        // has_register_write_command: case '0'..'9','A'..'F','a'..'f' letters are reserved for bitstream commands
        case '0': case '1': case '2': case '3': case '4':
        case '5': case '6': case '7': case '8': case '9':
        case 'a': case 'b': case 'c': case 'd': case 'e': case 'f':
        case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':
        {
            // hexadecimal codes get parsed as bytecodes
            //
            // parse_byteCount_byteList_dec() assumes all keyword args have already been removed from the buffer
                    // parse cmdLine byte list --> int byteCount; int mosiData[MAX_SPI_BYTE_COUNT];
                    #define MAX_SPI_BYTE_COUNT 32
                    size_t byteCount = byteCount;
                    static char mosiData[MAX_SPI_BYTE_COUNT];
                    static char misoData[MAX_SPI_BYTE_COUNT];
                    if (cmdLine.parse_byteCount_byteList_hex(byteCount, mosiData,
                                                             MAX_SPI_BYTE_COUNT))
                    {
                        // TODO: decode operation from commandByte
                        // TODO: OVERSIMPLIFICATION: if length is 1 byte then operation is RegRead, otherwise RegWrite
                        // register_read_function 'IsRegReadCommand'
                        // register_write_function 'RegWrite'
                        // register_name_function 'RegName'
                        // register_size_function 'RegSize'
// CODE GENERATOR: does the chip have a defined CMDOP_1aaa_aaaa_ReadRegister bit?
                        // MAX11043::MAX11043_CMD_enum_t regAddress = (MAX11043::MAX11043_CMD_enum_t)((mosiData[0] &~ MAX11043::CMDOP_1aaa_aaaa_ReadRegister) & 0xFF);
                        MAX11043::MAX11043_CMD_enum_t commandByte = (MAX11043::MAX11043_CMD_enum_t)(mosiData[0]);
                        MAX11043::MAX11043_CMDOP_enum_t commandOp = g_MAX11043_device.DecodeCommand(commandByte);
                        int regAddress = g_MAX11043_device.RegAddrOfCommand(commandByte);
                        cmdLine.serial().printf(" regAddress=0x%2.2x\r\n", (regAddress & 0xFF));
                        cmdLine.serial().printf(" RegName=%s\r\n", g_MAX11043_device.RegName(commandByte));
                        uint32_t regData = 0;
                        int regSize = g_MAX11043_device.RegSize(commandByte);
                        cmdLine.serial().printf(" RegSize=%d\r\n", regSize);
                        switch(regSize)
                        {
                        case 8:
                            regData = ((uint32_t)mosiData[1] & 0xFF);
                            break;
                        case 16:
                            regData = (((uint32_t)mosiData[1] & 0xFF) << 8) + ((uint32_t)mosiData[2] & 0xFF);
                            break;
                        case 24:
                            regData = (((uint32_t)mosiData[1] & 0xFF) << 16) + (((uint32_t)mosiData[2] & 0xFF) << 8) + ((uint32_t)mosiData[3] & 0xFF);
                            break;
                        }
// CODE GENERATOR: does the chip have a defined CMDOP_1aaa_aaaa_ReadRegister bit?
                        // if ((byteCount == 1) || (regAddress & MAX11043::CMDOP_1aaa_aaaa_ReadRegister))
                        if ((byteCount == 1) || g_MAX11043_device.IsRegReadCommand(commandByte))
                        {
                            cmdLine.serial().printf(" RegRead");
                            g_MAX11043_device.RegRead(commandByte, &regData);
                            cmdLine.serial().printf("regData=0x%6.6x\r\n", (regData & 0x00FFFFFF));
                        }
                        else
                        {
                            cmdLine.serial().printf(" RegWrite regData=0x%6.6X\r\n", (regData & 0x00FFFFFF));
                            g_MAX11043_device.RegWrite(commandByte, regData);
                        }
                        // is there support function shadow regValue of regAddr?
                    }
                    return true; // command handled by MAX11043
            //
        } // end case '0'..'9','A'..'F','a'..'f'
        break;
    } // end switch (cmdLine[0])
    return false; // command not handled by MAX11043
} // end bool MAX11043_menu_onEOLcommandParser(CmdLine & cmdLine)

// CODE GENERATOR: class declaration statement close
