// /*******************************************************************************
// * Copyright (C) 2020 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
//---------- CODE GENERATOR: testMainCppCodeList
// CODE GENERATOR: example code includes

// example code includes
// standard include for target platform -- Platform_Include_Boilerplate
#include "mbed.h"
// Platforms:
//   - MAX32625MBED
//      - supports mbed-os-5.11, requires USBDevice library
//      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32600MBED
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
//   - NUCLEO_F446RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - NUCLEO_F401RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32630FTHR
//      - #include "max32630fthr.h"
//      - add http://os.mbed.org/teams/MaximIntegrated/code/max32630fthr/
//      - remove MAX32620FTHR library (if present)
//   - MAX32620FTHR
//      - #include "MAX32620FTHR.h"
//      - remove max32630fthr library (if present)
//      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
//      - not tested yet
//   - MAX32625PICO
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - not tested yet
//
// end Platform_Include_Boilerplate
#include "MAX11043.h"
#include "CmdLine.h"
#include "MaximTinyTester.h"

// optional: serial port
// note: some platforms such as Nucleo-F446RE do not support the USBSerial library.
// In those cases, remove the USBDevice lib from the project and rebuild.
#if defined(TARGET_MAX32625MBED)
#include "USBSerial.h"
USBSerial serial; // virtual serial port over USB (DEV connector)
#elif defined(TARGET_MAX32630MBED)
#include "USBSerial.h"
USBSerial serial; // virtual serial port over USB (DEV connector)
#else
//#include "USBSerial.h"
Serial serial(USBTX, USBRX); // tx, rx
#endif

void on_immediate_0x21(); // Unicode (U+0021) ! EXCLAMATION MARK
void on_immediate_0x7b(); // Unicode (U+007B) { LEFT CURLY BRACKET
void on_immediate_0x7d(); // Unicode (U+007D) } RIGHT CURLY BRACKET

#include "CmdLine.h"

# if HAS_DAPLINK_SERIAL
CmdLine cmdLine_DAPLINKserial(DAPLINKserial, "DAPLINK");
# endif // HAS_DAPLINK_SERIAL
CmdLine cmdLine_serial(serial, "serial");


//--------------------------------------------------


#if defined(TARGET)
// TARGET_NAME macros from targets/TARGET_Maxim/TARGET_MAX32625/device/mxc_device.h
// Create a string definition for the TARGET
#define STRING_ARG(arg) #arg
#define STRING_NAME(name) STRING_ARG(name)
#define TARGET_NAME STRING_NAME(TARGET)
#elif defined(TARGET_MAX32600)
#define TARGET_NAME "MAX32600"
#elif defined(TARGET_LPC1768)
#define TARGET_NAME "LPC1768"
#elif defined(TARGET_NUCLEO_F446RE)
#define TARGET_NAME "NUCLEO_F446RE"
#elif defined(TARGET_NUCLEO_F401RE)
#define TARGET_NAME "NUCLEO_F401RE"
#else
#error TARGET NOT DEFINED
#endif
#if defined(TARGET_MAX32630)
//--------------------------------------------------
// TARGET=MAX32630FTHR ARM Cortex-M4F 96MHz 2048kB Flash 512kB SRAM
//             +-------------[microUSB]-------------+
//             | J1         MAX32630FTHR        J2  |
//      ______ | [ ] RST                    GND [ ] |
//      ______ | [ ] 3V3                    BAT+[ ] |
//      ______ | [ ] 1V8                  reset SW1 |
//      ______ | [ ] GND       J4               J3  |
// analogIn0/4 | [a] AIN_0 1.2Vfs     (bat) SYS [ ] | switched BAT+
// analogIn1/5 | [a] AIN_1 1.2Vfs           PWR [ ] | external pwr btn
// analogIn2   | [a] AIN_2 1.2Vfs      +5V VBUS [ ] | USB +5V power
// analogIn3   | [a] AIN_3 1.2Vfs   1-WIRE P4_0 [d] | D0 dig9
//  (I2C2.SDA) | [d] P5_7  SDA2        SRN P5_6 [d] | D1 dig8
//  (I2C2.SCL) | [d] P6_0  SCL2      SDIO3 P5_5 [d] | D2 dig7
//    D13/SCLK | [s] P5_0  SCLK      SDIO2 P5_4 [d] | D3 dig6
//    D11/MOSI | [s] P5_1  MOSI       SSEL P5_3 [d] | D4 dig5
//    D12/MISO | [s] P5_2  MISO        RTS P3_3 [d] | D5 dig4
//    D10/CS   | [s] P3_0  RX          CTS P3_2 [d] | D6 dig3
//    D9  dig0 | [d] P3_1  TX          SCL P3_5 [d] | D7 dig2
//      ______ | [ ] GND               SDA P3_4 [d] | D8 dig1
//             |                                    |
//             | XIP Flash      MAX14690N           |
//             | XIP_SCLK P1_0  SDA2 P5_7           |
//             | XIP_MOSI P1_1  SCL2 P6_0           |
//             | XIP_MISO P1_2  PMIC_INIT P3_7      |
//             | XIP_SSEL P1_3  MPC P2_7            |
//             | XIP_DIO2 P1_4  MON AIN_0           |
//             | XIP_DIO3 P1_5                      |
//             |                                    |
//             | PAN1326B     MicroSD        LED    |
//             | BT_RX  P0_0  SD_SCLK P0_4   r P2_4 |
//             | BT_TX  P0_1  SD_MOSI P0_5   g P2_5 |
//             | BT_CTS P0_2  SD_MISO P0_6   b P2_6 |
//             | BT_RTS P0_3  SD_SSEL P0_7          |
//             | BT_RST P1_6  DETECT  P2_2          |
//             | BT_CLK P1_7               SW2 P2_3 |
//             +------------------------------------+
// MAX32630FTHR board has MAX14690 PMIC on I2C bus (P5_7 SDA, P6_0 SCL) at slave address 0101_000r 0x50 (or 0x28 for 7 MSbit address).
// MAX32630FTHR board has BMI160 accelerometer on I2C bus (P5_7 SDA, P6_0 SCL) at slave address 1101_000r 0xD0 (or 0x68 for 7 MSbit address).
// AIN_0 = AIN0 pin       fullscale is 1.2V
// AIN_1 = AIN1 pin       fullscale is 1.2V
// AIN_2 = AIN2 pin       fullscale is 1.2V
// AIN_3 = AIN3 pin       fullscale is 1.2V
// AIN_4 = AIN0 / 5.0     fullscale is 6.0V
// AIN_5 = AIN1 / 5.0     fullscale is 6.0V
// AIN_6 = VDDB / 4.0     fullscale is 4.8V
// AIN_7 = VDD18          fullscale is 1.2V
// AIN_8 = VDD12          fullscale is 1.2V
// AIN_9 = VRTC / 2.0     fullscale is 2.4V
// AIN_10 = x undefined?
// AIN_11 = VDDIO / 4.0   fullscale is 4.8V
// AIN_12 = VDDIOH / 4.0  fullscale is 4.8V
//
    #include "max32630fthr.h"
MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
#define analogIn4_IS_HIGH_RANGE_OF_analogIn0 1
// MAX32630FTHR board supports only internal VREF = 1.200V at bypass capacitor C15
const float ADC_FULL_SCALE_VOLTAGE = 1.200;
// Arduino connector
#ifndef A0
#define A0 AIN_0
#endif
#ifndef A1
#define A1 AIN_1
#endif
#ifndef A2
#define A2 AIN_2
#endif
#ifndef A3
#define A3 AIN_3
#endif
#ifndef D0
#define D0 P4_0
#endif
#ifndef D1
#define D1 P5_6
#endif
#ifndef D2
#define D2 P5_5
#endif
#ifndef D3
#define D3 P5_4
#endif
#ifndef D4
#define D4 P5_3
#endif
#ifndef D5
#define D5 P3_3
#endif
#ifndef D6
#define D6 P3_2
#endif
#ifndef D7
#define D7 P3_5
#endif
#ifndef D8
#define D8 P3_4
#endif
#ifndef D9
#define D9 P3_1
#endif
#ifndef D10
#define D10 P3_0
#endif
#ifndef D11
#define D11 P5_1
#endif
#ifndef D12
#define D12 P5_2
#endif
#ifndef D13
#define D13 P5_0
#endif
//--------------------------------------------------
#elif defined(TARGET_MAX32625MBED)
//--------------------------------------------------
// TARGET=MAX32625MBED ARM Cortex-M4F 96MHz 512kB Flash 160kB SRAM
//             +-------------------------------------+
//             |   MAX32625MBED Arduino UNO header   |
//             |                                     |
//             |                           A5/SCL[ ] |   P1_7 dig15
//             |                           A4/SDA[ ] |   P1_6 dig14
//             |                         AREF=N/C[ ] |
//             |                              GND[ ] |
//             | [ ]N/C                    SCK/13[ ] |   P1_0 dig13
//             | [ ]IOREF=3V3             MISO/12[ ] |   P1_2 dig12
//             | [ ]RST                   MOSI/11[ ]~|   P1_1 dig11
//             | [ ]3V3                     CS/10[ ]~|   P1_3 dig10
//             | [ ]5V0                         9[ ]~|   P1_5 dig9
//             | [ ]GND                         8[ ] |   P1_4 dig8
//             | [ ]GND                              |
//             | [ ]Vin                         7[ ] |   P0_7 dig7
//             |                                6[ ]~|   P0_6 dig6
//       AIN_0 | [ ]A0                          5[ ]~|   P0_5 dig5
//       AIN_1 | [ ]A1                          4[ ] |   P0_4 dig4
//       AIN_2 | [ ]A2                     INT1/3[ ]~|   P0_3 dig3
//       AIN_3 | [ ]A3                     INT0/2[ ] |   P0_2 dig2
// dig16  P3_4 | [ ]A4/SDA  RST SCK MISO     TX>1[ ] |   P0_1 dig1
// dig17  P3_5 | [ ]A5/SCL  [ ] [ ] [ ]      RX<0[ ] |   P0_0 dig0
//             |            [ ] [ ] [ ]              |
//             |  UNO_R3    GND MOSI 5V  ____________/
//              \_______________________/
//
//             +------------------------+
//             |                        |
//             |  MicroSD        LED    |
//             |  SD_SCLK P2_4   r P3_0 |
//             |  SD_MOSI P2_5   g P3_1 |
//             |  SD_MISO P2_6   b P3_2 |
//             |  SD_SSEL P2_7   y P3_3 |
//             |                        |
//             |  DAPLINK      BUTTONS  |
//             |  TX P2_1      SW3 P2_3 |
//             |  RX P2_0      SW2 P2_2 |
//             +------------------------+
//
// AIN_0 = AIN0 pin       fullscale is 1.2V
// AIN_1 = AIN1 pin       fullscale is 1.2V
// AIN_2 = AIN2 pin       fullscale is 1.2V
// AIN_3 = AIN3 pin       fullscale is 1.2V
// AIN_4 = AIN0 / 5.0     fullscale is 6.0V
// AIN_5 = AIN1 / 5.0     fullscale is 6.0V
// AIN_6 = VDDB / 4.0     fullscale is 4.8V
// AIN_7 = VDD18          fullscale is 1.2V
// AIN_8 = VDD12          fullscale is 1.2V
// AIN_9 = VRTC / 2.0     fullscale is 2.4V
// AIN_10 = x undefined?
// AIN_11 = VDDIO / 4.0   fullscale is 4.8V
// AIN_12 = VDDIOH / 4.0  fullscale is 4.8V
//
//#include "max32625mbed.h" // ?
//MAX32625MBED mbed(MAX32625MBED::VIO_3V3); // ?
#define analogIn4_IS_HIGH_RANGE_OF_analogIn0 1
// MAX32630FTHR board supports only internal VREF = 1.200V at bypass capacitor C15
const float ADC_FULL_SCALE_VOLTAGE = 1.200;     // TODO: ADC_FULL_SCALE_VOLTAGE Pico?
// Arduino connector
#ifndef A0
#define A0 AIN_0
#endif
#ifndef A1
#define A1 AIN_1
#endif
#ifndef A2
#define A2 AIN_2
#endif
#ifndef A3
#define A3 AIN_3
#endif
#ifndef D0
#define D0 P0_0
#endif
#ifndef D1
#define D1 P0_1
#endif
#ifndef D2
#define D2 P0_2
#endif
#ifndef D3
#define D3 P0_3
#endif
#ifndef D4
#define D4 P0_4
#endif
#ifndef D5
#define D5 P0_5
#endif
#ifndef D6
#define D6 P0_6
#endif
#ifndef D7
#define D7 P0_7
#endif
#ifndef D8
#define D8 P1_4
#endif
#ifndef D9
#define D9 P1_5
#endif
#ifndef D10
#define D10 P1_3
#endif
#ifndef D11
#define D11 P1_1
#endif
#ifndef D12
#define D12 P1_2
#endif
#ifndef D13
#define D13 P1_0
#endif
//--------------------------------------------------
#elif defined(TARGET_MAX32600)
// target MAX32600
//
#define analogIn4_IS_HIGH_RANGE_OF_analogIn0 0
const float ADC_FULL_SCALE_VOLTAGE = 1.500;
//
//--------------------------------------------------
#elif defined(TARGET_MAX32620FTHR)
#warning "TARGET_MAX32620FTHR not previously tested; need to define pins..."
#include "MAX32620FTHR.h"
// Initialize I/O voltages on MAX32620FTHR board
MAX32620FTHR fthr(MAX32620FTHR::VIO_3V3);
//#define USE_LEDS 0 ?
#define analogIn4_IS_HIGH_RANGE_OF_analogIn0 1
#warning "TARGET_MAX32620FTHR not previously tested; need to verify ADC_FULL_SCALE_VOLTAGE..."
const float ADC_FULL_SCALE_VOLTAGE = 1.200;
//
//--------------------------------------------------
#elif defined(TARGET_MAX32625PICO)
#warning "TARGET_MAX32625PICO not previously tested; need to define pins..."
//#define USE_LEDS 0 ?
#define analogIn4_IS_HIGH_RANGE_OF_analogIn0 1
#warning "TARGET_MAX32625PICO not previously tested; need to verify ADC_FULL_SCALE_VOLTAGE..."
const float ADC_FULL_SCALE_VOLTAGE = 1.200;
//
//--------------------------------------------------
#elif defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F401RE)
// TODO1: target NUCLEO_F446RE
//
// USER_BUTTON PC13
// LED1 is shared with SPI_SCK on NUCLEO_F446RE PA_5, so don't use LED1.
#define USE_LEDS 0
// SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK);
// Serial serial(SERIAL_TX, SERIAL_RX);
#define analogIn4_IS_HIGH_RANGE_OF_analogIn0 0
const float ADC_FULL_SCALE_VOLTAGE = 3.300;     // TODO: ADC_FULL_SCALE_VOLTAGE Pico?
//
//--------------------------------------------------
#elif defined(TARGET_LPC1768)
//--------------------------------------------------
// TARGET=LPC1768 ARM Cortex-M3 100 MHz 512kB flash 64kB SRAM
//               +-------------[microUSB]-------------+
//        ______ | [ ] GND             +3.3V VOUT [ ] | ______
//        ______ | [ ] 4.5V<VIN<9.0V   +5.0V VU   [ ] | ______
//        ______ | [ ] VB                 USB.IF- [ ] | ______
//        ______ | [ ] nR                 USB.IF+ [ ] | ______
// digitalInOut0 | [ ] p5 MOSI       ETHERNET.RD- [ ] | ______
// digitalInOut1 | [ ] p6 MISO       ETHERNET.RD+ [ ] | ______
// digitalInOut2 | [ ] p7 SCLK       ETHERNET.TD- [ ] | ______
// digitalInOut3 | [ ] p8            ETHERNET.TD+ [ ] | ______
// digitalInOut4 | [ ] p9  TX SDA          USB.D- [ ] | ______
// digitalInOut5 | [ ] p10 RX SCL          USB.D+ [ ] | ______
// digitalInOut6 | [ ] p11    MOSI     CAN-RD p30 [ ] | digitalInOut13
// digitalInOut7 | [ ] p12    MISO     CAN-TD p29 [ ] | digitalInOut12
// digitalInOut8 | [ ] p13 TX SCLK     SDA TX p28 [ ] | digitalInOut11
// digitalInOut9 | [ ] p14 RX          SCL RX p27 [ ] | digitalInOut10
//     analogIn0 | [ ] p15 AIN0 3.3Vfs   PWM1 p26 [ ] | pwmDriver1
//     analogIn1 | [ ] p16 AIN1 3.3Vfs   PWM2 p25 [ ] | pwmDriver2
//     analogIn2 | [ ] p17 AIN2 3.3Vfs   PWM3 p24 [ ] | pwmDriver3
//     analogIn3 | [ ] p18 AIN3 AOUT     PWM4 p23 [ ] | pwmDriver4
//     analogIn4 | [ ] p19 AIN4 3.3Vfs   PWM5 p22 [ ] | pwmDriver5
//     analogIn5 | [ ] p20 AIN5 3.3Vfs   PWM6 p21 [ ] | pwmDriver6
//               +------------------------------------+
// AIN6 = P0.3 = TGT_SBL_RXD?
// AIN7 = P0.2 = TGT_SBL_TXD?
//
//--------------------------------------------------
// LPC1768 board uses VREF = 3.300V +A3,3V thru L1 to bypass capacitor C14
#define analogIn4_IS_HIGH_RANGE_OF_analogIn0 0
const float ADC_FULL_SCALE_VOLTAGE = 3.300;
#else // not defined(TARGET_LPC1768 etc.)
//--------------------------------------------------
// unknown target
//--------------------------------------------------
#endif // target definition


//--------------------------------------------------
// Option to dedicate SPI port pins
//
//    SPI2_MOSI  = P5_1
//    SPI2_MISO  = P5_2
//    SPI2_SCK   = P5_0
//    On this board I'm using P3_0 as spi_cs
//    SPI2_SS    = P5_3
//    SPI2_SDIO2 = P5_4
//    SPI2_SDIO3 = P5_5
//    SPI2_SRN   = P5_6
//
#ifndef HAS_SPI
#define HAS_SPI 1
#endif
#if HAS_SPI
#define SPI_MODE0 0
#define SPI_MODE1 1
#define SPI_MODE2 2
#define SPI_MODE3 3
//
#if defined(TARGET_MAX32630)
  // Before setting global variables g_SPI_SCLK_Hz and g_SPI_dataMode,
  // workaround for TARGET_MAX32630 SPI_MODE2 SPI_MODE3 problem (issue #30)
#warning "MAX32630 SPI workaround..."
  // replace SPI_MODE2 (CPOL=1,CPHA=0) with SPI_MODE1 (CPOL=0,CPHA=1) Falling Edge stable
  // replace SPI_MODE3 (CPOL=1,CPHA=1) with SPI_MODE0 (CPOL=0,CPHA=0) Rising Edge stable
# if ((SPI_dataMode) == (SPI_MODE2))
#warning "MAX32630 SPI_MODE2 workaround, changing SPI_dataMode to SPI_MODE1..."
  // SPI_dataMode SPI_MODE2 // CPOL=1,CPHA=0: Falling Edge stable; SCLK idle High
#  undef SPI_dataMode
#  define SPI_dataMode SPI_MODE1 // CPOL=0,CPHA=1: Falling Edge stable; SCLK idle Low
# elif ((SPI_dataMode) == (SPI_MODE3))
#warning "MAX32630 SPI_MODE3 workaround, changing SPI_dataMode to SPI_MODE0..."
  // SPI_dataMode SPI_MODE3 // CPOL=1,CPHA=1: Rising Edge stable; SCLK idle High
#  undef SPI_dataMode
#  define SPI_dataMode SPI_MODE0 // CPOL=0,CPHA=0: Rising Edge stable; SCLK idle Low
# endif // workaround for TARGET_MAX32630 SPI_MODE2 SPI_MODE3 problem
  // workaround for TARGET_MAX32630 SPI_MODE2 SPI_MODE3 problem (issue #30)
  // limit SPI SCLK speed to 6MHz or less
# if ((SPI_SCLK_Hz) > (6000000))
#warning "MAX32630 SPI speed workaround, changing SPI_SCLK_Hz to 6000000 or 6MHz..."
#  undef SPI_SCLK_Hz
#  define SPI_SCLK_Hz 6000000 // 6MHz
# endif
#endif
//
uint32_t g_SPI_SCLK_Hz = 24000000; // platform limit 24MHz intSPI_SCLK_Platform_Max_MHz * 1000000
// TODO1: validate g_SPI_SCLK_Hz against system clock frequency SystemCoreClock F_CPU
#if defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F401RE)
// Nucleo SPI frequency isn't working quite as expected...
// Looks like STMF4 has an spi clock prescaler (2,4,8,16,32,64,128,256)
// so 180MHz->[90.0, 45.0, 22.5, 11.25, 5.625, 2.8125, 1.40625, 0.703125]
// %SC SCLK=1MHz sets spi frequency 703.125kHz
// %SC SCLK=2MHz sets spi frequency 1.40625MHz
// %SC SCLK=3MHz sets spi frequency 2.8125MHz
// %SC SCLK=6MHz sets spi frequency 5.625MHz
// %SC SCLK=12MHz sets spi frequency 11.25MHz
// %SC SCLK=23MHz sets spi frequency 22.5MHz
// %SC SCLK=45MHz sets spi frequency 45.0MHz
// Don't know why I can't reach spi frequency 90.0MHz, but ok whatever.
const uint32_t limit_min_SPI_SCLK_divisor = 2;
const uint32_t limit_max_SPI_SCLK_divisor = 256;
// not really a divisor, just a powers-of-two prescaler with no intermediate divisors.
#else
const uint32_t limit_min_SPI_SCLK_divisor = 2;
const uint32_t limit_max_SPI_SCLK_divisor = 8191;
#endif
const uint32_t limit_max_SPI_SCLK_Hz = (SystemCoreClock / limit_min_SPI_SCLK_divisor); // F_CPU / 2; // 8MHz / 2 = 4MHz
const uint32_t limit_min_SPI_SCLK_Hz = (SystemCoreClock / limit_max_SPI_SCLK_divisor); // F_CPU / 128; // 8MHz / 128 = 62.5kHz
//
uint8_t g_SPI_dataMode = SPI_MODE0; // TODO: missing definition SPI_dataMode;
uint8_t g_SPI_cs_state = 1;
//
#endif


// uncrustify-0.66.1 *INDENT-OFF*
//--------------------------------------------------
// Declare the DigitalInOut GPIO pins
// Optional digitalInOut support. If there is only one it should be digitalInOut1.
// D) Digital High/Low/Input Pin
#if defined(TARGET_MAX32630)
//       +-------------[microUSB]-------------+
//       | J1         MAX32630FTHR        J2  |
//       | [ ] RST                    GND [ ] |
//       | [ ] 3V3                    BAT+[ ] |
//       | [ ] 1V8                  reset SW1 |
//       | [ ] GND       J4               J3  |
//       | [ ] AIN_0 1.2Vfs     (bat) SYS [ ] |
//       | [ ] AIN_1 1.2Vfs           PWR [ ] |
//       | [ ] AIN_2 1.2Vfs      +5V VBUS [ ] |
//       | [ ] AIN_3 1.2Vfs   1-WIRE P4_0 [ ] | dig9
// dig10 | [x] P5_7  SDA2        SRN P5_6 [ ] | dig8
// dig11 | [x] P6_0  SCL2      SDIO3 P5_5 [ ] | dig7
// dig12 | [x] P5_0  SCLK      SDIO2 P5_4 [ ] | dig6
// dig13 | [x] P5_1  MOSI       SSEL P5_3 [x] | dig5
// dig14 | [ ] P5_2  MISO        RTS P3_3 [ ] | dig4
// dig15 | [ ] P3_0  RX          CTS P3_2 [ ] | dig3
// dig0  | [ ] P3_1  TX          SCL P3_5 [x] | dig2
//       | [ ] GND               SDA P3_4 [x] | dig1
//       +------------------------------------+
    #define HAS_digitalInOut0 1 // P3_1 TARGET_MAX32630 J1.15
    #define HAS_digitalInOut1 1 // P3_4 TARGET_MAX32630 J3.12
    #define HAS_digitalInOut2 1 // P3_5 TARGET_MAX32630 J3.11
    #define HAS_digitalInOut3 1 // P3_2 TARGET_MAX32630 J3.10
    #define HAS_digitalInOut4 1 // P3_3 TARGET_MAX32630 J3.9
    #define HAS_digitalInOut5 1 // P5_3 TARGET_MAX32630 J3.8
    #define HAS_digitalInOut6 1 // P5_4 TARGET_MAX32630 J3.7
    #define HAS_digitalInOut7 1 // P5_5 TARGET_MAX32630 J3.6
    #define HAS_digitalInOut8 1 // P5_6 TARGET_MAX32630 J3.5
    #define HAS_digitalInOut9 1 // P4_0 TARGET_MAX32630 J3.4
#if HAS_I2C
// avoid resource conflict between P5_7, P6_0 I2C and DigitalInOut
    #define HAS_digitalInOut10 0 // P5_7 TARGET_MAX32630 J1.9
    #define HAS_digitalInOut11 0 // P6_0 TARGET_MAX32630 J1.10
#else // HAS_I2C
    #define HAS_digitalInOut10 1 // P5_7 TARGET_MAX32630 J1.9
    #define HAS_digitalInOut11 1 // P6_0 TARGET_MAX32630 J1.10
#endif // HAS_I2C
#if HAS_SPI
// avoid resource conflict between P5_0, P5_1, P5_2 SPI and DigitalInOut
    #define HAS_digitalInOut12 0 // P5_0 TARGET_MAX32630 J1.11
    #define HAS_digitalInOut13 0 // P5_1 TARGET_MAX32630 J1.12
    #define HAS_digitalInOut14 0 // P5_2 TARGET_MAX32630 J1.13
    #define HAS_digitalInOut15 0 // P3_0 TARGET_MAX32630 J1.14
#else // HAS_SPI
    #define HAS_digitalInOut12 1 // P5_0 TARGET_MAX32630 J1.11
    #define HAS_digitalInOut13 1 // P5_1 TARGET_MAX32630 J1.12
    #define HAS_digitalInOut14 1 // P5_2 TARGET_MAX32630 J1.13
    #define HAS_digitalInOut15 1 // P3_0 TARGET_MAX32630 J1.14
#endif // HAS_SPI
#if HAS_digitalInOut0
    DigitalInOut digitalInOut0(P3_1, PIN_INPUT, PullUp, 1); // P3_1 TARGET_MAX32630 J1.15
#endif
#if HAS_digitalInOut1
    DigitalInOut digitalInOut1(P3_4, PIN_INPUT, PullUp, 1); // P3_4 TARGET_MAX32630 J3.12
#endif
#if HAS_digitalInOut2
    DigitalInOut digitalInOut2(P3_5, PIN_INPUT, PullUp, 1); // P3_5 TARGET_MAX32630 J3.11
#endif
#if HAS_digitalInOut3
    DigitalInOut digitalInOut3(P3_2, PIN_INPUT, PullUp, 1); // P3_2 TARGET_MAX32630 J3.10
#endif
#if HAS_digitalInOut4
    DigitalInOut digitalInOut4(P3_3, PIN_INPUT, PullUp, 1); // P3_3 TARGET_MAX32630 J3.9
#endif
#if HAS_digitalInOut5
    DigitalInOut digitalInOut5(P5_3, PIN_INPUT, PullUp, 1); // P5_3 TARGET_MAX32630 J3.8
#endif
#if HAS_digitalInOut6
    DigitalInOut digitalInOut6(P5_4, PIN_INPUT, PullUp, 1); // P5_4 TARGET_MAX32630 J3.7
#endif
#if HAS_digitalInOut7
    DigitalInOut digitalInOut7(P5_5, PIN_INPUT, PullUp, 1); // P5_5 TARGET_MAX32630 J3.6
#endif
#if HAS_digitalInOut8
    DigitalInOut digitalInOut8(P5_6, PIN_INPUT, PullUp, 1); // P5_6 TARGET_MAX32630 J3.5
#endif
#if HAS_digitalInOut9
    DigitalInOut digitalInOut9(P4_0, PIN_INPUT, PullUp, 1); // P4_0 TARGET_MAX32630 J3.4
#endif
#if HAS_digitalInOut10
    DigitalInOut digitalInOut10(P5_7, PIN_INPUT, PullUp, 1); // P5_7 TARGET_MAX32630 J1.9
#endif
#if HAS_digitalInOut11
    DigitalInOut digitalInOut11(P6_0, PIN_INPUT, PullUp, 1); // P6_0 TARGET_MAX32630 J1.10
#endif
#if HAS_digitalInOut12
    DigitalInOut digitalInOut12(P5_0, PIN_INPUT, PullUp, 1); // P5_0 TARGET_MAX32630 J1.11
#endif
#if HAS_digitalInOut13
    DigitalInOut digitalInOut13(P5_1, PIN_INPUT, PullUp, 1); // P5_1 TARGET_MAX32630 J1.12
#endif
#if HAS_digitalInOut14
    DigitalInOut digitalInOut14(P5_2, PIN_INPUT, PullUp, 1); // P5_2 TARGET_MAX32630 J1.13
#endif
#if HAS_digitalInOut15
    DigitalInOut digitalInOut15(P3_0, PIN_INPUT, PullUp, 1); // P3_0 TARGET_MAX32630 J1.14
#endif
//--------------------------------------------------
#elif defined(TARGET_MAX32625MBED)
// TARGET=MAX32625MBED ARM Cortex-M4F 96MHz 512kB Flash 160kB SRAM
//             +-------------------------------------+
//             |   MAX32625MBED Arduino UNO header   |
//             |                                     |
//             |                           A5/SCL[ ] |   P1_7 dig15
//             |                           A4/SDA[ ] |   P1_6 dig14
//             |                         AREF=N/C[ ] |
//             |                              GND[ ] |
//             | [ ]N/C                    SCK/13[ ] |   P1_0 dig13
//             | [ ]IOREF=3V3             MISO/12[ ] |   P1_2 dig12
//             | [ ]RST                   MOSI/11[ ]~|   P1_1 dig11
//             | [ ]3V3                     CS/10[ ]~|   P1_3 dig10
//             | [ ]5V0                         9[ ]~|   P1_5 dig9
//             | [ ]GND                         8[ ] |   P1_4 dig8
//             | [ ]GND                              |
//             | [ ]Vin                         7[ ] |   P0_7 dig7
//             |                                6[ ]~|   P0_6 dig6
//       AIN_0 | [ ]A0                          5[ ]~|   P0_5 dig5
//       AIN_1 | [ ]A1                          4[ ] |   P0_4 dig4
//       AIN_2 | [ ]A2                     INT1/3[ ]~|   P0_3 dig3
//       AIN_3 | [ ]A3                     INT0/2[ ] |   P0_2 dig2
// dig16  P3_4 | [ ]A4/SDA  RST SCK MISO     TX>1[ ] |   P0_1 dig1
// dig17  P3_5 | [ ]A5/SCL  [ ] [ ] [ ]      RX<0[ ] |   P0_0 dig0
//             |            [ ] [ ] [ ]              |
//             |  UNO_R3    GND MOSI 5V  ____________/
//              \_______________________/
//
    #define HAS_digitalInOut0 1 // P0_0 TARGET_MAX32625MBED D0
    #define HAS_digitalInOut1 1 // P0_1 TARGET_MAX32625MBED D1
#if APPLICATION_MAX11131
    #define HAS_digitalInOut2 0 // P0_2 TARGET_MAX32625MBED D2 -- MAX11131 EOC DigitalIn
#else
    #define HAS_digitalInOut2 1 // P0_2 TARGET_MAX32625MBED D2
#endif
    #define HAS_digitalInOut3 1 // P0_3 TARGET_MAX32625MBED D3
    #define HAS_digitalInOut4 1 // P0_4 TARGET_MAX32625MBED D4
    #define HAS_digitalInOut5 1 // P0_5 TARGET_MAX32625MBED D5
    #define HAS_digitalInOut6 1 // P0_6 TARGET_MAX32625MBED D6
    #define HAS_digitalInOut7 1 // P0_7 TARGET_MAX32625MBED D7
    #define HAS_digitalInOut8 1 // P1_4 TARGET_MAX32625MBED D8
#if APPLICATION_MAX11131
    #define HAS_digitalInOut9 0 // P1_5 TARGET_MAX32625MBED D9 -- MAX11131 CNVST DigitalOut
#else
    #define HAS_digitalInOut9 1 // P1_5 TARGET_MAX32625MBED D9
#endif
#if HAS_SPI
// avoid resource conflict between P5_0, P5_1, P5_2 SPI and DigitalInOut
    #define HAS_digitalInOut10 0 // P1_3 TARGET_MAX32635MBED CS/10
    #define HAS_digitalInOut11 0 // P1_1 TARGET_MAX32635MBED MOSI/11
    #define HAS_digitalInOut12 0 // P1_2 TARGET_MAX32635MBED MISO/12
    #define HAS_digitalInOut13 0 // P1_0 TARGET_MAX32635MBED SCK/13
#else // HAS_SPI
    #define HAS_digitalInOut10 1 // P1_3 TARGET_MAX32635MBED CS/10
    #define HAS_digitalInOut11 1 // P1_1 TARGET_MAX32635MBED MOSI/11
    #define HAS_digitalInOut12 1 // P1_2 TARGET_MAX32635MBED MISO/12
    #define HAS_digitalInOut13 1 // P1_0 TARGET_MAX32635MBED SCK/13
#endif // HAS_SPI
#if HAS_I2C
// avoid resource conflict between P5_7, P6_0 I2C and DigitalInOut
    #define HAS_digitalInOut14 0 // P1_6 TARGET_MAX32635MBED A4/SDA (10pin digital connector)
    #define HAS_digitalInOut15 0 // P1_7 TARGET_MAX32635MBED A5/SCL (10pin digital connector)
    #define HAS_digitalInOut16 0 // P3_4 TARGET_MAX32635MBED A4/SDA (6pin analog connector)
    #define HAS_digitalInOut17 0 // P3_5 TARGET_MAX32635MBED A5/SCL (6pin analog connector)
#else // HAS_I2C
    #define HAS_digitalInOut14 1 // P1_6 TARGET_MAX32635MBED A4/SDA (10pin digital connector)
    #define HAS_digitalInOut15 1 // P1_7 TARGET_MAX32635MBED A5/SCL (10pin digital connector)
    #define HAS_digitalInOut16 1 // P3_4 TARGET_MAX32635MBED A4/SDA (6pin analog connector)
    #define HAS_digitalInOut17 1 // P3_5 TARGET_MAX32635MBED A5/SCL (6pin analog connector)
#endif // HAS_I2C
#if HAS_digitalInOut0
    DigitalInOut digitalInOut0(P0_0, PIN_INPUT, PullUp, 1); // P0_0 TARGET_MAX32625MBED D0
#endif
#if HAS_digitalInOut1
    DigitalInOut digitalInOut1(P0_1, PIN_INPUT, PullUp, 1); // P0_1 TARGET_MAX32625MBED D1
#endif
#if HAS_digitalInOut2
    DigitalInOut digitalInOut2(P0_2, PIN_INPUT, PullUp, 1); // P0_2 TARGET_MAX32625MBED D2
#endif
#if HAS_digitalInOut3
    DigitalInOut digitalInOut3(P0_3, PIN_INPUT, PullUp, 1); // P0_3 TARGET_MAX32625MBED D3
#endif
#if HAS_digitalInOut4
    DigitalInOut digitalInOut4(P0_4, PIN_INPUT, PullUp, 1); // P0_4 TARGET_MAX32625MBED D4
#endif
#if HAS_digitalInOut5
    DigitalInOut digitalInOut5(P0_5, PIN_INPUT, PullUp, 1); // P0_5 TARGET_MAX32625MBED D5
#endif
#if HAS_digitalInOut6
    DigitalInOut digitalInOut6(P0_6, PIN_INPUT, PullUp, 1); // P0_6 TARGET_MAX32625MBED D6
#endif
#if HAS_digitalInOut7
    DigitalInOut digitalInOut7(P0_7, PIN_INPUT, PullUp, 1); // P0_7 TARGET_MAX32625MBED D7
#endif
#if HAS_digitalInOut8
    DigitalInOut digitalInOut8(P1_4, PIN_INPUT, PullUp, 1); // P1_4 TARGET_MAX32625MBED D8
#endif
#if HAS_digitalInOut9
    DigitalInOut digitalInOut9(P1_5, PIN_INPUT, PullUp, 1); // P1_5 TARGET_MAX32625MBED D9
#endif
#if HAS_digitalInOut10
    DigitalInOut digitalInOut10(P1_3, PIN_INPUT, PullUp, 1); // P1_3 TARGET_MAX32635MBED CS/10
#endif
#if HAS_digitalInOut11
    DigitalInOut digitalInOut11(P1_1, PIN_INPUT, PullUp, 1); // P1_1 TARGET_MAX32635MBED MOSI/11
#endif
#if HAS_digitalInOut12
    DigitalInOut digitalInOut12(P1_2, PIN_INPUT, PullUp, 1); // P1_2 TARGET_MAX32635MBED MISO/12
#endif
#if HAS_digitalInOut13
    DigitalInOut digitalInOut13(P1_0, PIN_INPUT, PullUp, 1); // P1_0 TARGET_MAX32635MBED SCK/13
#endif
#if HAS_digitalInOut14
    // Ensure that the unused I2C pins do not interfere with analog inputs A4 and A5
    // DigitalInOut mode can be one of PullUp, PullDown, PullNone, OpenDrain
    DigitalInOut digitalInOut14(P1_6, PIN_INPUT, OpenDrain, 1); // P1_6 TARGET_MAX32635MBED A4/SDA (10pin digital connector)
#endif
#if HAS_digitalInOut15
    // Ensure that the unused I2C pins do not interfere with analog inputs A4 and A5
    DigitalInOut digitalInOut15(P1_7, PIN_INPUT, OpenDrain, 1); // P1_7 TARGET_MAX32635MBED A5/SCL (10pin digital connector)
#endif
#if HAS_digitalInOut16
    // Ensure that the unused I2C pins do not interfere with analog inputs A4 and A5
    // DigitalInOut mode can be one of PullUp, PullDown, PullNone, OpenDrain
    // PullUp-->3.4V, PullDown-->1.7V, PullNone-->3.5V, OpenDrain-->0.00V
    DigitalInOut digitalInOut16(P3_4, PIN_INPUT, OpenDrain, 0); // P3_4 TARGET_MAX32635MBED A4/SDA (6pin analog connector)
#endif
#if HAS_digitalInOut17
    // Ensure that the unused I2C pins do not interfere with analog inputs A4 and A5
    DigitalInOut digitalInOut17(P3_5, PIN_INPUT, OpenDrain, 0); // P3_5 TARGET_MAX32635MBED A5/SCL (6pin analog connector)
#endif
//--------------------------------------------------
#elif defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F401RE)
    #define HAS_digitalInOut0 0 // P0_0 TARGET_MAX32625MBED D0
    #define HAS_digitalInOut1 0 // P0_1 TARGET_MAX32625MBED D1
#if APPLICATION_MAX11131
    #define HAS_digitalInOut2 0 // P0_2 TARGET_MAX32625MBED D2 -- MAX11131 EOC DigitalIn
#else
    #define HAS_digitalInOut2 1 // P0_2 TARGET_MAX32625MBED D2
#endif
    #define HAS_digitalInOut3 1 // P0_3 TARGET_MAX32625MBED D3
    #define HAS_digitalInOut4 1 // P0_4 TARGET_MAX32625MBED D4
    #define HAS_digitalInOut5 1 // P0_5 TARGET_MAX32625MBED D5
    #define HAS_digitalInOut6 1 // P0_6 TARGET_MAX32625MBED D6
    #define HAS_digitalInOut7 1 // P0_7 TARGET_MAX32625MBED D7
#if APPLICATION_MAX5715
    #define HAS_digitalInOut8 0 // P1_4 TARGET_MAX32625MBED D8 -- MAX5715 CLRb DigitalOut
#else
    #define HAS_digitalInOut8 1 // P1_4 TARGET_MAX32625MBED D8
#endif
#if APPLICATION_MAX5715
    #define HAS_digitalInOut9 0 // P1_5 TARGET_MAX32625MBED D9 -- MAX5715 LDACb DigitalOut
#elif APPLICATION_MAX11131
    #define HAS_digitalInOut9 0 // P1_5 TARGET_MAX32625MBED D9 -- MAX11131 CNVST DigitalOut
#else
    #define HAS_digitalInOut9 1 // P1_5 TARGET_MAX32625MBED D9
#endif
#if HAS_SPI
// avoid resource conflict between P5_0, P5_1, P5_2 SPI and DigitalInOut
    // Arduino digital pin D10 SPI function is CS/10
    // Arduino digital pin D11 SPI function is MOSI/11
    // Arduino digital pin D12 SPI function is MISO/12
    // Arduino digital pin D13 SPI function is SCK/13
    #define HAS_digitalInOut10 0
    #define HAS_digitalInOut11 0
    #define HAS_digitalInOut12 0
    #define HAS_digitalInOut13 0
#else // HAS_SPI
    #define HAS_digitalInOut10 1
    #define HAS_digitalInOut11 1
    #define HAS_digitalInOut12 1
    #define HAS_digitalInOut13 1
#endif // HAS_SPI
#if HAS_I2C
// avoid resource conflict between P5_7, P6_0 I2C and DigitalInOut
    // Arduino digital pin D14 I2C function is A4/SDA (10pin digital connector)
    // Arduino digital pin D15 I2C function is A5/SCL (10pin digital connector)
    // Arduino digital pin D16 I2C function is A4/SDA (6pin analog connector)
    // Arduino digital pin D17 I2C function is A5/SCL (6pin analog connector)
    #define HAS_digitalInOut14 0
    #define HAS_digitalInOut15 0
    #define HAS_digitalInOut16 0
    #define HAS_digitalInOut17 0
#else // HAS_I2C
    #define HAS_digitalInOut14 1
    #define HAS_digitalInOut15 1
    #define HAS_digitalInOut16 0
    #define HAS_digitalInOut17 0
#endif // HAS_I2C
#if HAS_digitalInOut0
    DigitalInOut digitalInOut0(D0, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut1
    DigitalInOut digitalInOut1(D1, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut2
    DigitalInOut digitalInOut2(D2, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut3
    DigitalInOut digitalInOut3(D3, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut4
    DigitalInOut digitalInOut4(D4, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut5
    DigitalInOut digitalInOut5(D5, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut6
    DigitalInOut digitalInOut6(D6, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut7
    DigitalInOut digitalInOut7(D7, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut8
    DigitalInOut digitalInOut8(D8, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut9
    DigitalInOut digitalInOut9(D9, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut10
    // Arduino digital pin D10 SPI function is CS/10
    DigitalInOut digitalInOut10(D10, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut11
    // Arduino digital pin D11 SPI function is MOSI/11
    DigitalInOut digitalInOut11(D11, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut12
    // Arduino digital pin D12 SPI function is MISO/12
    DigitalInOut digitalInOut12(D12, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut13
    // Arduino digital pin D13 SPI function is SCK/13
    DigitalInOut digitalInOut13(D13, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut14
    // Arduino digital pin D14 I2C function is A4/SDA (10pin digital connector)
    DigitalInOut digitalInOut14(D14, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut15
    // Arduino digital pin D15 I2C function is A5/SCL (10pin digital connector)
    DigitalInOut digitalInOut15(D15, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut16
    // Arduino digital pin D16 I2C function is A4/SDA (6pin analog connector)
    DigitalInOut digitalInOut16(D16, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut17
    // Arduino digital pin D17 I2C function is A5/SCL (6pin analog connector)
    DigitalInOut digitalInOut17(D17, PIN_INPUT, PullUp, 1);
#endif
//--------------------------------------------------
#elif defined(TARGET_LPC1768)
    #define HAS_digitalInOut0 1
    #define HAS_digitalInOut1 1
    #define HAS_digitalInOut2 1
    #define HAS_digitalInOut3 1
    #define HAS_digitalInOut4 1
    #define HAS_digitalInOut5 1
    #define HAS_digitalInOut6 1
    #define HAS_digitalInOut7 1
    #define HAS_digitalInOut8 1
    #define HAS_digitalInOut9 1
//    #define HAS_digitalInOut10 1
//    #define HAS_digitalInOut11 1
//    #define HAS_digitalInOut12 1
//    #define HAS_digitalInOut13 1
//    #define HAS_digitalInOut14 1
//    #define HAS_digitalInOut15 1
#if HAS_digitalInOut0
    DigitalInOut digitalInOut0(p5, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.9/I2STX_SDA/MOSI1/MAT2.3
#endif
#if HAS_digitalInOut1
    DigitalInOut digitalInOut1(p6, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.8/I2STX_WS/MISO1/MAT2.2
#endif
#if HAS_digitalInOut2
    DigitalInOut digitalInOut2(p7, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.7/I2STX_CLK/SCK1/MAT2.1
#endif
#if HAS_digitalInOut3
    DigitalInOut digitalInOut3(p8, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.6/I2SRX_SDA/SSEL1/MAT2.0
#endif
#if HAS_digitalInOut4
    DigitalInOut digitalInOut4(p9, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.0/CAN_RX1/TXD3/SDA1
#endif
#if HAS_digitalInOut5
    DigitalInOut digitalInOut5(p10, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.1/CAN_TX1/RXD3/SCL1
#endif
#if HAS_digitalInOut6
    DigitalInOut digitalInOut6(p11, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.18/DCD1/MOSI0/MOSI1
#endif
#if HAS_digitalInOut7
    DigitalInOut digitalInOut7(p12, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.17/CTS1/MISO0/MISO
#endif
#if HAS_digitalInOut8
    DigitalInOut digitalInOut8(p13, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.15/TXD1/SCK0/SCK
#endif
#if HAS_digitalInOut9
    DigitalInOut digitalInOut9(p14, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.16/RXD1/SSEL0/SSEL
#endif
    //
    // these pins support analog input analogIn0 .. analogIn5
    //DigitalInOut digitalInOut_(p15, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.23/AD0.0/I2SRX_CLK/CAP3.0
    //DigitalInOut digitalInOut_(p16, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.24/AD0.1/I2SRX_WS/CAP3.1
    //DigitalInOut digitalInOut_(p17, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.25/AD0.2/I2SRX_SDA/TXD3
    //DigitalInOut digitalInOut_(p18, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.26/AD0.3/AOUT/RXD3
    //DigitalInOut digitalInOut_(p19, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P1.30/VBUS/AD0.4
    //DigitalInOut digitalInOut_(p20, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P1.31/SCK1/AD0.5
    //
    // these pins support PWM pwmDriver1 .. pwmDriver6
    //DigitalInOut digitalInOut_(p21, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P2.5/PWM1.6/DTR1/TRACEDATA0
    //DigitalInOut digitalInOut_(p22, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P2.4/PWM1.5/DSR1/TRACEDATA1
    //DigitalInOut digitalInOut_(p23, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P2.3/PWM1.4/DCD1/TRACEDATA2
    //DigitalInOut digitalInOut_(p24, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P2.2/PWM1.3/CTS1/TRACEDATA3
    //DigitalInOut digitalInOut_(p25, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P2.1/PWM1.2/RXD1
    //DigitalInOut digitalInOut_(p26, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P2.0/PWM1.1/TXD1/TRACECLK
    //
    // these could be additional digitalInOut pins
#if HAS_digitalInOut10
    DigitalInOut digitalInOut10(p27, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.11/RXD2/SCL2/MAT3.1
#endif
#if HAS_digitalInOut11
    DigitalInOut digitalInOut11(p28, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.10/TXD2/SDA2/MAT3.0
#endif
#if HAS_digitalInOut12
    DigitalInOut digitalInOut12(p29, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.5/I2SRX_WS/CAN_TX2/CAP2.1
#endif
#if HAS_digitalInOut13
    DigitalInOut digitalInOut13(p30, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.4/I2SRX_CLK/CAN_RX2/CAP2.0
#endif
#if HAS_digitalInOut14
    DigitalInOut digitalInOut14(___, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut15
    DigitalInOut digitalInOut15(___, PIN_INPUT, PullUp, 1);
#endif
#else
    // unknown target
#endif
// uncrustify-0.66.1 *INDENT-ON*
#if HAS_digitalInOut0 || HAS_digitalInOut1 \
    || HAS_digitalInOut2 || HAS_digitalInOut3 \
    || HAS_digitalInOut4 || HAS_digitalInOut5 \
    || HAS_digitalInOut6 || HAS_digitalInOut7 \
    || HAS_digitalInOut8 || HAS_digitalInOut9 \
    || HAS_digitalInOut10 || HAS_digitalInOut11 \
    || HAS_digitalInOut12 || HAS_digitalInOut13 \
    || HAS_digitalInOut14 || HAS_digitalInOut15 \
    || HAS_digitalInOut16 || HAS_digitalInOut17
#define HAS_digitalInOuts 1
#endif

// uncrustify-0.66.1 *INDENT-OFF*
//--------------------------------------------------
// Declare the AnalogIn driver
// Optional analogIn support. If there is only one it should be analogIn1.
// A) analog input
#if defined(TARGET_MAX32630)
    #define HAS_analogIn0 1
    #define HAS_analogIn1 1
    #define HAS_analogIn2 1
    #define HAS_analogIn3 1
    #define HAS_analogIn4 1
    #define HAS_analogIn5 1
    #define HAS_analogIn6 1
    #define HAS_analogIn7 1
    #define HAS_analogIn8 1
    #define HAS_analogIn9 1
//    #define HAS_analogIn10 0
//    #define HAS_analogIn11 0
//    #define HAS_analogIn12 0
//    #define HAS_analogIn13 0
//    #define HAS_analogIn14 0
//    #define HAS_analogIn15 0
#if HAS_analogIn0
    AnalogIn analogIn0(AIN_0); // TARGET_MAX32630 J1.5 AIN_0 = AIN0 pin       fullscale is 1.2V
#endif
#if HAS_analogIn1
    AnalogIn analogIn1(AIN_1); // TARGET_MAX32630 J1.6 AIN_1 = AIN1 pin       fullscale is 1.2V
#endif
#if HAS_analogIn2
    AnalogIn analogIn2(AIN_2); // TARGET_MAX32630 J1.7 AIN_2 = AIN2 pin       fullscale is 1.2V
#endif
#if HAS_analogIn3
    AnalogIn analogIn3(AIN_3); // TARGET_MAX32630 J1.8 AIN_3 = AIN3 pin       fullscale is 1.2V
#endif
#if HAS_analogIn4
    AnalogIn analogIn4(AIN_4); // TARGET_MAX32630 J1.5 AIN_4 = AIN0 / 5.0     fullscale is 6.0V
#endif
#if HAS_analogIn5
    AnalogIn analogIn5(AIN_5); // TARGET_MAX32630 J1.6 AIN_5 = AIN1 / 5.0     fullscale is 6.0V
#endif
#if HAS_analogIn6
    AnalogIn analogIn6(AIN_6); // TARGET_MAX32630 AIN_6 = VDDB / 4.0     fullscale is 4.8V
#endif
#if HAS_analogIn7
    AnalogIn analogIn7(AIN_7); // TARGET_MAX32630 AIN_7 = VDD18          fullscale is 1.2V
#endif
#if HAS_analogIn8
    AnalogIn analogIn8(AIN_8); // TARGET_MAX32630 AIN_8 = VDD12          fullscale is 1.2V
#endif
#if HAS_analogIn9
    AnalogIn analogIn9(AIN_9); // TARGET_MAX32630 AIN_9 = VRTC / 2.0     fullscale is 2.4V
#endif
#if HAS_analogIn10
    AnalogIn analogIn10(____); // TARGET_MAX32630 AIN_10 = x undefined?
#endif
#if HAS_analogIn11
    AnalogIn analogIn11(____); // TARGET_MAX32630 AIN_11 = VDDIO / 4.0   fullscale is 4.8V
#endif
#if HAS_analogIn12
    AnalogIn analogIn12(____); // TARGET_MAX32630 AIN_12 = VDDIOH / 4.0  fullscale is 4.8V
#endif
#if HAS_analogIn13
    AnalogIn analogIn13(____);
#endif
#if HAS_analogIn14
    AnalogIn analogIn14(____);
#endif
#if HAS_analogIn15
    AnalogIn analogIn15(____);
#endif
//--------------------------------------------------
#elif defined(TARGET_MAX32625MBED)
    #define HAS_analogIn0 1
    #define HAS_analogIn1 1
    #define HAS_analogIn2 1
    #define HAS_analogIn3 1
    #define HAS_analogIn4 1
    #define HAS_analogIn5 1
#if HAS_analogIn0
    AnalogIn analogIn0(AIN_0); // TARGET_MAX32630 J1.5 AIN_0 = AIN0 pin       fullscale is 1.2V
#endif
#if HAS_analogIn1
    AnalogIn analogIn1(AIN_1); // TARGET_MAX32630 J1.6 AIN_1 = AIN1 pin       fullscale is 1.2V
#endif
#if HAS_analogIn2
    AnalogIn analogIn2(AIN_2); // TARGET_MAX32630 J1.7 AIN_2 = AIN2 pin       fullscale is 1.2V
#endif
#if HAS_analogIn3
    AnalogIn analogIn3(AIN_3); // TARGET_MAX32630 J1.8 AIN_3 = AIN3 pin       fullscale is 1.2V
#endif
#if HAS_analogIn4
    AnalogIn analogIn4(AIN_4); // TARGET_MAX32630 J1.5 AIN_4 = AIN0 / 5.0     fullscale is 6.0V
#endif
#if HAS_analogIn5
    AnalogIn analogIn5(AIN_5); // TARGET_MAX32630 J1.6 AIN_5 = AIN1 / 5.0     fullscale is 6.0V
#endif
//--------------------------------------------------
#elif defined(TARGET_MAX32620FTHR)
#warning "TARGET_MAX32620FTHR not previously tested; need to verify analogIn0..."
    #define HAS_analogIn0 1
    #define HAS_analogIn1 1
    #define HAS_analogIn2 1
    #define HAS_analogIn3 1
    #define HAS_analogIn4 1
    #define HAS_analogIn5 1
    #define HAS_analogIn6 1
    #define HAS_analogIn7 1
    #define HAS_analogIn8 1
    #define HAS_analogIn9 1
//    #define HAS_analogIn10 0
//    #define HAS_analogIn11 0
//    #define HAS_analogIn12 0
//    #define HAS_analogIn13 0
//    #define HAS_analogIn14 0
//    #define HAS_analogIn15 0
#if HAS_analogIn0
    AnalogIn analogIn0(AIN_0); // TARGET_MAX32620FTHR J1.5 AIN_0 = AIN0 pin       fullscale is 1.2V
#endif
#if HAS_analogIn1
    AnalogIn analogIn1(AIN_1); // TARGET_MAX32620FTHR J1.6 AIN_1 = AIN1 pin       fullscale is 1.2V
#endif
#if HAS_analogIn2
    AnalogIn analogIn2(AIN_2); // TARGET_MAX32620FTHR J1.7 AIN_2 = AIN2 pin       fullscale is 1.2V
#endif
#if HAS_analogIn3
    AnalogIn analogIn3(AIN_3); // TARGET_MAX32620FTHR J1.8 AIN_3 = AIN3 pin       fullscale is 1.2V
#endif
#if HAS_analogIn4
    AnalogIn analogIn4(AIN_4); // TARGET_MAX32620FTHR J1.5 AIN_4 = AIN0 / 5.0     fullscale is 6.0V
#endif
#if HAS_analogIn5
    AnalogIn analogIn5(AIN_5); // TARGET_MAX32620FTHR J1.6 AIN_5 = AIN1 / 5.0     fullscale is 6.0V
#endif
#if HAS_analogIn6
    AnalogIn analogIn6(AIN_6); // TARGET_MAX32620FTHR AIN_6 = VDDB / 4.0     fullscale is 4.8V
#endif
#if HAS_analogIn7
    AnalogIn analogIn7(AIN_7); // TARGET_MAX32620FTHR AIN_7 = VDD18          fullscale is 1.2V
#endif
#if HAS_analogIn8
    AnalogIn analogIn8(AIN_8); // TARGET_MAX32620FTHR AIN_8 = VDD12          fullscale is 1.2V
#endif
#if HAS_analogIn9
    AnalogIn analogIn9(AIN_9); // TARGET_MAX32620FTHR AIN_9 = VRTC / 2.0     fullscale is 2.4V
#endif
#if HAS_analogIn10
    AnalogIn analogIn10(____); // TARGET_MAX32620FTHR AIN_10 = x undefined?
#endif
#if HAS_analogIn11
    AnalogIn analogIn11(____); // TARGET_MAX32620FTHR AIN_11 = VDDIO / 4.0   fullscale is 4.8V
#endif
#if HAS_analogIn12
    AnalogIn analogIn12(____); // TARGET_MAX32620FTHR AIN_12 = VDDIOH / 4.0  fullscale is 4.8V
#endif
#if HAS_analogIn13
    AnalogIn analogIn13(____);
#endif
#if HAS_analogIn14
    AnalogIn analogIn14(____);
#endif
#if HAS_analogIn15
    AnalogIn analogIn15(____);
#endif
//--------------------------------------------------
#elif defined(TARGET_MAX32625PICO)
#warning "TARGET_MAX32625PICO not previously tested; need to verify analogIn0..."
    #define HAS_analogIn0 1
    #define HAS_analogIn1 1
    #define HAS_analogIn2 1
    #define HAS_analogIn3 1
    #define HAS_analogIn4 1
    #define HAS_analogIn5 1
#if HAS_analogIn0
    AnalogIn analogIn0(AIN_0); // TARGET_MAX32630 J1.5 AIN_0 = AIN0 pin       fullscale is 1.2V
#endif
#if HAS_analogIn1
    AnalogIn analogIn1(AIN_1); // TARGET_MAX32630 J1.6 AIN_1 = AIN1 pin       fullscale is 1.2V
#endif
#if HAS_analogIn2
    AnalogIn analogIn2(AIN_2); // TARGET_MAX32630 J1.7 AIN_2 = AIN2 pin       fullscale is 1.2V
#endif
#if HAS_analogIn3
    AnalogIn analogIn3(AIN_3); // TARGET_MAX32630 J1.8 AIN_3 = AIN3 pin       fullscale is 1.2V
#endif
#if HAS_analogIn4
    AnalogIn analogIn4(AIN_4); // TARGET_MAX32630 J1.5 AIN_4 = AIN0 / 5.0     fullscale is 6.0V
#endif
#if HAS_analogIn5
    AnalogIn analogIn5(AIN_5); // TARGET_MAX32630 J1.6 AIN_5 = AIN1 / 5.0     fullscale is 6.0V
#endif
//--------------------------------------------------
#elif defined(TARGET_MAX32600)
    #define HAS_analogIn0 1
    #define HAS_analogIn1 1
    #define HAS_analogIn2 1
    #define HAS_analogIn3 1
    #define HAS_analogIn4 1
    #define HAS_analogIn5 1
#if HAS_analogIn0
    AnalogIn analogIn0(A0);
#endif
#if HAS_analogIn1
    AnalogIn analogIn1(A1);
#endif
#if HAS_analogIn2
    AnalogIn analogIn2(A2);
#endif
#if HAS_analogIn3
    AnalogIn analogIn3(A3);
#endif
#if HAS_analogIn4
    AnalogIn analogIn4(A4);
#endif
#if HAS_analogIn5
    AnalogIn analogIn5(A5);
#endif
//--------------------------------------------------
#elif defined(TARGET_NUCLEO_F446RE)
    #define HAS_analogIn0 1
    #define HAS_analogIn1 1
    #define HAS_analogIn2 1
    #define HAS_analogIn3 1
    #define HAS_analogIn4 1
    #define HAS_analogIn5 1
#if HAS_analogIn0
    AnalogIn analogIn0(A0);
#endif
#if HAS_analogIn1
    AnalogIn analogIn1(A1);
#endif
#if HAS_analogIn2
    AnalogIn analogIn2(A2);
#endif
#if HAS_analogIn3
    AnalogIn analogIn3(A3);
#endif
#if HAS_analogIn4
    AnalogIn analogIn4(A4);
#endif
#if HAS_analogIn5
    AnalogIn analogIn5(A5);
#endif
//--------------------------------------------------
#elif defined(TARGET_NUCLEO_F401RE)
    #define HAS_analogIn0 1
    #define HAS_analogIn1 1
    #define HAS_analogIn2 1
    #define HAS_analogIn3 1
    #define HAS_analogIn4 1
    #define HAS_analogIn5 1
#if HAS_analogIn0
    AnalogIn analogIn0(A0);
#endif
#if HAS_analogIn1
    AnalogIn analogIn1(A1);
#endif
#if HAS_analogIn2
    AnalogIn analogIn2(A2);
#endif
#if HAS_analogIn3
    AnalogIn analogIn3(A3);
#endif
#if HAS_analogIn4
    AnalogIn analogIn4(A4);
#endif
#if HAS_analogIn5
    AnalogIn analogIn5(A5);
#endif
//--------------------------------------------------
// TODO1: TARGET=MAX32625MBED ARM Cortex-M4F 96MHz 512kB Flash 160kB SRAM
#elif defined(TARGET_LPC1768)
    #define HAS_analogIn0 1
    #define HAS_analogIn1 1
    #define HAS_analogIn2 1
    #define HAS_analogIn3 1
    #define HAS_analogIn4 1
    #define HAS_analogIn5 1
//    #define HAS_analogIn6 1
//    #define HAS_analogIn7 1
//    #define HAS_analogIn8 1
//    #define HAS_analogIn9 1
//    #define HAS_analogIn10 1
//    #define HAS_analogIn11 1
//    #define HAS_analogIn12 1
//    #define HAS_analogIn13 1
//    #define HAS_analogIn14 1
//    #define HAS_analogIn15 1
#if HAS_analogIn0
    AnalogIn analogIn0(p15); // TARGET_LPC1768 P0.23/AD0.0/I2SRX_CLK/CAP3.0
#endif
#if HAS_analogIn1
    AnalogIn analogIn1(p16); // TARGET_LPC1768 P0.24/AD0.1/I2SRX_WS/CAP3.1
#endif
#if HAS_analogIn2
    AnalogIn analogIn2(p17); // TARGET_LPC1768 P0.25/AD0.2/I2SRX_SDA/TXD3
#endif
#if HAS_analogIn3
    AnalogIn analogIn3(p18); // TARGET_LPC1768 P0.26/AD0.3/AOUT/RXD3
#endif
#if HAS_analogIn4
    AnalogIn analogIn4(p19); // TARGET_LPC1768 P1.30/VBUS/AD0.4
#endif
#if HAS_analogIn5
    AnalogIn analogIn5(p20); // TARGET_LPC1768 P1.31/SCK1/AD0.5
#endif
#if HAS_analogIn6
    AnalogIn analogIn6(____);
#endif
#if HAS_analogIn7
    AnalogIn analogIn7(____);
#endif
#if HAS_analogIn8
    AnalogIn analogIn8(____);
#endif
#if HAS_analogIn9
    AnalogIn analogIn9(____);
#endif
#if HAS_analogIn10
    AnalogIn analogIn10(____);
#endif
#if HAS_analogIn11
    AnalogIn analogIn11(____);
#endif
#if HAS_analogIn12
    AnalogIn analogIn12(____);
#endif
#if HAS_analogIn13
    AnalogIn analogIn13(____);
#endif
#if HAS_analogIn14
    AnalogIn analogIn14(____);
#endif
#if HAS_analogIn15
    AnalogIn analogIn15(____);
#endif
#else
    // unknown target
#endif
// uncrustify-0.66.1 *INDENT-ON*
#if HAS_analogIn0 || HAS_analogIn1 \
    || HAS_analogIn2 || HAS_analogIn3 \
    || HAS_analogIn4 || HAS_analogIn5 \
    || HAS_analogIn6 || HAS_analogIn7 \
    || HAS_analogIn8 || HAS_analogIn9 \
    || HAS_analogIn10 || HAS_analogIn11 \
    || HAS_analogIn12 || HAS_analogIn13 \
    || HAS_analogIn14 || HAS_analogIn15
#define HAS_analogIns 1
#endif

// DigitalInOut pin resource: print the pin index names to serial
#if HAS_digitalInOuts
void list_digitalInOutPins(Stream& serialStream)
{
#if HAS_digitalInOut0
    serialStream.printf(" 0");
#endif
#if HAS_digitalInOut1
    serialStream.printf(" 1");
#endif
#if HAS_digitalInOut2
    serialStream.printf(" 2");
#endif
#if HAS_digitalInOut3
    serialStream.printf(" 3");
#endif
#if HAS_digitalInOut4
    serialStream.printf(" 4");
#endif
#if HAS_digitalInOut5
    serialStream.printf(" 5");
#endif
#if HAS_digitalInOut6
    serialStream.printf(" 6");
#endif
#if HAS_digitalInOut7
    serialStream.printf(" 7");
#endif
#if HAS_digitalInOut8
    serialStream.printf(" 8");
#endif
#if HAS_digitalInOut9
    serialStream.printf(" 9");
#endif
#if HAS_digitalInOut10
    serialStream.printf(" 10");
#endif
#if HAS_digitalInOut11
    serialStream.printf(" 11");
#endif
#if HAS_digitalInOut12
    serialStream.printf(" 12");
#endif
#if HAS_digitalInOut13
    serialStream.printf(" 13");
#endif
#if HAS_digitalInOut14
    serialStream.printf(" 14");
#endif
#if HAS_digitalInOut15
    serialStream.printf(" 15");
#endif
#if HAS_digitalInOut16
    serialStream.printf(" 16");
#endif
#if HAS_digitalInOut17
    serialStream.printf(" 17");
#endif
}
#endif


// DigitalInOut pin resource: search index
#if HAS_digitalInOuts
DigitalInOut& find_digitalInOutPin(int cPinIndex)
{
    switch (cPinIndex)
    {
        default: // default to the first defined digitalInOut pin
#if HAS_digitalInOut0
        case '0': case 0x00: return digitalInOut0;
#endif
#if HAS_digitalInOut1
        case '1': case 0x01: return digitalInOut1;
#endif
#if HAS_digitalInOut2
        case '2': case 0x02: return digitalInOut2;
#endif
#if HAS_digitalInOut3
        case '3': case 0x03: return digitalInOut3;
#endif
#if HAS_digitalInOut4
        case '4': case 0x04: return digitalInOut4;
#endif
#if HAS_digitalInOut5
        case '5': case 0x05: return digitalInOut5;
#endif
#if HAS_digitalInOut6
        case '6': case 0x06: return digitalInOut6;
#endif
#if HAS_digitalInOut7
        case '7': case 0x07: return digitalInOut7;
#endif
#if HAS_digitalInOut8
        case '8': case 0x08: return digitalInOut8;
#endif
#if HAS_digitalInOut9
        case '9': case 0x09: return digitalInOut9;
#endif
#if HAS_digitalInOut10
        case 'a': case 0x0a: return digitalInOut10;
#endif
#if HAS_digitalInOut11
        case 'b': case 0x0b: return digitalInOut11;
#endif
#if HAS_digitalInOut12
        case 'c': case 0x0c: return digitalInOut12;
#endif
#if HAS_digitalInOut13
        case 'd': case 0x0d: return digitalInOut13;
#endif
#if HAS_digitalInOut14
        case 'e': case 0x0e: return digitalInOut14;
#endif
#if HAS_digitalInOut15
        case 'f': case 0x0f: return digitalInOut15;
#endif
#if HAS_digitalInOut16
        case 'g': case 0x10: return digitalInOut16;
#endif
#if HAS_digitalInOut17
        case 'h': case 0x11: return digitalInOut17;
#endif
    }
}
#endif


// AnalogIn pin resource: search index
#if HAS_analogIns
AnalogIn& find_analogInPin(int cPinIndex)
{
    switch (cPinIndex)
    {
        default: // default to the first defined analogIn pin
#if HAS_analogIn0
        case '0': case 0x00: return analogIn0;
#endif
#if HAS_analogIn1
        case '1': case 0x01: return analogIn1;
#endif
#if HAS_analogIn2
        case '2': case 0x02: return analogIn2;
#endif
#if HAS_analogIn3
        case '3': case 0x03: return analogIn3;
#endif
#if HAS_analogIn4
        case '4': case 0x04: return analogIn4;
#endif
#if HAS_analogIn5
        case '5': case 0x05: return analogIn5;
#endif
#if HAS_analogIn6
        case '6': case 0x06: return analogIn6;
#endif
#if HAS_analogIn7
        case '7': case 0x07: return analogIn7;
#endif
#if HAS_analogIn8
        case '8': case 0x08: return analogIn8;
#endif
#if HAS_analogIn9
        case '9': case 0x09: return analogIn9;
#endif
#if HAS_analogIn10
        case 'a': case 0x0a: return analogIn10;
#endif
#if HAS_analogIn11
        case 'b': case 0x0b: return analogIn11;
#endif
#if HAS_analogIn12
        case 'c': case 0x0c: return analogIn12;
#endif
#if HAS_analogIn13
        case 'd': case 0x0d: return analogIn13;
#endif
#if HAS_analogIn14
        case 'e': case 0x0e: return analogIn14;
#endif
#if HAS_analogIn15
        case 'f': case 0x0f: return analogIn15;
#endif
    }
}
#endif

#if HAS_analogIns
const float analogInPin_fullScaleVoltage[] = {
# if defined(TARGET_MAX32630)
    ADC_FULL_SCALE_VOLTAGE, // analogIn0
    ADC_FULL_SCALE_VOLTAGE, // analogIn1
    ADC_FULL_SCALE_VOLTAGE, // analogIn2
    ADC_FULL_SCALE_VOLTAGE, // analogIn3
    ADC_FULL_SCALE_VOLTAGE * 5.0f, // analogIn4 // AIN_4 = AIN0 / 5.0     fullscale is 6.0V
    ADC_FULL_SCALE_VOLTAGE * 5.0f, // analogIn4 // AIN_5 = AIN1 / 5.0     fullscale is 6.0V
    ADC_FULL_SCALE_VOLTAGE * 4.0f, // analogIn6 // AIN_6 = VDDB / 4.0     fullscale is 4.8V
    ADC_FULL_SCALE_VOLTAGE, // analogIn7 // AIN_7 = VDD18          fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE, // analogIn8 // AIN_8 = VDD12          fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE * 2.0f, // analogIn9 // AIN_9 = VRTC / 2.0     fullscale is 2.4V
    ADC_FULL_SCALE_VOLTAGE, // analogIn10  // AIN_10 = x undefined?
    ADC_FULL_SCALE_VOLTAGE * 4.0f, // analogIn11 // AIN_11 = VDDIO / 4.0   fullscale is 4.8V
    ADC_FULL_SCALE_VOLTAGE * 4.0f, // analogIn12 // AIN_12 = VDDIOH / 4.0  fullscale is 4.8V
    ADC_FULL_SCALE_VOLTAGE, // analogIn13
    ADC_FULL_SCALE_VOLTAGE, // analogIn14
    ADC_FULL_SCALE_VOLTAGE // analogIn15
# elif defined(TARGET_MAX32620FTHR)
#warning "TARGET_MAX32620FTHR not previously tested; need to verify analogIn0..."
    ADC_FULL_SCALE_VOLTAGE, // analogIn0
    ADC_FULL_SCALE_VOLTAGE, // analogIn1
    ADC_FULL_SCALE_VOLTAGE, // analogIn2
    ADC_FULL_SCALE_VOLTAGE, // analogIn3
    ADC_FULL_SCALE_VOLTAGE * 5.0f, // analogIn4 // AIN_4 = AIN0 / 5.0     fullscale is 6.0V
    ADC_FULL_SCALE_VOLTAGE * 5.0f, // analogIn4 // AIN_5 = AIN1 / 5.0     fullscale is 6.0V
    ADC_FULL_SCALE_VOLTAGE * 4.0f, // analogIn6 // AIN_6 = VDDB / 4.0     fullscale is 4.8V
    ADC_FULL_SCALE_VOLTAGE, // analogIn7 // AIN_7 = VDD18          fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE, // analogIn8 // AIN_8 = VDD12          fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE * 2.0f, // analogIn9 // AIN_9 = VRTC / 2.0     fullscale is 2.4V
    ADC_FULL_SCALE_VOLTAGE, // analogIn10  // AIN_10 = x undefined?
    ADC_FULL_SCALE_VOLTAGE * 4.0f, // analogIn11 // AIN_11 = VDDIO / 4.0   fullscale is 4.8V
    ADC_FULL_SCALE_VOLTAGE * 4.0f, // analogIn12 // AIN_12 = VDDIOH / 4.0  fullscale is 4.8V
    ADC_FULL_SCALE_VOLTAGE, // analogIn13
    ADC_FULL_SCALE_VOLTAGE, // analogIn14
    ADC_FULL_SCALE_VOLTAGE // analogIn15
#elif defined(TARGET_MAX32625MBED)
    ADC_FULL_SCALE_VOLTAGE * 1.0f, // analogIn0 // fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE * 1.0f, // analogIn1 // fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE * 1.0f, // analogIn2 // fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE * 1.0f, // analogIn3 // fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE * 5.0f, // analogIn4 // AIN_4 = AIN0 / 5.0     fullscale is 6.0V
    ADC_FULL_SCALE_VOLTAGE * 5.0f, // analogIn4 // AIN_5 = AIN1 / 5.0     fullscale is 6.0V
    ADC_FULL_SCALE_VOLTAGE * 4.0f, // analogIn6 // AIN_6 = VDDB / 4.0     fullscale is 4.8V
    ADC_FULL_SCALE_VOLTAGE, // analogIn7 // AIN_7 = VDD18          fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE, // analogIn8 // AIN_8 = VDD12          fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE * 2.0f, // analogIn9 // AIN_9 = VRTC / 2.0     fullscale is 2.4V
    ADC_FULL_SCALE_VOLTAGE, // analogIn10  // AIN_10 = x undefined?
    ADC_FULL_SCALE_VOLTAGE * 4.0f, // analogIn11 // AIN_11 = VDDIO / 4.0   fullscale is 4.8V
    ADC_FULL_SCALE_VOLTAGE * 4.0f, // analogIn12 // AIN_12 = VDDIOH / 4.0  fullscale is 4.8V
    ADC_FULL_SCALE_VOLTAGE, // analogIn13
    ADC_FULL_SCALE_VOLTAGE, // analogIn14
    ADC_FULL_SCALE_VOLTAGE // analogIn15
#elif defined(TARGET_NUCLEO_F446RE)
    ADC_FULL_SCALE_VOLTAGE, // analogIn0
    ADC_FULL_SCALE_VOLTAGE, // analogIn1
    ADC_FULL_SCALE_VOLTAGE, // analogIn2
    ADC_FULL_SCALE_VOLTAGE, // analogIn3
    ADC_FULL_SCALE_VOLTAGE, // analogIn4
    ADC_FULL_SCALE_VOLTAGE, // analogIn5
    ADC_FULL_SCALE_VOLTAGE, // analogIn6
    ADC_FULL_SCALE_VOLTAGE, // analogIn7
    ADC_FULL_SCALE_VOLTAGE, // analogIn8
    ADC_FULL_SCALE_VOLTAGE, // analogIn9
    ADC_FULL_SCALE_VOLTAGE, // analogIn10
    ADC_FULL_SCALE_VOLTAGE, // analogIn11
    ADC_FULL_SCALE_VOLTAGE, // analogIn12
    ADC_FULL_SCALE_VOLTAGE, // analogIn13
    ADC_FULL_SCALE_VOLTAGE, // analogIn14
    ADC_FULL_SCALE_VOLTAGE // analogIn15
#elif defined(TARGET_NUCLEO_F401RE)
    ADC_FULL_SCALE_VOLTAGE, // analogIn0
    ADC_FULL_SCALE_VOLTAGE, // analogIn1
    ADC_FULL_SCALE_VOLTAGE, // analogIn2
    ADC_FULL_SCALE_VOLTAGE, // analogIn3
    ADC_FULL_SCALE_VOLTAGE, // analogIn4
    ADC_FULL_SCALE_VOLTAGE, // analogIn5
    ADC_FULL_SCALE_VOLTAGE, // analogIn6
    ADC_FULL_SCALE_VOLTAGE, // analogIn7
    ADC_FULL_SCALE_VOLTAGE, // analogIn8
    ADC_FULL_SCALE_VOLTAGE, // analogIn9
    ADC_FULL_SCALE_VOLTAGE, // analogIn10
    ADC_FULL_SCALE_VOLTAGE, // analogIn11
    ADC_FULL_SCALE_VOLTAGE, // analogIn12
    ADC_FULL_SCALE_VOLTAGE, // analogIn13
    ADC_FULL_SCALE_VOLTAGE, // analogIn14
    ADC_FULL_SCALE_VOLTAGE // analogIn15
//#elif defined(TARGET_LPC1768)
#else
    // unknown target
    ADC_FULL_SCALE_VOLTAGE, // analogIn0
    ADC_FULL_SCALE_VOLTAGE, // analogIn1
    ADC_FULL_SCALE_VOLTAGE, // analogIn2
    ADC_FULL_SCALE_VOLTAGE, // analogIn3
    ADC_FULL_SCALE_VOLTAGE, // analogIn4
    ADC_FULL_SCALE_VOLTAGE, // analogIn5
    ADC_FULL_SCALE_VOLTAGE, // analogIn6
    ADC_FULL_SCALE_VOLTAGE, // analogIn7
    ADC_FULL_SCALE_VOLTAGE, // analogIn8
    ADC_FULL_SCALE_VOLTAGE, // analogIn9
    ADC_FULL_SCALE_VOLTAGE, // analogIn10
    ADC_FULL_SCALE_VOLTAGE, // analogIn11
    ADC_FULL_SCALE_VOLTAGE, // analogIn12
    ADC_FULL_SCALE_VOLTAGE, // analogIn13
    ADC_FULL_SCALE_VOLTAGE, // analogIn14
    ADC_FULL_SCALE_VOLTAGE // analogIn15
# endif
};
#endif




//--------------------------------------------------
// Option to use LEDs to show status
#ifndef USE_LEDS
#define USE_LEDS 1
#endif
#if USE_LEDS
#if defined(TARGET_MAX32630)
# define LED_ON  0
# define LED_OFF 1
//--------------------------------------------------
#elif defined(TARGET_MAX32625MBED)
# define LED_ON  0
# define LED_OFF 1
//--------------------------------------------------
// TODO1: TARGET=MAX32625MBED ARM Cortex-M4F 96MHz 512kB Flash 160kB SRAM
#elif defined(TARGET_LPC1768)
# define LED_ON  1
# define LED_OFF 0
#else // not defined(TARGET_LPC1768 etc.)
// USE_LEDS with some platform other than MAX32630, MAX32625MBED, LPC1768
// bugfix for MAX32600MBED LED blink pattern: check if LED_ON/LED_OFF already defined
# ifndef LED_ON
#  define LED_ON  0
# endif
# ifndef LED_OFF
#  define LED_OFF 1
# endif
//# define LED_ON  1
//# define LED_OFF 0
#endif // target definition
DigitalOut led1(LED1, LED_OFF); // MAX32630FTHR: LED1 = LED_RED
DigitalOut led2(LED2, LED_OFF); // MAX32630FTHR: LED2 = LED_GREEN
DigitalOut led3(LED3, LED_OFF); // MAX32630FTHR: LED3 = LED_BLUE
DigitalOut led4(LED4, LED_OFF);
#else // USE_LEDS=0
// issue #41 support Nucleo_F446RE
// there are no LED indicators on the board, LED1 interferes with SPI;
// but we still need placeholders led1 led2 led3 led4.
// Declare DigitalOut led1 led2 led3 led4 targeting safe pins.
// PinName NC means NOT_CONNECTED; DigitalOut::is_connected() returns false
# define LED_ON  0
# define LED_OFF 1
DigitalOut led1(NC, LED_OFF);
DigitalOut led2(NC, LED_OFF);
DigitalOut led3(NC, LED_OFF);
DigitalOut led4(NC, LED_OFF);
#endif // USE_LEDS
#define led1_RFailLED led1
#define led2_GPassLED led2
#define led3_BBusyLED led3

//--------------------------------------------------


// example code board support
//MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
//DigitalOut rLED(LED1);
//DigitalOut gLED(LED2);
//DigitalOut bLED(LED3);
//
// Arduino "shield" connector port definitions (MAX32625MBED shown)
#if defined(TARGET_MAX32625MBED)
#define A0 AIN_0
#define A1 AIN_1
#define A2 AIN_2
#define A3 AIN_3
#define D0 P0_0
#define D1 P0_1
#define D2 P0_2
#define D3 P0_3
#define D4 P0_4
#define D5 P0_5
#define D6 P0_6
#define D7 P0_7
#define D8 P1_4
#define D9 P1_5
#define D10 P1_3
#define D11 P1_1
#define D12 P1_2
#define D13 P1_0
#endif

// example code declare SPI interface
#if defined(TARGET_MAX32625MBED)
// SPI spi(SPI1_MOSI, SPI1_MISO, SPI1_SCK); // mosi, miso, sclk spi1 TARGET_MAX32625MBED: P1_1 P1_2 P1_0 Arduino 10-pin header D11 D12 D13 D10
// DigitalOut spi_cs(SPI1_SS); // TARGET_MAX32625MBED: not connected
// Support SPI hardware-controlled CS instead of GPIO CS (mbed)
// 2020-02-19 MAX32625MBED GPIO CS envelope is 23us (11.4us before SCLK and 8.6us after SCLK).
// 2020-02-19 MAX32625MBED SPI controlled CS envelope 4 channel read reduced to 4.2us (24MHz SCLK), 1.2us setup, 0us hold.
// 2020-02-19 MAX11043 slowest EOC rate is 9us.
SPI spi(SPI1_MOSI, SPI1_MISO, SPI1_SCK, SPI1_SS); // mosi, miso, sclk spi1 TARGET_MAX32625MBED: P1_1 P1_2 P1_0 Arduino 10-pin header D11 D12 D13 D10
DigitalOut spi_cs(NC); // TARGET_MAX32625MBED: not connected
// PinName NC means NOT_CONNECTED; DigitalOut::is_connected() returns false
// add m_cs_pin.is_connected() guard before writing m_cs_pin = m_SPI_cs_state
// to avoid runtime error Assertion failed: obj->name != (PinName)NC
#elif defined(TARGET_MAX32600MBED)
SPI spi(SPI2_MOSI, SPI2_MISO, SPI2_SCK); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(SPI2_SS); // Generic: Arduino 10-pin header D10
#else
SPI spi(D11, D12, D13); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(D10); // Generic: Arduino 10-pin header D10
#endif

// example code declare GPIO interface pins
DigitalOut CONVRUN_pin(D9); // Digital Configuration Input to MAX11043 device
DigitalOut SHDN_pin(D8); // Digital Configuration Input to MAX11043 device
DigitalOut DACSTEP_pin(D7); // Digital Configuration Input to MAX11043 device
DigitalOut UP_slash_DWNb_pin(D6); // Digital Configuration Input to MAX11043 device
//--------------------------------------------------
// MAX11043 ADC Read operations must be synchronized to EOC End Of Conversion
// EOC# asserts low when new data is available.
// Initiate a data read prior to the next rising edge of EOC# or the result is overwritten.
#ifndef MAX11043_EOC_INTERRUPT_POLLING
#define MAX11043_EOC_INTERRUPT_POLLING 1
#endif // MAX11043_EOC_INTERRUPT_POLLING
//--------------------------------------------------
// MAX11043 ADC Read operations must be synchronized to EOC End Of Conversion
// EOC# asserts low when new data is available.
// Initiate a data read prior to the next rising edge of EOC# or the result is overwritten.
#if MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input should be InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
// Workaround using DigitalIn(PinName:EOC_pin) polled to sync with EOC falling edge for ADC reads
// 2020-02-20 MAX11043_EOC_INTERRUPT_POLLING works on MAX32625MBED at 9us conversion rate, with 1us timing margin
DigitalIn EOC_pin(D2); // Digital Event Output from MAX11043 device
#else // MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input is InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
InterruptIn EOC_pin(D2); // Digital Event Output from MAX11043 device
#endif // MAX11043_EOC_INTERRUPT_POLLING
//--------------------------------------------------
// example code declare device instance
MAX11043 g_MAX11043_device(spi, spi_cs, CONVRUN_pin, SHDN_pin, DACSTEP_pin, UP_slash_DWNb_pin, EOC_pin, MAX11043::MAX11043_IC);


//----------------------------------------
// Global SPI options
//

//--------------------------------------------------
// Optional Diagnostic function to print SPI transactions
#ifndef MAX11043_ONSPIPRINT
#define MAX11043_ONSPIPRINT 1
#endif // MAX11043_ONSPIPRINT

//----------------------------------------
// Global I2C options
//

#define APPLICATION_ArduinoPinsMonitor 1

//--------------------------------------------------
// use BUTTON1 trigger some action
#if defined(TARGET_MAX32630)
#define HAS_BUTTON1_DEMO_INTERRUPT 1
#define HAS_BUTTON2_DEMO 0
#define HAS_BUTTON2_DEMO_INTERRUPT 0
#elif defined(TARGET_MAX32625PICO)
#warning "TARGET_MAX32625PICO not previously tested; need to define buttons..."
#define HAS_BUTTON1_DEMO_INTERRUPT 1
#define HAS_BUTTON2_DEMO 0
#define HAS_BUTTON2_DEMO_INTERRUPT 0
#elif defined(TARGET_MAX32625)
#define HAS_BUTTON1_DEMO_INTERRUPT 1
#define HAS_BUTTON2_DEMO_INTERRUPT 1
#elif defined(TARGET_MAX32620FTHR)
#warning "TARGET_MAX32620FTHR not previously tested; need to define buttons..."
#define BUTTON1 SW1
#define HAS_BUTTON1_DEMO_INTERRUPT 1
#define HAS_BUTTON2_DEMO 0
#define HAS_BUTTON2_DEMO_INTERRUPT 0
#elif defined(TARGET_NUCLEO_F446RE)
#define HAS_BUTTON1_DEMO_INTERRUPT 0
#define HAS_BUTTON2_DEMO_INTERRUPT 0
#elif defined(TARGET_NUCLEO_F401RE)
#define HAS_BUTTON1_DEMO_INTERRUPT 0
#define HAS_BUTTON2_DEMO_INTERRUPT 0
#else
#warning "target not previously tested; need to define buttons..."
#endif
//
#ifndef HAS_BUTTON1_DEMO
#define HAS_BUTTON1_DEMO 0
#endif
#ifndef HAS_BUTTON2_DEMO
#define HAS_BUTTON2_DEMO 0
#endif
//
// avoid runtime error on button1 press [mbed-os-5.11]
// instead of using InterruptIn, use DigitalIn and poll in main while(1)
#ifndef HAS_BUTTON1_DEMO_INTERRUPT_POLLING
#define HAS_BUTTON1_DEMO_INTERRUPT_POLLING 1
#endif
//
#ifndef HAS_BUTTON1_DEMO_INTERRUPT
#define HAS_BUTTON1_DEMO_INTERRUPT 1
#endif
#ifndef HAS_BUTTON2_DEMO_INTERRUPT
#define HAS_BUTTON2_DEMO_INTERRUPT 1
#endif
//
#if HAS_BUTTON1_DEMO_INTERRUPT
# if HAS_BUTTON1_DEMO_INTERRUPT_POLLING
// avoid runtime error on button1 press [mbed-os-5.11]
// instead of using InterruptIn, use DigitalIn and poll in main while(1)
DigitalIn button1(BUTTON1);
# else
InterruptIn button1(BUTTON1);
# endif
#elif HAS_BUTTON1_DEMO
DigitalIn button1(BUTTON1);
#endif
#if HAS_BUTTON2_DEMO_INTERRUPT
# if HAS_BUTTON1_DEMO_INTERRUPT_POLLING
// avoid runtime error on button1 press [mbed-os-5.11]
// instead of using InterruptIn, use DigitalIn and poll in main while(1)
DigitalIn button2(BUTTON2);
# else
InterruptIn button2(BUTTON2);
# endif
#elif HAS_BUTTON2_DEMO
DigitalIn button2(BUTTON2);
#endif

//--------------------------------------------------
// functions tested by SelfTest()
extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);

//--------------------------------------------------
// optional self-test groups for function SelfTest()
// enable by changing the #define value from 0 to 1
#ifndef MAX11043_SELFTEST_BIP2C16
#define MAX11043_SELFTEST_BIP2C16 1
#endif

#ifndef MAX11043_SELFTEST_BIP2C24
#define MAX11043_SELFTEST_BIP2C24 1
#endif

//--------------------------------------------------
// When user presses button BUTTON1, perform self test
#if HAS_BUTTON1_DEMO_INTERRUPT
void onButton1FallingEdge(void)
{
    void SelfTest(CmdLine & cmdLine);
    SelfTest(cmdLine_serial);
}
#endif // HAS_BUTTON1_DEMO_INTERRUPT

//--------------------------------------------------
// When user presses button BUTTON2, perform demo configuration
#if HAS_BUTTON2_DEMO_INTERRUPT
void onButton2FallingEdge(void)
{
    // TBD demo configuration
    // CODE GENERATOR: example code: member function Configure_Demo
    g_MAX11043_device.Configure_Demo();

    // TODO diagnostic LED
    led1 = LED_OFF; led2 = LED_OFF; led3 = LED_ON;     // diagnostic rbg led BLUE
}
#endif // HAS_BUTTON2_DEMO_INTERRUPT

//--------------------------------------------------
void SelfTest(CmdLine & cmdLine)
{
    //--------------------------------------------------
#if analogIn4_IS_HIGH_RANGE_OF_analogIn0
    // Platform board uses AIN4,AIN5,.. as high range of AIN0,AIN1,..
    MaximTinyTester tinyTester(cmdLine, analogIn4, analogIn5, analogIn2, analogIn3, analogIn0, analogIn4, led1_RFailLED, led2_GPassLED, led3_BBusyLED);
    tinyTester.analogInPin_fullScaleVoltage[0] = analogInPin_fullScaleVoltage[4]; // board support
    tinyTester.analogInPin_fullScaleVoltage[1] = analogInPin_fullScaleVoltage[5]; // board support
    tinyTester.analogInPin_fullScaleVoltage[2] = analogInPin_fullScaleVoltage[2]; // board support
    tinyTester.analogInPin_fullScaleVoltage[3] = analogInPin_fullScaleVoltage[3]; // board support
    tinyTester.analogInPin_fullScaleVoltage[4] = analogInPin_fullScaleVoltage[0]; // board support
    tinyTester.analogInPin_fullScaleVoltage[5] = analogInPin_fullScaleVoltage[1]; // board support
    // low range channels AIN0, AIN1, AIN2, AIN3
#else // analogIn4_IS_HIGH_RANGE_OF_analogIn0
    // Platform board uses simple analog inputs
    MaximTinyTester tinyTester(cmdLine, analogIn0, analogIn1, analogIn2, analogIn3, analogIn4, analogIn5, led1_RFailLED, led2_GPassLED, led3_BBusyLED);
    tinyTester.analogInPin_fullScaleVoltage[0] = analogInPin_fullScaleVoltage[0]; // board support
    tinyTester.analogInPin_fullScaleVoltage[1] = analogInPin_fullScaleVoltage[1]; // board support
    tinyTester.analogInPin_fullScaleVoltage[2] = analogInPin_fullScaleVoltage[2]; // board support
    tinyTester.analogInPin_fullScaleVoltage[3] = analogInPin_fullScaleVoltage[3]; // board support
    tinyTester.analogInPin_fullScaleVoltage[4] = analogInPin_fullScaleVoltage[4]; // board support
    tinyTester.analogInPin_fullScaleVoltage[5] = analogInPin_fullScaleVoltage[5]; // board support
#endif
    tinyTester.clear();

    // CODE GENERATOR: generate SelfTest based on function docstrings @test lines

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0x7FFF) expect 2.500 within 0.030 Full Scale
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit Full Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0x7FFF), 2.500); // Full Scale
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.err_threshold = 0.030; // within 0.030
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0x7FFF, 2.500); // Full Scale
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0x7FFF) expect 2.500             Full Scale
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit Full Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0x7FFF), 2.500); // Full Scale
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0x7FFF, 2.500); // Full Scale
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0x6666) expect 2.000             Two Volts
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit Two Volts
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0x6666), 2.000); // Two Volts
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0x6666, 2.000); // Two Volts
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0x6000) expect 1.875             75% Scale
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit 75% Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0x6000), 1.875); // 75% Scale
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0x6000, 1.875); // 75% Scale
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0x4000) expect 1.250             Mid Scale
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit Mid Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0x4000), 1.250); // Mid Scale
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0x4000, 1.250); // Mid Scale
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0x3333) expect 1.000             One Volt
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit One Volt
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0x3333), 1.000); // One Volt
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0x3333, 1.000); // One Volt
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0x2000) expect 0.625             25% Scale
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit 25% Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0x2000), 0.625); // 25% Scale
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0x2000, 0.625); // 25% Scale
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0x051e) expect 0.100             100mV
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit 100mV
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0x051e), 0.100); // 100mV
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0x051e, 0.100); // 100mV
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0x0000) expect 0.00000894069671  Three LSB
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit Three LSB
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0x0000), 0.00000894069671); // Three LSB
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0x0000, 0.00000894069671); // Three LSB
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0x0000) expect 0.00000596046447  Two LSB
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit Two LSB
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0x0000), 0.00000596046447); // Two LSB
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0x0000, 0.00000596046447); // Two LSB
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0x0000) expect 0.0000029802326   One LSB
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit One LSB
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0x0000), 0.0000029802326); // One LSB
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0x0000, 0.0000029802326); // One LSB
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0x0000) expect 0.0               Zero Scale
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit Zero Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0x0000), 0.0); // Zero Scale
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0x0000, 0.0); // Zero Scale
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0xFFFF) expect -0.0000029802326  Negative One LSB
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit Negative One LSB
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0xFFFF), -0.0000029802326); // Negative One LSB
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0xFFFF, -0.0000029802326); // Negative One LSB
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0xFFFF) expect -0.0000059604644  Negative Two LSB
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit Negative Two LSB
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0xFFFF), -0.0000059604644); // Negative Two LSB
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0xFFFF, -0.0000059604644); // Negative Two LSB
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0xFFFF) expect -0.0000089406967  Negative Three LSB
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit Negative Three LSB
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0xFFFF), -0.0000089406967); // Negative Three LSB
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0xFFFF, -0.0000089406967); // Negative Three LSB
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0xFAE1) expect -0.100            Negative 100mV
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit Negative 100mV
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0xFAE1), -0.100); // Negative 100mV
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0xFAE1, -0.100); // Negative 100mV
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0xE000) expect -0.625            Negative 25% Scale
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit Negative 25% Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0xE000), -0.625); // Negative 25% Scale
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0xE000, -0.625); // Negative 25% Scale
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0xCCCC) expect -1.000            Negative One Volt
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit Negative One Volt
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0xCCCC), -1.000); // Negative One Volt
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0xCCCC, -1.000); // Negative One Volt
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0xC000) expect -1.250            Negative Mid Scale
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit Negative Mid Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0xC000), -1.250); // Negative Mid Scale
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0xC000, -1.250); // Negative Mid Scale
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0xA000) expect -1.875            Negative 75% Scale
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit Negative 75% Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0xA000), -1.875); // Negative 75% Scale
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0xA000, -1.875); // Negative 75% Scale
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0x9999) expect -2.000            Negative Two Volts
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit Negative Two Volts
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0x9999), -2.000); // Negative Two Volts
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0x9999, -2.000); // Negative Two Volts
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0x8000) expect -2.500            Negative Full Scale
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit Negative Full Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0x8000), -2.500); // Negative Full Scale
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0x8000, -2.500); // Negative Full Scale
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_16bit @test group BIP2C16 ADCVoltageOfCode_16bit(0x8000) expect -2.500            Negative Full Scale
#if MAX11043_SELFTEST_BIP2C16 // group BIP2C16 ADCVoltageOfCode_16bit Negative Full Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_16bit(0x8000), -2.500); // Negative Full Scale
    extern double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_16bit", fn_MAX11043_ADCVoltageOfCode_16bit, 0x8000, -2.500); // Negative Full Scale
#endif // MAX11043_SELFTEST_BIP2C16 // group BIP2C16

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0x7FFFFF) expect 2.500 within 0.030 Full Scale
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit Full Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0x7FFFFF), 2.500); // Full Scale
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.err_threshold = 0.030; // within 0.030
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0x7FFFFF, 2.500); // Full Scale
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0x7FFFFE) expect 2.500             Full Scale
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit Full Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0x7FFFFE), 2.500); // Full Scale
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0x7FFFFE, 2.500); // Full Scale
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0x666666) expect 2.000             Two Volts
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit Two Volts
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0x666666), 2.000); // Two Volts
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0x666666, 2.000); // Two Volts
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0x600000) expect 1.875             75% Scale
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit 75% Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0x600000), 1.875); // 75% Scale
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0x600000, 1.875); // 75% Scale
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0x400000) expect 1.250             Mid Scale
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit Mid Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0x400000), 1.250); // Mid Scale
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0x400000, 1.250); // Mid Scale
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0x333333) expect 1.000             One Volt
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit One Volt
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0x333333), 1.000); // One Volt
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0x333333, 1.000); // One Volt
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0x200000) expect 0.625             25% Scale
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit 25% Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0x200000), 0.625); // 25% Scale
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0x200000, 0.625); // 25% Scale
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0x051eb8) expect 0.100             100mV
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit 100mV
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0x051eb8), 0.100); // 100mV
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0x051eb8, 0.100); // 100mV
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0x000003) expect 0.00000894069671  Three LSB
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit Three LSB
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0x000003), 0.00000894069671); // Three LSB
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0x000003, 0.00000894069671); // Three LSB
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0x000002) expect 0.00000596046447  Two LSB
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit Two LSB
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0x000002), 0.00000596046447); // Two LSB
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0x000002, 0.00000596046447); // Two LSB
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0x000001) expect 0.0000029802326   One LSB
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit One LSB
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0x000001), 0.0000029802326); // One LSB
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0x000001, 0.0000029802326); // One LSB
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0x000000) expect 0.0               Zero Scale
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit Zero Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0x000000), 0.0); // Zero Scale
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0x000000, 0.0); // Zero Scale
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0xFFFFFF) expect -0.0000029802326  Negative One LSB
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit Negative One LSB
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0xFFFFFF), -0.0000029802326); // Negative One LSB
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0xFFFFFF, -0.0000029802326); // Negative One LSB
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0xFFFFFE) expect -0.0000059604644  Negative Two LSB
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit Negative Two LSB
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0xFFFFFE), -0.0000059604644); // Negative Two LSB
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0xFFFFFE, -0.0000059604644); // Negative Two LSB
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0xFFFFFD) expect -0.0000089406967  Negative Three LSB
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit Negative Three LSB
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0xFFFFFD), -0.0000089406967); // Negative Three LSB
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0xFFFFFD, -0.0000089406967); // Negative Three LSB
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0xFAE148) expect -0.100            Negative 100mV
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit Negative 100mV
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0xFAE148), -0.100); // Negative 100mV
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0xFAE148, -0.100); // Negative 100mV
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0xE00000) expect -0.625            Negative 25% Scale
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit Negative 25% Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0xE00000), -0.625); // Negative 25% Scale
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0xE00000, -0.625); // Negative 25% Scale
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0xCCCCCD) expect -1.000            Negative One Volt
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit Negative One Volt
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0xCCCCCD), -1.000); // Negative One Volt
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0xCCCCCD, -1.000); // Negative One Volt
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0xC00000) expect -1.250            Negative Mid Scale
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit Negative Mid Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0xC00000), -1.250); // Negative Mid Scale
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0xC00000, -1.250); // Negative Mid Scale
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0xA00000) expect -1.875            Negative 75% Scale
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit Negative 75% Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0xA00000), -1.875); // Negative 75% Scale
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0xA00000, -1.875); // Negative 75% Scale
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0x99999A) expect -2.000            Negative Two Volts
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit Negative Two Volts
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0x99999A), -2.000); // Negative Two Volts
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0x99999A, -2.000); // Negative Two Volts
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0x800001) expect -2.500            Negative Full Scale
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit Negative Full Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0x800001), -2.500); // Negative Full Scale
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0x800001, -2.500); // Negative Full Scale
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    // CODE GENERATOR: SelfTest ADCVoltageOfCode_24bit @test group BIP2C24 ADCVoltageOfCode_24bit(0x800000) expect -2.500            Negative Full Scale
#if MAX11043_SELFTEST_BIP2C24 // group BIP2C24 ADCVoltageOfCode_24bit Negative Full Scale
    // ASSERT_EQ(g_MAX11043_device.ADCVoltageOfCode_24bit(0x800000), -2.500); // Negative Full Scale
    extern double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24);
    tinyTester.FunctionCall_Expect("MAX11043.ADCVoltageOfCode_24bit", fn_MAX11043_ADCVoltageOfCode_24bit, 0x800000, -2.500); // Negative Full Scale
#endif // MAX11043_SELFTEST_BIP2C24 // group BIP2C24

    //
#if INJECT_SELFTEST_FAIL
    // Test of the pass/fail report mechanism
    tinyTester.FAIL();
    cmdLine.serial().print(F("injecting one false failure for test reporting"));
#endif
    //
    // Report number of pass and number of fail test results
    tinyTester.Report_Summary();
}

//--------------------------------------------------
// selftest: define function under test
// double MAX11043::ADCVoltageOfCode_16bit(uint32_t value_u16)
double fn_MAX11043_ADCVoltageOfCode_16bit(uint32_t value_u16)
{
    return g_MAX11043_device.ADCVoltageOfCode_16bit(value_u16);
}

//--------------------------------------------------
// selftest: define function under test
// double MAX11043::ADCVoltageOfCode_24bit(uint32_t value_u24)
double fn_MAX11043_ADCVoltageOfCode_24bit(uint32_t value_u24)
{
    return g_MAX11043_device.ADCVoltageOfCode_24bit(value_u24);
}


//--------------------------------------------------
inline void print_command_prompt()
{
    cmdLine_serial.serial().printf("\r\n> ");

}


//--------------------------------------------------
void pinsMonitor_submenu_onEOLcommandParser(CmdLine& cmdLine)
{
    // % diagnostic commands submenu
    // %Hpin -- digital output high
    // %Lpin -- digital output low
    // %?pin -- digital input
    // %A %Apin -- analog input
    // %Ppin df=xx -- pwm output
    // %Wpin -- measure high pulsewidth input in usec
    // %wpin -- measure low pulsewidth input in usec
    // %I... -- I2C diagnostics
    // %IP -- I2C probe
    // %IC scl=100khz ADDR=? -- I2C configure
    // %IW byte byte ... byte RD=? ADDR=0x -- write
    // %IR ADDR=? RD=? -- read
    // %I^ cmd=? -- i2c_smbus_read_word_data
    // %S... -- SPI diagnostics
    // %SC sclk=1Mhz -- SPI configure
    // %SW -- write (write and read)
    // %SR -- read (alias for %SW because SPI always write and read)
    // A-Z,a-z,0-9 reserved for application use
    //
    char strPinIndex[3];
    strPinIndex[0] = cmdLine[2];
    strPinIndex[1] = cmdLine[3];
    strPinIndex[2] = '\0';
    int pinIndex = strtoul(strPinIndex, NULL, 10);         // strtol(str, NULL, 10): get decimal value
    //cmdLine.serial().printf(" pinIndex=%d ", pinIndex);
    //
    // get next character
    switch (cmdLine[1])
    {
#if HAS_digitalInOuts
        case 'H': case 'h':
        {
            // %Hpin -- digital output high
#if ARDUINO_STYLE
            pinMode(pinIndex, OUTPUT);             // digital pins 0, 1, 2, .. 13, analog input pins A0, A1, .. A5
            digitalWrite(pinIndex, HIGH);             // digital pins 0, 1, 2, .. 13, analog input pins A0, A1, .. A5
#else
            DigitalInOut& digitalInOutPin = find_digitalInOutPin(pinIndex);
            digitalInOutPin.output();
            digitalInOutPin.write(1);
#endif
            cmdLine.serial().printf(" digitalInOutPin %d Output High ", pinIndex);
        }
        break;
        case 'L': case 'l':
        {
            // %Lpin -- digital output low
#if ARDUINO_STYLE
            pinMode(pinIndex, OUTPUT);             // digital pins 0, 1, 2, .. 13, analog input pins A0, A1, .. A5
            digitalWrite(pinIndex, LOW);             // digital pins 0, 1, 2, .. 13, analog input pins A0, A1, .. A5
#else
            DigitalInOut& digitalInOutPin = find_digitalInOutPin(pinIndex);
            digitalInOutPin.output();
            digitalInOutPin.write(0);
#endif
            cmdLine.serial().printf(" digitalInOutPin %d Output Low ", pinIndex);
        }
        break;
        case '?':
        {
            // %?pin -- digital input
#if ARDUINO_STYLE
            pinMode(pinIndex, INPUT);             // digital pins 0, 1, 2, .. 13, analog input pins A0, A1, .. A5
#else
            DigitalInOut& digitalInOutPin = find_digitalInOutPin(pinIndex);
            digitalInOutPin.input();
#endif
            serial.printf(" digitalInOutPin %d Input ", pinIndex);
#if ARDUINO_STYLE
            int value = digitalRead(pinIndex);
#else
            int value = digitalInOutPin.read();
#endif
            cmdLine.serial().printf("%d ", value);
        }
        break;
#endif
        //
#if HAS_analogIns
        case 'A': case 'a':
        {
            // %A %Apin -- analog input
#if analogIn4_IS_HIGH_RANGE_OF_analogIn0
            // Platform board uses AIN4,AIN5,.. as high range of AIN0,AIN1,..
            for (int pinIndex = 0; pinIndex < 2; pinIndex++)
            {
                int cPinIndex = '0' + pinIndex;
                AnalogIn& analogInPin = find_analogInPin(cPinIndex);
                float adc_full_scale_voltage = analogInPin_fullScaleVoltage[pinIndex];
                float normValue_0_1 = analogInPin.read();
                //
                int pinIndexH = pinIndex + 4;
                int cPinIndexH = '0' + pinIndexH;
                AnalogIn& analogInPinH = find_analogInPin(cPinIndexH);
                float adc_full_scale_voltageH = analogInPin_fullScaleVoltage[pinIndexH];
                float normValueH_0_1 = analogInPinH.read();
                //
                cmdLine.serial().printf("AIN%c = %7.3f%% = %1.3fV  AIN%c = %7.3f%% = %1.3fV  \r\n",
                                        cPinIndex,
                                        normValue_0_1 * 100.0,
                                        normValue_0_1 * adc_full_scale_voltage,
                                        cPinIndexH,
                                        normValueH_0_1 * 100.0,
                                        normValueH_0_1 * adc_full_scale_voltageH
                                        );
            }
            for (int pinIndex = 2; pinIndex < 4; pinIndex++)
            {
                int cPinIndex = '0' + pinIndex;
                AnalogIn& analogInPin = find_analogInPin(cPinIndex);
                float adc_full_scale_voltage = analogInPin_fullScaleVoltage[pinIndex];
                float normValue_0_1 = analogInPin.read();
                //
                cmdLine.serial().printf("AIN%c = %7.3f%% = %1.3fV\r\n",
                                        cPinIndex,
                                        normValue_0_1 * 100.0,
                                        normValue_0_1 * adc_full_scale_voltage
                                        );
            }
#else // analogIn4_IS_HIGH_RANGE_OF_analogIn0
            // Platform board uses simple analog inputs
            // assume standard Arduino analog inputs A0-A5
            for (int pinIndex = 0; pinIndex < 6; pinIndex++)
            {
                int cPinIndex = '0' + pinIndex;
                AnalogIn& analogInPin = find_analogInPin(cPinIndex);
                float adc_full_scale_voltage = analogInPin_fullScaleVoltage[pinIndex];
                float normValue_0_1 = analogInPin.read();
                //
                cmdLine.serial().printf("AIN%c = %7.3f%% = %1.3fV\r\n",
                                        cPinIndex,
                                        normValue_0_1 * 100.0,
                                        normValue_0_1 * adc_full_scale_voltage
                                        );
            }
#endif // analogIn4_IS_HIGH_RANGE_OF_analogIn0
        }
        break;
#endif
        //
#if HAS_SPI2_MAX541
        case 'D': case 'd':
        {
            // %D -- DAC output MAX541 (SPI2) -- need cmdLine.parse_float(voltageV)
            // MAX541 max541(spi2_max541, spi2_max541_cs);
            float voltageV = max541.Get_Voltage();
            // if (cmdLine[2] == '+') {
            //     // %D+
            //     voltageV = voltageV * 1.25f;
            //     if (voltageV >= max541.VRef) voltageV = max541.VRef;
            //     SelfTest_MAX541_Voltage(cmdLine, max541, voltageV);
            // }
            // else if (cmdLine[2] == '-') {
            //     // %D-
            //     voltageV = voltageV * 0.75f;
            //     if (voltageV < 0.1f) voltageV = 0.1f;
            //     SelfTest_MAX541_Voltage(cmdLine, max541, voltageV);
            // }
            if (cmdLine.parse_float("V", voltageV))
            {
                // %D V=1.234 -- set voltage
                max541.Set_Voltage(voltageV);
            }
            else if (cmdLine.parse_float("TEST", voltageV))
            {
                // %D TEST=1.234 -- set voltage and compare with AIN0
                SelfTest_MAX541_Voltage(cmdLine, max541, voltageV);
            }
            else if (cmdLine.parse_float("CAL", voltageV))
            {
                // %D CAL=1.234 -- calibrate VRef and compare with AIN0

                max541.Set_Code(0x8000); // we don't know the fullscale voltage yet, so set code to midscale
                double max541_midscale_V = analogInPin_fullScaleVoltage[4] * analogIn4.read(); // TARGET_MAX32630 J1.5 AIN_4 = AIN0 / 5.0     fullscale is 6.0V
                const int average_count = 100;
                const double average_K = 0.25;
                for (int count = 0; count < average_count; count++) {
                    double measurement_V = analogInPin_fullScaleVoltage[4] * analogIn4.read(); // TARGET_MAX32630 J1.5 AIN_4 = AIN0 / 5.0     fullscale is 6.0V
                    max541_midscale_V = ((1 - average_K) * max541_midscale_V) + (average_K * measurement_V);
                }
                max541.VRef = 2.0 * max541_midscale_V;
                cmdLine.serial().printf(
                    "\r\n      MAX541 midscale = %1.3fV, so fullscale = %1.3fV",
                    max541_midscale_V, max541.VRef);
                // Detect whether MAX541 is really connected to MAX32625MBED.AIN0/AIN4
                voltageV = 1.0f;
                SelfTest_MAX541_Voltage(cmdLine, max541, voltageV);
            }
            else {
                // %D -- print MAX541 DAC status
                cmdLine.serial().printf("MAX541 code=0x%4.4x = %1.3fV  VRef=%1.3fV\r\n",
                                        max541.Get_Code(), max541.Get_Voltage(), max541.VRef);
            }
        }
        break;
#endif

        //
#if HAS_I2C // SUPPORT_I2C
        case 'I': case 'i':
            // %I... -- I2C diagnostics
            // %IP -- I2C probe
            // %IC scl=100khz ADDR=? -- I2C configure
            // %IW byte byte ... byte RD=? ADDR=0x -- write
            // %IR ADDR=? RD=? -- read
            // %I^ cmd=? -- i2c_smbus_read_word_data
            // get next character
            // TODO: parse cmdLine arg (ADDR=\d+)? --> g_I2C_deviceAddress7
            cmdLine.parse_byte_hex("ADDR", g_I2C_deviceAddress7);
            // TODO: parse cmdLine arg (RD=\d)? --> g_I2C_read_count
            g_I2C_read_count = 0;         // read count must be reset every command
            cmdLine.parse_byte_dec("RD", g_I2C_read_count);
            // TODO: parse cmdLine arg (CMD=\d)? --> g_I2C_command_regAddress
            cmdLine.parse_byte_hex("CMD", g_I2C_command_regAddress);
            switch (cmdLine[2])
            {
                case 'P': case 'p':
                {
                    // %IP -- I2C probe
                    HuntAttachedI2CDevices(cmdLine, 0x03, 0x77);
                }
                break;
                case 'C': case 'c':
                {
                    bool isUpdatedI2CConfig = false;
                    // %IC scl=100khz ADDR=? -- I2C configure
                    // parse cmdLine arg (SCL=\d+(kHZ|MHZ)?)? --> g_I2C_SCL_Hz
                    if (cmdLine.parse_frequency_Hz("SCL", g_I2C_SCL_Hz))
                    {
                        isUpdatedI2CConfig = true;
                        // TODO1: validate g_I2C_SCL_Hz against system clock frequency F_CPU
                        if (g_I2C_SCL_Hz > limit_max_I2C_SCL_Hz)
                        {
                            g_I2C_SCL_Hz = limit_max_I2C_SCL_Hz;
                        }
                        if (g_I2C_SCL_Hz < limit_min_I2C_SCL_Hz)
                        {
                            g_I2C_SCL_Hz = limit_min_I2C_SCL_Hz;
                        }
                    }
                    if (isUpdatedI2CConfig)
                    {
                        // declare in narrower scope: MAX32625MBED I2C i2cMaster(...)
                        I2C i2cMaster(I2C0_SDA, I2C0_SCL);             // sda scl TARGET_MAX32635MBED: P1_6, P1_7 Arduino 10-pin header
                        i2cMaster.frequency(g_I2C_SCL_Hz);
                        i2cMaster.start();
                        i2cMaster.stop();
                        i2cMaster.frequency(g_I2C_SCL_Hz);
                        cmdLine.serial().printf(
                            "\r\n %%IC ADDR=0x%2.2x=(0x%2.2x>>1) SCL=%d=%1.3fkHz -- I2C config",
                            g_I2C_deviceAddress7, (g_I2C_deviceAddress7 << 1), g_I2C_SCL_Hz,
                            (g_I2C_SCL_Hz / 1000.));
                        i2cMaster.start();
                        i2cMaster.stop();
                    }
                }
                break;
                case 'W': case 'w':
                {
                    // declare in narrower scope: MAX32625MBED I2C i2cMaster(...)
                    I2C i2cMaster(I2C0_SDA, I2C0_SCL);             // sda scl TARGET_MAX32635MBED: P1_6, P1_7 Arduino 10-pin header
                    i2cMaster.frequency(g_I2C_SCL_Hz);
                    // %IW byte byte ... byte RD=? ADDR=0x -- write
                    // parse cmdLine byte list --> int byteCount; int mosiData[MAX_SPI_BYTE_COUNT];
                    #define MAX_I2C_BYTE_COUNT 32
                    size_t byteCount = byteCount;
                    static char mosiData[MAX_I2C_BYTE_COUNT];
                    static char misoData[MAX_I2C_BYTE_COUNT];
                    if (cmdLine.parse_byteCount_byteList_hex(byteCount, mosiData,
                                                             MAX_I2C_BYTE_COUNT))
                    {
                        // hex dump mosiData[0..byteCount-1]
                        cmdLine.serial().printf(
                            "\r\nADDR=0x%2.2x=(0x%2.2x>>1) byteCount:%d RD=%d\r\nI2C MOSI->",
                            g_I2C_deviceAddress7,
                            (g_I2C_deviceAddress7 << 1), byteCount, g_I2C_read_count);
                        for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
                        {
                            cmdLine.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
                        }
                        //
                        // TODO: i2c transfer
                        //const int addr7bit = 0x48;      // 7 bit I2C address
                        //const int addr8bit = 0x48 << 1; // 8bit I2C address, 0x90
                        // /* int  */   i2cMaster.read (int addr8bit, char *data, int length, bool repeated=false) // Read from an I2C slave.
                        // /* int  */   i2cMaster.read (int ack) // Read a single byte from the I2C bus.
                        // /* int  */   i2cMaster.write (int addr8bit, const char *data, int length, bool repeated=false) // Write to an I2C slave.
                        // /* int  */   i2cMaster.write (int data) // Write single byte out on the I2C bus.
                        // /* void */   i2cMaster.start (void) // Creates a start condition on the I2C bus.
                        // /* void */   i2cMaster.stop (void) // Creates a stop condition on the I2C bus.
                        // /* int */    i2cMaster.transfer (int addr8bit, const char *tx_buffer, int tx_length, char *rx_buffer, int rx_length, const event_callback_t &callback, int event=I2C_EVENT_TRANSFER_COMPLETE, bool repeated=false) // Start nonblocking I2C transfer. More...
                        // /* void */   i2cMaster.abort_transfer () // Abort the ongoing I2C transfer. More...
                        const int addr8bit = g_I2C_deviceAddress7 << 1;             // 8bit I2C address, 0x90
                        unsigned int misoLength = 0;
                        bool repeated = (g_I2C_read_count > 0);
                        //
                        int writeStatus = i2cMaster.write (addr8bit, mosiData, byteCount, repeated);
                        switch (writeStatus)
                        {
                            case 0: cmdLine.serial().printf(" ack "); break;
                            case 1: cmdLine.serial().printf(" nack "); break;
                            default: cmdLine.serial().printf(" {writeStatus 0x%2.2X} ",
                                                             writeStatus);
                        }
                        if (repeated)
                        {
                            int readStatus =
                                i2cMaster.read (addr8bit, misoData, g_I2C_read_count, false);
                            switch (readStatus)
                            {
                                case 1: cmdLine.serial().printf(" nack "); break;
                                case 0: cmdLine.serial().printf(" ack "); break;
                                default: cmdLine.serial().printf(" {readStatus 0x%2.2X} ",
                                                                 readStatus);
                            }
                        }
                        //
                        if (misoLength > 0)
                        {
                            // hex dump misoData[0..byteCount-1]
                            cmdLine.serial().printf("  MISO<-");
                            for (unsigned int byteIndex = 0; byteIndex < g_I2C_read_count;
                                 byteIndex++)
                            {
                                cmdLine.serial().printf(" 0x%2.2X", misoData[byteIndex]);
                            }
                        }
                        cmdLine.serial().printf(" ");
                    }
                }
                break;
                case 'R': case 'r':
                {
                    // declare in narrower scope: MAX32625MBED I2C i2cMaster(...)
                    I2C i2cMaster(I2C0_SDA, I2C0_SCL);             // sda scl TARGET_MAX32635MBED: P1_6, P1_7 Arduino 10-pin header
                    i2cMaster.frequency(g_I2C_SCL_Hz);
                    // %IR ADDR=? RD=? -- read
                    // TODO: i2c transfer
                    //const int addr7bit = 0x48;      // 7 bit I2C address
                    //const int addr8bit = 0x48 << 1; // 8bit I2C address, 0x90
                    // /* int  */   i2cMaster.read (int addr8bit, char *data, int length, bool repeated=false) // Read from an I2C slave.
                    // /* int  */   i2cMaster.read (int ack) // Read a single byte from the I2C bus.
                    // /* int  */   i2cMaster.write (int addr8bit, const char *data, int length, bool repeated=false) // Write to an I2C slave.
                    // /* int  */   i2cMaster.write (int data) // Write single byte out on the I2C bus.
                    // /* void */   i2cMaster.start (void) // Creates a start condition on the I2C bus.
                    // /* void */   i2cMaster.stop (void) // Creates a stop condition on the I2C bus.
                    // /* int */    i2cMaster.transfer (int addr8bit, const char *tx_buffer, int tx_length, char *rx_buffer, int rx_length, const event_callback_t &callback, int event=I2C_EVENT_TRANSFER_COMPLETE, bool repeated=false) // Start nonblocking I2C transfer. More...
                    // /* void */   i2cMaster.abort_transfer () // Abort the ongoing I2C transfer. More...
                }
                break;
                case '^':
                {
                    // declare in narrower scope: MAX32625MBED I2C i2cMaster(...)
                    I2C i2cMaster(I2C0_SDA, I2C0_SCL);             // sda scl TARGET_MAX32635MBED: P1_6, P1_7 Arduino 10-pin header
                    i2cMaster.frequency(g_I2C_SCL_Hz);
                    // %I^ cmd=? -- i2c_smbus_read_word_data
                    // TODO: i2c transfer
                    //const int addr7bit = 0x48;      // 7 bit I2C address
                    //const int addr8bit = 0x48 << 1; // 8bit I2C address, 0x90
                    // /* int  */   i2cMaster.read (int addr8bit, char *data, int length, bool repeated=false) // Read from an I2C slave.
                    // /* int  */   i2cMaster.read (int ack) // Read a single byte from the I2C bus.
                    // /* int  */   i2cMaster.write (int addr8bit, const char *data, int length, bool repeated=false) // Write to an I2C slave.
                    // /* int  */   i2cMaster.write (int data) // Write single byte out on the I2C bus.
                    // /* void */   i2cMaster.start (void) // Creates a start condition on the I2C bus.
                    // /* void */   i2cMaster.stop (void) // Creates a stop condition on the I2C bus.
                    // /* int */    i2cMaster.transfer (int addr8bit, const char *tx_buffer, int tx_length, char *rx_buffer, int rx_length, const event_callback_t &callback, int event=I2C_EVENT_TRANSFER_COMPLETE, bool repeated=false) // Start nonblocking I2C transfer. More...
                    // /* void */   i2cMaster.abort_transfer () // Abort the ongoing I2C transfer. More...
                }
                break;
            }         // switch(cmdLine[2])
            break;
#endif
        //
#if HAS_SPI // SUPPORT_SPI
        case 'S': case 's':
        {
            // %S... -- SPI diagnostics
            // %SC sclk=1Mhz -- SPI configure
            // %SW -- write (write and read)
            // %SR -- read (alias for %SW because SPI always write and read)
            //
            // Process arguments SCLK=\d+(kHZ|MHZ) CPOL=\d CPHA=\d
            bool isUpdatedSPIConfig = false;
            // parse cmdLine arg (CPOL=\d)? --> g_SPI_dataMode | SPI_MODE2
            // parse cmdLine arg (CPHA=\d)? --> g_SPI_dataMode | SPI_MODE1
            if (cmdLine.parse_flag("CPOL", g_SPI_dataMode, SPI_MODE2))
            {
                isUpdatedSPIConfig = true;
            }
            if (cmdLine.parse_flag("CPHA", g_SPI_dataMode, SPI_MODE1))
            {
                isUpdatedSPIConfig = true;
            }
            if (cmdLine.parse_flag("CS", g_SPI_cs_state, 1))
            {
                isUpdatedSPIConfig = true;
            }
            // parse cmdLine arg (SCLK=\d+(kHZ|MHZ)?)? --> g_SPI_SCLK_Hz
            if (cmdLine.parse_frequency_Hz("SCLK", g_SPI_SCLK_Hz))
            {
                isUpdatedSPIConfig = true;
                // TODO1: validate g_SPI_SCLK_Hz against system clock frequency F_CPU
                if (g_SPI_SCLK_Hz > limit_max_SPI_SCLK_Hz)
                {
                    g_SPI_SCLK_Hz = limit_max_SPI_SCLK_Hz;
                }
                if (g_SPI_SCLK_Hz < limit_min_SPI_SCLK_Hz)
                {
                    g_SPI_SCLK_Hz = limit_min_SPI_SCLK_Hz;
                }
            }
            // Update SPI configuration
            if (isUpdatedSPIConfig)
            {
                // %SC sclk=1Mhz -- SPI configure
                spi_cs = g_SPI_cs_state;
                spi.format(8,g_SPI_dataMode);             // int bits_must_be_8, int mode=0_3 CPOL=0,CPHA=0
#if APPLICATION_MAX5715
                g_MAX5715_device.spi_frequency(g_SPI_SCLK_Hz);
#elif APPLICATION_MAX11131
                g_MAX11131_device.spi_frequency(g_SPI_SCLK_Hz);
#elif APPLICATION_MAX5171
                g_MAX5171_device.spi_frequency(g_SPI_SCLK_Hz);
#elif APPLICATION_MAX11410
                g_MAX11410_device.spi_frequency(g_SPI_SCLK_Hz);
#elif APPLICATION_MAX12345
                g_MAX12345_device.spi_frequency(g_SPI_SCLK_Hz);
#else
                spi.frequency(g_SPI_SCLK_Hz);             // int SCLK_Hz=1000000 = 1MHz (initial default)
#endif
                //
                double ideal_divisor = ((double)SystemCoreClock) / g_SPI_SCLK_Hz;
                int actual_divisor = (int)(ideal_divisor + 0.0);             // frequency divisor truncate
                double actual_SCLK_Hz = SystemCoreClock / actual_divisor;
                //
                // fixed: mbed-os-5.11: [Warning] format '%d' expects argument of type 'int', but argument 6 has type 'uint32_t {aka long unsigned int}' [-Wformat=]
                cmdLine.serial().printf(
                    "\r\n %%SC CPOL=%d CPHA=%d CS=%d SCLK=%ld=%1.3fMHz (%1.1fMHz/%1.2f = actual %1.3fMHz) -- SPI config",
                    ((g_SPI_dataMode & SPI_MODE2) ? 1 : 0),
                    ((g_SPI_dataMode & SPI_MODE1) ? 1 : 0),
                    g_SPI_cs_state,
                    g_SPI_SCLK_Hz,
                    (g_SPI_SCLK_Hz / 1000000.),
                    ((double)(SystemCoreClock / 1000000.)),
                    ideal_divisor,
                    (actual_SCLK_Hz / 1000000.)
                    );
            }
            // get next character
            switch (cmdLine[2])
            {
                case 'C': case 's':
                    // %SC sclk=1Mhz -- SPI configure
                    break;
                case 'D': case 'd':
                    // %SD -- SPI diagnostic messages enable
                    if (g_MAX11043_device.onSPIprint) {
                        g_MAX11043_device.onSPIprint = NULL;
                    }
                    else {
                        void onSPIprint_handler(size_t byteCount, uint8_t mosiData[], uint8_t misoData[]);
                        g_MAX11043_device.onSPIprint = onSPIprint_handler;
                    }
                    break;
                case 'W': case 'R': case 'w': case 'r':
                {
                    // %SW -- write (write and read)
                    // %SR -- read (alias for %SW because SPI always write and read)
                    // parse cmdLine byte list --> int byteCount; int mosiData[MAX_SPI_BYTE_COUNT];
                    #define MAX_SPI_BYTE_COUNT 32
                    size_t byteCount = byteCount;
                    static char mosiData[MAX_SPI_BYTE_COUNT];
                    static char misoData[MAX_SPI_BYTE_COUNT];
                    if (cmdLine.parse_byteCount_byteList_hex(byteCount, mosiData,
                                                             MAX_SPI_BYTE_COUNT))
                    {
                        // hex dump mosiData[0..byteCount-1]
                        cmdLine.serial().printf("\r\nSPI");
                        if (byteCount > 7) {
                            cmdLine.serial().printf(" byteCount:%d", byteCount);
                        }
                        cmdLine.serial().printf(" MOSI->");
                        for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
                        {
                            cmdLine.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
                        }
                        spi_cs = 0;
                        unsigned int numBytesTransferred =
                            spi.write(mosiData, byteCount, misoData, byteCount);
                        spi_cs = 1;
                        // hex dump misoData[0..byteCount-1]
                        cmdLine.serial().printf("  MISO<-");
                        for (unsigned int byteIndex = 0; byteIndex < numBytesTransferred;
                             byteIndex++)
                        {
                            cmdLine.serial().printf(" 0x%2.2X", misoData[byteIndex]);
                        }
                        cmdLine.serial().printf(" ");
                    }
                }
                break;
            }             // switch(cmdLine[2])
        }             // case 'S': // %S... -- SPI diagnostics
        break;
#endif
        //
        // A-Z,a-z,0-9 reserved for application use
    }         // switch(cmdLine[1])
} // end void pinsMonitor_submenu_onEOLcommandParser(CmdLine & cmdLine)


//--------------------------------------------------
void main_menu_status(CmdLine & cmdLine)
{
    cmdLine.serial().printf("\r\nMain menu");

    cmdLine.serial().printf(" MAX11043 24-bit 200ksps Delta-Sigma ADC");

    //cmdLine.serial().print(" %s", TARGET_NAME);
    if (cmdLine.nameStr())
    {
        cmdLine.serial().printf(" [%s]", cmdLine.nameStr());

    }
    cmdLine.serial().printf("\r\n ? -- help");

}


//--------------------------------------------------
void main_menu_help(CmdLine & cmdLine)
{
    // ? -- help
    //~ cmdLine.serial().print(F("\r\nMenu:"));
    cmdLine.serial().printf("\r\n # -- lines beginning with # are comments");

    cmdLine.serial().printf("\r\n . -- SelfTest");

    //cmdLine.serial().print(F("\r\n ! -- Initial Configuration"));
    //
    // % standardize diagnostic commands
    // %Hpin -- digital output high
    // %Lpin -- digital output low
    // %?pin -- digital input
    // %A %Apin -- analog input
    // %Ppin df=xx -- pwm output
    // %Wpin -- measure high pulsewidth input in usec
    // %wpin -- measure low pulsewidth input in usec
    // %I... -- I2C diagnostics
    // %IP -- I2C probe
    // %IC scl=100khz ADDR=? -- I2C configure
    // %IW ADDR=? cmd=? data,data,data -- write
    // %IR ADDR=? RD=? -- read
    // %I^ cmd=? -- i2c_smbus_read_word_data
    // %S... -- SPI diagnostics
    // %SC sclk=1Mhz -- SPI configure
    // %SW -- write (write and read)
    // %SR -- read (alias for %SW because SPI always write and read)
    // A-Z,a-z,0-9 reserved for application use
    //
#if HAS_digitalInOuts
    // %Hpin -- digital output high
    // %Lpin -- digital output low
    // %?pin -- digital input
    cmdLine.serial().printf("\r\n %%Hn {pin:");
    list_digitalInOutPins(cmdLine.serial());
    cmdLine.serial().printf("} -- High Output");
    cmdLine.serial().printf("\r\n %%Ln {pin:");
    list_digitalInOutPins(cmdLine.serial());
    cmdLine.serial().printf("} -- Low Output");
    cmdLine.serial().printf("\r\n %%?n {pin:");
    list_digitalInOutPins(cmdLine.serial());
    cmdLine.serial().printf("} -- Input");
#endif

#if HAS_analogIns
    // Menu A) analogRead A0..7
    // %A %Apin -- analog input
    // analogRead(pinIndex) // analog input pins A0, A1, A2, A3, A4, A5; float voltage = analogRead(A0) * (5.0 / 1023.0)
    cmdLine.serial().printf("\r\n %%A -- analogRead");
#endif

#if HAS_SPI2_MAX541
    // TODO1: MAX541 max541(spi2_max541, spi2_max541_cs);
    cmdLine.serial().printf("\r\n %%D -- DAC output MAX541 (SPI2)");
#endif

#if HAS_I2C // SUPPORT_I2C
    // TODO: support I2C HAS_I2C // SUPPORT_I2C
    // VERIFY: I2C utility commands SUPPORT_I2C
    // VERIFY: report g_I2C_SCL_Hz = (F_CPU / ((TWBR * 2) + 16)) from last Wire_Sr.setClock(I2C_SCL_Hz);
    // %I... -- I2C diagnostics
    // %IP -- I2C probe
    // %IC scl=100khz ADDR=? -- I2C configure
    // %IW byte byte ... byte RD=? ADDR=0x -- write
    // %IR ADDR=? RD=? -- read
    // %I^ cmd=? -- i2c_smbus_read_word_data
    //g_I2C_SCL_Hz = (F_CPU / ((TWBR * 2) + 16));   // 'F_CPU' 'TWBR' not declared in this scope
    cmdLine.serial().printf("\r\n %%IC ADDR=0x%2.2x=(0x%2.2x>>1) SCL=%d=%1.3fkHz -- I2C config",
                            g_I2C_deviceAddress7, (g_I2C_deviceAddress7 << 1), g_I2C_SCL_Hz,
                            (g_I2C_SCL_Hz / 1000.));
    cmdLine.serial().printf("\r\n %%IW byte byte ... byte RD=? ADDR=0x%2.2x -- I2C write/read",
                            g_I2C_deviceAddress7);
    //
#if SUPPORT_I2C
    // Menu ^ cmd=?) i2c_smbus_read_word_data
    cmdLine.serial().printf("\r\n %%I^ cmd=? -- i2c_smbus_read_word_data");
    // test low-level I2C i2c_smbus_read_word_data
#endif // SUPPORT_I2C
    //cmdLine.serial().printf(" H) Hunt for attached I2C devices");
    cmdLine.serial().printf("\r\n %%IP -- I2C Probe for attached devices");
    // cmdLine.serial().printf(" s) search i2c address");
#endif // SUPPORT_I2C

#if HAS_SPI // SUPPORT_SPI
    // TODO: support SPI HAS_SPI // SUPPORT_SPI
    // SPI test command  S (mosiData)+
    // %S... -- SPI diagnostics
    // %SC sclk=1Mhz -- SPI configure
    // %SW -- write (write and read)
    // %SR -- read (alias for %SW because SPI always write and read)
    // spi.format(8,0); // int bits_must_be_8, int mode=0_3 CPOL=0,CPHA=0 rising edge (initial default)
    // spi.format(8,1); // int bits_must_be_8, int mode=0_3 CPOL=0,CPHA=1 falling edge (initial default)
    // spi.format(8,2); // int bits_must_be_8, int mode=0_3 CPOL=1,CPHA=0 falling edge (initial default)
    // spi.format(8,3); // int bits_must_be_8, int mode=0_3 CPOL=1,CPHA=1 rising edge (initial default)
    // spi.frequency(1000000); // int SCLK_Hz=1000000 = 1MHz (initial default)
    // mode | POL PHA
    // -----+--------
    //   0  |  0   0
    //   1  |  0   1
    //   2  |  1   0
    //   3  |  1   1
    //cmdLine.serial().printf(" S) SPI mosi,mosi,...mosi hex bytes SCLK=1000000 CPOL=0 CPHA=0");
    // fixed: mbed-os-5.11: [Warning] format '%d' expects argument of type 'int', but argument 3 has type 'uint32_t {aka long unsigned int}' [-Wformat=]
    cmdLine.serial().printf("\r\n %%SC SCLK=%ld=%1.3fMHz CPOL=%d CPHA=%d -- SPI config",
                            g_SPI_SCLK_Hz, (g_SPI_SCLK_Hz / 1000000.),
                            ((g_SPI_dataMode & SPI_MODE2) ? 1 : 0),
                            ((g_SPI_dataMode & SPI_MODE1) ? 1 : 0));
    cmdLine.serial().printf("\r\n %%SD -- SPI diagnostic messages ");
    if (g_MAX11043_device.onSPIprint) {
        cmdLine.serial().printf("hide");
    }
    else {
        cmdLine.serial().printf("show");
    }
    cmdLine.serial().printf("\r\n %%SW mosi,mosi,...mosi -- SPI write hex bytes");
    // VERIFY: parse new SPI settings parse_strCommandArgs() SCLK=1000000 CPOL=0 CPHA=0
#endif // SUPPORT_SPI
       //
       // Application-specific commands (help text) here
       //
#if APPLICATION_ArduinoPinsMonitor
    cmdLine.serial().printf("\r\n A-Z,a-z,0-9 -- reserved for application use");     // ArduinoPinsMonitor
#endif // APPLICATION_ArduinoPinsMonitor
       //

    extern bool MAX11043_menu_help(CmdLine & cmdLine); // defined in Test_Menu_MAX11043.cpp\n
    MAX11043_menu_help(cmdLine);
}



//--------------------------------------------------
// main menu command-line parser
// invoked by CmdLine::append(char ch) or CmdLine::idleAppendIfReadable()
void main_menu_onEOLcommandParser(CmdLine & cmdLine)
{
    // DIAGNOSTIC: print line buffer
    //~ cmdLine.serial().printf("\r\nmain_menu_onEOLcommandParser: ~%s~\r\n", cmdLine.str());
    //
    switch (cmdLine[0])
    {
        case '?':
            main_menu_status(cmdLine);
            main_menu_help(cmdLine);
            // print command prompt
            //cmdLine.serial().printf("\r\n>");
            break;
        case '\r': case '\n':     // ignore blank line
        case '\0':     // ignore empty line
        case '#':     // ignore comment line
            // # -- lines beginning with # are comments
            main_menu_status(cmdLine);
            //~ main_menu_help(cmdLine);
            // print command prompt
            //cmdLine.serial().printf("\r\n>");
            break;
#if ECHO_EOF_ON_EOL
        case '\x04':     // Unicode (U+0004) EOT END OF TRANSMISSION = CTRL+D as EOF end of file
            cmdLine.serial().printf("\x04");     // immediately echo EOF for test scripting
            diagnostic_led_EOF();
            break;
        case '\x1a':     // Unicode (U+001A) SUB SUBSTITUTE = CTRL+Z as EOF end of file
            cmdLine.serial().printf("\x1a");     // immediately echo EOF for test scripting
            diagnostic_led_EOF();
            break;
#endif
#if APPLICATION_ArduinoPinsMonitor
        case '.':
        {
            // . -- SelfTest
            cmdLine.serial().printf("SelfTest()");
            SelfTest(cmdLine);
        }
        break;
        case '%':
        {
            pinsMonitor_submenu_onEOLcommandParser(cmdLine);
        }
        break;         // case '%'
#endif // APPLICATION_ArduinoPinsMonitor
       //
       // Application-specific commands here
       // alphanumeric command codes A-Z,a-z,0-9 reserved for application use
       //
#if APPLICATION_ArduinoPinsMonitor
#endif // APPLICATION_ArduinoPinsMonitor

        //
        // add new commands here
        //
        default:
            extern bool MAX11043_menu_onEOLcommandParser(CmdLine & cmdLine); // defined in Test_Menu_MAX11043.cpp
            if (!MAX11043_menu_onEOLcommandParser(cmdLine))
            { // not_handled_by_device_submenu
                cmdLine.serial().printf("\r\n unknown command 0x%2.2x \"%s\"\r\n", cmdLine.str()[0], cmdLine.str());

# if HAS_DAPLINK_SERIAL
                cmdLine_DAPLINKserial.serial().printf("\r\n unknown command 0x%2.2x \"%s\"\r\n", cmdLine.str()[0], cmdLine.str());

# endif // HAS_DAPLINK_SERIAL
            }
    }     // switch (cmdLine[0])
//
// print command prompt
    cmdLine.serial().printf("\r\nMAX11043 > ");

} // end void main_menu_onEOLcommandParser(CmdLine & cmdLine)

//--------------------------------------------------
#if MAX11043_ONSPIPRINT
// Optional Diagnostic function to print SPI transactions
void onSPIprint_handler(size_t byteCount, uint8_t mosiData[], uint8_t misoData[])
{
    cmdLine_serial.serial().printf("\r\nSPI MOSI->");
    for (uint8_t index = 0; index < byteCount; index++) {
        cmdLine_serial.serial().printf(" 0x%2.2X", mosiData[index]);
    }
    cmdLine_serial.serial().printf("  MISO<-");
    for (uint8_t index = 0; index < byteCount; index++) {
        cmdLine_serial.serial().printf(" 0x%2.2X", misoData[index]);
    }
    cmdLine_serial.serial().printf(" ");
}
#endif // MAX11043_ONSPIPRINT

//--------------------------------------------------
void InitializeConfiguration()
{
    // CODE GENERATOR: example code: member function Init
# if HAS_DAPLINK_SERIAL
    cmdLine_DAPLINKserial.serial().printf("\r\nMAX11043_Init()");

# endif
    cmdLine_serial.serial().printf("\r\nMAX11043_Init()");

    // Initialize MAX11043 and verify device ID
    if (g_MAX11043_device.Init() == 0)
    {  // init failed; try "safe mode" SPI at slower SCLK rate
        cmdLine_serial.serial().printf("\r\nMAX11043 Init failed; retry at SPI SCLK frequency 2000000 Hz\r\n");

        g_SPI_SCLK_Hz = 2000000;
        g_MAX11043_device.spi_frequency(2000000);
        g_MAX11043_device.Init();
    }
    // CODE GENERATOR: get spi properties from device
    if (g_SPI_SCLK_Hz > g_MAX11043_device.get_spi_frequency())
    {  // Device limits SPI SCLK frequency
        g_SPI_SCLK_Hz = g_MAX11043_device.get_spi_frequency();
        cmdLine_serial.serial().printf("\r\nMAX11043 limits SPI SCLK frequency to %d Hz\r\n", g_SPI_SCLK_Hz);

        g_MAX11043_device.Init();
    }
    if (g_MAX11043_device.get_spi_frequency() > g_SPI_SCLK_Hz)
    {  // Platform limits SPI SCLK frequency
        g_MAX11043_device.spi_frequency(g_SPI_SCLK_Hz);
        cmdLine_serial.serial().printf("\r\nPlatform limits MAX11043 SPI SCLK frequency to %d Hz\r\n", g_SPI_SCLK_Hz);

        g_MAX11043_device.Init();
    }
    g_SPI_dataMode = g_MAX11043_device.get_spi_dataMode();

# if MAX11043_ONSPIPRINT
  // Optional Diagnostic function to print SPI transactions
  g_MAX11043_device.onSPIprint = onSPIprint_handler;
# endif
}

//--------------------------------------------------
// diagnostic rbg led GREEN
void diagnostic_led_EOF()
{
#if USE_LEDS
    led1 = LED_ON; led2 = LED_ON; led3 = LED_OFF;     // diagnostic rbg led RED+GREEN=YELLOW
    // TODO1: mbed-os-5.11: [Warning] 'static osStatus rtos::Thread::wait(uint32_t)' is deprecated: Static methods only affecting current thread cause confusion. Replaced by ThisThread::sleep_for. [since mbed-os-5.10] [-Wdeprecated-declarations]
    ThisThread::sleep_for(250); // [since mbed-os-5.10] vs Thread::wait(250);
    led1 = LED_OFF; led2 = LED_ON; led3 = LED_OFF;     // diagnostic rbg led GREEN
    ThisThread::sleep_for(250); // [since mbed-os-5.10] vs Thread::wait(250);
    led1 = LED_ON; led2 = LED_ON; led3 = LED_OFF;     // diagnostic rbg led RED+GREEN=YELLOW
    ThisThread::sleep_for(250); // [since mbed-os-5.10] vs Thread::wait(250);
    led1 = LED_OFF; led2 = LED_ON; led3 = LED_OFF;     // diagnostic rbg led GREEN
    ThisThread::sleep_for(250); // [since mbed-os-5.10] vs Thread::wait(250);
#endif // USE_LEDS
}

//--------------------------------------------------
// Support commands that get handled immediately w/o waiting for EOL
// handled as immediate command, do not append to buffer
void on_immediate_0x21() // Unicode (U+0021) ! EXCLAMATION MARK
{
#if USE_LEDS
    led1 = LED_OFF; led2 = LED_OFF; led3 = LED_ON;     // diagnostic rbg led BLUE
#endif // USE_LEDS
    InitializeConfiguration();
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
}

//--------------------------------------------------
// Support commands that get handled immediately w/o waiting for EOL
// handled as immediate command, do not append to buffer
void on_immediate_0x7b() // Unicode (U+007B) { LEFT CURLY BRACKET
{
#if HAS_BUTTON2_DEMO_INTERRUPT
    onButton2FallingEdge();
#endif
}

//--------------------------------------------------
// Support commands that get handled immediately w/o waiting for EOL
// handled as immediate command, do not append to buffer
void on_immediate_0x7d() // Unicode (U+007D) } RIGHT CURLY BRACKET
{
#if HAS_BUTTON1_DEMO_INTERRUPT
    onButton1FallingEdge();
#endif
}

//----------------------------------------
// example code main function
int main()
{
    // Configure serial ports
    cmdLine_serial.clear();
    //~ cmdLine_serial.serial().printf("\r\n cmdLine_serial.serial().printf test\r\n");
    cmdLine_serial.onEOLcommandParser = main_menu_onEOLcommandParser;
    cmdLine_serial.diagnostic_led_EOF = diagnostic_led_EOF;
    /// CmdLine::set_immediate_handler(char, functionPointer_void_void_on_immediate_0x21);
    cmdLine_serial.on_immediate_0x21 = on_immediate_0x21;
    cmdLine_serial.on_immediate_0x7b = on_immediate_0x7b;
    cmdLine_serial.on_immediate_0x7d = on_immediate_0x7d;
# if HAS_DAPLINK_SERIAL
    cmdLine_DAPLINKserial.clear();
    //~ cmdLine_DAPLINKserial.serial().printf("\r\n cmdLine_DAPLINKserial.serial().printf test\r\n");
    cmdLine_DAPLINKserial.onEOLcommandParser = main_menu_onEOLcommandParser;
    /// @todo CmdLine::set_immediate_handler(char, functionPointer_void_void_on_immediate_0x21);
    cmdLine_DAPLINKserial.on_immediate_0x21 = on_immediate_0x21;
    cmdLine_DAPLINKserial.on_immediate_0x7b = on_immediate_0x7b;
    cmdLine_DAPLINKserial.on_immediate_0x7d = on_immediate_0x7d;
# endif


    //print_banner();



#if USE_LEDS
#if defined(TARGET_MAX32630)
    led1 = LED_ON; led2 = LED_OFF; led3 = LED_OFF;     // diagnostic rbg led RED
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_OFF; led2 = LED_ON; led3 = LED_OFF;     // diagnostic rbg led GREEN
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_OFF; led2 = LED_OFF; led3 = LED_ON;     // diagnostic rbg led BLUE
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_ON; led2 = LED_ON; led3 = LED_ON;     // diagnostic rbg led RED+GREEN+BLUE=WHITE
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_OFF; led2 = LED_ON; led3 = LED_ON;     // diagnostic rbg led GREEN+BLUE=CYAN
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_ON; led2 = LED_OFF; led3 = LED_ON;     // diagnostic rbg led RED+BLUE=MAGENTA
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_ON; led2 = LED_ON; led3 = LED_OFF;     // diagnostic rbg led RED+GREEN=YELLOW
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_OFF; led2 = LED_OFF; led3 = LED_OFF;     // diagnostic rbg led BLACK
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
#elif defined(TARGET_MAX32625MBED)
    led1 = LED_ON; led2 = LED_OFF; led3 = LED_OFF;     // diagnostic rbg led RED
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_OFF; led2 = LED_ON; led3 = LED_OFF;     // diagnostic rbg led GREEN
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_OFF; led2 = LED_OFF; led3 = LED_ON;     // diagnostic rbg led BLUE
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_ON; led2 = LED_ON; led3 = LED_ON;     // diagnostic rbg led RED+GREEN+BLUE=WHITE
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_OFF; led2 = LED_ON; led3 = LED_ON;     // diagnostic rbg led GREEN+BLUE=CYAN
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_ON; led2 = LED_OFF; led3 = LED_ON;     // diagnostic rbg led RED+BLUE=MAGENTA
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_ON; led2 = LED_ON; led3 = LED_OFF;     // diagnostic rbg led RED+GREEN=YELLOW
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_OFF; led2 = LED_OFF; led3 = LED_OFF;     // diagnostic rbg led BLACK
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
#else // not defined(TARGET_LPC1768 etc.)
    led1 = LED_ON;
    led2 = LED_OFF;
    led3 = LED_OFF;
    led4 = LED_OFF;
    ThisThread::sleep_for(75); // [since mbed-os-5.10] vs Thread::wait(75);
    //led1 = LED_ON;
    led2 = LED_ON;
    ThisThread::sleep_for(75); // [since mbed-os-5.10] vs Thread::wait(75);
    led1 = LED_OFF;
    //led2 = LED_ON;
    led3 = LED_ON;
    ThisThread::sleep_for(75); // [since mbed-os-5.10] vs Thread::wait(75);
    led2 = LED_OFF;
    //led3 = LED_ON;
    led4 = LED_ON;
    ThisThread::sleep_for(75); // [since mbed-os-5.10] vs Thread::wait(75);
    led3 = LED_OFF;
    led4 = LED_ON;
    //
#endif // target definition
#endif

    // cmd_TE();

// #if USE_LEDS
//     rgb_led.white();     // diagnostic rbg led RED+GREEN+BLUE=WHITE
// #endif // USE_LEDS
    led1 = LED_ON;
    led2 = LED_ON;
    led3 = LED_ON;

    InitializeConfiguration();
    // CODE GENERATOR: example code: member function Init
    g_MAX11043_device.Init();

        // example code: serial port banner message
    #if defined(TARGET_MAX32625MBED)
        serial.printf("MAX32625MBED ");
    #elif defined(TARGET_MAX32600MBED)
        serial.printf("MAX32600MBED ");
    #elif defined(TARGET_NUCLEO_F446RE)
        serial.printf("NUCLEO_F446RE ");
    #endif
        serial.printf("MAX11043BOB\r\n");


    while (1) {
#if HAS_BUTTON1_DEMO_INTERRUPT_POLLING
        // avoid runtime error on button1 press [mbed-os-5.11]
        // instead of using InterruptIn, use DigitalIn and poll in main while(1)
# if HAS_BUTTON1_DEMO_INTERRUPT
        static int button1_value_prev = 1;
        static int button1_value_now = 1;
        button1_value_prev = button1_value_now;
        button1_value_now = button1.read();
        if ((button1_value_prev - button1_value_now) == 1)
        {
            // on button1 falling edge (button1 press)
            onButton1FallingEdge();
        }
# endif // HAS_BUTTON1_DEMO_INTERRUPT
# if HAS_BUTTON2_DEMO_INTERRUPT
        static int button2_value_prev = 1;
        static int button2_value_now = 1;
        button2_value_prev = button2_value_now;
        button2_value_now = button2.read();
        if ((button2_value_prev - button2_value_now) == 1)
        {
            // on button2 falling edge (button2 press)
            onButton2FallingEdge();
        }
# endif // HAS_BUTTON2_DEMO_INTERRUPT
#endif
    # if HAS_DAPLINK_SERIAL
        if (DAPLINKserial.readable()) {
            cmdLine_DAPLINKserial.append(DAPLINKserial.getc());
        }
    # endif // HAS_DAPLINK_SERIAL
        if (serial.readable()) {
            int c = serial.getc();
            cmdLine_serial.append(c);
#if IGNORE_AT_COMMANDS
# if HAS_DAPLINK_SERIAL
            cmdLine_DAPLINKserial.serial().printf("%c", c);
# endif // HAS_DAPLINK_SERIAL
#endif // IGNORE_AT_COMMANDS
            //
        }
    }     // while(1)
}
//---------- CODE GENERATOR: end testMainCppCodeList
