// /*******************************************************************************
// * Copyright (C) 2020 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
// *********************************************************************
// @file MAX11043.cpp
// *********************************************************************
// Device Driver file
// DO NOT EDIT; except areas designated "CUSTOMIZE". Automatically generated file. * MANUAL EDITS PRESENT *
// generated by XMLSystemOfDevicesToMBED.py
// System Name = ExampleSystem
// System Description = Device driver example

#include "MAX11043.h"
//--------------------------------------------------
// MAX11043 ADC Read operations must be synchronized to EOC End Of Conversion
// EOC# asserts low when new data is available.
// Initiate a data read prior to the next rising edge of EOC# or the result is overwritten.
#ifndef MAX11043_EOC_INTERRUPT_POLLING
#define MAX11043_EOC_INTERRUPT_POLLING 1
#endif // MAX11043_EOC_INTERRUPT_POLLING
//--------------------------------------------------
// SPI is not interrupt-safe, so use EventQueue to defer execution to user context.
#ifndef MAX11043_EOC_INTERRUPT_EVENTQUEUE
#define MAX11043_EOC_INTERRUPT_EVENTQUEUE 0
#endif // MAX11043_EOC_INTERRUPT_EVENTQUEUE
#if MAX11043_EOC_INTERRUPT_EVENTQUEUE
#else // MAX11043_EOC_INTERRUPT_EVENTQUEUE
#endif // MAX11043_EOC_INTERRUPT_EVENTQUEUE
#if MAX11043_EOC_INTERRUPT_EVENTQUEUE
// SPI is not interrupt-safe, so use EventQueue to defer execution to user context.
#include "mbed_events.h"
#define MYONEOCTHREADEVENTFLAG_ENABLE_SPI (1UL << 0)
EventFlags myOnEOCThread_event_flags;
Thread myOnEOCThread;
#if MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 myOnEOCThread_POLLING_handler needs 18.80us, still too slow
extern DigitalInOut digitalInOut2; // m_EOC_pin declared in Test_Main_MAX11043.cpp
extern void myOnEOCThread_POLLING_handler();
#else // MAX11043_EOC_INTERRUPT_POLLING
extern void myOnEOCThread_EVENTFLAG_ENABLE_SPI_handler();
#endif // MAX11043_EOC_INTERRUPT_POLLING
#else // MAX11043_EOC_INTERRUPT_EVENTQUEUE
#endif // MAX11043_EOC_INTERRUPT_EVENTQUEUE
//--------------------------------------------------
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
#ifndef MAX11043_ScopeTrigger_MAX32625MBED_D5
#define MAX11043_ScopeTrigger_MAX32625MBED_D5 1
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
// WIP MAX11043 interrupt EOC echo - moving DigitalOut ScopeTrigger to global scope, it compiles but there is no activity on scope
extern DigitalInOut digitalInOut5; // declared in Test_Main_MAX11043.cpp (D5, PIN_INPUT, PullUp, 1) 
const size_t byteCount_onEOCFallingEdge = 1 + (2 * 4);
const uint8_t mosiData_onEOCFallingEdge[9] = {
    MAX11043::CMD_0001_1010_d16o8_d16o8_d16o8_d16o8_Rd06_ADCabcd,
    0, 0, 0, 0, 0, 0, 0, 0
};
uint8_t misoData_onEOCFallingEdge[9];
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5

// Device Name = MAX11043
// Device Description = 200ksps, Low-Power, Serial SPI 24-Bit, 4-Channel, Differential/Single-Ended Input, Simultaneous-Sampling SD ADC
// Device DeviceBriefDescription = 24-bit 200ksps Delta-Sigma ADC
// Device Manufacturer = Maxim Integrated
// Device PartNumber = MAX11043ATL+
// Device RegValue_Width = DataWidth16bit_HL
//
// ADC MaxOutputDataRate = 200ksps
// ADC NumChannels = 4
// ADC ResolutionBits = 24
//
// SPI CS = ActiveLow
// SPI FrameStart = CS
// SPI CPOL = 0
// SPI CPHA = 0
// SPI MOSI and MISO Data are both stable on Rising edge of SCLK
// SPI SCLK Idle Low
// SPI SCLKMaxMHz = 40
// SPI SCLKMinMHz = 0
//
// InputPin Name = CONVRUN
// InputPin Description = CONVRUN (digital input). Convert Run. Drive high to start continuous conversions on all 4 channels. The device is idle when
// CONVRUN is low.
// InputPin Function = Configuration
//
// InputPin Name = SHDN
// InputPin Description = Shutdown (digital input). Active-High Shutdown Input. Drive high to shut down the MAX11043.
// InputPin Function = Configuration
//
// InputPin Name = DACSTEP
// InputPin Description = DACSTEP (digital input). DAC Step Input. Drive high to move the DAC output in the direction of UP/DWN on the next rising
// edge of the system clock.
// InputPin Function = Configuration
//
// InputPin Name = UP/DWN#
// InputPin Description = UP/DWN# (digital input). DAC Step Direction Select. Drive high to step up, drive low to step down when DACSTEP is toggled.
// InputPin Function = Configuration
//
// OutputPin Name = EOC
// OutputPin Description = End of Conversion Output. Active-Low End-of-Conversion Indicator. EOC asserts low to indicate that new data is ready.
// OutputPin Function = Event
//
// SupplyPin Name = AVDD
// SupplyPin Description = Analog Power-Supply Input. Bypass each AVDD with a nominal 1uF capacitor to AGND.
// SupplyPin VinMax = 3.60
// SupplyPin VinMin = 3.00
// SupplyPin Function = Analog
//
// SupplyPin Name = AGND
// SupplyPin Description = Analog Ground. Connect all AGND inputs together.
// SupplyPin VinMax = 0
// SupplyPin VinMin = 0
// SupplyPin Function = Analog
//
// SupplyPin Name = DGND
// SupplyPin Description = Digital Ground. Connect all DGND inputs together.
// SupplyPin VinMax = 0
// SupplyPin VinMin = 0
// SupplyPin Function = Digital
//
// SupplyPin Name = DVDD
// SupplyPin Description = Digital Power-Supply Input. Bypass each DVDD with a nominal 1uF capacitor to DGND.
// SupplyPin VinMax = 3.60
// SupplyPin VinMin = 3.00
// SupplyPin Function = Digital
//
// SupplyPin Name = DVREG
// SupplyPin Description = Regulated Digital Core Supply (from internal +2.5V regulator). Bypass DVREG to DGND with a 10uF capacitor.
// SupplyPin VinMax = 2.50
// SupplyPin VinMin = 2.50
// SupplyPin Function = Digital
//

// CODE GENERATOR: class constructor definition
MAX11043::MAX11043(SPI &spi, DigitalOut &cs_pin, // SPI interface
                 // CODE GENERATOR: class constructor definition gpio InputPin pins
                 DigitalOut &CONVRUN_pin, // Digital Configuration Input to MAX11043 device
                 DigitalOut &SHDN_pin, // Digital Configuration Input to MAX11043 device
                 DigitalOut &DACSTEP_pin, // Digital Configuration Input to MAX11043 device
                 DigitalOut &UP_slash_DWNb_pin, // Digital Configuration Input to MAX11043 device
                 // CODE GENERATOR: class constructor definition gpio OutputPin pins
// MAX11043 ADC Read operations must be synchronized to EOC End Of Conversion
#if MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input should be InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
// Workaround using DigitalIn(PinName:EOC_pin) polled to sync with EOC falling edge for ADC reads
// TODO: onEOCFallingEdge: replace DigitalIn &EOC_pin with PinName EOC_pin, so that I can create an InterruptIn(PinName:EOC_pin)
                 DigitalIn &EOC_pin, // Digital Event Output from MAX11043 device
#else // MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input is InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
// TODO: onEOCFallingEdge: replace DigitalIn &EOC_pin with PinName EOC_pin, so that I can create an InterruptIn(PinName:EOC_pin)
                 InterruptIn &EOC_pin, // Digital Event Output from MAX11043 device
#endif // MAX11043_EOC_INTERRUPT_POLLING
                 // CODE GENERATOR: class constructor definition ic_variant
                 MAX11043_ic_t ic_variant)
    // CODE GENERATOR: class constructor initializer list
    : m_spi(spi), m_cs_pin(cs_pin), // SPI interface
    // CODE GENERATOR: class constructor initializer list gpio InputPin pins
    m_CONVRUN_pin(CONVRUN_pin), // Digital Configuration Input to MAX11043 device
    m_SHDN_pin(SHDN_pin), // Digital Configuration Input to MAX11043 device
    m_DACSTEP_pin(DACSTEP_pin), // Digital Configuration Input to MAX11043 device
    m_UP_slash_DWNb_pin(UP_slash_DWNb_pin), // Digital Configuration Input to MAX11043 device
    // CODE GENERATOR: class constructor initializer list gpio OutputPin pins
// MAX11043 ADC Read operations must be synchronized to EOC End Of Conversion
#if MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input should be InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
// Workaround using DigitalIn(PinName:EOC_pin) polled to sync with EOC falling edge for ADC reads
    m_EOC_pin(EOC_pin), // Digital Event Output from MAX11043 device
#else // MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input is InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
    m_EOC_pin(EOC_pin), // Digital Event Output from MAX11043 device
#endif // MAX11043_EOC_INTERRUPT_POLLING
    // CODE GENERATOR: class constructor initializer list ic_variant
    m_ic_variant(ic_variant)
{
    // CODE GENERATOR: class constructor definition SPI interface initialization
    //
    // SPI CS = ActiveLow
    // SPI FrameStart = CS
    m_SPI_cs_state = 1;
    if (m_cs_pin.is_connected()) { // avoid mbed runtime error if pin is NC not connected
        m_cs_pin = m_SPI_cs_state;
    }

    // SPI CPOL = 0
    // SPI CPHA = 0
    // SPI MOSI and MISO Data are both stable on Rising edge of SCLK
    // SPI SCLK Idle Low
    m_SPI_dataMode = 0; //SPI_MODE0; // CPOL=0,CPHA=0: Rising Edge stable; SCLK idle Low
    m_spi.format(8,m_SPI_dataMode);         // int bits_must_be_8, int mode=0_3 CPOL=0,CPHA=0

    // SPI SCLKMaxMHz = 40
    // SPI SCLKMinMHz = 0
    //#define SPI_SCLK_Hz 48000000 // 48MHz
    //#define SPI_SCLK_Hz 24000000 // 24MHz
    //#define SPI_SCLK_Hz 12000000 // 12MHz
    //#define SPI_SCLK_Hz 6000000 // 6MHz
    //#define SPI_SCLK_Hz 4000000 // 4MHz
    //#define SPI_SCLK_Hz 2000000 // 2MHz
    //#define SPI_SCLK_Hz 1000000 // 1MHz
    m_SPI_SCLK_Hz = 24000000; // platform limit 24MHz; MAX11043 limit is 40MHz
    m_spi.frequency(m_SPI_SCLK_Hz);

    //
    // CODE GENERATOR: class constructor definition gpio InputPin (Input to device) initialization
    //
    // CONVRUN Configuration Input to MAX11043 device
    m_CONVRUN_pin = 1; // output logic high -- initial value in constructor
    //
    // SHDN Configuration Input to MAX11043 device
    m_SHDN_pin = 1; // output logic high -- initial value in constructor
    //
    // DACSTEP Configuration Input to MAX11043 device
    m_DACSTEP_pin = 1; // output logic high -- initial value in constructor
    //
    // UP_slash_DWNb Configuration Input to MAX11043 device
    m_UP_slash_DWNb_pin = 1; // output logic high -- initial value in constructor
    //
    // CODE GENERATOR: class constructor definition gpio OutputPin (Output from MAX11043 device) initialization
    //
    // EOC Event Output from device
// MAX11043 ADC Read operations must be synchronized to EOC End Of Conversion
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
    digitalInOut5.output(); // ScopeTrigger
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
#if MAX11043_EOC_INTERRUPT_EVENTQUEUE
    // SPI is not interrupt-safe, so use EventQueue to defer execution to user context.
#if MAX11043_EOC_INTERRUPT_POLLING
    myOnEOCThread.start(myOnEOCThread_POLLING_handler);
#else // MAX11043_EOC_INTERRUPT_POLLING
    myOnEOCThread.start(myOnEOCThread_EVENTFLAG_ENABLE_SPI_handler);
#endif // MAX11043_EOC_INTERRUPT_POLLING
#else // MAX11043_EOC_INTERRUPT_EVENTQUEUE
#endif // MAX11043_EOC_INTERRUPT_EVENTQUEUE
// MAX11043 ADC Read operations must be synchronized to EOC End Of Conversion
#if MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input should be InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
// Workaround using DigitalIn(PinName:EOC_pin) polled to sync with EOC falling edge for ADC reads
#else // MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input is InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
    // TODO: onEOCFallingEdge: interrupt handler requires global object extern MAX11043 g_MAX11043_device
    // InterruptIn interruptEOC(EOC_pin); // InterruptIn constructor requires PinName, not DigitalIn -- Error: No instance of constructor "mbed::InterruptIn::InterruptIn"  matches the argument list in "MAX11043/MAX11043.cpp", Line: 187, Col: 31
    // TODO: onEOCFallingEdge: replace DigitalIn &EOC_pin with PinName EOC_pin, so that I can create an InterruptIn(PinName:EOC_pin)
    extern void onEOCFallingEdge(void);
    // interruptEOC.fall(&onEOCFallingEdge);
    EOC_pin.fall(&onEOCFallingEdge);
#endif // MAX11043_EOC_INTERRUPT_POLLING
}

// MAX11043 ADC Read operations must be synchronized to EOC End Of Conversion
// SPI is not interrupt-safe, so use EventQueue to defer execution to user context.
#if MAX11043_EOC_INTERRUPT_EVENTQUEUE
#if MAX11043_EOC_INTERRUPT_POLLING
void myOnEOCThread_POLLING_handler()
{
    while (true) {
// MAX11043 EOC End Of Conversion input should be InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
// Workaround using DigitalIn(PinName:EOC_pin) polled to sync with EOC falling edge for ADC reads
        // poll m_EOC_pin if CONVRUN is high
        //if (m_CONVRUN_pin)
        //{
            //#warning "myOnEOCThread_handler() Potential infinite loop if EOC pin not connected"
            // possible infinite loop; need a timeout or futility countdown to escape
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
        //~ digitalInOut5.write(0); // ScopeTrigger low -- waiting for EOC# high
        //~ digitalInOut5.write(1); // ScopeTrigger
        //~ digitalInOut5.write(0); // ScopeTrigger
        //~ digitalInOut5.write(1); // ScopeTrigger
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
            //for (int futility_countdown = 100;
            //    ((futility_countdown > 0) &&
            //    (m_EOC_pin != 1));
            //    futility_countdown--)
            //while (digitalInOut2.read() != 1) // digitalInOut2 m_EOC_pin
            //{
            //    // spinlock waiting for logic high pin state (start of new conversion)
            //}
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
        //~ digitalInOut5.write(0); // ScopeTrigger
        //~ digitalInOut5.write(1); // ScopeTrigger high -- waiting for EOC# falling edge
        //~ digitalInOut5.write(0); // ScopeTrigger
        //~ digitalInOut5.write(1); // ScopeTrigger
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
            //for (int futility_countdown = 100;
            //    ((futility_countdown > 0) &&
            //    (m_EOC_pin != 0));
            //    futility_countdown--)
            while (digitalInOut2.read() != 0) // digitalInOut2 m_EOC_pin
            {
                // spinlock waiting for logic low pin state (new data is available)
            }
        //}
        //else
        //{
        //    // CONVRUN pin is being driven low, so conversion result will not change, EOC# remains high
        //    continue;
        //}
        //
        //extern MAX11043 g_MAX11043_device;
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
        //~ digitalInOut5.write(0); // ScopeTrigger low -- EOC# falling edge detected, about to start SPI
        //~ digitalInOut5.write(1); // ScopeTrigger
        //~ digitalInOut5.write(0); // ScopeTrigger
        //~ digitalInOut5.write(1); // ScopeTrigger
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
        extern SPI spi; // declared in Test_Main_MAX11043.cpp
        spi.write((char*)mosiData_onEOCFallingEdge, byteCount_onEOCFallingEdge, (char*)misoData_onEOCFallingEdge, byteCount_onEOCFallingEdge);
        // Note: EOC# is high immediately after SPI read ADCabcd
        // SPI timing: CS low 13.30us after EOC# falling edge
        // SPI timing: SCLK first 14.60us after EOC# falling edge
        // SPI timing: SCLK last 17.70us after EOC# falling edge
        // SPI timing: CS high 17.70us after EOC# falling edge
        //
        // TODO1: update adca
        //g_MAX11043_device.adca = (misoData_onEOCFallingEdge[1] << 8) | misoData_onEOCFallingEdge[2];
        // TODO1: update adcb
        //g_MAX11043_device.adcb = (misoData_onEOCFallingEdge[3] << 8) | misoData_onEOCFallingEdge[4];
        // TODO1: update adcc
        //g_MAX11043_device.adcc = (misoData_onEOCFallingEdge[5] << 8) | misoData_onEOCFallingEdge[6];
        // TODO1: update adcd
        //g_MAX11043_device.adcd = (misoData_onEOCFallingEdge[7] << 8) | misoData_onEOCFallingEdge[8];
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
        //~ digitalInOut5.write(0); // ScopeTrigger
        //~ digitalInOut5.write(1); // ScopeTrigger high -- end of while loop
        //~ digitalInOut5.write(0); // ScopeTrigger
        //~ digitalInOut5.write(1); // ScopeTrigger
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
    } // while (true)
} // myOnEOCThread_POLLING_handler()
#else // MAX11043_EOC_INTERRUPT_POLLING
// Waiting for EOC# fall to signal EventQueue is too slow, ~25us to handle event but events happen every 9us.
void myOnEOCThread_EVENTFLAG_ENABLE_SPI_handler()
{
    while (true) {
// MAX11043 EOC End Of Conversion input is InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
// Interrupt Handler: EOC Event Output from device
        // Wait for MYONEOCTHREADEVENTFLAG_ENABLE_SPI event sent from onEOCFallingEdge interrupt
        //signal_wait(int32_t signals, uint32_t millisec=osWaitForever)
        //flags_read = myOnEOCThread_event_flags.wait_any(MYONEOCTHREADEVENTFLAG_ENABLE_SPI);
        // myOnEOCThread_event_flags.wait_any(MYONEOCTHREADEVENTFLAG_ENABLE_SPI, osWaitForever, false); // clear=false: don't auto clear the flag
        myOnEOCThread_event_flags.wait_any(MYONEOCTHREADEVENTFLAG_ENABLE_SPI, osWaitForever, true); // clear=true: auto clear the flag
        //
        //extern MAX11043 g_MAX11043_device;
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
        digitalInOut5.write(0); // ScopeTrigger happens at 1.8us after EOC# falling edge
        digitalInOut5.write(1); // ScopeTrigger
        digitalInOut5.write(0); // ScopeTrigger
        digitalInOut5.write(1); // ScopeTrigger
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
        extern SPI spi; // declared in Test_Main_MAX11043.cpp
        spi.write((char*)mosiData_onEOCFallingEdge, byteCount_onEOCFallingEdge, (char*)misoData_onEOCFallingEdge, byteCount_onEOCFallingEdge);
        // SPI timing: CS low 13.30us after EOC# falling edge
        // SPI timing: SCLK first 14.60us after EOC# falling edge
        // SPI timing: SCLK last 17.70us after EOC# falling edge
        // SPI timing: CS high 17.70us after EOC# falling edge
        //
        // TODO1: update adca
        //g_MAX11043_device.adca = (misoData_onEOCFallingEdge[1] << 8) | misoData_onEOCFallingEdge[2];
        // TODO1: update adcb
        //g_MAX11043_device.adcb = (misoData_onEOCFallingEdge[3] << 8) | misoData_onEOCFallingEdge[4];
        // TODO1: update adcc
        //g_MAX11043_device.adcc = (misoData_onEOCFallingEdge[5] << 8) | misoData_onEOCFallingEdge[6];
        // TODO1: update adcd
        //g_MAX11043_device.adcd = (misoData_onEOCFallingEdge[7] << 8) | misoData_onEOCFallingEdge[8];
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
        digitalInOut5.write(0); // ScopeTrigger happens at 22.5us after EOC# falling edge
        digitalInOut5.write(1); // ScopeTrigger
        digitalInOut5.write(0); // ScopeTrigger
        digitalInOut5.write(1); // ScopeTrigger
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
    } // while (true)
} // myOnEOCThread_EVENTFLAG_ENABLE_SPI_handler()
#endif // MAX11043_EOC_INTERRUPT_POLLING
#endif // MAX11043_EOC_INTERRUPT_EVENTQUEUE

// MAX11043 ADC Read operations must be synchronized to EOC End Of Conversion
#if MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input should be InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
// Workaround using DigitalIn(PinName:EOC_pin) polled to sync with EOC falling edge for ADC reads
#else // MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input is InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
// Interrupt Handler: EOC Event Output from device
void onEOCFallingEdge(void)
{
    // VERIFIED: if DO NOTHING inside interrupt service routine, no crash
#if 1
    // VERIFIED: GPIO PIN pulse in response to EOC# falling edge, no crash on HH, no missed pulses
#if MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
    digitalInOut5.write(0); // ScopeTrigger 1.8us after EOC# falling edge
    digitalInOut5.write(1); // ScopeTrigger
    digitalInOut5.write(0); // ScopeTrigger
    digitalInOut5.write(1); // ScopeTrigger
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
#endif
#if MAX11043_EOC_INTERRUPT_EVENTQUEUE
    // SPI is not interrupt-safe, so use EventQueue to defer execution to user context.
    myOnEOCThread_event_flags.set(MYONEOCTHREADEVENTFLAG_ENABLE_SPI);
#else // MAX11043_EOC_INTERRUPT_EVENTQUEUE
#endif // MAX11043_EOC_INTERRUPT_EVENTQUEUE
#if 0
    // TODO: read 4 channels in response to EOC# falling edge
    //     WIP MAX11043 interrupt CRASH on Menu item HH CONVRUN High
    //
    //     ++ MbedOS Error Info ++
    //     Error Status: 0x80020115 Code: 277 Module: 2
    //     Error Message: Mutex lock failed
    //     Location: 0xBA33
    //     Error Value: 0xFFFFFFFA
    //     Current Thread: main  Id: 0x20002CD0 Entry: 0xBD17 StackSize: 0x1000 StackMem: 0x20001CD0 SP: 0x20027ED0
    //     For more info, visit: https://armmbed.github.io/mbedos-error/?error=0x80020115
    //     -- MbedOS Error Info --
    extern MAX11043 g_MAX11043_device;
    //~ g_MAX11043_device.Read_ADCabcd();
    // read register ADCabcd -> &adca, &adcb, &adcc, &adcd
    // g_MAX11043_device.RegRead(CMD_0001_1010_d16o8_d16o8_d16o8_d16o8_Rd06_ADCabcd, 0);
    // SPI 8+64 = 72-bit transfer
    //            1234 5678 ___[1]_16 ___[2]_24 ___[3]_32 ___[4]_40 ___[5]_48 ___[6]_56 ___[7]_64 ___[8]_72
    // SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000 ... _0000
    // SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd ... _xxxx
    // global const size_t byteCount_onEOCFallingEdge = 1 + (2 * 4);
    // global const uint8_t mosiData_onEOCFallingEdge[9] = {
    // global     CMD_0001_1010_d16o8_d16o8_d16o8_d16o8_Rd06_ADCabcd,
    // global     0, 0, 0, 0, 0, 0, 0, 0
    // global };
    // global uint8_t misoData_onEOCFallingEdge[9];
    // SPIreadWriteWithLowCS(size_t byteCount, uint8_t mosiData[], uint8_t misoData[]);
    // SPIreadWriteWithLowCS(byteCount_onEOCFallingEdge, mosiData_onEOCFallingEdge, misoData_onEOCFallingEdge);
    // onSPIprint() is not interrupt-safe
    // unsigned int numBytesTransferred = m_spi.write((char*)mosiData, byteCount, (char*)misoData, byteCount);
    // g_MAX11043_device.m_spi is inaccessible
    extern SPI spi; // declared in Test_Main_MAX11043.cpp
    spi.write((char*)mosiData_onEOCFallingEdge, byteCount_onEOCFallingEdge, (char*)misoData_onEOCFallingEdge, byteCount_onEOCFallingEdge);
    // 
    // ++ MbedOS Error Info ++
    // Error Status: 0x80020115 Code: 277 Module: 2
    // Error Message: Mutex lock failed
    // Location: 0xBABB
    // Error Value: 0xFFFFFFFA
    // Current Thread: main  Id: 0x20002CD0 Entry: 0xBD9F StackSize: 0x1000 StackMem: 0x20001CD0 SP: 0x20027F10
    // For more info, visit: https://armmbed.github.io/mbedos-error/?error=0x80020115
    // -- MbedOS Error Info --
    // 
    //if (ptrRegData) { (*ptrRegData) = (misoData[1] << 8) | misoData[2]; }
    //if (commandByte == CMD_0001_1010_d16o8_d16o8_d16o8_d16o8_Rd06_ADCabcd) {
        // TODO1: update adca
        //g_MAX11043_device.adca = (misoData_onEOCFallingEdge[1] << 8) | misoData_onEOCFallingEdge[2];
        // TODO1: update adcb
        //g_MAX11043_device.adcb = (misoData_onEOCFallingEdge[3] << 8) | misoData_onEOCFallingEdge[4];
        // TODO1: update adcc
        //g_MAX11043_device.adcc = (misoData_onEOCFallingEdge[5] << 8) | misoData_onEOCFallingEdge[6];
        // TODO1: update adcd
        //g_MAX11043_device.adcd = (misoData_onEOCFallingEdge[7] << 8) | misoData_onEOCFallingEdge[8];
    //}
#endif
#if 0 // MAX11043_ScopeTrigger_MAX32625MBED_D5
// Diagnostic: Use MAX32625MBED pin D5 as DigitalOut EOC#-detected
    digitalInOut5.write(0); // ScopeTrigger
    digitalInOut5.write(1); // ScopeTrigger
#endif // MAX11043_ScopeTrigger_MAX32625MBED_D5
}
#endif // MAX11043_EOC_INTERRUPT_POLLING

// CODE GENERATOR: class destructor definition
MAX11043::~MAX11043()
{
    // do nothing
}

// CODE GENERATOR: spi_frequency setter definition
/// set SPI SCLK frequency
void MAX11043::spi_frequency(int spi_sclk_Hz)
{
    m_SPI_SCLK_Hz = spi_sclk_Hz;
    m_spi.frequency(m_SPI_SCLK_Hz);
}

// CODE GENERATOR: omit global g_MAX11043_device
// CODE GENERATOR: extern function declarations
// CODE GENERATOR: extern function requirement MAX11043::SPIoutputCS
// Assert SPI Chip Select
// SPI chip-select for MAX11043
//
inline void MAX11043::SPIoutputCS(int isLogicHigh)
{
    // CODE GENERATOR: extern function definition for function SPIoutputCS
    // CODE GENERATOR: extern function definition for standard SPI interface function SPIoutputCS(int isLogicHigh)
    m_SPI_cs_state = isLogicHigh;
    if (m_cs_pin.is_connected()) { // avoid mbed runtime error if pin is NC not connected
        m_cs_pin = m_SPI_cs_state;
    }
}

// CODE GENERATOR: extern function requirement MAX11043::SPIreadWriteWithLowCS
// SPI read and write arbitrary number of 8-bit bytes
// SPI interface to MAX11043 shift mosiData into MAX11043 DIN
// while simultaneously capturing miso data from MAX11043 DOUT
//
int MAX11043::SPIreadWriteWithLowCS(size_t byteCount, uint8_t mosiData[], uint8_t misoData[])
{
    // CODE GENERATOR: extern function definition for function SPIreadWriteWithLowCS
    // TODO1: CODE GENERATOR: extern function definition for standard SPI interface function SPIreadWriteWithLowCS(size_t byteCount, uint8_t mosiData[], uint8_t misoData[])
    //size_t byteCount = 4;
    //static char mosiData[4];
    //static char misoData[4];
    //
    // Arduino: begin critical section: noInterrupts() masks all interrupt sources; end critical section with interrupts()
    //~ noInterrupts();
    //
    //~ digitalWrite(Scope_Trigger_Pin, LOW); // diagnostic Scope_Trigger_Pin
    //
    if (m_cs_pin.is_connected()) { // avoid mbed runtime error if pin is NC not connected
        m_cs_pin = 0;
    }
    unsigned int numBytesTransferred = m_spi.write((char*)mosiData, byteCount, (char*)misoData, byteCount);
    if (m_cs_pin.is_connected()) { // avoid mbed runtime error if pin is NC not connected
        m_cs_pin = m_SPI_cs_state;
    }
    //
    //~ digitalWrite(Scope_Trigger_Pin, HIGH); // diagnostic Scope_Trigger_Pin
    //
    // Arduino: begin critical section: noInterrupts() masks all interrupt sources; end critical section with interrupts()
    //~ interrupts();
    // Optional Diagnostic function to print SPI transactions
    if (onSPIprint)
    {
        onSPIprint(byteCount, (uint8_t*)mosiData, (uint8_t*)misoData);
    }
    return numBytesTransferred;
}

// TODO1: CODE GENERATOR: extern function GPIOoutputSHDN alias SHDNoutputValue
// CODE GENERATOR: extern function requirement MAX11043::SHDNoutputValue
// Assert MAX11043 SHDN pin : High = Shut Down, Low = Normal Operation.
//
void MAX11043::SHDNoutputValue(int isLogicHigh)
{
    // CODE GENERATOR: extern function definition for function SHDNoutputValue
    // TODO1: CODE GENERATOR: extern function definition for gpio interface function SHDNoutputValue
    // TODO1: CODE GENERATOR: gpio pin SHDN assuming member function m_SHDN_pin
    // TODO1: CODE GENERATOR: gpio direction output
    // m_SHDN_pin.output(); // only applicable to DigitalInOut
    // TODO1: CODE GENERATOR: gpio function Value
    m_SHDN_pin = isLogicHigh;
}

// TODO1: CODE GENERATOR: extern function GPIOoutputCONVRUN alias CONVRUNoutputValue
// CODE GENERATOR: extern function requirement MAX11043::CONVRUNoutputValue
// Assert MAX11043 CONVRUN pin : High = start continuous conversions on all 4 channels, Low = Idle.
//
void MAX11043::CONVRUNoutputValue(int isLogicHigh)
{
    // CODE GENERATOR: extern function definition for function CONVRUNoutputValue
    // TODO1: CODE GENERATOR: extern function definition for gpio interface function CONVRUNoutputValue
    // TODO1: CODE GENERATOR: gpio pin CONVRUN assuming member function m_CONVRUN_pin
    // TODO1: CODE GENERATOR: gpio direction output
    // m_CONVRUN_pin.output(); // only applicable to DigitalInOut
    // TODO1: CODE GENERATOR: gpio function Value
    m_CONVRUN_pin = isLogicHigh;
//--------------------------------------------------
// MAX11043 ADC Read operations must be synchronized to EOC End Of Conversion
// EOC# asserts low when new data is available.
// Initiate a data read prior to the next rising edge of EOC# or the result is overwritten.
#if MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input should be InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
// Workaround using DigitalIn(PinName:EOC_pin) polled to sync with EOC falling edge for ADC reads
    if (m_CONVRUN_pin)
    {
        // CONVRUN was switched high, EOC# will now begin toggling
    }
    else
    {
        // CONVRUN was switched low, so wait until EOC# returns high
        #warning "MAX11043::Read_ADCabcd() Potential infinite loop if EOC pin not connected"
        // possible infinite loop; need a timeout or futility countdown to escape
        for (int futility_countdown = 100;
            ((futility_countdown > 0) &&
            (m_EOC_pin != 1));
            futility_countdown--)
        {
            // spinlock waiting for logic high pin state (start of new conversion)
        }
    }
#else // MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input is InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
#endif // MAX11043_EOC_INTERRUPT_POLLING
//--------------------------------------------------
}

// CODE GENERATOR: extern function requirement MAX11043::CONVRUNoutputGetValue
// Return the state being driven onto the MAX11043 CONVRUN pin.
//
int MAX11043::CONVRUNoutputGetValue()
{
    // CODE GENERATOR: extern function definition for function CONVRUNoutputGetValue
    // TODO1: CODE GENERATOR: extern function definition for gpio interface function CONVRUNoutputGetValue
    // TODO1: CODE GENERATOR: gpio pin CONVRUN assuming member function m_CONVRUN_pin
    // TODO1: CODE GENERATOR: gpio direction output
    // m_CONVRUN_pin.output(); // only applicable to DigitalInOut
    // TODO1: CODE GENERATOR: gpio function GetValue
    return m_CONVRUN_pin;
}

// TODO1: CODE GENERATOR: extern function GPIOoutputDACSTEP alias DACSTEPoutputValue
// CODE GENERATOR: extern function requirement MAX11043::DACSTEPoutputValue
// Assert MAX11043 DACSTEP pin : High = Active, Low = Idle.
//
void MAX11043::DACSTEPoutputValue(int isLogicHigh)
{
    // CODE GENERATOR: extern function definition for function DACSTEPoutputValue
    // TODO1: CODE GENERATOR: extern function definition for gpio interface function DACSTEPoutputValue
    // TODO1: CODE GENERATOR: gpio pin DACSTEP assuming member function m_DACSTEP_pin
    // TODO1: CODE GENERATOR: gpio direction output
    // m_DACSTEP_pin.output(); // only applicable to DigitalInOut
    // TODO1: CODE GENERATOR: gpio function Value
    m_DACSTEP_pin = isLogicHigh;
}

// TODO1: CODE GENERATOR: extern function GPIOoutputUP_slash_DWNb alias UP_slash_DWNboutputValue
// CODE GENERATOR: extern function requirement MAX11043::UP_slash_DWNboutputValue
// Assert MAX11043 UP_slash_DWNb pin : High = Up, Low = Down.
//
void MAX11043::UP_slash_DWNboutputValue(int isLogicHigh)
{
    // CODE GENERATOR: extern function definition for function UP_slash_DWNboutputValue
    // TODO1: CODE GENERATOR: extern function definition for gpio interface function UP_slash_DWNboutputValue
    // TODO1: CODE GENERATOR: gpio pin UP_slash_DWNb assuming member function m_UP_slash_DWNb_pin
    // TODO1: CODE GENERATOR: gpio direction output
    // m_UP_slash_DWNb_pin.output(); // only applicable to DigitalInOut
    // TODO1: CODE GENERATOR: gpio function Value
    m_UP_slash_DWNb_pin = isLogicHigh;
}

// CODE GENERATOR: extern function requirement MAX11043::EOCinputWaitUntilLow
// Wait for MAX11043 EOC pin low, indicating end of conversion.
// Required when using any of the InternalClock modes.
//
void MAX11043::EOCinputWaitUntilLow()
{
    // CODE GENERATOR: extern function definition for function EOCinputWaitUntilLow
    // TODO1: CODE GENERATOR: extern function definition for gpio interface function EOCinputWaitUntilLow
    // TODO1: CODE GENERATOR: gpio pin EOC assuming member function m_EOC_pin
    // TODO1: CODE GENERATOR: gpio direction input
    // m_EOC_pin.input(); // only applicable to DigitalInOut
    // TODO1: CODE GENERATOR: gpio function WaitUntilLow
    while (m_EOC_pin != 0)
    {
        // spinlock waiting for logic low pin state
    }
}

// CODE GENERATOR: extern function requirement MAX11043::EOCinputValue
// Return the status of the MAX11043 EOC pin.
//
int MAX11043::EOCinputValue()
{
    // CODE GENERATOR: extern function definition for function EOCinputValue
    // TODO1: CODE GENERATOR: extern function definition for gpio interface function EOCinputValue
    // TODO1: CODE GENERATOR: gpio pin EOC assuming member function m_EOC_pin
    // TODO1: CODE GENERATOR: gpio direction input
    // m_EOC_pin.input(); // only applicable to DigitalInOut
    // TODO1: CODE GENERATOR: gpio function Value
    return m_EOC_pin.read();
}

// CODE GENERATOR: class member function definitions
//----------------------------------------
// Menu item '!'
// Initialize device
// @return 1 on success; 0 on failure
uint8_t MAX11043::Init(void)
{
    
    //----------------------------------------
    // reference voltage, in Volts
    VRef = 2.500;
    
    //----------------------------------------
    // shadow of register config CMD_0010_0000_d16_Wr08_Configuration
    config = 0x6000;
    
    //----------------------------------------
    // shadow of register status CMD_0001_1110_d8_Rd07_Status
    status = 0x00;
    
    //----------------------------------------
    // shadow of register ADCa CMD_0000_0010_d16o8_Rd00_ADCa
    adca = 0x0000;
    
    //----------------------------------------
    // shadow of register ADCb CMD_0000_0110_d16o8_Rd01_ADCb
    adcb = 0x0000;
    
    //----------------------------------------
    // shadow of register ADCc CMD_0000_1010_d16o8_Rd02_ADCc
    adcc = 0x0000;
    
    //----------------------------------------
    // shadow of register ADCd CMD_0000_1110_d16o8_Rd03_ADCd
    adcd = 0x0000;
    
    //----------------------------------------
    // init (based on old EV kit GUI)
    #warning "Not Implemented Yet: MAX11043::Init init..."
    // bool bOpResult = false;
    // String FWVersionString = "00";
    // bool bDemoMode = true;
    // int scan_resolution = 0;
    // int scan_channels = 0;
    // int scan_bits = 0;
    // int sampleRateFactore = 0;
    // double sampleRate = 0;
    // unsigned long banks_requested = 0;
    // bool bScanMode = 0;
    
    //----------------------------------------
    // Device ID Validation -- not used, no device ID register
    #warning "Not Implemented Yet: MAX11043::Init Device ID Validation..."
    // const uint32_t part_id_expect = 0x000F02;
    // uint32_t part_id_readback;
    // RegRead(xxxxxxxxxxxxCMD_r001_0001_xxxx_xxxx_xxxx_xxxx_xxxx_xddd_PART_ID, &part_id_readback);
    // if (part_id_readback != part_id_expect) return 0;
    
    //----------------------------------------
    // Active-High Shutdown Input. Drive high to shut down the MAX11043.
    SHDNoutputValue(0); // SHDN Inactive
    
    //----------------------------------------
    // Convert Run. Drive high to start continuous conversions on all 4 channels. The device is idle when
    // CONVRUN is low.
    CONVRUNoutputValue(0); // CONVRUN Idle
    
    //----------------------------------------
    // DAC Step Input. Drive high to move the DAC output in the direction of UP/DWN on the next rising
    // edge of the system clock.
    DACSTEPoutputValue(0); // DACSTEP Idle
    
    //----------------------------------------
    // DAC Step Direction Select. Drive high to step up, drive low to step down when DACSTEP is toggled.
    UP_slash_DWNboutputValue(0); // UP/DWN# Down
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Return the physical voltage corresponding to conversion result
// (conversion format is Bipolar mode, 2's complement)
// Does not perform any offset or gain correction.
//
// @pre CONFIG_xxxx_xxxx_xx1x_xxxx_24BIT is 0: 16-bit mode is configured
// @pre VRef = Voltage of REF input, in Volts
// @param[in] value_u24: raw 24-bit MAX11043 code (right justified).
// @return physical voltage corresponding to MAX11043 code.
// @test group BIP2C16 ADCVoltageOfCode_16bit(0x7FFF) expect 2.500 within 0.030 Full Scale
// @test group BIP2C16 ADCVoltageOfCode_16bit(0x7FFF) expect 2.500             Full Scale
// @test group BIP2C16 ADCVoltageOfCode_16bit(0x6666) expect 2.000             Two Volts
// @test group BIP2C16 ADCVoltageOfCode_16bit(0x6000) expect 1.875             75% Scale
// @test group BIP2C16 ADCVoltageOfCode_16bit(0x4000) expect 1.250             Mid Scale
// @test group BIP2C16 ADCVoltageOfCode_16bit(0x3333) expect 1.000             One Volt
// @test group BIP2C16 ADCVoltageOfCode_16bit(0x2000) expect 0.625             25% Scale
// @test group BIP2C16 ADCVoltageOfCode_16bit(0x051e) expect 0.100             100mV
// @test group BIP2C16 ADCVoltageOfCode_16bit(0x0000) expect 0.00000894069671  Three LSB
// @test group BIP2C16 ADCVoltageOfCode_16bit(0x0000) expect 0.00000596046447  Two LSB
// @test group BIP2C16 ADCVoltageOfCode_16bit(0x0000) expect 0.0000029802326   One LSB
// @test group BIP2C16 ADCVoltageOfCode_16bit(0x0000) expect 0.0               Zero Scale
// @test group BIP2C16 ADCVoltageOfCode_16bit(0xFFFF) expect -0.0000029802326  Negative One LSB
// @test group BIP2C16 ADCVoltageOfCode_16bit(0xFFFF) expect -0.0000059604644  Negative Two LSB
// @test group BIP2C16 ADCVoltageOfCode_16bit(0xFFFF) expect -0.0000089406967  Negative Three LSB
// @test group BIP2C16 ADCVoltageOfCode_16bit(0xFAE1) expect -0.100            Negative 100mV
// @test group BIP2C16 ADCVoltageOfCode_16bit(0xE000) expect -0.625            Negative 25% Scale
// @test group BIP2C16 ADCVoltageOfCode_16bit(0xCCCC) expect -1.000            Negative One Volt
// @test group BIP2C16 ADCVoltageOfCode_16bit(0xC000) expect -1.250            Negative Mid Scale
// @test group BIP2C16 ADCVoltageOfCode_16bit(0xA000) expect -1.875            Negative 75% Scale
// @test group BIP2C16 ADCVoltageOfCode_16bit(0x9999) expect -2.000            Negative Two Volts
// @test group BIP2C16 ADCVoltageOfCode_16bit(0x8000) expect -2.500            Negative Full Scale
// @test group BIP2C16 ADCVoltageOfCode_16bit(0x8000) expect -2.500            Negative Full Scale
//
double MAX11043::ADCVoltageOfCode_16bit(uint32_t value_u16)
{
    
    //----------------------------------------
    // Linear map min and max endpoints
    double MaxScaleVoltage = 2 * VRef; // voltage of maximum code 0x7fff
    double MinScaleVoltage = 0; // voltage of minimum code 0x8000
    const int32_t FULL_SCALE_CODE_16BIT_2S_COMPLEMENT = 0x7fff;
    const int32_t SIGN_BIT_16BIT_2S_COMPLEMENT = 0x8000;
    if (value_u16 >= SIGN_BIT_16BIT_2S_COMPLEMENT) { value_u16 = value_u16 - (2 * SIGN_BIT_16BIT_2S_COMPLEMENT); }
    const int32_t MaxCode = FULL_SCALE_CODE_16BIT_2S_COMPLEMENT;
    const int32_t CodeSpan = 0x10000;
    const int32_t MinCode = 0;
    double codeFraction = ((double)((int32_t)value_u16) - MinCode) / CodeSpan;
    return (MinScaleVoltage + ((MaxScaleVoltage - MinScaleVoltage) * codeFraction)); //  / pgaGain;
}

//----------------------------------------
// Return the physical voltage corresponding to conversion result
// (conversion format is Bipolar mode, 2's complement)
// Does not perform any offset or gain correction.
//
// @pre CONFIG_xxxx_xxxx_xx1x_xxxx_24BIT is 1: 24-bit mode is configured
// @pre VRef = Voltage of REF input, in Volts
// @param[in] value_u24: raw 24-bit MAX11043 code (right justified).
// @return physical voltage corresponding to MAX11043 code.
// @test group BIP2C24 ADCVoltageOfCode_24bit(0x7FFFFF) expect 2.500 within 0.030 Full Scale
// @test group BIP2C24 ADCVoltageOfCode_24bit(0x7FFFFE) expect 2.500             Full Scale
// @test group BIP2C24 ADCVoltageOfCode_24bit(0x666666) expect 2.000             Two Volts
// @test group BIP2C24 ADCVoltageOfCode_24bit(0x600000) expect 1.875             75% Scale
// @test group BIP2C24 ADCVoltageOfCode_24bit(0x400000) expect 1.250             Mid Scale
// @test group BIP2C24 ADCVoltageOfCode_24bit(0x333333) expect 1.000             One Volt
// @test group BIP2C24 ADCVoltageOfCode_24bit(0x200000) expect 0.625             25% Scale
// @test group BIP2C24 ADCVoltageOfCode_24bit(0x051eb8) expect 0.100             100mV
// @test group BIP2C24 ADCVoltageOfCode_24bit(0x000003) expect 0.00000894069671  Three LSB
// @test group BIP2C24 ADCVoltageOfCode_24bit(0x000002) expect 0.00000596046447  Two LSB
// @test group BIP2C24 ADCVoltageOfCode_24bit(0x000001) expect 0.0000029802326   One LSB
// @test group BIP2C24 ADCVoltageOfCode_24bit(0x000000) expect 0.0               Zero Scale
// @test group BIP2C24 ADCVoltageOfCode_24bit(0xFFFFFF) expect -0.0000029802326  Negative One LSB
// @test group BIP2C24 ADCVoltageOfCode_24bit(0xFFFFFE) expect -0.0000059604644  Negative Two LSB
// @test group BIP2C24 ADCVoltageOfCode_24bit(0xFFFFFD) expect -0.0000089406967  Negative Three LSB
// @test group BIP2C24 ADCVoltageOfCode_24bit(0xFAE148) expect -0.100            Negative 100mV
// @test group BIP2C24 ADCVoltageOfCode_24bit(0xE00000) expect -0.625            Negative 25% Scale
// @test group BIP2C24 ADCVoltageOfCode_24bit(0xCCCCCD) expect -1.000            Negative One Volt
// @test group BIP2C24 ADCVoltageOfCode_24bit(0xC00000) expect -1.250            Negative Mid Scale
// @test group BIP2C24 ADCVoltageOfCode_24bit(0xA00000) expect -1.875            Negative 75% Scale
// @test group BIP2C24 ADCVoltageOfCode_24bit(0x99999A) expect -2.000            Negative Two Volts
// @test group BIP2C24 ADCVoltageOfCode_24bit(0x800001) expect -2.500            Negative Full Scale
// @test group BIP2C24 ADCVoltageOfCode_24bit(0x800000) expect -2.500            Negative Full Scale
//
double MAX11043::ADCVoltageOfCode_24bit(uint32_t value_u24)
{
    
    //----------------------------------------
    // Linear map min and max endpoints
    double MaxScaleVoltage = 2 * VRef; // voltage of maximum code 0x7fffff
    double MinScaleVoltage = 0; // voltage of minimum code 0x800000
    const int32_t FULL_SCALE_CODE_24BIT_2S_COMPLEMENT = 0x7fffff;
    const int32_t SIGN_BIT_24BIT_2S_COMPLEMENT = 0x800000;
    if (value_u24 >= SIGN_BIT_24BIT_2S_COMPLEMENT) { value_u24 = value_u24 - (2 * SIGN_BIT_24BIT_2S_COMPLEMENT); }
    const int32_t MaxCode = FULL_SCALE_CODE_24BIT_2S_COMPLEMENT;
    const int32_t CodeSpan = 0x1000000;
    const int32_t MinCode = 0;
    double codeFraction = ((double)((int32_t)value_u24) - MinCode) / CodeSpan;
    return (MinScaleVoltage + ((MaxScaleVoltage - MinScaleVoltage) * codeFraction)); //  / pgaGain;
}

//----------------------------------------
// Write a MAX11043 register.
//
// CMDOP_1aaa_aaaa_ReadRegister bit is cleared 0 indicating a write operation.
//
// MAX11043 register length can be determined by function RegSize.
//
// For 8-bit register size:
//
//     SPI 16-bit transfer
//
//     SPI MOSI = 0aaa_aaaa_dddd_dddd
//
//     SPI MISO = xxxx_xxxx_xxxx_xxxx
//
// For 16-bit register size:
//
//     SPI 24-bit or 32-bit transfer
//
//     SPI MOSI = 0aaa_aaaa_dddd_dddd_dddd_dddd
//
//     SPI MISO = xxxx_xxxx_xxxx_xxxx_xxxx_xxxx
//
// For 24-bit register size:
//
//     SPI 32-bit transfer
//
//     SPI MOSI = 0aaa_aaaa_dddd_dddd_dddd_dddd_dddd_dddd
//
//     SPI MISO = xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx
//
// @return 1 on success; 0 on failure
uint8_t MAX11043::RegWrite(MAX11043_CMD_enum_t commandByte, uint32_t regData)
{
    
    //----------------------------------------
    // switch based on register address szie RegSize(commandByte)
    //commandByte = (MAX11043_CMD_enum_t)((commandByte &~ CMDOP_0aaa_aa10_ReadRegister) & 0xFF);
    switch(RegSize(commandByte))
    {
        case 8:  // 8-bit register size
            {
                // SPI 8+8 = 16-bit transfer
                //            1234 5678 ___[1]_16
                // SPI MOSI = 0aaa_aaaa_dddd_dddd ... _0000
                // SPI MISO = xxxx_xxxx_xxxx_xxxx ... _xxxx
                size_t byteCount = 1 + 1;
                uint8_t mosiData[2];
                uint8_t misoData[2];
                mosiData[0] = commandByte;
                mosiData[1] = regData;
                // SPIreadWriteWithLowCS(size_t byteCount, uint8_t mosiData[], uint8_t misoData[]);
                SPIreadWriteWithLowCS(byteCount, mosiData, misoData);
                // TODO: cache CMD_0101_0100_d8_Wr15_FilterCAddress
                // if (commandByte == CMD_0101_0100_d8_Wr15_FilterCAddress) {
                //     FilterCAddress = regData;
                // }
                // TODO: cache CMD_0110_0000_d8_Wr18_FlashMode
                // if (commandByte == CMD_0110_0000_d8_Wr18_FlashMode) {
                //     FlashMode = regData;
                // }
            }
            break;
        case 16:  // 16-bit register size
            #warning "Not Verified Yet: MAX11043::RegWrite 16-bit"
            {
                // SPI 8+16 = 24-bit transfer
                //            1234 5678 ___[1]_16 ___[2]_24
                // SPI MOSI = 0aaa_aaaa_dddd_dddd_dddd_dddd ... _0000
                // SPI MISO = xxxx_xxxx_xxxx_xxxx_xxxx_xxxx ... _xxxx
                size_t byteCount = 1 + 2;
                uint8_t mosiData[3];
                uint8_t misoData[3];
                mosiData[0] = commandByte;
                mosiData[1] = (uint8_t)((regData >> 8) & 0xFF);
                mosiData[2] = (uint8_t)((regData >> 0) & 0xFF);
                // SPIreadWriteWithLowCS(size_t byteCount, uint8_t mosiData[], uint8_t misoData[]);
                SPIreadWriteWithLowCS(byteCount, mosiData, misoData);
                // cache CMD_0010_0000_d16_Wr08_Configuration
                if (commandByte == CMD_0010_0000_d16_Wr08_Configuration) {
                    config = regData;
                }
                // TODO: cache CMD_0010_0100_d16_Wr09_DAC
                // TODO: cache CMD_0010_1000_d16_Wr0A_DACStep
                // TODO: cache CMD_0010_1100_d16_Wr0B_DACHDACL
                // TODO: cache CMD_0011_0000_d16_Wr0C_ConfigA
                // TODO: cache CMD_0011_0100_d16_Wr0D_ConfigB
                // TODO: cache CMD_0011_1000_d16_Wr0E_ConfigC
                // TODO: cache CMD_0011_1100_d16_Wr0F_ConfigD
                // TODO: cache CMD_0100_0000_d16_Wr10_Reference
                // TODO: cache CMD_0100_0100_d16_Wr11_AGain
                // TODO: cache CMD_0100_1000_d16_Wr12_BGain
                // TODO: cache CMD_0100_1100_d16_Wr13_CGain
                // TODO: cache CMD_0101_0000_d16_Wr14_DGain
                // TODO: cache CMD_0110_0100_d16_Wr19_FlashAddr
                // TODO: cache CMD_0110_1000_d16_Wr1A_FlashDataIn
            }
            break;
        case 32:  // 32-bit register size
            #warning "Not Verified Yet: MAX11043::RegWrite 32-bit"
            {
                // SPI 8+32 = 40-bit transfer
                //            1234 5678 ___[1]_16 ___[2]_24 ___[3]_32 ___[4]_40
                // SPI MOSI = 1aaa_aaaa_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd ... _0000
                // SPI MISO = xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx ... _xxxx
                //
                size_t byteCount = 1 + (2 * 2);
                uint8_t mosiData[5];
                uint8_t misoData[5];
                mosiData[0] = commandByte;
                mosiData[1] = (uint8_t)((regData >> 24) & 0xFF);
                mosiData[2] = (uint8_t)((regData >> 16) & 0xFF);
                mosiData[3] = (uint8_t)((regData >>  8) & 0xFF);
                mosiData[4] = (uint8_t)((regData >>  0) & 0xFF);
                // SPIreadWriteWithLowCS(size_t byteCount, uint8_t mosiData[], uint8_t misoData[]);
                SPIreadWriteWithLowCS(byteCount, mosiData, misoData);
                // TODO: cache CMD_0101_1000_d32_Wr16_FilterCDataOut
                // if (commandByte == CMD_0101_1000_d32_Wr16_FilterCDataOut) {
                //     FilterCDataOut = regData;
                // }
                // TODO: cache CMD_0101_1100_d32_Wr17_FilterCDataIn
                // if (commandByte == CMD_0101_1000_d32_Wr16_FilterCDataOut) {
                //     FilterCDataOut = regData;
                // }
            }
            break;
    }
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Read an 8-bit MAX11043 register
//
// CMDOP_1aaa_aaaa_ReadRegister bit is set 1 indicating a read operation.
//
// MAX11043 register length can be determined by function RegSize.
//
// For 8-bit register size:
//
//     SPI 16-bit transfer
//
//     SPI MOSI = 1aaa_aaaa_0000_0000
//
//     SPI MISO = xxxx_xxxx_dddd_dddd
//
// For 16-bit register size:
//
//     SPI 24-bit or 32-bit transfer
//
//     SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000
//
//     SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd
//
// For 24-bit register size:
//
//     SPI 32-bit transfer
//
//     SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000_0000_0000
//
//     SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd_dddd_dddd
//
//
// @return 1 on success; 0 on failure
uint8_t MAX11043::RegRead(MAX11043_CMD_enum_t commandByte, uint32_t* ptrRegData)
{
    
    //----------------------------------------
    // switch based on register address szie RegSize(regAddress)
    #define SIGN_EXTEND_INT16_VALUE(x) (((x)&(0x8000))?((x)-65536):(x))
    //commandByte = (MAX11043_CMD_enum_t)((commandByte &~ CMDOP_0aaa_aa10_ReadRegister) & 0xFF);
    switch(RegSize(commandByte))
    {
        case 8:  // 8-bit register size
            {
                // SPI 8+8 = 16-bit transfer
                //            1234 5678 ___[1]_16
                // SPI MOSI = 1aaa_aaaa_0000_0000 ... _0000
                // SPI MISO = xxxx_xxxx_dddd_dddd ... _xxxx
                size_t byteCount = 1 + 1;
                uint8_t mosiData[2];
                uint8_t misoData[2];
                mosiData[0] = CMDOP_0aaa_aa10_ReadRegister | commandByte;
                mosiData[1] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                // SPIreadWriteWithLowCS(size_t byteCount, uint8_t mosiData[], uint8_t misoData[]);
                SPIreadWriteWithLowCS(byteCount, mosiData, misoData);
                if (ptrRegData) { (*ptrRegData) = misoData[1]; }
                if (commandByte == CMD_0001_1110_d8_Rd07_Status) {
                    // TODO1: update status
                    status = misoData[1];
                }
            }
            break;
        case 16:  // 16-bit register size
            #warning "Not Verified Yet: MAX11043::RegRead 16-bit"
            {
                // SPI 8+16 = 24-bit transfer
                //            1234 5678 ___[1]_16 ___[2]_24
                // SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000 ... _0000
                // SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd ... _xxxx
                size_t byteCount = 1 + 2;
                uint8_t mosiData[3];
                uint8_t misoData[3];
                mosiData[0] = CMDOP_0aaa_aa10_ReadRegister | commandByte;
                mosiData[1] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[2] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                // SPIreadWriteWithLowCS(size_t byteCount, uint8_t mosiData[], uint8_t misoData[]);
                SPIreadWriteWithLowCS(byteCount, mosiData, misoData);
                if (ptrRegData) { (*ptrRegData) = (misoData[1] << 8) | misoData[2]; }
                if (commandByte == CMD_0010_0010_d16_Rd08_Configuration) {
                    // TODO1: update config
                    config = (misoData[1] << 8) | misoData[2];
                }
                if (commandByte == CMD_0000_0010_d16o8_Rd00_ADCa) {
                    // TODO1: update adca
                    // adca = (misoData[1] << 8) | misoData[2];
                    // TODO1: update adca as 2's complement
                    // int raw_code = (misoData[1] << 8) | misoData[2];
                    // if (raw_code & 0x8000) { adca = raw_code - 65536; } else { adca = raw_code; }
                    adca = SIGN_EXTEND_INT16_VALUE((int)(misoData[1] << 8) | misoData[2]);
                }
                if (commandByte == CMD_0000_0110_d16o8_Rd01_ADCb) {
                    // TODO1: update adcb
                    // adcb = (misoData[1] << 8) | misoData[2];
                    // TODO1: update adca as 2's complement
                    // int raw_code = (misoData[1] << 8) | misoData[2];
                    // if (raw_code & 0x8000) { adca = raw_code - 65536; } else { adca = raw_code; }
                    adcb = SIGN_EXTEND_INT16_VALUE((int)(misoData[1] << 8) | misoData[2]);
                }
                if (commandByte == CMD_0000_1010_d16o8_Rd02_ADCc) {
                    // TODO1: update adcc
                    // adcc = (misoData[1] << 8) | misoData[2];
                    // TODO1: update adca as 2's complement
                    // int raw_code = (misoData[1] << 8) | misoData[2];
                    // if (raw_code & 0x8000) { adca = raw_code - 65536; } else { adca = raw_code; }
                    adcc = SIGN_EXTEND_INT16_VALUE((int)(misoData[1] << 8) | misoData[2]);
                }
                if (commandByte == CMD_0000_1110_d16o8_Rd03_ADCd) {
                    // TODO1: update adcd
                    // adcd = (misoData[1] << 8) | misoData[2];
                    // TODO1: update adca as 2's complement
                    // int raw_code = (misoData[1] << 8) | misoData[2];
                    // if (raw_code & 0x8000) { adca = raw_code - 65536; } else { adca = raw_code; }
                    adcd = SIGN_EXTEND_INT16_VALUE((int)(misoData[1] << 8) | misoData[2]);
                }
            }
            break;
        case 24:  // 24-bit register size
            {
                // SPI 8+24 = 32-bit transfer
                //            1234 5678 ___[1]_16 ___[2]_24 ___[3]_32
                // SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000_0000_0000 ... _0000
                // SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd_dddd_dddd ... _xxxx
                size_t byteCount = 1 + 3;
                uint8_t mosiData[4];
                uint8_t misoData[4];
                mosiData[0] = CMDOP_0aaa_aa10_ReadRegister | commandByte;
                mosiData[1] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[2] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[3] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                // SPIreadWriteWithLowCS(size_t byteCount, uint8_t mosiData[], uint8_t misoData[]);
                SPIreadWriteWithLowCS(byteCount, mosiData, misoData);
                if (ptrRegData) { (*ptrRegData) = (misoData[1] << 16) | (misoData[2] << 8) | misoData[3]; }
                if (commandByte == CMD_0000_0010_d16o8_Rd00_ADCa) {
                    // TODO1: update adca
                    adca = (misoData[1] << 16) | (misoData[2] << 8) | misoData[3];
                }
                if (commandByte == CMD_0000_0110_d16o8_Rd01_ADCb) {
                    // TODO1: update adcb
                    adcb = (misoData[1] << 16) | (misoData[2] << 8) | misoData[3];
                }
                if (commandByte == CMD_0000_1010_d16o8_Rd02_ADCc) {
                    // TODO1: update adcc
                    adcc = (misoData[1] << 16) | (misoData[2] << 8) | misoData[3];
                }
                if (commandByte == CMD_0000_1110_d16o8_Rd03_ADCd) {
                    // TODO1: update adcd
                    adcd = (misoData[1] << 16) | (misoData[2] << 8) | misoData[3];
                }
            }
            break;
        case 32:  // 32-bit register size CMD_0001_0010_d16o8_d16o8_Rd04_ADCab, CMD_0001_0110_d16o8_d16o8_Rd05_ADCcd
            //
            #warning "Not Implemented Yet: MAX11043::RegRead 32-bit CMD_0001_0010_d16o8_d16o8_Rd04_ADCab"
            // TODO: support long SPI read CMD_0001_0010_d16o8_d16o8_Rd04_ADCab
            // %SW 0x12 (0 0)   (0 0)   -- for 16-bit read A,B
            // update adca, adcb
            //
            // TODO: support long SPI read CMD_0001_0110_d16o8_d16o8_Rd05_ADCcd
            // %SW 0x16 (0 0)   (0 0)   -- for 16-bit read C,D
            // update adcc, adcd
            //
            {
                // SPI 8+32 = 40-bit transfer
                //            1234 5678 ___[1]_16 ___[2]_24 ___[3]_32 ___[4]_40
                // SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000_0000_0000_0000_0000 ... _0000
                // SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd ... _xxxx
                size_t byteCount = 1 + (2 * 2);
                uint8_t mosiData[5];
                uint8_t misoData[5];
                mosiData[0] = CMDOP_0aaa_aa10_ReadRegister | commandByte;
                mosiData[1] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[2] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[3] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[4] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                // SPIreadWriteWithLowCS(size_t byteCount, uint8_t mosiData[], uint8_t misoData[]);
                SPIreadWriteWithLowCS(byteCount, mosiData, misoData);
                if (ptrRegData) { (*ptrRegData) = (misoData[1] << 8) | misoData[2]; }
                if (commandByte == CMD_0001_0010_d16o8_d16o8_Rd04_ADCab) {
                    // TODO1: update adca
                    // adca = (misoData[1] << 8) | misoData[2];
                    // TODO1: update adca as 2's complement
                    // int raw_code = (misoData[1] << 8) | misoData[2];
                    // if (raw_code & 0x8000) { adca = raw_code - 65536; } else { adca = raw_code; }
                    adca = SIGN_EXTEND_INT16_VALUE((int)(misoData[1] << 8) | misoData[2]);
                    // TODO1: update adcb
                    // adcb = (misoData[3] << 8) | misoData[4];
                    // TODO1: update adca as 2's complement
                    // int raw_code = (misoData[1] << 8) | misoData[2];
                    // if (raw_code & 0x8000) { adca = raw_code - 65536; } else { adca = raw_code; }
                    adcb = SIGN_EXTEND_INT16_VALUE((int)(misoData[3] << 8) | misoData[4]);
                }
                if (commandByte == CMD_0001_0110_d16o8_d16o8_Rd05_ADCcd) {
                    // TODO1: update adcc
                    adcc = (misoData[1] << 8) | misoData[2];
                    // TODO1: update adca as 2's complement
                    // int raw_code = (misoData[1] << 8) | misoData[2];
                    // if (raw_code & 0x8000) { adca = raw_code - 65536; } else { adca = raw_code; }
                    adcc = SIGN_EXTEND_INT16_VALUE((int)(misoData[1] << 8) | misoData[2]);
                    // TODO1: update adcd
                    // adcd = (misoData[3] << 8) | misoData[4];
                    // TODO1: update adca as 2's complement
                    // int raw_code = (misoData[1] << 8) | misoData[2];
                    // if (raw_code & 0x8000) { adca = raw_code - 65536; } else { adca = raw_code; }
                    adcd = SIGN_EXTEND_INT16_VALUE((int)(misoData[3] << 8) | misoData[4]);
                }
            }
            break;
        case 48:  // 48-bit register size CMD_0001_0010_d16o8_d16o8_Rd04_ADCab, CMD_0001_0110_d16o8_d16o8_Rd05_ADCcd
            //
            #warning "Not Verified Yet: MAX11043::RegRead 48-bit CMD_0001_0010_d16o8_d16o8_Rd04_ADCab"
            // TODO: support long SPI read CMD_0001_0010_d16o8_d16o8_Rd04_ADCab
            // %SW 0x12 (0 0 0) (0 0 0) -- for 24-bit read A,B
            // update adca, adcb
            //
            // TODO: support long SPI read CMD_0001_0110_d16o8_d16o8_Rd05_ADCcd
            // %SW 0x16 (0 0 0) (0 0 0) -- for 24-bit read C,D
            // update adcc, adcd
            //
            {
                // SPI 8+48 = 56-bit transfer
                //            1234 5678 ___[1]_16 ___[2]_24 ___[3]_32 ___[4]_40 ___[5]_48 ___[6]_56
                // SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000 ... _0000
                // SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd ... _xxxx
                size_t byteCount = 1 + (3 * 2);
                uint8_t mosiData[7];
                uint8_t misoData[7];
                mosiData[0] = CMDOP_0aaa_aa10_ReadRegister | commandByte;
                mosiData[1] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[2] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[3] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[4] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[5] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[6] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                // SPIreadWriteWithLowCS(size_t byteCount, uint8_t mosiData[], uint8_t misoData[]);
                SPIreadWriteWithLowCS(byteCount, mosiData, misoData);
                if (ptrRegData) { (*ptrRegData) = (misoData[1] << 16) | (misoData[2] << 8) | misoData[3]; }
                if (commandByte == CMD_0001_0010_d16o8_d16o8_Rd04_ADCab) {
                    // TODO1: update adca
                    adca = (misoData[1] << 16) | (misoData[2] << 8) | misoData[3];
                    // TODO1: update adcb
                    adcb = (misoData[4] << 16) | (misoData[5] << 8) | misoData[6];
                }
                if (commandByte == CMD_0001_0110_d16o8_d16o8_Rd05_ADCcd) {
                    // TODO1: update adcc
                    adcc = (misoData[1] << 16) | (misoData[2] << 8) | misoData[3];
                    // TODO1: update adcd
                    adcd = (misoData[4] << 16) | (misoData[5] << 8) | misoData[6];
                }
            }
            break;
        case 64:  // 64-bit register size CMD_0001_1010_d16o8_d16o8_d16o8_d16o8_Rd06_ADCabcd
            //
            #warning "Not Verified Yet: MAX11043::RegRead 64-bit CMD_0001_1010_d16o8_d16o8_d16o8_d16o8_Rd06_ADCabcd"
            // TODO: support long SPI read CMD_0001_1010_d16o8_d16o8_d16o8_d16o8_Rd06_ADCabcd
            // %SW 0x1A (0 0)   (0 0)   (0 0)   (0 0)   -- for 16-bit read A,B,C,D
            // update adca, adcb, adcc, adcd
            //
            {
                // SPI 8+64 = 72-bit transfer
                //            1234 5678 ___[1]_16 ___[2]_24 ___[3]_32 ___[4]_40 ___[5]_48 ___[6]_56 ___[7]_64 ___[8]_72
                // SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000 ... _0000
                // SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd ... _xxxx
                size_t byteCount = 1 + (2 * 4);
                uint8_t mosiData[9];
                uint8_t misoData[9];
                mosiData[0] = CMDOP_0aaa_aa10_ReadRegister | commandByte;
                mosiData[1] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[2] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[3] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[4] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[5] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[6] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[7] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[8] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                // SPIreadWriteWithLowCS(size_t byteCount, uint8_t mosiData[], uint8_t misoData[]);
                SPIreadWriteWithLowCS(byteCount, mosiData, misoData);
                if (ptrRegData) { (*ptrRegData) = (misoData[1] << 8) | misoData[2]; }
                if (commandByte == CMD_0001_1010_d16o8_d16o8_d16o8_d16o8_Rd06_ADCabcd) {
                    // TODO1: update adca
                    // adca = (misoData[1] << 8) | misoData[2];
                    // TODO1: update adca as 2's complement
                    // int raw_code = (misoData[1] << 8) | misoData[2];
                    // if (raw_code & 0x8000) { adca = raw_code - 65536; } else { adca = raw_code; }
                    adca = SIGN_EXTEND_INT16_VALUE((int)(misoData[1] << 8) | misoData[2]);
                    //
                    // TODO1: update adcb
                    // adcb = (misoData[3] << 8) | misoData[4];
                    // TODO1: update adcb as 2's complement
                    // raw_code = (misoData[3] << 8) | misoData[4];
                    // if (raw_code & 0x8000) { adcb = raw_code - 65536; } else { adcb = raw_code; }
                    adcb = SIGN_EXTEND_INT16_VALUE((int)(misoData[3] << 8) | misoData[4]);
                    //
                    // TODO1: update adcc
                    // adcc = (misoData[5] << 8) | misoData[6];
                    // TODO1: update adcc as 2's complement
                    // raw_code = (misoData[5] << 8) | misoData[6];
                    // if (raw_code & 0x8000) { adcc = raw_code - 65536; } else { adcc = raw_code; }
                    adcc = SIGN_EXTEND_INT16_VALUE((int)(misoData[5] << 8) | misoData[6]);
                    //
                    // TODO1: update adcd
                    // adcd = (misoData[7] << 8) | misoData[8];
                    // TODO1: update adcd as 2's complement
                    // raw_code = (misoData[7] << 8) | misoData[8];
                    // if (raw_code & 0x8000) { adcd = raw_code - 65536; } else { adcd = raw_code; }
                    adcd = SIGN_EXTEND_INT16_VALUE((int)(misoData[7] << 8) | misoData[8]);
                    //
                }
            }
            break;
        case 96:  // 96-bit register size CMD_0001_1010_d16o8_d16o8_d16o8_d16o8_Rd06_ADCabcd
            //
            #warning "Not Verified Yet: MAX11043::RegRead 96-bit CMD_0001_1010_d16o8_d16o8_d16o8_d16o8_Rd06_ADCabcd"
            // TODO: support long SPI read CMD_0001_1010_d16o8_d16o8_d16o8_d16o8_Rd06_ADCabcd
            // %SW 0x1A (0 0 0) (0 0 0) (0 0 0) (0 0 0) -- for 24-bit read A,B,C,D
            // update adca, adcb, adcc, adcd
            //
            {
                // SPI 8+96 = 104-bit transfer
                //            1234 5678 ___[1]_16 ___[2]_24 ___[3]_32 ___[4]_40 ___[5]_48 ___[6]_56 ___[7]_64 ___[8]_72 ___[9]_80 __[10]_88 __[11]_96 __[12]104
                // SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000 ... _0000
                // SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd_dddd ... _xxxx
                size_t byteCount = 1 + (3 * 4);
                uint8_t mosiData[13];
                uint8_t misoData[13];
                mosiData[0] = CMDOP_0aaa_aa10_ReadRegister | commandByte;
                mosiData[1] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[2] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[3] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[4] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[5] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[6] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[7] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[8] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[9] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[10] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[11] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                mosiData[12] = 0; // CMDOP_1111_1111_NoOperationMOSIidleHigh;
                // SPIreadWriteWithLowCS(size_t byteCount, uint8_t mosiData[], uint8_t misoData[]);
                SPIreadWriteWithLowCS(byteCount, mosiData, misoData);
                if (ptrRegData) { (*ptrRegData) = (misoData[1] << 16) | (misoData[2] << 8) | misoData[3]; }
                if (commandByte == CMD_0001_1010_d16o8_d16o8_d16o8_d16o8_Rd06_ADCabcd) {
                    // TODO1: update adca
                    adca = (misoData[1] << 16) | (misoData[2] << 8) | misoData[3];
                    // TODO1: update adcb
                    adcb = (misoData[4] << 16) | (misoData[5] << 8) | misoData[6];
                    // TODO1: update adcc
                    adcc = (misoData[7] << 16) | (misoData[8] << 8) | misoData[9];
                    // TODO1: update adcd
                    adcd = (misoData[10] << 16) | (misoData[11] << 8) | misoData[12];
                }
            }
            break;
    }
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Return the size of a MAX11043 register
//
// @return 8 for 8-bit, 16 for 16-bit, 24 for 24-bit, else 0 for undefined register size
uint8_t MAX11043::RegSize(MAX11043_CMD_enum_t commandByte)
{
    
    //----------------------------------------
    // switch based on register address value regAddress
    // commandByte = (MAX11043_CMD_enum_t)((commandByte &~ CMDOP_0aaa_aa10_ReadRegister) & 0xFF);
    switch(commandByte)
    {
        default:
        // case CMDOP_0aaa_aa00_WriteRegister:
        // case CMDOP_0aaa_aa10_ReadRegister:
        // case CMDOP_1111_1111_NoOperationMOSIidleHigh:
            return 0;  // undefined register size
        case CMD_0001_1110_d8_Rd07_Status:
        case CMD_0101_0100_d8_Wr15_FilterCAddress:
        case CMD_0101_0110_d8_Rd15_FilterCAddress:
        case CMD_0110_0000_d8_Wr18_FlashMode:
        case CMD_0110_0010_d8_Rd18_FlashMode:
            return 8;  // 8-bit register size
        case CMD_0010_0000_d16_Wr08_Configuration:
        case CMD_0010_0010_d16_Rd08_Configuration:
        case CMD_0010_0100_d16_Wr09_DAC:
        case CMD_0010_0110_d16_Rd09_DAC:
        case CMD_0010_1000_d16_Wr0A_DACStep:
        case CMD_0010_1010_d16_Rd0A_DACStep:
        case CMD_0010_1100_d16_Wr0B_DACHDACL:
        case CMD_0010_1110_d16_Rd0B_DACHDACL:
        case CMD_0011_0000_d16_Wr0C_ConfigA:
        case CMD_0011_0010_d16_Rd0C_ConfigA:
        case CMD_0011_0100_d16_Wr0D_ConfigB:
        case CMD_0011_0110_d16_Rd0D_ConfigB:
        case CMD_0011_1000_d16_Wr0E_ConfigC:
        case CMD_0011_1010_d16_Rd0E_ConfigC:
        case CMD_0011_1100_d16_Wr0F_ConfigD:
        case CMD_0011_1110_d16_Rd0F_ConfigD:
        case CMD_0100_0000_d16_Wr10_Reference:
        case CMD_0100_0010_d16_Rd10_Reference:
        case CMD_0100_0100_d16_Wr11_AGain:
        case CMD_0100_0110_d16_Rd11_AGain:
        case CMD_0100_1000_d16_Wr12_BGain:
        case CMD_0100_1010_d16_Rd12_BGain:
        case CMD_0100_1100_d16_Wr13_CGain:
        case CMD_0100_1110_d16_Rd13_CGain:
        case CMD_0101_0000_d16_Wr14_DGain:
        case CMD_0101_0010_d16_Rd14_DGain:
        case CMD_0110_0100_d16_Wr19_FlashAddr:
        case CMD_0110_0110_d16_Rd19_FlashAddr:
        case CMD_0110_1000_d16_Wr1A_FlashDataIn:
        case CMD_0110_1010_d16_Rd1A_FlashDataIn:
        case CMD_0110_1110_d16_Rd1B_FlashDataOut:
            return 16;  // 16-bit register size
        case CMD_0000_0010_d16o8_Rd00_ADCa:
        case CMD_0000_0110_d16o8_Rd01_ADCb:
        case CMD_0000_1010_d16o8_Rd02_ADCc:
        case CMD_0000_1110_d16o8_Rd03_ADCd:
            if (config & CONFIG_xxxx_xxxx_xx1x_xxxx_24BIT)
            {
                // %SW 0x02 (0 0 0) -- for 24-bit read
                return 24;  // 24-bit register size
            }
            // %SW 0x02 (0 0) -- for 16-bit read
            //
            return 16;  // 16-bit register size
        case CMD_0001_0010_d16o8_d16o8_Rd04_ADCab:
        case CMD_0001_0110_d16o8_d16o8_Rd05_ADCcd:
            //
            // TODO: support long SPI read
            if (config & CONFIG_xxxx_xxxx_xx1x_xxxx_24BIT)
            {
                // %SW 0x12 (0 0 0) (0 0 0) -- for 24-bit read A,B
                // %SW 0x16 (0 0 0) (0 0 0) -- for 24-bit read C,D
                return 48;  // 48-bit register size: 2*(24)
            }
            // %SW 0x12 (0 0)   (0 0)   -- for 16-bit read A,B
            // %SW 0x16 (0 0)   (0 0)   -- for 16-bit read C,D
            //
            return 32;  // 32-bit register size: 2*(16)
        case CMD_0001_1010_d16o8_d16o8_d16o8_d16o8_Rd06_ADCabcd:
            //
            // TODO: support long SPI read
            if (config & CONFIG_xxxx_xxxx_xx1x_xxxx_24BIT)
            {
                // %SW 0x1A (0 0 0) (0 0 0) (0 0 0) (0 0 0) -- for 24-bit read A,B,C,D
                return 96;  // 96-bit register size: 4*(24)
            }
            // %SW 0x1A (0 0)   (0 0)   (0 0)   (0 0)   -- for 16-bit read A,B,C,D
            //
            return 64;  // 64-bit register size: 4*(16)
        case CMD_0101_1000_d32_Wr16_FilterCDataOut:
        case CMD_0101_1010_d32_Rd16_FilterCDataOut:
        case CMD_0101_1100_d32_Wr17_FilterCDataIn:
        case CMD_0101_1110_d32_Rd17_FilterCDataIn:
            return 32;  // 32-bit register size
    }
}

//----------------------------------------
// Decode operation from commandByte
//
// @return operation such as idle, read register, write register, etc.
MAX11043::MAX11043_CMDOP_enum_t MAX11043::DecodeCommand(MAX11043_CMD_enum_t commandByte)
{
    
    //----------------------------------------
    // decode operation from command byte
    switch (commandByte & 0x83)
    {
    case CMDOP_0aaa_aa10_ReadRegister:
        return CMDOP_0aaa_aa10_ReadRegister;
    case CMDOP_0aaa_aa00_WriteRegister:
        return CMDOP_0aaa_aa00_WriteRegister;
    default:
        return CMDOP_1111_1111_NoOperationMOSIidleHigh;
    }
}

//----------------------------------------
// Return the address field of a MAX11043 register
//
// @return register address field as given in datasheet
uint8_t MAX11043::RegAddrOfCommand(MAX11043_CMD_enum_t commandByte)
{
    
    //----------------------------------------
    // extract register address value from command byte
    return (uint8_t)((commandByte &~ 0x83) >> 2); // CMDOP_0aaa_aa10_ReadRegister
}

//----------------------------------------
// Test whether a command byte is a register read command
//
// @return true if command byte is a register read command
uint8_t MAX11043::IsRegReadCommand(MAX11043_CMD_enum_t commandByte)
{
    
    //----------------------------------------
    // Test whether a command byte is a register read command
    return (commandByte &~ 0x02) ? 1 : 0; // CMDOP_0aaa_aa10_ReadRegister
}

//----------------------------------------
// Return the name of a MAX11043 register
//
// @return null-terminated constant C string containing register name or empty string
const char* MAX11043::RegName(MAX11043_CMD_enum_t commandByte)
{
    
    //----------------------------------------
    // switch based on register address value regAddress
    // commandByte = (MAX11043_CMD_enum_t)((commandByte &~ CMDOP_0aaa_aa10_ReadRegister) & 0xFF);
    switch(commandByte)
    {
        default:
            return "";  // undefined register
        // case CMDOP_0aaa_aa00_WriteRegister: return "_______";
        // case CMDOP_0aaa_aa10_ReadRegister: return "_______";
        // case CMDOP_1111_1111_NoOperationMOSIidleHigh: return "_______";
        case CMD_0000_0010_d16o8_Rd00_ADCa: return "ADCa";
        case CMD_0000_0110_d16o8_Rd01_ADCb: return "ADCb";
        case CMD_0000_1010_d16o8_Rd02_ADCc: return "ADCc";
        case CMD_0000_1110_d16o8_Rd03_ADCd: return "ADCd";
        case CMD_0001_0010_d16o8_d16o8_Rd04_ADCab: return "ADCab";
        case CMD_0001_0110_d16o8_d16o8_Rd05_ADCcd: return "ADCcd";
        case CMD_0001_1010_d16o8_d16o8_d16o8_d16o8_Rd06_ADCabcd: return "ADCabcd";
        case CMD_0001_1110_d8_Rd07_Status: return "Status";
        case CMD_0010_0000_d16_Wr08_Configuration: return "Configuration";
        case CMD_0010_0010_d16_Rd08_Configuration: return "Configuration";
        case CMD_0010_0100_d16_Wr09_DAC: return "DAC";
        case CMD_0010_0110_d16_Rd09_DAC: return "DAC";
        case CMD_0010_1000_d16_Wr0A_DACStep: return "DACStep";
        case CMD_0010_1010_d16_Rd0A_DACStep: return "DACStep";
        case CMD_0010_1100_d16_Wr0B_DACHDACL: return "DACHDACL";
        case CMD_0010_1110_d16_Rd0B_DACHDACL: return "DACHDACL";
        case CMD_0011_0000_d16_Wr0C_ConfigA: return "ConfigA";
        case CMD_0011_0010_d16_Rd0C_ConfigA: return "ConfigA";
        case CMD_0011_0100_d16_Wr0D_ConfigB: return "ConfigB";
        case CMD_0011_0110_d16_Rd0D_ConfigB: return "ConfigB";
        case CMD_0011_1000_d16_Wr0E_ConfigC: return "ConfigC";
        case CMD_0011_1010_d16_Rd0E_ConfigC: return "ConfigC";
        case CMD_0011_1100_d16_Wr0F_ConfigD: return "ConfigD";
        case CMD_0011_1110_d16_Rd0F_ConfigD: return "ConfigD";
        case CMD_0100_0000_d16_Wr10_Reference: return "Reference";
        case CMD_0100_0010_d16_Rd10_Reference: return "Reference";
        case CMD_0100_0100_d16_Wr11_AGain: return "AGain";
        case CMD_0100_0110_d16_Rd11_AGain: return "AGain";
        case CMD_0100_1000_d16_Wr12_BGain: return "BGain";
        case CMD_0100_1010_d16_Rd12_BGain: return "BGain";
        case CMD_0100_1100_d16_Wr13_CGain: return "CGain";
        case CMD_0100_1110_d16_Rd13_CGain: return "CGain";
        case CMD_0101_0000_d16_Wr14_DGain: return "DGain";
        case CMD_0101_0010_d16_Rd14_DGain: return "DGain";
        case CMD_0101_0100_d8_Wr15_FilterCAddress: return "FilterCAddress";
        case CMD_0101_0110_d8_Rd15_FilterCAddress: return "FilterCAddress";
        case CMD_0101_1000_d32_Wr16_FilterCDataOut: return "FilterCDataOut";
        case CMD_0101_1010_d32_Rd16_FilterCDataOut: return "FilterCDataOut";
        case CMD_0101_1100_d32_Wr17_FilterCDataIn: return "FilterCDataIn";
        case CMD_0101_1110_d32_Rd17_FilterCDataIn: return "FilterCDataIn";
        case CMD_0110_0000_d8_Wr18_FlashMode: return "FlashMode";
        case CMD_0110_0010_d8_Rd18_FlashMode: return "FlashMode";
        case CMD_0110_0100_d16_Wr19_FlashAddr: return "FlashAddr";
        case CMD_0110_0110_d16_Rd19_FlashAddr: return "FlashAddr";
        case CMD_0110_1000_d16_Wr1A_FlashDataIn: return "FlashDataIn";
        case CMD_0110_1010_d16_Rd1A_FlashDataIn: return "FlashDataIn";
        case CMD_0110_1110_d16_Rd1B_FlashDataOut: return "FlashDataOut";
    }
}

//----------------------------------------
// Menu item '$' -> adca, adcb, adcc, adcd
// Read ADCabcd
//
// @return 1 on success; 0 on failure
uint8_t MAX11043::Read_ADCabcd(void)
{
    
    //----------------------------------------
    // warning -- WIP work in progress
    #warning "Not Tested Yet: MAX11043::Read_ADCabcd..."
    
//--------------------------------------------------
// MAX11043 ADC Read operations must be synchronized to EOC End Of Conversion
    //----------------------------------------
    // warning -- WIP work in progress
    #warning "need CONVRUNoutputGetValue() -- is CONVRUN being driven high?"
    
    //----------------------------------------
    // Synchronize with EOC End Of Conversion
    // MAX11043 ADC Read operations must be synchronized to EOC End Of Conversion
// EOC# asserts low when new data is available.
// Initiate a data read prior to the next rising edge of EOC# or the result is overwritten.
#if MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input should be InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
// Workaround using DigitalIn(PinName:EOC_pin) polled to sync with EOC falling edge for ADC reads
// 2020-02-20 MAX11043_EOC_INTERRUPT_POLLING works on MAX32625MBED at 9us conversion rate, with 1us timing margin
    // TODO: poll m_EOC_pin if CONVRUN is high
    if (CONVRUNoutputGetValue()) // is CONVRUN being driven high?
    {
        // CONVRUN pin is being driven high, so EOC# will be changing.
        // Try to read as close as possible to EOC# falling edge,
        // because if EOC# falling edge happens during SPI data readout,
        // the data will be corrupted.
        #warning "MAX11043::Read_ADCabcd() Potential infinite loop if EOC pin not connected"
        // possible infinite loop; need a timeout or futility countdown to escape
        for (int futility_countdown = 100;
            ((futility_countdown > 0) &&
            (EOCinputValue() != 1));
            futility_countdown--)
        {
            // spinlock waiting for logic high pin state (start of new conversion)
        }
        for (int futility_countdown = 100;
            ((futility_countdown > 0) &&
            (EOCinputValue() != 0));
            futility_countdown--)
        {
            // spinlock waiting for logic low pin state (new data is available)
        }
    }
    else
    {
        // CONVRUN pin is being driven low, so conversion result will not change, EOC# remains high
    }
#else // MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input is InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
#endif // MAX11043_EOC_INTERRUPT_POLLING
//--------------------------------------------------

    //----------------------------------------
    // read register ADCabcd -> &adca, &adcb, &adcc, &adcd
    RegRead(CMD_0001_1010_d16o8_d16o8_d16o8_d16o8_Rd06_ADCabcd, 0); // updates &adca, &adcb, &adcc, &adcd
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Menu item 'GA'
// Write AGain register
//
// @param[in] gain 2's complement, 0x800=0.25V/V, 0x1000=0.5V/V, 0x2000=1V/V, 0x4000=2V/V, default=0x2000
//
// @return 1 on success; 0 on failure
uint8_t MAX11043::Write_AGain(uint32_t gain)
{
    
    //----------------------------------------
    // warning -- WIP work in progress
    #warning "Not Tested Yet: MAX11043::Write_AGain..."
    
    //----------------------------------------
    // write register
    RegWrite(CMD_0100_0100_d16_Wr11_AGain, gain);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Menu item 'XD'
// Example configuration.
// Slowest conversion rate 1:6 = 9us,
// Bypass PGA and filters, Gain=1V/V,
// AOUT = 2.0V
//
void MAX11043::Configure_Demo(void)
{
    
    //----------------------------------------
    // warning -- WIP work in progress
    #warning "Not Tested Yet: MAX11043::Configure_Demo..."
    
    //----------------------------------------
    // *Config=0x6000 (POR default, slowest conversion rate 1:6 = 9us)
    RegWrite(CMD_0010_0000_d16_Wr08_Configuration, 0x6000);
    
    //----------------------------------------
    // *ConfigA=0x0018 (Bypass PGA and filters, Gain=1V/V)
    RegWrite(CMD_0011_0000_d16_Wr0C_ConfigA, 0x0018);
    
    //----------------------------------------
    // *AGain=0x1000 (0.5) (default is 0x2000=1.0)
    RegWrite(CMD_0100_0100_d16_Wr11_AGain, 0x1000);
    
    //----------------------------------------
    // *ConfigB=0x0018 (Bypass PGA and filters, Gain=1V/V)
    RegWrite(CMD_0011_0100_d16_Wr0D_ConfigB, 0x0018);
    
    //----------------------------------------
    // *BGain=0x1000 (0.5) (default is 0x2000=1.0)
    RegWrite(CMD_0100_1000_d16_Wr12_BGain, 0x1000);
    
    //----------------------------------------
    // *ConfigC=0x0018 (Bypass PGA and filters, Gain=1V/V)
    RegWrite(CMD_0011_1000_d16_Wr0E_ConfigC, 0x0018);
    
    //----------------------------------------
    // *CGain=0x1000 (0.5) (default is 0x2000=1.0)
    RegWrite(CMD_0100_1100_d16_Wr13_CGain, 0x1000);
    
    //----------------------------------------
    // *ConfigD=0x0018 (Bypass PGA and filters, Gain=1V/V)
    RegWrite(CMD_0011_1100_d16_Wr0F_ConfigD, 0x0018);
    
    //----------------------------------------
    // *DGain=0x1000 (0.5) (default is 0x2000=1.0)
    RegWrite(CMD_0101_0000_d16_Wr14_DGain, 0x1000);
    
    //----------------------------------------
    // *DacHDacL=0xFF00 (DAC code 0xFFF fullscale 2.5V, DAC code 0x000 lowest 0V)
    RegWrite(CMD_0010_1100_d16_Wr0B_DACHDACL, 0xFF00);
    
    //----------------------------------------
    // *DacStep=0x0001 (DAC increment value triggered by DACSTEP pin)
    RegWrite(CMD_0010_1000_d16_Wr0A_DACStep, 0x0001);
    
    //----------------------------------------
    // *Dac=0x0ccc (AOUT=2V)
    RegWrite(CMD_0010_0100_d16_Wr09_DAC, 0x0ccc);
}

//----------------------------------------
// Menu item 'XX'
//
// @return 1 on success; 0 on failure
uint8_t MAX11043::Configure_XXXXX(uint8_t linef, uint8_t rate)
{
    
    //----------------------------------------
    // warning -- WIP work in progress
    #warning "Not Tested Yet: MAX11043::Configure_XXXXX..."
    
    //----------------------------------------
    // read register
    RegRead(CMD_0000_0010_d16o8_Rd00_ADCa, 0); // updates &adca
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Menu item 'XY'
//
// @return 1 on success; 0 on failure
uint8_t MAX11043::Configure_XXXXY(uint8_t linef, uint8_t rate)
{
    
    //----------------------------------------
    // warning -- WIP work in progress
    #warning "Not Tested Yet: MAX11043::Configure_XXXXY..."
    
    //----------------------------------------
    // read register
    RegRead(CMD_0001_1110_d8_Rd07_Status, 0); // udpates &status
    
    //----------------------------------------
    // success
    return 1;
}


// End of file
