// /*******************************************************************************
// * Copyright (C) 2020 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
// *********************************************************************
// @file MAX11043.h
// *********************************************************************
// Header file
// DO NOT EDIT; except areas designated "CUSTOMIZE". Automatically generated file. * MANUAL EDITS PRESENT *
// generated by XMLSystemOfDevicesToMBED.py
// System Name = ExampleSystem
// System Description = Device driver example
// Device Name = MAX11043
// Device Description = 200ksps, Low-Power, Serial SPI 24-Bit, 4-Channel, Differential/Single-Ended Input, Simultaneous-Sampling SD ADC
// Device DeviceBriefDescription = 24-bit 200ksps Delta-Sigma ADC
// Device Manufacturer = Maxim Integrated
// Device PartNumber = MAX11043ATL+
// Device RegValue_Width = DataWidth16bit_HL
//
// ADC MaxOutputDataRate = 200ksps
// ADC NumChannels = 4
// ADC ResolutionBits = 24
//
// SPI CS = ActiveLow
// SPI FrameStart = CS
// SPI CPOL = 0
// SPI CPHA = 0
// SPI MOSI and MISO Data are both stable on Rising edge of SCLK
// SPI SCLK Idle Low
// SPI SCLKMaxMHz = 40
// SPI SCLKMinMHz = 0
//


// Prevent multiple declaration
#ifndef __MAX11043_H__
#define __MAX11043_H__

//--------------------------------------------------
// MAX11043 ADC Read operations must be synchronized to EOC End Of Conversion
// EOC# asserts low when new data is available.
// Initiate a data read prior to the next rising edge of EOC# or the result is overwritten.
#ifndef MAX11043_EOC_INTERRUPT_POLLING
#define MAX11043_EOC_INTERRUPT_POLLING 1
#endif // MAX11043_EOC_INTERRUPT_POLLING
//--------------------------------------------------
// MAX11043 ADC Read operations must be synchronized to EOC End Of Conversion
// EOC# asserts low when new data is available.
// Initiate a data read prior to the next rising edge of EOC# or the result is overwritten.
#if MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input should be InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
// Workaround using DigitalIn(PinName:EOC_pin) polled to sync with EOC falling edge for ADC reads
// 2020-02-20 MAX11043_EOC_INTERRUPT_POLLING works on MAX32625MBED at 9us conversion rate, with 1us timing margin
#else // MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input is InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
#endif // MAX11043_EOC_INTERRUPT_POLLING
//--------------------------------------------------

// standard include for target platform -- Platform_Include_Boilerplate
#include "mbed.h"
// Platforms:
//   - MAX32625MBED
//      - supports mbed-os-5.11, requires USBDevice library
//      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32600MBED
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
//   - NUCLEO_F446RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - NUCLEO_F401RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32630FTHR
//      - #include "max32630fthr.h"
//      - add http://os.mbed.org/teams/MaximIntegrated/code/max32630fthr/
//      - remove MAX32620FTHR library (if present)
//   - MAX32620FTHR
//      - #include "MAX32620FTHR.h"
//      - remove max32630fthr library (if present)
//      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
//      - not tested yet
//   - MAX32625PICO
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - not tested yet
//
// end Platform_Include_Boilerplate

// CODE GENERATOR: conditional defines
// CODE GENERATOR: class declaration and docstrings
/**
 * @brief MAX11043 200ksps, Low-Power, Serial SPI 24-Bit, 4-Channel, Differential/Single-Ended Input, Simultaneous-Sampling SD ADC
 *
 *
 *
 * Datasheet: https://www.maximintegrated.com/MAX11043
 *
 *
 *
 * //---------- CODE GENERATOR: helloCppCodeList
 * @code
 * // CODE GENERATOR: example code includes
 *
 * // example code includes
 * // standard include for target platform -- Platform_Include_Boilerplate
 * #include "mbed.h"
 * // Platforms:
 * //   - MAX32625MBED
 * //      - supports mbed-os-5.11, requires USBDevice library
 * //      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //   - MAX32600MBED
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
 * //   - NUCLEO_F446RE
 * //      - remove USBDevice library
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //   - NUCLEO_F401RE
 * //      - remove USBDevice library
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //   - MAX32630FTHR
 * //      - #include "max32630fthr.h"
 * //      - add http://os.mbed.org/teams/MaximIntegrated/code/max32630fthr/
 * //      - remove MAX32620FTHR library (if present)
 * //   - MAX32620FTHR
 * //      - #include "MAX32620FTHR.h"
 * //      - remove max32630fthr library (if present)
 * //      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
 * //      - not tested yet
 * //   - MAX32625PICO
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //      - not tested yet
 * //
 * // end Platform_Include_Boilerplate
 * #include "MAX11043.h"
 *
 * // example code board support
 * //MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
 * //DigitalOut rLED(LED1);
 * //DigitalOut gLED(LED2);
 * //DigitalOut bLED(LED3);
 * //
 * // Arduino "shield" connector port definitions (MAX32625MBED shown)
 * #if defined(TARGET_MAX32625MBED)
 * #define A0 AIN_0
 * #define A1 AIN_1
 * #define A2 AIN_2
 * #define A3 AIN_3
 * #define D0 P0_0
 * #define D1 P0_1
 * #define D2 P0_2
 * #define D3 P0_3
 * #define D4 P0_4
 * #define D5 P0_5
 * #define D6 P0_6
 * #define D7 P0_7
 * #define D8 P1_4
 * #define D9 P1_5
 * #define D10 P1_3
 * #define D11 P1_1
 * #define D12 P1_2
 * #define D13 P1_0
 * #endif
 *
 * // example code declare SPI interface
 * #if defined(TARGET_MAX32625MBED)
 * // SPI spi(SPI1_MOSI, SPI1_MISO, SPI1_SCK); // mosi, miso, sclk spi1 TARGET_MAX32625MBED: P1_1 P1_2 P1_0 Arduino 10-pin header D11 D12 D13 D10
 * // DigitalOut spi_cs(SPI1_SS); // TARGET_MAX32625MBED: not connected
 * // Support SPI hardware-controlled CS instead of GPIO CS (mbed)
 * // 2020-02-19 MAX32625MBED GPIO CS envelope is 23us (11.4us before SCLK and 8.6us after SCLK).
 * // 2020-02-19 MAX32625MBED SPI controlled CS envelope 4 channel read reduced to 4.2us (24MHz SCLK), 1.2us setup, 0us hold.
 * // 2020-02-19 MAX11043 slowest EOC rate is 9us.
 * SPI spi(SPI1_MOSI, SPI1_MISO, SPI1_SCK, SPI1_SS); // mosi, miso, sclk spi1 TARGET_MAX32625MBED: P1_1 P1_2 P1_0 Arduino 10-pin header D11 D12 D13 D10
 * DigitalOut spi_cs(NC); // TARGET_MAX32625MBED: not connected
 * // PinName NC means NOT_CONNECTED; DigitalOut::is_connected() returns false
 * // add m_cs_pin.is_connected() guard before writing m_cs_pin = m_SPI_cs_state
 * // to avoid runtime error Assertion failed: obj->name != (PinName)NC
 * #elif defined(TARGET_MAX32600MBED)
 * SPI spi(SPI2_MOSI, SPI2_MISO, SPI2_SCK); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(SPI2_SS); // Generic: Arduino 10-pin header D10
 * #else
 * SPI spi(D11, D12, D13); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(D10); // Generic: Arduino 10-pin header D10
 * #endif
 *
 * // example code declare GPIO interface pins
 * DigitalOut CONVRUN_pin(D9); // Digital Configuration Input to MAX11043 device
 * DigitalOut SHDN_pin(D8); // Digital Configuration Input to MAX11043 device
 * DigitalOut DACSTEP_pin(D7); // Digital Configuration Input to MAX11043 device
 * DigitalOut UP_slash_DWNb_pin(D6); // Digital Configuration Input to MAX11043 device
 * DigitalIn EOC_pin(D2); // Digital Event Output from MAX11043 device
 * // example code declare device instance
 * MAX11043 g_MAX11043_device(spi, spi_cs, CONVRUN_pin, SHDN_pin, DACSTEP_pin, UP_slash_DWNb_pin, EOC_pin, MAX11043::MAX11043_IC);
 *
 * // CODE GENERATOR: example code for ADC: serial port declaration
 * //--------------------------------------------------
 * // Declare the Serial driver
 * // default baud rate settings are 9600 8N1
 * // install device driver from http://developer.mbed.org/media/downloads/drivers/mbedWinSerial_16466.exe
 * // see docs https://docs.mbed.com/docs/mbed-os-handbook/en/5.5/getting_started/what_need/
 * #if defined(TARGET_MAX32630)
 *     #include "USBSerial.h"
 * // Hardware serial port over DAPLink
 * // The default baud rate for the DapLink UART is 9600
 * //Serial DAPLINKserial(P2_1, P2_0);     // tx, rx
 * //    #define HAS_DAPLINK_SERIAL 1
 * // Virtual serial port over USB
 * // The baud rate does not affect the virtual USBSerial UART.
 * USBSerial serial;
 * //--------------------------------------------------
 * #elif defined(TARGET_MAX32625MBED)
 *     #include "USBSerial.h"
 * // Hardware serial port over DAPLink
 * // The default baud rate for the DapLink UART is 9600
 * //Serial DAPLINKserial(P2_1, P2_0);     // tx, rx
 * //    #define HAS_DAPLINK_SERIAL 1
 * // Virtual serial port over USB
 * // The baud rate does not affect the virtual USBSerial UART.
 * USBSerial serial;
 * //--------------------------------------------------
 * #elif defined(TARGET_MAX32600)
 *     #include "USBSerial.h"
 * // Hardware serial port over DAPLink
 * // The default baud rate for the DapLink UART is 9600
 * Serial DAPLINKserial(P1_1, P1_0);     // tx, rx
 *     #define HAS_DAPLINK_SERIAL 1
 * // Virtual serial port over USB
 * // The baud rate does not affect the virtual USBSerial UART.
 * USBSerial serial;
 * //--------------------------------------------------
 * #elif defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F401RE)
 * Serial serial(SERIAL_TX, SERIAL_RX);     // tx, rx
 * //--------------------------------------------------
 * #else
 * #if defined(SERIAL_TX)
 * #warning "target not previously tested; guess serial pins are SERIAL_TX, SERIAL_RX..."
 * Serial serial(SERIAL_TX, SERIAL_RX);     // tx, rx
 * #elif defined(USBTX)
 * #warning "target not previously tested; guess serial pins are USBTX, USBRX..."
 * Serial serial(USBTX, USBRX);     // tx, rx
 * #elif defined(UART_TX)
 * #warning "target not previously tested; guess serial pins are UART_TX, UART_RX..."
 * Serial serial(UART_TX, UART_RX);     // tx, rx
 * #else
 * #warning "target not previously tested; need to define serial pins..."
 * #endif
 * #endif
 * //
 * #include "CmdLine.h"
 * CmdLine cmdLine(serial, "serial");
 *
 * // example code main function
 * int main()
 * {
 *     // CODE GENERATOR: example code: member function Init
 *     g_MAX11043_device.Init();
 *
 *     while (1)
 *     {
 *         // CODE GENERATOR: example code: has no member function REF
 *         // CODE GENERATOR: example code for ADC: repeat-forever convert and print conversion result, one record per line
 *         // CODE GENERATOR: ResolutionBits = 24
 *         // CODE GENERATOR: FScode = None
 *         // CODE GENERATOR: NumChannels = 4
 *         while(1) { // this code repeats forever
 *             // this code repeats forever
 *             // CODE GENERATOR: example code: has no member function ScanStandardExternalClock
 *             // CODE GENERATOR: example code: has no member function ReadAINcode
 *             // wait(3.0);
 *             // CODE GENERATOR: print conversion result
 *             // Use Arduino Serial Plotter to view output: Tools | Serial Plotter
 *             cmdLine.serial().printf("%d", g_MAX11043_device.AINcode[0]);
 *             for (int index = 1; index <= channelId_0_3; index++) {
 *                 cmdLine.serial().printf(",%d", g_MAX11043_device.AINcode[index]);
 *             }
 *             cmdLine.serial().printf("\r\n");
 *
 *         } // this code repeats forever
 *     }
 * }
 * @endcode
 * //---------- CODE GENERATOR: end helloCppCodeList
 */
class MAX11043 {
public:
// CODE GENERATOR: TypedefEnum EnumItem declarations
// CODE GENERATOR: TypedefEnum MAX11043_CMDOP_enum_t
    //----------------------------------------
    /// Command Operation Format (see function DecodeCommand)
    ///
    /// Naming convention is CMDOP_bitstream_OPERATION_NAME
    /// - 0aaa_aax0 = 5-bit register address field
    /// - 0xxx_xxr0 = read/write bit (1=read, 0=write)
    /// - xxxx = don't care
    typedef enum MAX11043_CMDOP_enum_t {
        CMDOP_0aaa_aa00_WriteRegister = 0x00, //!< 8'b00000000
        CMDOP_0aaa_aa10_ReadRegister = 0x02, //!< 8'b00000010
        CMDOP_1111_1111_NoOperationMOSIidleHigh = 0xff, //!< 8'b11111111
    } MAX11043_CMDOP_enum_t;

// CODE GENERATOR: TypedefEnum MAX11043_CMD_enum_t
    //----------------------------------------
    /// Register Addresses
    ///
    /// Naming convention is CMD_bitstream_WrAddr_FunctionName
    /// - first byte format is 0aaa_aar0
    /// - 0 = bitstream required 0 bit
    /// - aaa_aa = bitstream 5-bit register address field
    /// - r = bitstream read/write bit (1=read, 0=write)
    /// - WrAddr = Write operation to address Addr
    /// - RdAddr = Read operation from address Addr
    /// - d8 = 8-bit register data field
    /// - d16 = 16-bit register data field
    /// - d16o8 = 16-bit or 24-bit register data field
    /// - d24 = 24-bit register data field
    /// - d32 = 32-bit register data field
    /// - x = don't care
    typedef enum MAX11043_CMD_enum_t {
        CMD_0000_0010_d16o8_Rd00_ADCa = 0x02, //!< 8'b00000010
        CMD_0000_0110_d16o8_Rd01_ADCb = 0x06, //!< 8'b00000110
        CMD_0000_1010_d16o8_Rd02_ADCc = 0x0a, //!< 8'b00001010
        CMD_0000_1110_d16o8_Rd03_ADCd = 0x0e, //!< 8'b00001110
        CMD_0001_0010_d16o8_d16o8_Rd04_ADCab = 0x12, //!< 8'b00010010
        CMD_0001_0110_d16o8_d16o8_Rd05_ADCcd = 0x16, //!< 8'b00010110
        CMD_0001_1010_d16o8_d16o8_d16o8_d16o8_Rd06_ADCabcd = 0x1a, //!< 8'b00011010
        CMD_0001_1110_d8_Rd07_Status = 0x1e, //!< 8'b00011110
        CMD_0010_0000_d16_Wr08_Configuration = 0x20, //!< 8'b00100000
        CMD_0010_0010_d16_Rd08_Configuration = 0x22, //!< 8'b00100010
        CMD_0010_0100_d16_Wr09_DAC = 0x24, //!< 8'b00100100
        CMD_0010_0110_d16_Rd09_DAC = 0x26, //!< 8'b00100110
        CMD_0010_1000_d16_Wr0A_DACStep = 0x28, //!< 8'b00101000
        CMD_0010_1010_d16_Rd0A_DACStep = 0x2a, //!< 8'b00101010
        CMD_0010_1100_d16_Wr0B_DACHDACL = 0x2c, //!< 8'b00101100
        CMD_0010_1110_d16_Rd0B_DACHDACL = 0x2e, //!< 8'b00101110
        CMD_0011_0000_d16_Wr0C_ConfigA = 0x30, //!< 8'b00110000
        CMD_0011_0010_d16_Rd0C_ConfigA = 0x32, //!< 8'b00110010
        CMD_0011_0100_d16_Wr0D_ConfigB = 0x34, //!< 8'b00110100
        CMD_0011_0110_d16_Rd0D_ConfigB = 0x36, //!< 8'b00110110
        CMD_0011_1000_d16_Wr0E_ConfigC = 0x38, //!< 8'b00111000
        CMD_0011_1010_d16_Rd0E_ConfigC = 0x3a, //!< 8'b00111010
        CMD_0011_1100_d16_Wr0F_ConfigD = 0x3c, //!< 8'b00111100
        CMD_0011_1110_d16_Rd0F_ConfigD = 0x3e, //!< 8'b00111110
        CMD_0100_0000_d16_Wr10_Reference = 0x40, //!< 8'b01000000
        CMD_0100_0010_d16_Rd10_Reference = 0x42, //!< 8'b01000010
        CMD_0100_0100_d16_Wr11_AGain = 0x44, //!< 8'b01000100
        CMD_0100_0110_d16_Rd11_AGain = 0x46, //!< 8'b01000110
        CMD_0100_1000_d16_Wr12_BGain = 0x48, //!< 8'b01001000
        CMD_0100_1010_d16_Rd12_BGain = 0x4a, //!< 8'b01001010
        CMD_0100_1100_d16_Wr13_CGain = 0x4c, //!< 8'b01001100
        CMD_0100_1110_d16_Rd13_CGain = 0x4e, //!< 8'b01001110
        CMD_0101_0000_d16_Wr14_DGain = 0x50, //!< 8'b01010000
        CMD_0101_0010_d16_Rd14_DGain = 0x52, //!< 8'b01010010
        CMD_0101_0100_d8_Wr15_FilterCAddress = 0x54, //!< 8'b01010100
        CMD_0101_0110_d8_Rd15_FilterCAddress = 0x56, //!< 8'b01010110
        CMD_0101_1000_d32_Wr16_FilterCDataOut = 0x58, //!< 8'b01011000
        CMD_0101_1010_d32_Rd16_FilterCDataOut = 0x5a, //!< 8'b01011010
        CMD_0101_1100_d32_Wr17_FilterCDataIn = 0x5c, //!< 8'b01011100
        CMD_0101_1110_d32_Rd17_FilterCDataIn = 0x5e, //!< 8'b01011110
        CMD_0110_0000_d8_Wr18_FlashMode = 0x60, //!< 8'b01100000
        CMD_0110_0010_d8_Rd18_FlashMode = 0x62, //!< 8'b01100010
        CMD_0110_0100_d16_Wr19_FlashAddr = 0x64, //!< 8'b01100100
        CMD_0110_0110_d16_Rd19_FlashAddr = 0x66, //!< 8'b01100110
        CMD_0110_1000_d16_Wr1A_FlashDataIn = 0x68, //!< 8'b01101000
        CMD_0110_1010_d16_Rd1A_FlashDataIn = 0x6a, //!< 8'b01101010
        CMD_0110_1110_d16_Rd1B_FlashDataOut = 0x6e, //!< 8'b01101110
    } MAX11043_CMD_enum_t;

// CODE GENERATOR: TypedefEnum MAX11043_STATUS_enum_t
    //----------------------------------------
    /// CMD_0001_1110_d8_Rd07_Status regAddr=07h
    /// Status: x x FlashBusy BOOT OFLGA OFLGB OFLGC OFLGD
    typedef enum MAX11043_STATUS_enum_t {
        STATUS_xxxx_xxx1_OverflowFlagOFLGD = 0x01, //!< 8'b00000001
        STATUS_xxxx_xx1x_OverflowFlagOFLGC = 0x02, //!< 8'b00000010
        STATUS_xxxx_x1xx_OverflowFlagOFLGB = 0x04, //!< 8'b00000100
        STATUS_xxxx_1xxx_OverflowFlagOFLGA = 0x08, //!< 8'b00001000
        STATUS_xxx1_xxxx_PowerOnResetBOOT = 0x10, //!< 8'b00010000
        STATUS_xx1x_xxxx_FlashBusy = 0x20, //!< 8'b00100000
        STATUS_x1xx_xxxx_RESERVED = 0x40, //!< 8'b01000000
        STATUS_1xxx_xxxx_RESERVED = 0x80, //!< 8'b10000000
    } MAX11043_STATUS_enum_t;

// CODE GENERATOR: TypedefEnum MAX11043_CONFIG_enum_t
    //----------------------------------------
    /// CMD_0010_0000_d16_Wr08_Configuration regAddr=08h
    /// Config: EXTCLK CLKDIV1 CLKDIV0 PD PDA PDB PDC PDD PDDAC PDOSC 24BIT SCHANA SCHANB SCHANC SCHAND DECSEL
    typedef enum MAX11043_CONFIG_enum_t {
        CONFIG_xxxx_xxxx_xxxx_xxx1_DECSEL12 = 0x0001, //!< 16'b0000000000000001
        CONFIG_xxxx_xxxx_xxxx_xx1x_SCHAND = 0x0002, //!< 16'b0000000000000010
        CONFIG_xxxx_xxxx_xxxx_x1xx_SCHANC = 0x0004, //!< 16'b0000000000000100
        CONFIG_xxxx_xxxx_xxxx_1xxx_SCHANB = 0x0008, //!< 16'b0000000000001000
        CONFIG_xxxx_xxxx_xxx1_xxxx_SCHANA = 0x0010, //!< 16'b0000000000010000
        CONFIG_xxxx_xxxx_xx1x_xxxx_24BIT = 0x0020, //!< 16'b0000000000100000
        CONFIG_xxxx_xxxx_x1xx_xxxx_PDOSC = 0x0040, //!< 16'b0000000001000000
        CONFIG_xxxx_xxxx_1xxx_xxxx_PDDAC = 0x0080, //!< 16'b0000000010000000
        CONFIG_xxxx_xxx1_xxxx_xxxx_PDD = 0x0100, //!< 16'b0000000100000000
        CONFIG_xxxx_xx1x_xxxx_xxxx_PDC = 0x0200, //!< 16'b0000001000000000
        CONFIG_xxxx_x1xx_xxxx_xxxx_PDB = 0x0400, //!< 16'b0000010000000000
        CONFIG_xxxx_1xxx_xxxx_xxxx_PDA = 0x0800, //!< 16'b0000100000000000
        CONFIG_xxx1_xxxx_xxxx_xxxx_PD = 0x1000, //!< 16'b0001000000000000
        CONFIG_xx1x_xxxx_xxxx_xxxx_CLKDIV0 = 0x2000, //!< 16'b0010000000000000
        CONFIG_x1xx_xxxx_xxxx_xxxx_CLKDIV1 = 0x4000, //!< 16'b0100000000000000
        CONFIG_1xxx_xxxx_xxxx_xxxx_EXTCLK = 0x8000, //!< 16'b1000000000000000
    } MAX11043_CONFIG_enum_t;

// CODE GENERATOR: TypedefEnum MAX11043_CONFIGABCD_enum_t
    //----------------------------------------
    /// CMD_0011_0000_d16_Wr0C_ConfigA regAddr=0Ch
    /// CMD_0011_0100_d16_Wr0D_ConfigB regAddr=0Dh
    /// CMD_0011_1000_d16_Wr0E_ConfigC regAddr=0Eh
    /// CMD_0011_1100_d16_Wr0F_ConfigD regAddr=0Fh
    /// ConfigABCD: x x x BDAC[3:0] DIFF EQ MODG[1:0] PDPGA FILT PGAG ENBIASP ENBIASN
    typedef enum MAX11043_CONFIGABCD_enum_t {
        CONFIGABCD_xxxx_xxxx_xxxx_xxx1_ENBIASN = 0x0001, //!< 16'b0000000000000001
        CONFIGABCD_xxxx_xxxx_xxxx_xx1x_ENBIASP = 0x0002, //!< 16'b0000000000000010
        CONFIGABCD_xxxx_xxxx_xxxx_x1xx_PGAG16 = 0x0004, //!< 16'b0000000000000100
        CONFIGABCD_xxxx_xxxx_xxxx_1xxx_FILTLP = 0x0008, //!< 16'b0000000000001000
        CONFIGABCD_xxxx_xxxx_xxx1_xxxx_PDPGA = 0x0010, //!< 16'b0000000000010000
        CONFIGABCD_xxxx_xxxx_xx1x_xxxx_MODG0 = 0x0020, //!< 16'b0000000000100000
        CONFIGABCD_xxxx_xxxx_x1xx_xxxx_MODG1 = 0x0040, //!< 16'b0000000001000000
        CONFIGABCD_xxxx_xxxx_1xxx_xxxx_EQ = 0x0080, //!< 16'b0000000010000000
        CONFIGABCD_xxxx_xxx1_xxxx_xxxx_DIFF = 0x0100, //!< 16'b0000000100000000
        CONFIGABCD_xxxx_xx1x_xxxx_xxxx_BDAC0 = 0x0200, //!< 16'b0000001000000000
        CONFIGABCD_xxxx_x1xx_xxxx_xxxx_BDAC1 = 0x0400, //!< 16'b0000010000000000
        CONFIGABCD_xxxx_1xxx_xxxx_xxxx_BDAC2 = 0x0800, //!< 16'b0000100000000000
        CONFIGABCD_xxx1_xxxx_xxxx_xxxx_BDAC3 = 0x1000, //!< 16'b0001000000000000
        CONFIGABCD_xx1x_xxxx_xxxx_xxxx_RESERVED = 0x2000, //!< 16'b0010000000000000
        CONFIGABCD_x1xx_xxxx_xxxx_xxxx_RESERVED = 0x4000, //!< 16'b0100000000000000
        CONFIGABCD_1xxx_xxxx_xxxx_xxxx_RESERVED = 0x8000, //!< 16'b1000000000000000
    } MAX11043_CONFIGABCD_enum_t;

// CODE GENERATOR: TypedefEnum MAX11043_BDAC_enum_t
    //----------------------------------------
    /// CMD_0011_0000_d16_Wr0C_ConfigA regAddr=0Ch
    /// CMD_0011_0100_d16_Wr0D_ConfigB regAddr=0Dh
    /// CMD_0011_1000_d16_Wr0E_ConfigC regAddr=0Eh
    /// CMD_0011_1100_d16_Wr0F_ConfigD regAddr=0Fh
    ///
    /// CONFIGABCD_xxx1_xxxx_xxxx_xxxx_BDAC3
    /// CONFIGABCD_xxxx_1xxx_xxxx_xxxx_BDAC2
    /// CONFIGABCD_xxxx_x1xx_xxxx_xxxx_BDAC1
    /// CONFIGABCD_xxxx_xx1x_xxxx_xxxx_BDAC0
    /// Sets the input bias voltage for AC-coupled signals when ENBIAS_ is set to 1.
    /// ConfigABCD: x x x BDAC[3:0] DIFF EQ MODG[1:0] PDPGA FILT PGAG ENBIASP ENBIASN
    typedef enum MAX11043_BDAC_enum_t {
        BDAC_0000_033pctAVDD = 0x00, //!< 8'b00000000
        BDAC_0001_035pctAVDD = 0x01, //!< 8'b00000001
        BDAC_0010_038pctAVDD = 0x02, //!< 8'b00000010
        BDAC_0011_040pctAVDD = 0x03, //!< 8'b00000011
        BDAC_0100_042pctAVDD = 0x04, //!< 8'b00000100
        BDAC_0101_044pctAVDD = 0x05, //!< 8'b00000101
        BDAC_0110_046pctAVDD = 0x06, //!< 8'b00000110
        BDAC_0111_048pctAVDD = 0x07, //!< 8'b00000111
        BDAC_1000_050pctAVDD = 0x08, //!< 8'b00001000
        BDAC_1001_052pctAVDD = 0x09, //!< 8'b00001001
        BDAC_1010_054pctAVDD = 0x0a, //!< 8'b00001010
        BDAC_1011_056pctAVDD = 0x0b, //!< 8'b00001011
        BDAC_1100_058pctAVDD = 0x0c, //!< 8'b00001100
        BDAC_1101_060pctAVDD = 0x0d, //!< 8'b00001101
        BDAC_1110_062pctAVDD = 0x0e, //!< 8'b00001110
        BDAC_1111_065pctAVDD = 0x0f, //!< 8'b00001111
    } MAX11043_BDAC_enum_t;

// CODE GENERATOR: TypedefEnum MAX11043_REFERENCE_enum_t
    //----------------------------------------
    /// CMD_0100_0000_d16_Wr10_Reference regAddr=10h
    /// ReferenceDelay: 0 0 0 PURGE[4:0] EXTREF EXBUFA EXBUFB EXBUFC EXBUFD EXBUFDAC EXBUFDACH EXBUFDACL
    typedef enum MAX11043_REFERENCE_enum_t {
        REFERENCE_xxxx_xxxx_xxxx_xxx1_EXBUFDACL = 0x0001, //!< 16'b0000000000000001
        REFERENCE_xxxx_xxxx_xxxx_xx1x_EXBUFDACH = 0x0002, //!< 16'b0000000000000010
        REFERENCE_xxxx_xxxx_xxxx_x1xx_EXBUFDAC = 0x0004, //!< 16'b0000000000000100
        REFERENCE_xxxx_xxxx_xxxx_1xxx_EXBUFD = 0x0008, //!< 16'b0000000000001000
        REFERENCE_xxxx_xxxx_xxx1_xxxx_EXBUFC = 0x0010, //!< 16'b0000000000010000
        REFERENCE_xxxx_xxxx_xx1x_xxxx_EXBUFB = 0x0020, //!< 16'b0000000000100000
        REFERENCE_xxxx_xxxx_x1xx_xxxx_EXBUFA = 0x0040, //!< 16'b0000000001000000
        REFERENCE_xxxx_xxxx_1xxx_xxxx_EXTREF = 0x0080, //!< 16'b0000000010000000
        REFERENCE_xxxx_xxx1_xxxx_xxxx_PURGE0 = 0x0100, //!< 16'b0000000100000000
        REFERENCE_xxxx_xx1x_xxxx_xxxx_PURGE1 = 0x0200, //!< 16'b0000001000000000
        REFERENCE_xxxx_x1xx_xxxx_xxxx_PURGE2 = 0x0400, //!< 16'b0000010000000000
        REFERENCE_xxxx_1xxx_xxxx_xxxx_PURGE3 = 0x0800, //!< 16'b0000100000000000
        REFERENCE_xxx1_xxxx_xxxx_xxxx_PURGE4 = 0x1000, //!< 16'b0001000000000000
        REFERENCE_xx1x_xxxx_xxxx_xxxx_RESERVED = 0x2000, //!< 16'b0010000000000000
        REFERENCE_x1xx_xxxx_xxxx_xxxx_RESERVED = 0x4000, //!< 16'b0100000000000000
        REFERENCE_1xxx_xxxx_xxxx_xxxx_RESERVED = 0x8000, //!< 16'b1000000000000000
    } MAX11043_REFERENCE_enum_t;

// TODO1: CODE GENERATOR: ic_variant -- IC's supported with this driver
    /**
     * @brief IC's supported with this driver
     * @details MAX11043
     */
    typedef enum
    {
        MAX11043_IC = 0,
        //MAX11043_IC = 1
    } MAX11043_ic_t;

// TODO1: CODE GENERATOR: class constructor declaration
    /**********************************************************//**
    * @brief Constructor for MAX11043 Class.
    *
    * @details Requires an existing SPI object as well as a DigitalOut object.
    * The DigitalOut object is used for a chip enable signal
    *
    * On Entry:
    *     @param[in] spi - pointer to existing SPI object
    *     @param[in] cs_pin - pointer to a DigitalOut pin object
    *     CODE GENERATOR: class constructor docstrings gpio InputPin pins
    *     @param[in] CONVRUN_pin - pointer to a DigitalOut pin object
    *     @param[in] SHDN_pin - pointer to a DigitalOut pin object
    *     @param[in] DACSTEP_pin - pointer to a DigitalOut pin object
    *     @param[in] UP_slash_DWNb_pin - pointer to a DigitalOut pin object
    *     CODE GENERATOR: class constructor docstrings gpio OutputPin pins
    *     @param[in] EOC_pin - pointer to a DigitalIn pin object
    *     @param[in] ic_variant - which type of MAX11043 is used
    *
    * On Exit:
    *
    * @return None
    **************************************************************/
    MAX11043(SPI &spi, DigitalOut &cs_pin, // SPI interface
            // CODE GENERATOR: class constructor declaration gpio InputPin pins
            DigitalOut &CONVRUN_pin, // Digital Configuration Input to MAX11043 device
            DigitalOut &SHDN_pin, // Digital Configuration Input to MAX11043 device
            DigitalOut &DACSTEP_pin, // Digital Configuration Input to MAX11043 device
            DigitalOut &UP_slash_DWNb_pin, // Digital Configuration Input to MAX11043 device
            // CODE GENERATOR: class constructor declaration gpio OutputPin pins
// MAX11043 ADC Read operations must be synchronized to EOC End Of Conversion
#if MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input should be InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
// Workaround using DigitalIn(PinName:EOC_pin) polled to sync with EOC falling edge for ADC reads
// TODO: onEOCFallingEdge: replace DigitalIn &EOC_pin with PinName EOC_pin, so that I can create an InterruptIn(PinName:EOC_pin)
            DigitalIn &EOC_pin, // Digital Event Output from MAX11043 device
#else // MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input is InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
            InterruptIn &EOC_pin, // Digital Event Output from MAX11043 device
#endif // MAX11043_EOC_INTERRUPT_POLLING
            MAX11043_ic_t ic_variant);

// CODE GENERATOR: class destructor declaration
    /************************************************************
     * @brief Default destructor for MAX11043 Class.
     *
     * @details Destroys SPI object if owner
     *
     * On Entry:
     *
     * On Exit:
     *
     * @return None
     **************************************************************/
    ~MAX11043();

    // CODE GENERATOR: Declare SPI diagnostic function pointer void onSPIprint()
    /// Function pointer void f(size_t byteCount, uint8_t mosiData[], uint8_t misoData[])
    Callback<void(size_t, uint8_t*, uint8_t*)> onSPIprint; //!< optional @ref onSPIprint SPI diagnostic function

    // CODE GENERATOR: spi_frequency setter declaration
    /// set SPI SCLK frequency
    void spi_frequency(int spi_sclk_Hz);

    // CODE GENERATOR: spi_frequency getter declaration and definition
    /// get SPI SCLK frequency
    int get_spi_frequency() const { return m_SPI_SCLK_Hz; }

    // CODE GENERATOR: spi_dataMode getter declaration and definition
    /// get SPI mode
    int get_spi_dataMode() const { return m_SPI_dataMode; }

//----------------------------------------
// CODE GENERATOR: omit typedef enum MAX11043_device_t, class members instead of global device object
public:

    /// reference voltage, in Volts
    double VRef;

    /// shadow of register config CMD_0010_0010_d16_Rd08_Configuration
    uint16_t config;

    /// shadow of register status CMD_0001_1110_d8_Rd07_Status
    uint8_t status;

    /// shadow of register ADCa CMD_0000_0010_d16o8_Rd00_ADCa
    int adca;

    /// shadow of register ADCb CMD_0000_0110_d16o8_Rd01_ADCb
    int adcb;

    /// shadow of register ADCc CMD_0000_1010_d16o8_Rd02_ADCc
    int adcc;

    /// shadow of register ADCd CMD_0000_1110_d16o8_Rd03_ADCd
    int adcd;

// CODE GENERATOR: omit global g_MAX11043_device

// CODE GENERATOR: extern function declarations
// CODE GENERATOR: extern function declaration SPIoutputCS
//----------------------------------------
// Assert SPI Chip Select
// SPI chip-select for MAX11043
//
    void SPIoutputCS(int isLogicHigh);

// CODE GENERATOR: extern function declaration SPIreadWriteWithLowCS
//----------------------------------------
// SPI read and write arbitrary number of 8-bit bytes
// SPI interface to MAX11043 shift mosiData into MAX11043 DIN
// while simultaneously capturing miso data from MAX11043 DOUT
//
    int SPIreadWriteWithLowCS(size_t byteCount, uint8_t mosiData[], uint8_t misoData[]);

// CODE GENERATOR: extern function declaration SHDNoutputValue
//----------------------------------------
// Assert MAX11043 SHDN pin : High = Shut Down, Low = Normal Operation.
//
    void SHDNoutputValue(int isLogicHigh);

// CODE GENERATOR: extern function declaration CONVRUNoutputValue
//----------------------------------------
// Assert MAX11043 CONVRUN pin : High = start continuous conversions on all 4 channels, Low = Idle.
//
    void CONVRUNoutputValue(int isLogicHigh);

// CODE GENERATOR: extern function declaration CONVRUNoutputGetValue
//----------------------------------------
// Return the state being driven onto the MAX11043 CONVRUN pin.
//
    int CONVRUNoutputGetValue();

// CODE GENERATOR: extern function declaration DACSTEPoutputValue
//----------------------------------------
// Assert MAX11043 DACSTEP pin : High = Active, Low = Idle.
//
    void DACSTEPoutputValue(int isLogicHigh);

// CODE GENERATOR: extern function declaration UP_slash_DWNboutputValue
//----------------------------------------
// Assert MAX11043 UP_slash_DWNb pin : High = Up, Low = Down.
//
    void UP_slash_DWNboutputValue(int isLogicHigh);

// CODE GENERATOR: extern function declaration EOCinputWaitUntilLow
//----------------------------------------
// Wait for MAX11043 EOC pin low, indicating end of conversion.
// Required when using any of the InternalClock modes.
//
    void EOCinputWaitUntilLow();

// CODE GENERATOR: extern function declaration EOCinputValue
//----------------------------------------
// Return the status of the MAX11043 EOC pin.
//
    int EOCinputValue();

// CODE GENERATOR: class member data
private:
// CODE GENERATOR: class member data for SPI interface
    // SPI object
    SPI &m_spi;
    int m_SPI_SCLK_Hz;
    int m_SPI_dataMode;
    int m_SPI_cs_state;

    // Selector pin object
    DigitalOut &m_cs_pin;

// CODE GENERATOR: class member data for gpio InputPin pins
// InputPin Name = CONVRUN
// InputPin Description = CONVRUN (digital input). Convert Run. Drive high to start continuous conversions on all 4 channels. The device is idle when
// CONVRUN is low.
// InputPin Function = Configuration
    DigitalOut &m_CONVRUN_pin;
//
// InputPin Name = SHDN
// InputPin Description = Shutdown (digital input). Active-High Shutdown Input. Drive high to shut down the MAX11043.
// InputPin Function = Configuration
    DigitalOut &m_SHDN_pin;
//
// InputPin Name = DACSTEP
// InputPin Description = DACSTEP (digital input). DAC Step Input. Drive high to move the DAC output in the direction of UP/DWN on the next rising
// edge of the system clock.
// InputPin Function = Configuration
    DigitalOut &m_DACSTEP_pin;
//
// InputPin Name = UP/DWN#
// InputPin Description = UP/DWN# (digital input). DAC Step Direction Select. Drive high to step up, drive low to step down when DACSTEP is toggled.
// InputPin Function = Configuration
    DigitalOut &m_UP_slash_DWNb_pin;
//
// CODE GENERATOR: class member data for gpio OutputPin pins
// OutputPin Name = EOC
// OutputPin Description = End of Conversion Output. Active-Low End-of-Conversion Indicator. EOC asserts low to indicate that new data is ready.
// OutputPin Function = Event
//--------------------------------------------------
// MAX11043 ADC Read operations must be synchronized to EOC End Of Conversion
// EOC# asserts low when new data is available.
// Initiate a data read prior to the next rising edge of EOC# or the result is overwritten.
#if MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input should be InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
// Workaround using DigitalIn(PinName:EOC_pin) polled to sync with EOC falling edge for ADC reads
// 2020-02-20 MAX11043_EOC_INTERRUPT_POLLING works on MAX32625MBED at 9us conversion rate, with 1us timing margin
    DigitalIn &m_EOC_pin;
#else // MAX11043_EOC_INTERRUPT_POLLING
// MAX11043 EOC End Of Conversion input is InterruptIn(PinName:EOC_pin).fall(onEOCFallingEdge);
    InterruptIn &m_EOC_pin;
#endif // MAX11043_EOC_INTERRUPT_POLLING
//--------------------------------------------------
//

    // Identifies which IC variant is being used
    MAX11043_ic_t m_ic_variant;

public:

// CODE GENERATOR: class member function declarations
    //----------------------------------------
    /// Menu item '!'
    /// Initialize device
    /// @return 1 on success; 0 on failure
    uint8_t Init(void);

    //----------------------------------------
    /// Return the physical voltage corresponding to conversion result
    /// (conversion format is Bipolar mode, 2's complement)
    /// Does not perform any offset or gain correction.
    ///
    /// @pre CONFIG_xxxx_xxxx_xx1x_xxxx_24BIT is 0: 16-bit mode is configured
    /// @pre g_MAX11043_device.VRef = Voltage of REF input, in Volts
    /// @param[in] value_u24: raw 24-bit MAX11043 code (right justified).
    /// @return physical voltage corresponding to MAX11043 code.
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0x7FFF) expect 2.500 within 0.030 Full Scale
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0x7FFF) expect 2.500             Full Scale
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0x6666) expect 2.000             Two Volts
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0x6000) expect 1.875             75% Scale
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0x4000) expect 1.250             Mid Scale
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0x3333) expect 1.000             One Volt
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0x2000) expect 0.625             25% Scale
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0x051e) expect 0.100             100mV
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0x0000) expect 0.00000894069671  Three LSB
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0x0000) expect 0.00000596046447  Two LSB
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0x0000) expect 0.0000029802326   One LSB
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0x0000) expect 0.0               Zero Scale
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0xFFFF) expect -0.0000029802326  Negative One LSB
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0xFFFF) expect -0.0000059604644  Negative Two LSB
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0xFFFF) expect -0.0000089406967  Negative Three LSB
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0xFAE1) expect -0.100            Negative 100mV
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0xE000) expect -0.625            Negative 25% Scale
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0xCCCC) expect -1.000            Negative One Volt
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0xC000) expect -1.250            Negative Mid Scale
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0xA000) expect -1.875            Negative 75% Scale
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0x9999) expect -2.000            Negative Two Volts
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0x8000) expect -2.500            Negative Full Scale
    /// @test group BIP2C16 ADCVoltageOfCode_16bit(0x8000) expect -2.500            Negative Full Scale
    ///
    double ADCVoltageOfCode_16bit(uint32_t value_u16);

    //----------------------------------------
    /// Return the physical voltage corresponding to conversion result
    /// (conversion format is Bipolar mode, 2's complement)
    /// Does not perform any offset or gain correction.
    ///
    /// @pre CONFIG_xxxx_xxxx_xx1x_xxxx_24BIT is 1: 24-bit mode is configured
    /// @pre g_MAX11043_device.VRef = Voltage of REF input, in Volts
    /// @param[in] value_u24: raw 24-bit MAX11043 code (right justified).
    /// @return physical voltage corresponding to MAX11043 code.
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0x7FFFFF) expect 2.500 within 0.030 Full Scale
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0x7FFFFE) expect 2.500             Full Scale
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0x666666) expect 2.000             Two Volts
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0x600000) expect 1.875             75% Scale
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0x400000) expect 1.250             Mid Scale
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0x333333) expect 1.000             One Volt
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0x200000) expect 0.625             25% Scale
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0x051eb8) expect 0.100             100mV
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0x000003) expect 0.00000894069671  Three LSB
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0x000002) expect 0.00000596046447  Two LSB
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0x000001) expect 0.0000029802326   One LSB
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0x000000) expect 0.0               Zero Scale
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0xFFFFFF) expect -0.0000029802326  Negative One LSB
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0xFFFFFE) expect -0.0000059604644  Negative Two LSB
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0xFFFFFD) expect -0.0000089406967  Negative Three LSB
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0xFAE148) expect -0.100            Negative 100mV
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0xE00000) expect -0.625            Negative 25% Scale
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0xCCCCCD) expect -1.000            Negative One Volt
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0xC00000) expect -1.250            Negative Mid Scale
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0xA00000) expect -1.875            Negative 75% Scale
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0x99999A) expect -2.000            Negative Two Volts
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0x800001) expect -2.500            Negative Full Scale
    /// @test group BIP2C24 ADCVoltageOfCode_24bit(0x800000) expect -2.500            Negative Full Scale
    ///
    double ADCVoltageOfCode_24bit(uint32_t value_u24);

// CODE GENERATOR: looks like this is a register access function because 'regAdd'
// CODE GENERATOR: looks like this is a 'write' register access function
    //----------------------------------------
    /// Write a MAX11043 register.
    ///
    /// CMDOP_1aaa_aaaa_ReadRegister bit is cleared 0 indicating a write operation.
    ///
    /// MAX11043 register length can be determined by function RegSize.
    ///
    /// For 8-bit register size:
    ///
    ///     SPI 16-bit transfer
    ///
    ///     SPI MOSI = 0aaa_aaaa_dddd_dddd
    ///
    ///     SPI MISO = xxxx_xxxx_xxxx_xxxx
    ///
    /// For 16-bit register size:
    ///
    ///     SPI 24-bit or 32-bit transfer
    ///
    ///     SPI MOSI = 0aaa_aaaa_dddd_dddd_dddd_dddd
    ///
    ///     SPI MISO = xxxx_xxxx_xxxx_xxxx_xxxx_xxxx
    ///
    /// For 24-bit register size:
    ///
    ///     SPI 32-bit transfer
    ///
    ///     SPI MOSI = 0aaa_aaaa_dddd_dddd_dddd_dddd_dddd_dddd
    ///
    ///     SPI MISO = xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx
    ///
    /// @return 1 on success; 0 on failure
    uint8_t RegWrite(MAX11043_CMD_enum_t commandByte, uint32_t regData);

// CODE GENERATOR: looks like this is a register access function because 'regAdd'
// CODE GENERATOR: looks like this is a 'read' register access function
    //----------------------------------------
    /// Read an 8-bit MAX11043 register
    ///
    /// CMDOP_1aaa_aaaa_ReadRegister bit is set 1 indicating a read operation.
    ///
    /// MAX11043 register length can be determined by function RegSize.
    ///
    /// For 8-bit register size:
    ///
    ///     SPI 16-bit transfer
    ///
    ///     SPI MOSI = 1aaa_aaaa_0000_0000
    ///
    ///     SPI MISO = xxxx_xxxx_dddd_dddd
    ///
    /// For 16-bit register size:
    ///
    ///     SPI 24-bit or 32-bit transfer
    ///
    ///     SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000
    ///
    ///     SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd
    ///
    /// For 24-bit register size:
    ///
    ///     SPI 32-bit transfer
    ///
    ///     SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000_0000_0000
    ///
    ///     SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd_dddd_dddd
    ///
    ///
    /// @return 1 on success; 0 on failure
    uint8_t RegRead(MAX11043_CMD_enum_t commandByte, uint32_t* ptrRegData);

// CODE GENERATOR: looks like this is a register access function because 'regAdd'
// CODE GENERATOR: looks like this is a 'size' register access function
    //----------------------------------------
    /// Return the size of a MAX11043 register
    ///
    /// @return 8 for 8-bit, 16 for 16-bit, 24 for 24-bit, else 0 for undefined register size
    uint8_t RegSize(MAX11043_CMD_enum_t commandByte);

// CODE GENERATOR: looks like this is a register access function because 'regAdd'
    //----------------------------------------
    /// Decode operation from commandByte
    ///
    /// @return operation such as idle, read register, write register, etc.
    MAX11043::MAX11043_CMDOP_enum_t DecodeCommand(MAX11043_CMD_enum_t commandByte);

// CODE GENERATOR: looks like this is a register access function because 'regAdd'
    //----------------------------------------
    /// Return the address field of a MAX11043 register
    ///
    /// @return register address field as given in datasheet
    uint8_t RegAddrOfCommand(MAX11043_CMD_enum_t commandByte);

// CODE GENERATOR: looks like this is a register access function because 'regAdd'
// CODE GENERATOR: looks like this is a 'read' register access function
    //----------------------------------------
    /// Test whether a command byte is a register read command
    ///
    /// @return true if command byte is a register read command
    uint8_t IsRegReadCommand(MAX11043_CMD_enum_t commandByte);

// CODE GENERATOR: looks like this is a register access function because 'regAdd'
// CODE GENERATOR: looks like this is a 'name' register access function
    //----------------------------------------
    /// Return the name of a MAX11043 register
    ///
    /// @return null-terminated constant C string containing register name or empty string
    const char* RegName(MAX11043_CMD_enum_t commandByte);

    //----------------------------------------
    /// Menu item '$' -> adca, adcb, adcc, adcd
    /// Read ADCabcd
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Read_ADCabcd(void);

    //----------------------------------------
    /// Menu item 'GA'
    /// Write AGain register
    ///
    /// @param[in] gain 2's complement, 0x800=0.25V/V, 0x1000=0.5V/V, 0x2000=1V/V, 0x4000=2V/V, default=0x2000
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Write_AGain(uint32_t gain);

    //----------------------------------------
    /// Menu item 'XD'
    /// Example configuration.
    /// Slowest conversion rate 1:6 = 9us,
    /// Bypass PGA and filters, Gain=1V/V,
    /// AOUT = 2.0V
    ///
    void Configure_Demo(void);

    //----------------------------------------
    /// Menu item 'XX'
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Configure_XXXXX(uint8_t linef, uint8_t rate);

    //----------------------------------------
    /// Menu item 'XY'
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Configure_XXXXY(uint8_t linef, uint8_t rate);

}; // end of class MAX11043

#endif // __MAX11043_H__

// End of file
