// /*******************************************************************************
// * Copyright (C) 2021 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
// *********************************************************************
// @file Board_Calibration_Data.cpp
// *********************************************************************

// data unique to certain boards based on serial number
#include "Board_Calibration_Data.h"

#ifdef BOARD_SERIAL_NUMBER
// data unique to certain boards based on serial number
//----------------------------------------------------------------------
# if          (BOARD_SERIAL_NUMBER) == 0
    #warning "(BOARD_SERIAL_NUMBER) == 0"
    //
// Calibration is between two points for each channel, defined by
// a normalized value between 0% and 100%, and the corresponding voltage.
// nominal 5% fullscale point; normValue_0_1 < 0.5
// calibration_05_normValue_0_1, calibration_05_V should be around 5% or 25%
double calibration_05_normValue_0_1 [] = {
    // TODO: calibrate BOARD_SERIAL_NUMBER 0 channels A0/A4(CSA*100/3.34=mA), A1/A5(1V0), A2(WE), A3(CE)
    0.25, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.25, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.25, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.25, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    0.25, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    0.25, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
double calibration_05_V [] = {
    // TODO: calibrate BOARD_SERIAL_NUMBER 0 channels A0/A4(CSA*100/3.34=mA), A1/A5(1V0), A2(WE), A3(CE)
    0.300, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.300, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.300, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.300, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    1.500, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    1.500, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
// nominal 95% fullscale point; normValue_0_1 > 0.5
// calibration_95_normValue_0_1, calibration_95_V should be around 95% or 75%
double calibration_95_normValue_0_1 [] = {
    // TODO: calibrate BOARD_SERIAL_NUMBER 0 channels A0/A4(CSA*100/3.34=mA), A1/A5(1V0), A2(WE), A3(CE)
    0.75, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.75, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.75, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.75, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    0.75, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    0.75, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
double calibration_95_V [] = {
    // TODO: calibrate BOARD_SERIAL_NUMBER 0 channels A0/A4(CSA*100/3.34=mA), A1/A5(1V0), A2(WE), A3(CE)
    0.900, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.900, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.900, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.900, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    4.500, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    4.500, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
//
//----------------------------------------------------------------------
# elif        (BOARD_SERIAL_NUMBER) == 1
    #warning "(BOARD_SERIAL_NUMBER) == 1"
    //
// Calibration is between two points for each channel, defined by
// a normalized value between 0% and 100%, and the corresponding voltage.
// nominal 5% fullscale point; normValue_0_1 < 0.5
// calibration_05_normValue_0_1, calibration_05_V should be around 5% or 25%
double calibration_05_normValue_0_1 [] = {
    // TODO: calibrate BOARD_SERIAL_NUMBER 1 channels A0/A4(CSA*100/3.34=mA), A1/A5(1V0), A2(WE), A3(CE)
    0.250000000, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.624736547, // %A cal1n=0.624736547 cal1v=0.748000026V cal1n=0.979754724 cal1v=1.167500019V
    0.250000000, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.250000000, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    0.250000000, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    0.127252869, // %A cal5n=0.127252869 cal5v=0.748000026V cal5n=0.267205842 cal5v=1.578999996V
};
double calibration_05_V [] = {
    // TODO: calibrate BOARD_SERIAL_NUMBER 1 channels A0/A4(CSA*100/3.34=mA), A1/A5(1V0), A2(WE), A3(CE)
    0.300000000, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.748000026, // %A cal1n=0.624736547 cal1v=0.748000026V cal1n=0.979754724 cal1v=1.167500019V
    0.300000000, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.300000000, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    1.500000000, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    0.748000026, // %A cal5n=0.127252869 cal5v=0.748000026V cal5n=0.267205842 cal5v=1.578999996V
};
// nominal 95% fullscale point; normValue_0_1 > 0.5
// calibration_95_normValue_0_1, calibration_95_V should be around 95% or 75%
double calibration_95_normValue_0_1 [] = {
    // TODO: calibrate BOARD_SERIAL_NUMBER 1 channels A0/A4(CSA*100/3.34=mA), A1/A5(1V0), A2(WE), A3(CE)
    0.750000000, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.979754724, // %A cal1n=0.624736547 cal1v=0.748000026V cal1n=0.979754724 cal1v=1.167500019V
    0.750000000, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.750000000, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    0.750000000, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    0.267205842, // %A cal5n=0.127252869 cal5v=0.748000026V cal5n=0.267205842 cal5v=1.578999996V
};
double calibration_95_V [] = {
    // TODO: calibrate BOARD_SERIAL_NUMBER 1 channels A0/A4(CSA*100/3.34=mA), A1/A5(1V0), A2(WE), A3(CE)
    0.900000000, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    1.167500019, // %A cal1n=0.624736547 cal1v=0.748000026V cal1n=0.979754724 cal1v=1.167500019V
    0.900000000, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.900000000, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    4.500000000, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    1.578999996, // %A cal5n=0.127252869 cal5v=0.748000026V cal5n=0.267205842 cal5v=1.578999996V
};
//
//----------------------------------------------------------------------
# elif        (BOARD_SERIAL_NUMBER) == 2
    #warning "(BOARD_SERIAL_NUMBER) == 2"
    //
// Calibration is between two points for each channel, defined by
// a normalized value between 0% and 100%, and the corresponding voltage.
// nominal 5% fullscale point; normValue_0_1 < 0.5
// calibration_05_normValue_0_1, calibration_05_V should be around 5% or 25%
double calibration_05_normValue_0_1 [] = {
    // TODO: calibrate BOARD_SERIAL_NUMBER 2 channels A1/A5(1V0)?
    0.001955034, // %A cal0n=0.001955034 cal0v=0.000120000V cal0n=0.964797903 cal0v=1.149270058V
    0.646371711, // %A cal1n=0.646371711 cal1v=0.761619985V cal1n=0.964797903 cal1v=1.149270058V
    0.121437412, // %A cal2n=0.121437412 cal2v=0.146500006V cal2n=0.833466958 cal2v=1.004999995V
    0.121437412, // %A cal3n=0.121437412 cal3v=0.146500006V cal3n=0.833466958 cal3v=1.004999995V
    0.001955034, // %A cal4n=0.001955034 cal4v=0.000120000V cal4n=0.291349728 cal4v=1.735399961V
    0.130005952, // %A cal5n=0.130005952 cal5v=0.761650026V cal5n=0.291349728 cal5v=1.735399961V
};
double calibration_05_V [] = {
    // TODO: calibrate BOARD_SERIAL_NUMBER 2 channels A1/A5(1V0)?
    0.000120000, // %A cal0n=0.001955034 cal0v=0.000120000V cal0n=0.964797903 cal0v=1.149270058V
    0.761619985, // %A cal1n=0.646371711 cal1v=0.761619985V cal1n=0.964797903 cal1v=1.149270058V
    0.146500006, // %A cal2n=0.121437412 cal2v=0.146500006V cal2n=0.833466958 cal2v=1.004999995V
    0.146500006, // %A cal3n=0.121437412 cal3v=0.146500006V cal3n=0.833466958 cal3v=1.004999995V
    0.000120000, // %A cal4n=0.001955034 cal4v=0.000120000V cal4n=0.291349728 cal4v=1.735399961V
    0.761650026, // %A cal5n=0.130005952 cal5v=0.761650026V cal5n=0.291349728 cal5v=1.735399961V
};
// nominal 95% fullscale point; normValue_0_1 > 0.5
// calibration_95_normValue_0_1, calibration_95_V should be around 95% or 75%
double calibration_95_normValue_0_1 [] = {
    // TODO: calibrate BOARD_SERIAL_NUMBER 2 channels A1/A5(1V0)?
    0.964797903, // %A cal0n=0.001955034 cal0v=0.000120000V cal0n=0.964797903 cal0v=1.149270058V
    0.964797903, // %A cal1n=0.646371711 cal1v=0.761619985V cal1n=0.964797903 cal1v=1.149270058V
    0.833466958, // %A cal2n=0.121437412 cal2v=0.146500006V cal2n=0.833466958 cal2v=1.004999995V
    0.833466958, // %A cal3n=0.121437412 cal3v=0.146500006V cal3n=0.833466958 cal3v=1.004999995V
    0.291349728, // %A cal4n=0.001955034 cal4v=0.000120000V cal4n=0.291349728 cal4v=1.735399961V
    0.291349728, // %A cal5n=0.130005952 cal5v=0.761650026V cal5n=0.291349728 cal5v=1.735399961V
};
double calibration_95_V [] = {
    // TODO: calibrate BOARD_SERIAL_NUMBER 2 channels A1/A5(1V0)?
    1.149270058, // %A cal0n=0.001955034 cal0v=0.000120000V cal0n=0.964797903 cal0v=1.149270058V
    1.149270058, // %A cal1n=0.646371711 cal1v=0.761619985V cal1n=0.964797903 cal1v=1.149270058V
    1.004999995, // %A cal2n=0.121437412 cal2v=0.146500006V cal2n=0.833466958 cal2v=1.004999995V
    1.004999995, // %A cal3n=0.121437412 cal3v=0.146500006V cal3n=0.833466958 cal3v=1.004999995V
    1.735399961, // %A cal4n=0.001955034 cal4v=0.000120000V cal4n=0.291349728 cal4v=1.735399961V
    1.735399961, // %A cal5n=0.130005952 cal5v=0.761650026V cal5n=0.291349728 cal5v=1.735399961V
};
//
//----------------------------------------------------------------------
# elif        (BOARD_SERIAL_NUMBER) == 3
    #warning "(BOARD_SERIAL_NUMBER) == 3"
    //
// Calibration is between two points for each channel, defined by
// a normalized value between 0% and 100%, and the corresponding voltage.
// nominal 5% fullscale point; normValue_0_1 < 0.5
// calibration_05_normValue_0_1, calibration_05_V should be around 5% or 25%
double calibration_05_normValue_0_1 [] = {
    // TODO: calibrate BOARD_SERIAL_NUMBER 3 channels A2(WE), A3(CE) not quite right yet
    0.002932551, // %A cal0n=0.002932551 cal0v=0.000130000V cal0n=0.966447462 cal0v=1.149999976V
    0.643798094, // %A cal1n=0.643798094 cal1v=0.756900012V cal1n=0.966447462 cal1v=1.149999976V
    0.151286051, // %A cal2n=0.151286051 cal2v=0.181050003V cal2n=0.786534725 cal2v=0.936999977V
    0.151286051, // %A cal3n=0.151286051 cal3v=0.181050003V cal3n=0.786023080 cal3v=0.936999977V
    0.002932551, // %A cal4n=0.002932551 cal4v=0.000130000V cal4n=0.286962360 cal4v=1.707499981V
    0.130120505, // %A cal5n=0.130120505 cal5v=0.757099986V cal5n=0.286962360 cal5v=1.707499981V
};
double calibration_05_V [] = {
    // TODO: calibrate BOARD_SERIAL_NUMBER 3 channels A2(WE), A3(CE) not quite right yet
    0.000130000, // %A cal0n=0.002932551 cal0v=0.000130000V cal0n=0.966447462 cal0v=1.149999976V
    0.756900012, // %A cal1n=0.643798094 cal1v=0.756900012V cal1n=0.966447462 cal1v=1.149999976V
    0.181050003, // %A cal2n=0.151286051 cal2v=0.181050003V cal2n=0.786534725 cal2v=0.936999977V
    0.181050003, // %A cal3n=0.151286051 cal3v=0.181050003V cal3n=0.786023080 cal3v=0.936999977V
    0.000130000, // %A cal4n=0.002932551 cal4v=0.000130000V cal4n=0.286962360 cal4v=1.707499981V
    0.757099986, // %A cal5n=0.130120505 cal5v=0.757099986V cal5n=0.286962360 cal5v=1.707499981V
};
// nominal 95% fullscale point; normValue_0_1 > 0.5
// calibration_95_normValue_0_1, calibration_95_V should be around 95% or 75%
double calibration_95_normValue_0_1 [] = {
    // TODO: calibrate BOARD_SERIAL_NUMBER 3 channels A2(WE), A3(CE) not quite right yet
    0.966447462, // %A cal0n=0.002932551 cal0v=0.000130000V cal0n=0.966447462 cal0v=1.149999976V
    0.966447462, // %A cal1n=0.643798094 cal1v=0.756900012V cal1n=0.966447462 cal1v=1.149999976V
    0.786534725, // %A cal2n=0.151286051 cal2v=0.181050003V cal2n=0.786534725 cal2v=0.936999977V
    0.786023080, // %A cal3n=0.151286051 cal3v=0.181050003V cal3n=0.786023080 cal3v=0.936999977V
    0.286962360, // %A cal4n=0.002932551 cal4v=0.000130000V cal4n=0.286962360 cal4v=1.707499981V
    0.286962360, // %A cal5n=0.130120505 cal5v=0.757099986V cal5n=0.286962360 cal5v=1.707499981V
};
double calibration_95_V [] = {
    // TODO: calibrate BOARD_SERIAL_NUMBER 3 channels A2(WE), A3(CE) not quite right yet
    1.149999976, // %A cal0n=0.002932551 cal0v=0.000130000V cal0n=0.966447462 cal0v=1.149999976V
    1.149999976, // %A cal1n=0.643798094 cal1v=0.756900012V cal1n=0.966447462 cal1v=1.149999976V
    0.936999977, // %A cal2n=0.151286051 cal2v=0.181050003V cal2n=0.786534725 cal2v=0.936999977V
    0.936999977, // %A cal3n=0.151286051 cal3v=0.181050003V cal3n=0.786023080 cal3v=0.936999977V
    1.707499981, // %A cal4n=0.002932551 cal4v=0.000130000V cal4n=0.286962360 cal4v=1.707499981V
    1.707499981, // %A cal5n=0.130120505 cal5v=0.757099986V cal5n=0.286962360 cal5v=1.707499981V
};
//
//----------------------------------------------------------------------
# elif        (BOARD_SERIAL_NUMBER) == 4
    #warning "(BOARD_SERIAL_NUMBER) == 4"
    //
// Calibration is between two points for each channel, defined by
// a normalized value between 0% and 100%, and the corresponding voltage.
// nominal 5% fullscale point; normValue_0_1 < 0.5
// calibration_05_normValue_0_1, calibration_05_V should be around 5% or 25%
double calibration_05_normValue_0_1 [] = {
    0.003910068, // %A cal0n=0.003910068 cal0v=0.000120000V cal0n=0.925441444 cal0v=1.107100010V
    0.635619044, // %A cal1n=0.635619044 cal1v=0.759999990V cal1n=0.925441444 cal1v=1.107100010V
    0.083768636, // %A cal2n=0.083768636 cal2v=0.100000001V cal2n=0.820740156 cal2v=0.980000019V
    0.083768636, // %A cal3n=0.083768636 cal3v=0.100000001V cal3n=0.820740156 cal3v=0.980000019V
    0.003910068, // %A cal4n=0.003910068 cal4v=0.000120000V cal4n=0.279630989 cal4v=1.651999950V
    0.129257541, // %A cal5n=0.129257541 cal5v=0.759999990V cal5n=0.279630989 cal5v=1.651999950V
};
double calibration_05_V [] = {
    0.000120000, // %A cal0n=0.003910068 cal0v=0.000120000V cal0n=0.925441444 cal0v=1.107100010V
    0.759999990, // %A cal1n=0.635619044 cal1v=0.759999990V cal1n=0.925441444 cal1v=1.107100010V
    0.100000001, // %A cal2n=0.083768636 cal2v=0.100000001V cal2n=0.820740156 cal2v=0.980000019V
    0.100000001, // %A cal3n=0.083768636 cal3v=0.100000001V cal3n=0.820740156 cal3v=0.980000019V
    0.000120000, // %A cal4n=0.003910068 cal4v=0.000120000V cal4n=0.279630989 cal4v=1.651999950V
    0.759999990, // %A cal5n=0.129257541 cal5v=0.759999990V cal5n=0.279630989 cal5v=1.651999950V
};
// nominal 95% fullscale point; normValue_0_1 > 0.5
// calibration_95_normValue_0_1, calibration_95_V should be around 95% or 75%
double calibration_95_normValue_0_1 [] = {
    0.925441444, // %A cal0n=0.003910068 cal0v=0.000120000V cal0n=0.925441444 cal0v=1.107100010V
    0.925441444, // %A cal1n=0.635619044 cal1v=0.759999990V cal1n=0.925441444 cal1v=1.107100010V
    0.820740156, // %A cal2n=0.083768636 cal2v=0.100000001V cal2n=0.820740156 cal2v=0.980000019V
    0.820740156, // %A cal3n=0.083768636 cal3v=0.100000001V cal3n=0.820740156 cal3v=0.980000019V
    0.279630989, // %A cal4n=0.003910068 cal4v=0.000120000V cal4n=0.279630989 cal4v=1.651999950V
    0.279630989, // %A cal5n=0.129257541 cal5v=0.759999990V cal5n=0.279630989 cal5v=1.651999950V
};
double calibration_95_V [] = {
    1.107100010, // %A cal0n=0.003910068 cal0v=0.000120000V cal0n=0.925441444 cal0v=1.107100010V
    1.107100010, // %A cal1n=0.635619044 cal1v=0.759999990V cal1n=0.925441444 cal1v=1.107100010V
    0.980000019, // %A cal2n=0.083768636 cal2v=0.100000001V cal2n=0.820740156 cal2v=0.980000019V
    0.980000019, // %A cal3n=0.083768636 cal3v=0.100000001V cal3n=0.820740156 cal3v=0.980000019V
    1.651999950, // %A cal4n=0.003910068 cal4v=0.000120000V cal4n=0.279630989 cal4v=1.651999950V
    1.651999950, // %A cal5n=0.129257541 cal5v=0.759999990V cal5n=0.279630989 cal5v=1.651999950V
};
//
//----------------------------------------------------------------------
# elif        (BOARD_SERIAL_NUMBER) == 5
    #warning "(BOARD_SERIAL_NUMBER) == 5"
    //
// Calibration is between two points for each channel, defined by
// a normalized value between 0% and 100%, and the corresponding voltage.
// nominal 5% fullscale point; normValue_0_1 < 0.5
// calibration_05_normValue_0_1, calibration_05_V should be around 5% or 25%
double calibration_05_normValue_0_1 [] = {
    0.25, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.25, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.25, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.25, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    0.25, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    0.25, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
double calibration_05_V [] = {
    0.300, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.300, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.300, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.300, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    1.500, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    1.500, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
// nominal 95% fullscale point; normValue_0_1 > 0.5
// calibration_95_normValue_0_1, calibration_95_V should be around 95% or 75%
double calibration_95_normValue_0_1 [] = {
    0.75, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.75, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.75, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.75, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    0.75, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    0.75, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
double calibration_95_V [] = {
    0.900, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.900, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.900, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.900, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    4.500, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    4.500, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
//
//----------------------------------------------------------------------
# elif        (BOARD_SERIAL_NUMBER) == 6
    #warning "(BOARD_SERIAL_NUMBER) == 6"
    //
// Calibration is between two points for each channel, defined by
// a normalized value between 0% and 100%, and the corresponding voltage.
// nominal 5% fullscale point; normValue_0_1 < 0.5
// calibration_05_normValue_0_1, calibration_05_V should be around 5% or 25%
double calibration_05_normValue_0_1 [] = {
    0.25, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.25, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.25, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.25, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    0.25, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    0.25, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
double calibration_05_V [] = {
    0.300, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.300, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.300, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.300, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    1.500, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    1.500, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
// nominal 95% fullscale point; normValue_0_1 > 0.5
// calibration_95_normValue_0_1, calibration_95_V should be around 95% or 75%
double calibration_95_normValue_0_1 [] = {
    0.75, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.75, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.75, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.75, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    0.75, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    0.75, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
double calibration_95_V [] = {
    0.900, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.900, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.900, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.900, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    4.500, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    4.500, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
//
//----------------------------------------------------------------------
# else
    #warning "BOARD_SERIAL_NUMBER defined but not recognized; using default values"
    //
// Calibration is between two points for each channel, defined by
// a normalized value between 0% and 100%, and the corresponding voltage.
// nominal 5% fullscale point; normValue_0_1 < 0.5
// calibration_05_normValue_0_1, calibration_05_V should be around 5% or 25%
double calibration_05_normValue_0_1 [] = {
    0.25, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.25, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.25, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.25, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    0.25, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    0.25, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
double calibration_05_V [] = {
    0.300, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.300, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.300, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.300, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    1.500, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    1.500, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
// nominal 95% fullscale point; normValue_0_1 > 0.5
// calibration_95_normValue_0_1, calibration_95_V should be around 95% or 75%
double calibration_95_normValue_0_1 [] = {
    0.75, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.75, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.75, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.75, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    0.75, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    0.75, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
double calibration_95_V [] = {
    0.900, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.900, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.900, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.900, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    4.500, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    4.500, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
//
//----------------------------------------------------------------------
# endif
#else // BOARD_SERIAL_NUMBER data unique to certain boards based on serial number
    #warning "BOARD_SERIAL_NUMBER not defined; using default values"
    //
// Calibration is between two points for each channel, defined by
// a normalized value between 0% and 100%, and the corresponding voltage.
// nominal 5% fullscale point; normValue_0_1 < 0.5
// calibration_05_normValue_0_1, calibration_05_V should be around 5% or 25%
double calibration_05_normValue_0_1 [] = {
    0.25, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.25, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.25, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.25, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    0.25, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    0.25, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
double calibration_05_V [] = {
    0.300, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.300, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.300, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.300, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    1.500, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    1.500, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
// nominal 95% fullscale point; normValue_0_1 > 0.5
// calibration_95_normValue_0_1, calibration_95_V should be around 95% or 75%
double calibration_95_normValue_0_1 [] = {
    0.75, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.75, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.75, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.75, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    0.75, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    0.75, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
double calibration_95_V [] = {
    0.900, // %A cal0n=0.250000000 cal0v=0.300000000V cal0n=0.750000000 cal0v=0.900000000V
    0.900, // %A cal1n=0.250000000 cal1v=0.300000000V cal1n=0.750000000 cal1v=0.900000000V
    0.900, // %A cal2n=0.250000000 cal2v=0.300000000V cal2n=0.750000000 cal2v=0.900000000V
    0.900, // %A cal3n=0.250000000 cal3v=0.300000000V cal3n=0.750000000 cal3v=0.900000000V
    4.500, // %A cal4n=0.250000000 cal4v=1.500000000V cal4n=0.750000000 cal4v=4.500000000V
    4.500, // %A cal5n=0.250000000 cal5v=1.500000000V cal5n=0.750000000 cal5v=4.500000000V
};
//
//----------------------------------------------------------------------
#endif // BOARD_SERIAL_NUMBER data unique to certain boards based on serial number


// End of file
