//  Experimentally derived Band Settings for VFO ...
//      Band 0: 83.78 - 91.72
//      Band 1: 88.74 - 98.28
//      Band 2: 93.10 - 104.00
//      Band 3: 99.50 - 112.72
//      ref: http://cba.sakura.ne.jp/sub04/jisaku36.htm (translated)

#include "mbed.h"
#include "TextLCD.h"

#define topFM  107900000            // Top of the FM Dial Range in USA
#define botFM   87500000            // Bottom of the FM Dial Range in USA
#define incrFM    200000            // FM Channel Increment in USA

long frequency = 97300000;          // the default initial frequency in Hz
long newFrequency = 0;
bool mute = true;

LocalFileSystem local("local");
TextLCD lcd(p15, p16, p17, p18, p19, p20); // rs, e, d4-d7
Serial pc(USBTX, USBRX);
I2C i2c(p9, p10);
DigitalIn left(p23);
DigitalIn center(p22);
DigitalIn right(p21);
FILE *fp;

float storedF = 10.1;

const int addr= 0xCC;

void writeToReg(unsigned int, unsigned int, unsigned int);
void initializeTransmitter(long);
void setFrequency(long);

int main() {
      lcd.printf("Starting up.\r\n");
      left.mode(PullUp);
      center.mode(PullUp);
      right.mode(PullUp);
      wait_ms(100);                                //Wait for VDD to settle
      
      fp = fopen("/local/out.txt", "r");
      fscanf(fp, "%f", &storedF);
      fclose(fp);
      
      frequency = ((long)(storedF*100.0))*10000;
      
      //lcd.cls();
      //lcd.printf("Transmitting on FM %d", frequency);
      
      initializeTransmitter(frequency);

      while(1) {
        if(left == 0)
        {
            if(frequency - incrFM > botFM)
                frequency = frequency - incrFM;
            else
                frequency = topFM;
                
            lcd.cls();
            setFrequency(frequency);
            lcd.printf("Transmitting on FM %2.1f", float(frequency)/1000000.0);
            
            fp = fopen("/local/out.txt", "w");  // Open "out.txt" on the local file system for writing
            fprintf(fp, "%2.1f", float(frequency)/1000000.0);
            fclose(fp);
        }
        else if (right == 0)
        {
            if(frequency + incrFM < topFM)
                frequency = frequency + incrFM;
            else
                frequency = botFM;   
                 
            lcd.cls();
            setFrequency(frequency);
            lcd.printf("Transmitting on FM %2.1f", float(frequency)/1000000.0);
            
            fp = fopen("/local/out.txt", "w");  // Open "out.txt" on the local file system for writing
            fprintf(fp, "%2.1f", float(frequency)/1000000.0);
            fclose(fp);
        }
        else if (center == 0)
        {
            frequency = 97300000;
            lcd.cls();
            setFrequency(frequency);
            lcd.printf("Transmitting on FM %2.1f", float(frequency)/1000000.0);
            
            fp = fopen("/local/out.txt", "w");  // Open "out.txt" on the local file system for writing
            fprintf(fp, "%2.1f", float(frequency)/1000000.0);
            fclose(fp);
        }
        wait_ms(200); // lazy debounce
    }
}

void initializeTransmitter(long freq)
{
    lcd.printf("Initializing...");
    
    writeToReg(addr, 0x0E, 0x05); // Software reset
    
    writeToReg(addr, 0x01, 0xB4); // Reg 1: forced subccarrier, pilot tone on
    
    writeToReg(addr, 0x02, 0x03); // Reg 2: Unlock detect off, 2mW Tx Power
    
    setFrequency(freq);
      
    //writeToReg(addr, 0x08, 0x1A); //Register 8: set Osc on band 2
    
    writeToReg(addr, 0x00, 0xA1); //Register 0: 200mV audio input, 75us pre-emphasis on, crystal off, power on

    writeToReg(addr, 0x0E, 0x05); // Software reset
    
    writeToReg(addr, 0x06, 0x1E); // Reg 6: chare pumps at 320uA and 80 uA

    lcd.cls();
    lcd.printf("Transmitting on FM %2.1f", float(freq)/1000000.0);  //for debugging
}

void setFrequency(long freq)
{     
      int new_frequency;

      // New Range Checking... Implement the (experimentally determined) VFO bands:
      if (freq < 88500000) {        // Band 3
        writeToReg(addr, 0x08, 0x1B);
        //Serial.println("Band 3");
      }  
      else if (freq < 97900000) {   // Band 2
        writeToReg(addr, 0x08, 0x1A);
        //Serial.println("Band 2");
      }
      else if (freq < 103000000) {  // Band 1 
        writeToReg(addr, 0x08, 0x19);
        //Serial.println("Band 1");
      }
      else {                        // Band 0
        // Must be OVER 103.000.000,
        writeToReg(addr, 0x08, 0x18);
        //Serial.println("Band 0");
      }
      
      new_frequency = (freq + 304000) / 8192;
      
      unsigned char reg3 = new_frequency & 255;                  //extract low byte of frequency register
      unsigned char reg4 = new_frequency >> 8;                   //extract high byte of frequency register
      writeToReg(addr, 0x03, reg3);                             //send low byte
      writeToReg(addr, 0x04, reg4);                             //send high byte
      
      writeToReg(addr, 0x0E, 0x05);         // Software reset
}

void writeToReg(unsigned int addr, unsigned int reg, unsigned int data)
{
    i2c.start();
    i2c.write(addr);
    i2c.write(reg);
    i2c.write(data);
    i2c.stop();
}
