#include "mbed.h"
#include "pinmap.h"
#include "SSD1308.h"
#include "MBed_Adafruit_GPS.h"

Serial gps(P0_19,P0_18);

#define DEBUG

#ifdef DEBUG
#include "USBSerial.h"                       // To use USB virtual serial, a driver is needed, check http://mbed.org/handbook/USBSerial
#define LOG(args...)    pc.printf(args)
USBSerial pc;
#else
#define LOG(args...)
#endif

#define HARD_SPI        1
#define I2C_FREQ            100000

I2C i2c(I2C_SDA, I2C_SCL);
//Use Xadow OLED for display
SSD1308 oled = SSD1308(i2c, SSD1308_SA0);

//GPS Data


int main()
{
    Adafruit_GPS myGPS(&gps);
    char c; //when read via Adafruit_GPS::read(), the class returns single character stored here
    Timer refresh_Timer; //sets up a timer for use in loop; how often do we print GPS info?
    const int refresh_Time = 1000; //refresh time in ms

    myGPS.begin(9600);
    oled.clearDisplay();
    oled.writeString(0,0,"GPS Test");
    oled.writeString(1,0,"GPS Start");
    
    wait(1);
    
    refresh_Timer.start();  //starts the clock on the timer

    while (true) {
        c = myGPS.read();   //queries the GPS

        if (c) {
            pc.printf("%c", c);    //this line will echo the GPS data if not paused
        }

        //check if we recieved a new message from GPS, if so, attempt to parse it,
        if ( myGPS.newNMEAreceived() ) {
            if ( !myGPS.parse(myGPS.lastNMEA()) ) {
                continue;
            }
        }



        //check if enough time has passed to warrant printing GPS info to screen
        //note if refresh_Time is too low or pc.baud is too low, GPS data may be lost during printing
        if (refresh_Timer.read_ms() >= refresh_Time) {
            refresh_Timer.reset();
            pc.printf("Time: %d:%d:%d.%u\n", myGPS.hour, myGPS.minute, myGPS.seconds, myGPS.milliseconds);
            pc.printf("Date: %d/%d/20%d\n", myGPS.day, myGPS.month, myGPS.year);
            pc.printf("Fix: %d\n", (int) myGPS.fix);
            pc.printf("Quality: %d\n", (int) myGPS.fixquality);
            if (myGPS.fix) {
                pc.printf("Location: %5.2f%c, %5.2f%c\n", myGPS.latitude, myGPS.lat, myGPS.longitude, myGPS.lon);
                pc.printf("Speed: %5.2f knots\n", myGPS.speed);
                pc.printf("Angle: %5.2f\n", myGPS.angle);
                pc.printf("Altitude: %5.2f\n", myGPS.altitude);
                pc.printf("Satellites: %d\n", myGPS.satellites);
            }

            if (myGPS.fix) {
                char oled_str[20];
                oled.writeString(1,0,"GPS Lock ");
                sprintf(oled_str,"LAT:%f",myGPS.latitude);
                oled.writeString(2,0,oled_str);
                sprintf(oled_str,"LON:%f",myGPS.longitude);
                oled.writeString(3,0,oled_str);
                sprintf(oled_str,"ALT:%f",myGPS.altitude);
                oled.writeString(4,0,oled_str);
            } else {
                oled.writeString(1,0,"GPS Lost ");
            }
        }
    }
}
