#include "mbed.h"
#include "SDFileSystem.h"
#include "pinmap.h"
#include "SSD1308.h"

#define DEBUG
#define HARD_SPI        1
#define I2C_FREQ            100000

I2C i2c(I2C_SDA, I2C_SCL);
//Use Xadow OLED for display
SSD1308 oled = SSD1308(i2c, SSD1308_SA0);

#ifdef DEBUG
#include "USBSerial.h"                       // To use USB virtual serial, a driver is needed, check http://mbed.org/handbook/USBSerial
#define LOG(args...)    pc.printf(args)
USBSerial pc;
#else
#define LOG(args...)
#endif

SDFileSystem sd(P0_21, P0_22, P1_15, P1_19, "sd", P0_20,  SDFileSystem::SWITCH_POS_NC); // the pinout on the mbed Cool Components workshop board
 
int main() {
    LOG("Hello World!\n");  
    oled.clearDisplay();
    oled.writeString(0,0,"Hello World!");
    mkdir("/sd/mydir", 0777);
    
    while(1)
    {
        FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
        if(fp == NULL) {
            LOG("Could not open file for write\n");
            oled.writeString(2,0,"Failed on SD");
        }
        fprintf(fp, "Hello fun Xadow SD Card World!");
        fclose(fp);
        LOG("Goodbye World!\n");
        oled.writeString(1,0,"Goodbye World!");
    }    
    
}
