#include "mbed.h"
#include "SC16IS750.h"


#if defined(TARGET_LPC1768)
// SPI for LPC1768
#define D_MOSI                 p5
#define D_MISO                 p6
#define D_SCLK                 p7
#define D_CS                   p8
#define D_INTR                 p15
#define D_RST                  p16

// Serial for LPC1768
#define D_TX                   USBTX
#define D_RX                   USBRX
//#define D_RST                  p25
//#define D_STS                  p26
#endif

#if defined(TARGET_KL25Z)
// SPI for KL25Z
#define D_MOSI                 PTD2
#define D_MISO                 PTD3
#define D_SCLK                 PTD1
#define D_CS                   PTD0
//#define D_INTR                 PTA13
#define D_RST                  PTD5

// I2C for KL25Z
#define D_SCL                  PTE1
#define D_SDA                  PTE0

// Serial for KL25Z
#define D_TX                   USBTX
#define D_RX                   USBRX
#endif

#if defined(TARGET_LPC812)
// SPI for LPC812
#define D_MOSI                 P0_14
#define D_MISO                 P0_15
#define D_SCLK                 P0_12
#define D_CS                   P0_13
//#define D_INTR                 P0_7
//#define D_RST                  P0_8

// Serial for LPC812
#define D_TX                   P0_4
#define D_RX                   P0_0
//#define D_RST                  P0_9
//#define D_STS                  P0_17
#endif


//SPI Version
//SPI spi(D_MOSI, D_MISO, D_SCLK); //MOSI, MISO, SCK
//SC16IS750_SPI serial_bridge(&spi, D_CS);
//SC16IS750_SPI serial_bridge(&spi, D_CS, D_RST);  // version with Hardware Reset pin
//SC16IS752_SPI serial_bridge(&spi, D_CS, D_RST, SC16IS750::Channel_A);  // Dual UART version with Hardware Reset pin
//SC16IS752_SPI serial_bridge_B(&spi, D_CS, D_RST, SC16IS750::Channel_B);  // Dual UART version with Hardware Reset pin

//I2C Version
//I2C i2c(D_SDA, D_SCL);       //SDA, SCL
#define DEFAULT_SC16IS750_ADDR 0x4D
#define I2C_FREQ            100000
I2C i2c(I2C_SDA, I2C_SCL);
SC16IS750_I2C serial_bridge(&i2c, DEFAULT_SC16IS750_ADDR);
//SC16IS750_I2C serial_bridge(&i2c, DEFAULT_SC16IS750_ADDR, D_RST);

//DigitalOut myled1(LED_RED);
//DigitalOut myled2(LED_GREEN); 
//DigitalOut myled3(LED_BLUE);  // Same as PTD1 (SCK)
//DigitalOut heartbeatLED(LED_GREEN);
 
//Serial pc(D_TX,D_RX);
#define DEBUG

#ifdef DEBUG
#include "USBSerial.h"                       // To use USB virtual serial, a driver is needed, check http://mbed.org/handbook/USBSerial
#define LOG(args...)    pc.printf(args)
USBSerial pc;
#else
#define LOG(args...)
#endif

void show_menu() {
    pc.printf("0: Exit\n\r");
    pc.printf("1: Show Menu\n\r");    
    pc.printf("2: Init\n\r"); 
    pc.printf("3: IO Port Out\n\r");     
    pc.printf("4: Transparant mode\n\r");        
    pc.printf("5: Free bufferspace\n\r");                
    pc.printf("6: Enable RTS/CTS\n\r");                
    pc.printf("7: Disable RTS/CTS\n\r");                    
    pc.printf("8: Write block\n\r");       
    pc.printf("9: Baudrate 9600\n\r");                            
    pc.printf("A: Baudrate 115200\n\r");                           
    pc.printf("B: Transparant mode with bufferdisplay\n\r");        
    pc.printf("C: Test printf \n\r");                        

 #if(0)                
    pc.printf("D: \n\r");                           
    pc.printf("P: \n\r");                        
#endif    
    pc.printf("\n\r");                
}

// Variables for Heartbeat and Status monitoring
Ticker heartbeat;
bool heartbeatflag=false;

// Local functions
void clear_screen() {
//ANSI Terminal Commands
    pc.printf("\x1B[2J");
    pc.printf("\x1B[H");
}

   
// Heartbeat monitor
void pulse() {
  //heartbeatLED = !heartbeatLED;
}

void heartbeat_start() {
  heartbeat.attach(&pulse, 0.5);
}

void heartbeat_stop() {
  heartbeat.detach();
}


int main() {
  bool running=true;
  bool running_test=true;                   
  char command, ch;
  int i=0;
   
#if defined(TARGET_LPC1768)
  pc.printf("\r\nHello World from LPC1768\r\n");
#endif  
#if defined(TARGET_KL25Z)
  pc.printf("\r\nHello World from KL25Z\r\n");
#endif  
#if defined(TARGET_LPC812)
  pc.printf("\r\nHello World from LPC812\r\n");
#endif


  heartbeat_start();     

  //myled1 = 1; // LED Off

 // We need to enable flow control or we overflow buffers and
  // lose data when used with the WiFly. Note that flow control 
  // needs to be enabled on the WiFly for this to work but it's
  // possible to do that with flow control enabled here but not there.
//  serial_bridge.set_flow_control(SC16IS750::RTSCTS);

    serial_bridge.ioSetDirection(0xFF); // All outputs
    serial_bridge.ioSetState(0x00);     // All On

    show_menu();
      
    while(running) {
     
       if(pc.readable()) {
         command = pc.getc();       
         pc.printf("command= %c \n\r", command);         

         switch (command) {
          case '0' :
                     pc.printf("Done\n\r");                    
                     running = false;  
                     break;
                     
          case '1' :
                     show_menu();
                     break;

          case '2' :
                     pc.printf("Hardware Reset\n\r");                                         
                     serial_bridge.hwReset();                             //test
                     
                     pc.printf("Init\n\r");                                                             
                     serial_bridge._init();                      
                     break;
          
          case '3' :        
                     pc.printf("IO Port Out\n\r");                    
                     
                     i=0;
                     while (!pc.readable()) {
                       serial_bridge.ioSetState(~i); 
                       serial_bridge.ioGetState() ;                       //test
                       wait(0.5);
                       pc.putc('*');                
                       i=(i+1) & 0xFF;
                     }
                     
                     pc.getc();
                     pc.printf("IO Port Out Done\n\r");                                         
                     break;

          case '4' :        
                     pc.printf("Transparant Mode, Enter '#' to quit...\n\r");                    
                     
                     running_test=true;
                     
                     while (running_test) {
                       // From SPI/I2C to serial                       
                       while (running_test && pc.readable()) {
                         ch = pc.getc();
                         running_test = (ch != '#');
                         serial_bridge.putc(ch);
                       }
                       
                       // From Serial to SPI/I2C 
                       while (running_test && serial_bridge.readable()) {
                         ch = serial_bridge.getc();
                         running_test = (ch != '#');
                         pc.putc(ch);
                       }
                       
                     }
                     
                     pc.printf("\n\rTransparant Mode done\n\r");                                         
                     break;

          case '5' :        
                     pc.printf("Available for Reading = %3d (Free Space = %3d)\n\r", serial_bridge.readableCount(), SC16IS750_FIFO_RX - serial_bridge.readableCount());                    
                     pc.printf("Available for Writing = %3d (Used Space = %3d)\n\r", serial_bridge.writableCount(), SC16IS750_FIFO_TX - serial_bridge.writableCount());                                         
                     break;

          case '6' :        
                     pc.printf("Enable RTS/CTS\n\r");
                     serial_bridge.set_flow_control(SC16IS750::RTSCTS);
                     break;                     
          case '7' :        
                     pc.printf("Disable RTS/CTS\n\r");     
                     serial_bridge.set_flow_control(SC16IS750::Disabled);                     
                     break;                     

          case '8' :        
                     pc.printf("Write block\n\r");                                                 
                     serial_bridge.writeString("Hello World from mbed and SC16IS750 ");                     
                     break;                     

          case '9' :        
                     pc.printf("Baudrate = 9600, Divisor = %d\n\r", SC16IS750_BAUDRATE_DIVISOR(9600));
                     serial_bridge.baud(9600);                     
                     break;                     

          case 'A' :        
                     pc.printf("Baudrate = 115200, Divisor = %d\n\r", SC16IS750_BAUDRATE_DIVISOR(115200));
                     serial_bridge.baud(115200);                     
                     break;                     

          case 'B' :        
                     pc.printf("Transparant Mode with buffer display, Enter '#' to quit...\n\r");                    
                     
                     running_test=true;
                     
                     while (running_test) {
                       // From SPI/I2C to serial                       
                       while (running_test && pc.readable()) {
                         ch = pc.getc();
                         running_test = (ch != '#');
                         serial_bridge.putc(ch);
                         
                         // Show buffers when character was entered                         
                         pc.printf("\n\r");
                         pc.printf("Available for Reading = %3d (Free Space = %3d)\n\r", serial_bridge.readableCount(), SC16IS750_FIFO_RX - serial_bridge.readableCount());
                         pc.printf("Available for Writing = %3d (Used Space = %3d)\n\r", serial_bridge.writableCount(), SC16IS750_FIFO_TX - serial_bridge.writableCount());                       
                       }

                       
                       // From Serial to SPI/I2C 
                       while (running_test && serial_bridge.readable()) {
                         ch = serial_bridge.getc();
                         running_test = (ch != '#');
                         pc.putc(ch);
                       }

                     }
                     
                     pc.printf("\n\rTransparant Mode done\n\r");                                         
                     break;

          case 'C' :        
                     pc.printf("Test printf() \n\r");                        
                     
                     serial_bridge.printf("Available for Reading = %3d (Free Space = %3d)\n\r", serial_bridge.readableCount(), SC16IS750_FIFO_RX - serial_bridge.readableCount() );                     
                     serial_bridge.printf("Available for Writing = %3d (Used Space = %3d)\n\r", serial_bridge.writableCount(), SC16IS750_FIFO_TX - serial_bridge.writableCount());                                            
                     
                     pc.printf("\n\rTest printf() done\n\r");                                         
                     break;
          default :
                     break;                     

         } //switch
       } //if  
    } //while
   
  pc.printf("\nBye World!\n");    
}
