// NUClight_TEST1_V3 
// Diese Software testet die verschiedenen Funktionen des M0 Boards  
// BULME Graz,     by F. Wolf   05.10.2019
/*
                             PIN-OUT-NUClight
                                NUCLEO-L432KC
                     RGB-rot   D1|-------| VIn
                     RGB-gruen D0|       | GND
                             NRST|       | RST
                              GND|       | 5V0
                        LED1 <-D2|       | A7
                        LED2 <-D3|       | A6 -> LED7
SDA (I2C)  (MPU6050 gyro)   <- D4|       | A5
SCL (I2C)  (MPU6050 gyro)   <- D5|       | A4
                        LED3 <-D6|       | A3 -> POTI
                            nc D7|       | A2 -> Taster
                            nc D8|       | A1 -> Taster
                         LED4  D9|       | A0 -> DS18B20
                  RGB-blau <- D10|       | ARF
                      LED5 <- D11|       | 3V0
                      LED6 <- D12|-------| D13 -> LED8
        
 RGB LED aktiv hight (1)       
 */   
        
#include "mbed.h"


// ********   Definitionen  **********
//Serial pc(USBTX, USBRX);
Serial pc(SERIAL_TX,SERIAL_RX);



DigitalOut L0 (D2) ;  // led L0
DigitalOut L1 (D3) ;  // led L1
DigitalOut L2 (D6) ;  // led L2

void led1_thread();
void led2_thread();

Thread thread1 (osPriorityNormal,2*OS_STACK_SIZE );
Thread thread2 (osPriorityNormal,2*OS_STACK_SIZE );

// main is the 1st thread
int main(void) 
{   
    pc.printf("3-threads-%s %s",__DATE__,__TIME__);
    pc.printf("mbed-os-3-threads-%s %s\n\r",__DATE__,__TIME__);
    pc.printf("DEFAULT_STACK_SIZE:%d\n\r", OS_STACK_SIZE); 

    thread1.start(led1_thread);   
    thread2.start(led2_thread);
    
    thread2.join();  // wartet bis thread2 fertig ist
 
    while(1){
        L0=!L0;
        pc.printf("*     [pid-%d]Main \n\r",osThreadGetId());
        wait(0.0200);  
    }
}

void led1_thread(){
    
    
    while (1) {
        L1 = ! L1;
        pc.printf("  *   [pid-%d]led1_thread_1 \n\r",osThreadGetId());
        wait(0.500);  
  }
}

void led2_thread(){
    while (1) {
        L2 = ! L2;
        pc.printf("     *[pid-%d]led2_thread_2 \n\r",osThreadGetId());
        
        for(int i=0; i<100; i++) {
         pc.printf("Zahl %d\n", i+1);
        }
        
        
        wait(2.500);  
        
       
   }
}

    