
 


  
  /*
 *  Copyright (c) 2012 Neal Horman - http://www.wanlink.com
 *  
 *  License: MIT open source (http://opensource.org/licenses/MIT)
 *      Summary;
 *      Use / modify / distribute / publish it how you want and 
 *      if you use it, or don't, you can't hold me liable for how
 *      it does or doesn't work.
 *      If it doesn't work how you want, don't use it, or change
 *      it so that it does work.
 */
 
#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include "DS1820.h"




//****** Definitionen **********************
Serial pc(SERIAL_TX,SERIAL_RX);  //nucleo
 
// DS1820 Temperatursensor
#define DATA_PIN        A0  // DS18B20
DS1820      ds1820(DATA_PIN);             // create a ds1820 sensor
 

// an I2C sub-class that provides a constructed default
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(400000);
        start();
    };
};
 

 
I2CPreInit gI2C(D4,D5);
Adafruit_SSD1306_I2c gOled2(gI2C,NC,0x78,64,128);  
// NC not connected
// 0x78 i2c adress
// 64x128 auflösung 
int main()
{   uint16_t x=0;
 
 


    // Invert Display
    //display.invertDisplay(1);
 
   
   // gOled2.printf("%ux%u OLED Display\r\n", gOled2.width(), gOled2.height());
    
    while(1)
    {
        gOled2.printf("%u\r",x);
        gOled2.display();
        x++;
        wait(1.0);
        
          //DS18B20
        if(ds1820.begin()) 
        {
            ds1820.startConversion();   // start temperature conversion
            wait(1.0);                  // let DS1820 complete the temperature conversion
            pc.printf("temprature DS1820 = %3.1f ^C\r\n", ds1820.read(),248);     // read temperature
            pc.printf("__________________\r\n");
            gOled2.printf("DS1820 = %3.1f ^C\r\n",ds1820.read());
        }
        else
        {
            pc.printf("No DS1820 sensor found!\r\n");
        }
        
        
        
    }
}


