// Diese Software testet die verschiedenen Funktionen des NUClight V3 Boards  
// BULME Graz,     
// by F. Wolf   20.10.2019
/*
                             PIN-OUT-NUClight
                                NUCLEO-L432KC
                     RGB-rot   D1|-------| VIn
                     RGB-gruen D0|       | GND
                             NRST|       | RST
                              GND|       | 5V0
                        LED1 <-D2|       | A7
                        LED2 <-D3|       | A6 -> LED7
SDA (I2C)  (MPU6050 gyro)   <- D4|       | A5
SCL (I2C)  (MPU6050 gyro)   <- D5|       | A4
                        LED3 <-D6|       | A3 -> POTI
                            nc D7|       | A2 -> Taster
                            nc D8|       | A1 -> Taster
                         LED4  D9|       | A0 -> DS18B20
                  RGB-blau <- D10|       | ARF
                      LED5 <- D11|       | 3V0
                      LED6 <- D12|-------| D13 -> LED8
        
 RGB LED aktiv hight (1)       
 */   
#include <mbed.h>
#include "MPU6050.h"
#include "DS1820.h"

//****** Definitionen **********************
Serial pc(SERIAL_TX,SERIAL_RX);  //nucleo

// Definition der Taster (Switches)
InterruptIn sw1(A1); 
InterruptIn sw2(A2); 
AnalogIn   ain(A3);

// Definition der 8 LED's
DigitalOut led1(D2);
DigitalOut led2(D3);
DigitalOut led3(D6);
DigitalOut led4(D9);
DigitalOut led5(D11);
DigitalOut led6(D12);
DigitalOut led7(A6);
DigitalOut led8(D13);   // on Board LED

// RGB LED
PwmOut RGBg(D0);  // gruen LED
PwmOut RGBr(D1);  // rote LED
PwmOut RGBb(D10); // blaue LED

// DS1820 Temperatursensor
#define DATA_PIN        A0  // DS18B20
DS1820      ds1820(DATA_PIN);             // create a ds1820 sensor

// GY-521 Module MPU-6050 3-Achsen-Gyroskop + 3 Achsen Accelerometre
MPU6050 ark(D4,D5); // MPU6050(PinName sda, PinName scl);

// ********** Deklarationen **************
void RGBtest();
void LEDtest();
void LEDonoff();

// variable
int a;          
int num_devices = 0;     

// **********  Hauptprogramm ************** 
int main()
{
    pc.printf("******** TEST-SW *************\r\n"); //HTerm Welcome Message  
    pc.printf("TEST-SW Welcome to NUClight V3 \r\n"); //HTerm Welcome Message 
    pc.printf("*******************************\r\n"); //HTerm Welcome Message 
    while(1)
    {
        // attach the address of the flip function to the rising edge
        sw1.fall(&RGBtest);      //RGB-Test Unterprogramm aufrufen
        sw2.fall(&LEDonoff);     //LED ON OFF - Test Unterprogramm aufrufen
        pc.printf("percentage: %3.0f%%\r\n", ain.read()*100.0f);  
        RGBr.period_ms(20.0f);  // 20 mili second period
        RGBr.pulsewidth_ms(ain.read()*10.0f);  //  5 mili second pulse (on)
        
        wait(1);      
        // *** MPU6050 (gyro) TEST        
        // reading Temprature
        float temp = ark.getTemp();

        pc.printf("MPU6050-temprature = %0.2f ^C\r\n",temp); 
        pc.printf("__________________\r\n");
        //reading Gyrometer readings
        float gyro[3];
        ark.getGyro(gyro);
        pc.printf("Gyroscope\r\n");
        pc.printf("__________________\r\n");
        pc.printf("Gyro0=%0.3f,  Gyro1=%0.3f,  Gyro2=%0.3f\r\n",gyro[0],gyro[1],gyro[2]);
        //reading Acclerometer readings
        float acce[3];
        ark.getAccelero(acce);
        pc.printf("Accelerometer\r\n");
        pc.printf("__________________\r\n");
        pc.printf("Acce0=%0.3f,  Acce1=%0.3f,  Acce2=%0.3f\r\n",acce[0],acce[1],acce[2]);
        wait(1); //wait 1000ms
        
        //DS18B20
        if(ds1820.begin()) 
        {
            ds1820.startConversion();   // start temperature conversion
            wait(1.0);                  // let DS1820 complete the temperature conversion
            pc.printf("temprature DS1820 = %3.1f ^C\r\n", ds1820.read(),248);     // read temperature
            pc.printf("__________________\r\n");
        }
        else
        {
            pc.printf("No DS1820 sensor found!\r\n");
        }
    }
}


// **********  Funktionen **************   
// TEST-RGB
//------------------------------------
void RGBtest()
{
    pc.printf("RGBTEST\r\n"); //HTerm Ausgabe
    LEDtest();
    for (int t=1; t<15;t++)
    {
        RGBr.period_ms(20.0f);  // 20 mili second period
        RGBr.pulsewidth_ms(t);  //  5 mili second pulse (on)
        wait(0.3);
    }
    
    RGBr.pulsewidth_ms(0);  //  5 mili second pulse (on) 
    for (int t=1; t<15;t++)
    {
        RGBg.period_ms(20.0f);  // 20 mili second period
        RGBg.pulsewidth_ms(t);  //  5 mili second pulse (on)
        wait(0.3);
    }

    RGBr.pulsewidth_ms(0);  //  5 mili second pulse (on)
    RGBg.pulsewidth_ms(0);  //  5 mili second pulse (on)
    for (int t=1; t<15;t++)
    {
        RGBb.period_ms(20.0f);  // 20 mili second period
        RGBb.pulsewidth_ms(t);  //  5 mili second pulse (on)
        wait(0.3);
    }
    wait(1);
    RGBr.pulsewidth_ms(0);  //  RGB-LED off
    RGBg.pulsewidth_ms(0);  //  
    RGBb.pulsewidth_ms(0);  //
    
    int rr=(rand()%15);
    int rg=(rand()%15);
    int rb=(rand()%15);
    
    RGBr.period_ms(20.0f);  // 20 mili second period
    RGBr.pulsewidth_ms(rr);  //  5 mili second pulse (on)
    
    RGBg.period_ms(20.0f);  // 20 mili second period
    RGBg.pulsewidth_ms(rg);  //  5 mili second pulse (on)
    
    RGBb.period_ms(20.0f);  // 20 mili second period
    RGBb.pulsewidth_ms(rb);  //  5 mili second pulse (on)
    
    wait(1);
    RGBr.pulsewidth_ms(0);  //  RGB-LED off
    RGBg.pulsewidth_ms(0);  //  
    RGBb.pulsewidth_ms(0);  //
   
}

// TEST-LED
//------------------------------------
void LEDtest()
{
    pc.printf("LAUFLICHT UEBER 8 LED (5-mal) \r\n"); //HTerm Ausgabe
    a=0;
    while (a<5) {   
        led1=1;     //Led1 einschalten
        wait(0.2);
        led1=0;     //Led1 ausschalten
        
        led2=1;     //Led2 einschalten
        wait(0.2);
        led2=0;     //Led2 ausschalten
        
        led3=1;     //Led3 einschalten
        wait(0.2);
        led3=0;     //Led3 ausschalten
        
        led4=1;     //Led1 einschalten
        wait(0.2);
        led4=0;     //Led1 ausschalten
        
        led5=1;     //Led2 einschalten
        wait(0.2);
        led5=0;     //Led2 ausschalten
        
        led6=1;     //Led3 einschalten
        wait(0.2);
        led6=0;     //Led3 ausschalten
        
        led7=1;     //Led2 einschalten
        wait(0.2);
        led7=0;     //Led2 ausschalten
        
        led8=1;     //Led3 einschalten
        wait(0.2);
        led8=0;     //Led3 ausschalten
        a++;
        }
}

// TEST-LED-on-off
//------------------------------------
void LEDonoff()
{
    led1=!led1;     //Led1 einschalten
    led2=!led2;     //Led1 einschalten
    led3=!led3;     //Led1 einschalten
    led4=!led4;     //Led1 einschalten
    led5=!led5;     //Led1 einschalten
    led6=!led6;     //Led1 einschalten
    led7=!led7;     //Led1 einschalten
    led8=!led8;     //Led1 einschalten
}
/********************   ENDE  ***********************/