#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD20x4); // rs, e, d4-d7
PwmOut led(p25);
Serial device(p9, p10);  // tx, rx
DigitalIn Opt(p5);       // option button
DigitalIn Sel(p6);       // select/tag button
DigitalOut IRled(LED1);  // Blinks for serial input from the IR sensor
DigitalOut tagled(LED2); // Blinks for a confirmed tag
Timer timer;            // used to timestamp incoming tags
int State;
char Tags[500];
float Tstamp[500];
int TagsElem=0;
char TaggerID=0;
char MyTagID=0;
char LCDText[][9]=
   {"CHOOSE  ",
    "ID      ",
    "ABCDEFGH",
    "IJKLMNOP",
    "QRSTUVWX",
    "YZ      ",
    "TAGGED  ",
    "00 TIMES",
    "BY 0    ",};
//int main() {
    //lcd.printf("Hello World!\n");
//}

void callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    IRled=1;
    Tags[TagsElem] = device.getc();
    Tstamp[TagsElem] = timer.read();
    
    if (Tags[TagsElem] != MyTagID)
    {
    TagsElem++;
    }
    IRled=0;    
}

int tagcount()
{
float LastTagTime=0;
int counter=0;
for (int i=0;i<=TagsElem-2;i++)
{
    if (TagsElem>2)
    {
        if ((Tags[i]==Tags[i+1]) && (Tags[i+1]==Tags[i+2]) && ('A'<=Tags[i]<='Z') && ((Tstamp[i+2]-Tstamp[i])<.25) && ((LastTagTime+.25)<Tstamp[i+2]))
        {
        TaggerID=Tags[i];
        LastTagTime = Tstamp[i+2];
        counter++;
        }
        
        
    }
}
return counter;
}

void scrnslct(char n)
{
int alpha;
int row;
int col;
lcd.cls();
    if (n=='0')
        {
        lcd.printf("%s\n%s",LCDText[0],LCDText[1]);
        }
    if (n=='1')
        {
        lcd.printf("%s\n%s",LCDText[6],LCDText[7]);
        }
    if (n=='2')
        {
        lcd.printf("%s\n%s",LCDText[6],LCDText[8]);
        }
    if ('A'<=n<='Z')
        {
        alpha=n-'A';
        row=alpha/8;
        col=alpha%8;
        lcd.printf("%c",LCDText[2+row][col]);
        }
    else
    lcd.printf("ERROR1");                   //ERROR1= No screen selected by program, error not caused by user
}

int State0()
{
    scrnslct('0');
while(1)
{
    if (Opt==1)
    {
    wait(.25);
    return 0;
    }
    if (Sel==1)
    {
    wait(.25);
    return 1;
    }
}
}

int State1()
{
scrnslct('A');
char c='A';
while(1)
{

    if (Opt==1)
    {
    wait(.2);
    
        if (c=='Z')
        {
            c='A';
        }
        else
        c++;
        scrnslct(c);
    }
    if (Sel==1)
    {
    wait(.25);
    MyTagID=c;
    return 2;
    }

}
}

int State2()
{
timer.reset();
TagsElem=0;
memset(&Tags[0], '0', sizeof(Tags));
int check=TagsElem;
int c=tagcount();
int compare=c;
float timer1;
int TagsOnes = 48;                  // 48 is the decimal value of the ASCII char '0'
int TagsTens = 48;                  // a variable for the tens place and the ones place
//LCDText[7][0]=TagsTens;
//LCDText[7][1]=TagsOnes;
scrnslct('1');
timer.start();
while (1)
{
    c=tagcount();
    if(check != TagsElem)                              //only true if the IR sensor recieves data, probably a tag
    {
        if (compare != c)
        {
            tagled=1;
            LCDText[8][3]=TaggerID;
            scrnslct('2');
            wait(2);
            LCDText[7][0]=TagsTens+c/10;
            LCDText[7][1]=TagsOnes+c%10;
            scrnslct('1');
            compare = c;
            tagled=0;
        }
        check = TagsElem;
    }
    
    if (Sel==1)
    {
        wait(.1);
        timer1=timer.read();
        while ((timer.read()-timer1)<.25)                         //sends out my tag constantly for the amount of seconds to the right of the "<"
        {
            device.putc(MyTagID);
        }
    }
    if (Opt==1)
    {
        wait(.25);
        return 0;
    }
    
}
}

int main() {
    device.attach(&callback);
    //lcd.cls();
    led.period_us(26.3);
    led=.5;
    device.baud(1200);
    State=0;
    while(1)
    {   
    
        if (State==0)
        {
        State=State0();
        }
        
        if (State==1)
        {
        State=State1();
        }
        
        if (State==2)
        {
        State=State2();
        }
    }    
}