#include "mbed.h"
#include <RF24Network.h>
#include <RF24.h>

Serial pc(USBTX, USBRX);

RF24 radio(SPI_MOSI, SPI_MISO, SPI_SCK, D9, SPI_CS );

// Network uses that radio
RF24Network network(radio);

// Address of our node
const uint16_t this_node = 00;

// Address of the other node
const uint16_t other_node = 01;

// When did we last send?
unsigned long last_sent;

// How many have we sent already
unsigned long packets_sent;

// Structure of our payload
struct payload_t 
{
    unsigned long ms;
    unsigned long counter;
};


int main()
{
    pc.baud(115200);
    wait_ms(1000);

    pc.printf("mBed RF24Network node\n");
    radio.begin();
    network.begin(/*channel*/ 90, /*node address*/ this_node);
    wait_ms(2000);

    while(1) 
    {
        // Pump the network regularly
        network.update();
        
        // Is there anything ready for us?
        while ( network.available() ) 
        {
            // If so, grab it and print it out
            RF24NetworkHeader header_rx;
            payload_t payload_rx;
            network.read(header_rx,&payload_rx,sizeof(payload_rx));
            pc.printf("Received packet # %d at %d ms\r\n",payload_rx.counter,payload_rx.ms);
        }

    }

}