#include "mbed.h"
#include "WakeUp.h"
#include <stdlib.h>


DigitalIn progMode(P0_3);

DigitalOut LED[] = {(P0_7), (P0_8), (P0_2), (P0_20), (P1_19), (P0_17), (P0_23)};// declare 7 LEDs

void myDeepSleep() {
    LPC_PMU->PCON = 0x1;
    SCB->SCR |= SCB_SCR_SLEEPDEEP_Msk;
    LPC_SYSCON->PDAWAKECFG &= 0xFFFFF800;
    __WFI();
}


int main() {

    int i = 0;
    
    
    
    // Unconfigured GPIO pins default to having the internal pullups enabled. 
    // The board has a pull down on pin P0_3. This conflict was causing the extra power draw in sleep mode.
    // Therefor we disable internal pull-ups to ensure low current mode
    progMode.mode(PullNone);

    
    //The low-power oscillator can be quite inaccurate on some targets
    //this function calibrates it against the main clock
    WakeUp::calibrate();
    while(1)
    {  
        LED[i] = 1; // turn on
        wait(.05);   // delay
        LED[i] = 0; // turn off
        
         //Set wakeup time for second
        WakeUp::set_ms(5000);
        //Enter deepsleep, the program won't go beyond this point until it is woken up
        myDeepSleep();
        i++;
        if (i >= 7) 
           i = 0;             
    }
}