#include "mbed.h"

//Defining the keypad rows as outputs and columns as inputs
Serial pc(USBTX, USBRX);
DigitalOut row2(p17);
DigitalOut row3(p12);
DigitalOut row4(p15);
DigitalOut row1(p18);

DigitalIn column1(p16);
DigitalIn column2(p14);
DigitalIn column3(p13);
DigitalIn column4(p12);

DigitalOut buzzer(p22);  

//defining tickers                                                                                                                                                  
Ticker rowsTick;
Ticker tick;

//function to flip the buzzer value for generating sounds
int i = 0;

//function to flip the buzzer value
void outFreq(){ 
    buzzer =! buzzer;      
    }

//defining class for sound
class Speaker
{
public:
    Speaker(PinName pin) : inpPin(pin) {
    }
//function to play the sound for according to the key pressed
    void Output(float frequency, float sound) {
        inpPin.period(1.0/frequency);
        inpPin = sound;
    }
 //defining the inpPin as PwmOut so that microcontroller recoginses it
    PwmOut inpPin;
};

//iterating over the rows in a cycle  
void row_press()
 {
        if(i < 4)
        {
              i++;
        }
        else
        {
         i = 1;
        } 
}

int main(){ 

//initializing all rows to zero
    Speaker speaker1(p21);
    row1 = 0;
    row2 = 0;
    row3 = 0; 
    row4 = 0;
    
//calling a ticker once every 4ms

    rowsTick.attach_us(&row_press, 4000);      

    while(1){  
        //checking each row and creating the sound accordingly
        // Check for Row 1
        if(i == 1){
             row1 = 1;
             if(column1 == 1){     
                  
                speaker1.Output(1209, 0.5); 
                buzzer = 0;            
                tick.attach(&outFreq, 0.5/697.0);
                wait_ms(16);
                speaker1.Output(0, 0.0);
                pc.printf("1"); 
                tick.detach();                                                       
                }     
            else if(column2 == 1){
                speaker1.Output(1336, 0.5); 
                buzzer = 0;            
                tick.attach(&outFreq, 0.5/697.0); 
                wait_ms(16);
                speaker1.Output(0, 0.0);
                tick.detach();      
                pc.printf("2");         
                }
            else if(column3 == 1){ 
                speaker1.Output(1477, 0.5); 
                buzzer = 0;            
                tick.attach(&outFreq, 0.5/697.0); 
                wait_ms(16);
                speaker1.Output(0, 0.0);
                tick.detach();        
                pc.printf("3");       
                }
            else if(column4 == 1){
                pc.printf("A");
                speaker1.Output(1633, 0.5);  
                buzzer = 0;            
                tick.attach(&outFreq, 0.5/697.0); 
                wait_ms(16);
                speaker1.Output(0, 0.0);
                tick.detach();               
                } 
                row1 = 0;    
            }
        // Check for Row 2
         if(i == 2){
             
             row2 = 1;
             
             if(column1 == 1){
                pc.printf("4"); 
                speaker1.Output(1209, 0.5);  
                buzzer = 0;            
                tick.attach(&outFreq, 0.5/770.0); 
                wait_ms(16);
                speaker1.Output(0, 0.0);
                tick.detach();                         
                }
            else if(column2 == 1){
                pc.printf("5");
                speaker1.Output(1336, 0.5);   
                buzzer = 0;            
                tick.attach(&outFreq, 0.5/770.0); 
                wait_ms(16);
                speaker1.Output(0, 0.0);
                tick.detach();              
                }
            else if(column3 == 1){
                pc.printf("6"); 
                speaker1.Output(1477, 0.5);  
                buzzer = 0;            
                tick.attach(&outFreq, 0.5/770.0); 
                wait_ms(16);
                speaker1.Output(0, 0.0);
                tick.detach();                
                }
            else if(column4 == 1){
                pc.printf("B"); 
                speaker1.Output(1633, 0.5);      
                buzzer = 0;            
                tick.attach(&outFreq, 0.5/770.0); 
                wait_ms(16);
                speaker1.Output(0, 0.0);
                tick.detach();           
                }    
                row2 = 0;     
            }
        // Check for Row 3   
        if(i == 3){
             
             row3 = 1;
             
             if(column1 == 1){
                pc.printf("7"); 
                speaker1.Output(1209, 0.5); 
                buzzer = 0;            
                tick.attach(&outFreq, 0.5/852.0); 
                wait_ms(16);
                speaker1.Output(0, 0.0);
                tick.detach();                          
                }
            else if(column2 == 1){
                pc.printf("8");
                speaker1.Output(1336, 0.5); 
                buzzer = 0;            
                tick.attach(&outFreq, 0.5/852.0); 
                wait_ms(16);
                speaker1.Output(0, 0.0);
                tick.detach();            
                }
            else if(column3 == 1){
                pc.printf("9"); 
                speaker1.Output(1477, 0.5); 
                buzzer = 0;            
                tick.attach(&outFreq, 0.5/852.0); 
                wait_ms(16);
                speaker1.Output(0, 0.0);
                tick.detach();             
                }
            else if(column4 == 1){
                pc.printf("C");   
                speaker1.Output(1633, 0.5);  
                buzzer = 0;            
                tick.attach(&outFreq, 0.5/852.0); 
                wait_ms(16);
                speaker1.Output(0, 0.0);
                tick.detach();          
                }   
                row3 = 0;      
            }
        
        // Check for Row 4
        if(i == 4){
             
             row4 = 1;
             
             if(column1 == 1){
                pc.printf("*"); 
                speaker1.Output(1209, 0.5); 
                buzzer = 0;            
                tick.attach(&outFreq, 0.5/941.0); 
                wait_ms(16);
                speaker1.Output(0, 0.0);
                tick.detach();                          
                }
            else if(column2 == 1){
                pc.printf("0");
                speaker1.Output(1336, 0.5);  
                buzzer = 0;            
                tick.attach(&outFreq, 0.5/941.0); 
                wait_ms(16);
                speaker1.Output(0, 0.0);
                tick.detach();               
                }
            else if(column3 == 1){
                pc.printf("#");
                speaker1.Output(1477, 0.5);  
                buzzer = 0;            
                tick.attach(&outFreq, 0.5/941.0); 
                wait_ms(16);
                speaker1.Output(0, 0.0);
                tick.detach();               
                }
            else if(column4 == 1){
                pc.printf("D");  
                speaker1.Output(1633, 0.5);
                buzzer = 0;            
                tick.attach(&outFreq, 0.5/941.0); 
                wait_ms(16);
                speaker1.Output(0, 0.0);
                tick.detach();               
                }  
                row4 = 0;    
            }  
    }
    
}