
#include "mbed.h"
#include "ble/BLE.h"

Ticker timer;

DigitalIn pir_signal_pin(P0_10);

BLE& ble = BLE::Instance(BLE::DEFAULT_INSTANCE);

/* Optional: Device Name, add for human read-ability */
const static char     DEVICE_NAME[] = "BLEBEACON";

/* You have up to 26 bytes of advertising data to use. */
uint8_t AdvData[] = {0x01,0x02,0x03,0x04,0x00};   /* Example of hex data */

const uint8_t SERVICE_UUID[] = {0xAA, 0xFE};


class AdvertisementPacketHandler {
public:
    AdvertisementPacketHandler(BLE&);
    void updatePIRValue(){
        
        AdvData[4] = pir_signal_pin;     
        ble.gap().clearAdvertisingPayload();
        ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
        ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, SERVICE_UUID, sizeof(SERVICE_UUID));
        ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::SERVICE_DATA, AdvData, sizeof(AdvData) );
        ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    };
private:
    BLE &ble;
};

AdvertisementPacketHandler::AdvertisementPacketHandler(BLE &bleIn): ble(bleIn){
        
};


/**
 * This function is called when the ble initialization process has failed
 */
void onBleInitError(BLE &ble, ble_error_t error)
{
    /* Avoid compiler warnings */
    (void) ble;
    (void) error;
    
    /* Initialization error handling should go here */
}    

/**
 * Callback triggered when the ble initialization process has finished
 */
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {
        /* In case of error, forward the error handling to onBleInitError */
        onBleInitError(ble, error);
        return;
    }

    /* Ensure that it is the default instance of BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }
    
    /* Set device name characteristic data */
    ble.gap().setDeviceName((const uint8_t *) DEVICE_NAME);
    
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_NON_CONNECTABLE_UNDIRECTED);
  
    ble.gap().setAdvertisingInterval(1000); /* 1000ms */
   
    
    /* Start advertising */
    ble.gap().startAdvertising();
}

int main(void)
{ 
    /* Initialize BLE baselayer, always do this first! */
    ble.init(bleInitComplete);

    /* SpinWait for initialization to complete. This is necessary because the
     * BLE object is used in the main loop below. */
    while (!ble.hasInitialized()) { /* spin loop */ }
    
    AdvertisementPacketHandler f(ble);

    timer.attach( &f, &AdvertisementPacketHandler::updatePIRValue, 1.0); 
    while (true) {
        ble.waitForEvent();
    }
}
