#include "mbed.h"
#include "HCSR04.h"

float sampleTime = 0.05f;//Ehemals 0.5

HCSR04::HCSR04(InterruptIn& echo, DigitalOut& trigger) : echo(echo), trigger(trigger) {
                                            
    ticker_sens.attach(callback(this, &HCSR04::startMeasurement), sampleTime);
    init();
        //ticker.attach(callback(this, &Controller::run), PERIOD);
}

HCSR04::~HCSR04()
{
    ticker_sens.detach(); // Stoppt den periodischen Task
}

void HCSR04::init() {
    distance = -1;      // initial distance
    minDistance = 2;
    maxDistance = 400;
    newDataReady = timerStarted = false;
}

void HCSR04::startTimer() {
    if (!timerStarted) {
        timer.start(); // start the timer
        timerStarted = true;
        echoTimeout.attach_us(this, &HCSR04::stopTimer, 25000); // in case echo fall does not occur
        echo.fall(this, &HCSR04::stopTimer);
        echo.rise(NULL);
    }
}

void HCSR04::stopTimer() {
    timer.stop(); // stop the timer
    if (timerStarted) {
        distance = timer.read() * 1e6 / 58;
        if (distance < minDistance)
            distance = minDistance;
        if (distance > maxDistance)
            distance = maxDistance;
        newDataReady = true;
    }
    timer.reset();
    timerStarted = false;
    echoTimeout.detach();
    echo.fall(NULL);
}

void HCSR04::turnOffTrigger() {
    trigger = 0; 
}

void HCSR04::startMeasurement() {
    trigger = 1;
    triggerTimeout.attach_us(this, &HCSR04::turnOffTrigger, 10);//Ehemals 10
    echo.rise(this, &HCSR04::startTimer);
    newDataReady = false;
}

float HCSR04::getDistance_cm() {
    newDataReady = false;
    return distance;
}

float HCSR04::getDistance_mm() {
    newDataReady = false;
    return distance * 10;
}

bool HCSR04::isNewDataReady() {
    return newDataReady;
}

void HCSR04::setRanges(float minRange, float maxRange) {
    if (minRange < maxRange) {
        if (minRange >= 2 && minRange < 400) // bug from revs. 4 and 5 corrected
            minDistance = minRange;
        if (maxRange <= 400)
            maxDistance = maxRange;
    }
}

float HCSR04::getMinRange() {
    return minDistance;
}

float HCSR04::getMaxRange() {
    return maxDistance;
}