#include "mbed.h"
#include "SLCD.h"
#include <string>
#include <cstring>
using namespace std;

typedef struct msg_t {
    char msg[5];
    int value;
    } msg_t;
   
DigitalOut led1(LED1);
DigitalOut led2(LED2);
Thread th_1;
Thread th_2;
Queue<msg_t, 8> infoQueue;
//Queue<int, 8> infoQueue;
Mutex LCD_mutex;
SLCD slcd;
msg_t* msg;

void getTime()
{

    //char* buffer; 
    int second;
    int minute;
    int hour;
    second = 0;
    minute = 0;
    hour = 0;
    printf("get time\n");
    while(true) {
        second=second + 1;
        msg->value = second;
        if(second >= 60) {
            minute ++;
            second = 0;
            if(minute >= 60) {
                hour ++;
                minute = 0;
            }
        }
       
        if (second <10){
            msg->msg[3]='0';
            msg->msg[4]=second;
            }
        else {
            msg->msg[3]=(second / 10);
            msg->msg[4]=(second % 10);
            }
        if (hour <10){
            msg->msg[0]=0;
            msg->msg[1]=hour;
            }
        else {
            msg->msg[0]=(hour / 10);
            msg->msg[1]=(hour % 10);
            }
        msg->msg[2]=':';
        //printf("message sent is :%c\n",msg->msg[4]);
        printf("value is :%d\n",msg->value);
        
        infoQueue.put(msg);
        led1=!led1;
        wait_ms(1000);
    }
}

void dispLCD()
{
    //string* msg;
    //msg_t* msg;
    printf("disp\n");
    while(true) {
        osEvent evt = infoQueue.get();
        //printf("queue received\n");
        if (evt.status == osEventMessage) {
            msg = (msg_t*)evt.value.p;
        }
        printf("message\n");
        printf("received msg is %s\n",msg->msg);
        LCD_mutex.lock();
        //char * buffer = new char [msg.length()+1];
        slcd.printf("%s",msg->msg);
        LCD_mutex.unlock();
    }
}

int main()
{
    printf("main\n");
    th_1.start(getTime);
    th_2.start(dispLCD);
    //printf("thread started\n");
}

