//CS435 Final Project: Ralph Lira, Mohammed Ramlaoui, Ian Rysdale
#include "mbed.h"
#include "TextLCD.h"
#include "DHT.h"
#include "beep.h"

DHT sensor(D2, DHT11);
DigitalIn button(PB_3);
DigitalOut redLED(PB_10);
DigitalOut greenLED(PA_8);
PwmOut speaker(PB_4);
TextLCD ark(PA_0,PA_1,PA_4,PB_0,PC_1,PC_0);

Timer t;

int main()
{
    redLED = 0;
    greenLED = 0;
    float c = 0.0f, f = 0.0f, h = 0.0f;
    
    while(1) 
    {
        sensor.readData();
        if (button == 0)
        {
            wait_us(250000.0f);
            if(button == 1)
            {
                t.reset();
                t.start();
                while (t.read() < 10.0f)
                {
                    f   = sensor.ReadTemperature(FARENHEIT);
                    h   = sensor.ReadHumidity();

                    if(h >= 40.0f)
                    {
                        redLED = 1;
                        greenLED = 0;
                        speaker.period(1.0f/500.0f);
                        speaker = 0.5f;

                    }
                    else if(f >= 65.0f)
                    {
                        redLED = 1;
                        greenLED = 0;
                        speaker.period(1.0f/500.0f);
                        speaker = 0.5f;

                    }
                    else
                    {
                        redLED = 0;
                        greenLED = 1;
                        speaker = 0.0f;
                    }
                    printf("---------------------------------------\r\n");
                    printf("Temperature in Farenheit %4.2f\r\n", f);
                    printf("\r\n");
                    printf("Humidity is %4.2f\r\n", h);
                    printf("Time is %4.2f\r\n", t.read());
                    printf("---------------------------------------\r\n");
                    printf("\n");
                    ark.locate(0,1);
                    ark.cls();
                    ark.printf("Temp:%4.2f\n", f);
                    ark.printf("H:%4.2f", h);
                    ark.printf(" %4.2f", t.read());
                }
               t.stop();
               ark.cls();
               ark.printf("Sleep Mode\n");
               ark.printf("Press button\n");
               redLED = 0;
               greenLED = 0;
               speaker = 0.0f;
               ThisThread::sleep_for(50);
               __WFI();
            }
        }
        else
        {
           printf("Sleep Mode, press button to run\r\n");
           ark.cls();
           ark.printf("Sleep Mode\n");
           ark.printf("Press button\n");
           redLED = 0;
           greenLED = 0;
           ThisThread::sleep_for(50);
           __WFI();
        }
    }
}