#include "mbed.h"
#include "DebounceIn_.h"
#include <stdlib.h>
#include <stdbool.h>


DebounceIn button1(p15);
DebounceIn button2(p16);
DebounceIn button3(p17);
DebounceIn button4(p21);

class CSimonButton {
    _Bool pressed;
    int button;
  public:
          CSimonButton();
    _Bool IsPressed(void);
    int   GetButton(void) {return button;};
    void  Handle(void);
    void  Reset(void); // {pressed = 0;};
};

void CSimonButton::Reset(void) {
  pressed = 0;
  button1.pressed = 0;
  button2.pressed = 0;
  button3.pressed = 0;
  button4.pressed = 0;
}

CSimonButton::CSimonButton() {
    button1.mode(PullUp);
    button2.mode(PullUp);
    button3.mode(PullUp);
    button4.mode(PullUp);
    Reset(); // pressed = 0;
}

_Bool CSimonButton::IsPressed(void) {
  _Bool tmp;
  
  tmp = pressed;
  pressed = 0;
  return tmp;
}

void CSimonButton::Handle(void) {
      if  (button1.pressed) {
        button1.pressed = 0;
        pressed = 1;
        button = 1;
      }
      if  (button2.pressed) {
        button2.pressed = 0;
        pressed = 1;
        button = 2;
      }
      if  (button3.pressed) {
        button3.pressed = 0;
        pressed = 1;
        button = 3;
      }
      if  (button4.pressed) {
        button4.pressed = 0;
        pressed = 1;
        button = 4;
      }
  
}

CSimonButton simonButton;

BusOut leds(LED1, LED2, LED3, LED4);

#define SIMON_MIN_SEQUENCE 3
#define SIMON_MAX_SEQUENCE 10
int simonPuzzle[SIMON_MAX_SEQUENCE];  // storage for the current puzzle
int simonLevel;                       // current level


int Random(int bound) {
  return rand() % bound;
}

void InitSimon(void) {
  // prepare puzzle array
  for (int i = 0; i < SIMON_MAX_SEQUENCE; i++) {
    simonPuzzle[i] = Random(4);
  }
  simonLevel = SIMON_MIN_SEQUENCE;
  // visual: rapid blinking 
  for (int i = 0; i < 10; i++) {
    leds.write(0x0F);
    wait(0.1);
    leds.write(0);
    wait(0.1);
  }
  wait(1.0);  
}

void PresentSimon(void) {  // present the puzzle up to current simonLevel
  for (int i = 0; i < simonLevel; i++) {
    leds.write(1 << simonPuzzle[i]);
    wait(0.3);
    leds.write(0);
    wait(0.3);
  }
}

_Bool AnswerSimon(void) {
  int i = 0;
  int button;
  simonButton.Reset();
  while (i < simonLevel) {
      simonButton.Handle();
      if (simonButton.IsPressed()) {
        button = simonButton.GetButton() - 1;
        leds.write(1 << button);
        wait(0.3);
        leds.write(0);
        if (button != simonPuzzle[i]) {
          return 0;
        } else {
          i++;
        }
      }
  }
  wait(0.5);
  return 1;
}

void WinCeremony(void) {
  for (int i = 0; i < 200; i++) {
    leds.write(Random(0x10));
    wait(0.03);
  }
  leds.write(0);
  wait(2.0);
}

void YesCeremony(void) {
  for (int i = 0; i < 3; i++) {
    leds.write(0x0F);
    wait(0.2);
    leds.write(0);
    wait(0.1);
  }
  wait(1.0);
}


void NoCeremony(void) {
  for (int i = 0; i < 3; i++) {
    leds.write(0x01); wait(0.1);
    leds.write(0x02); wait(0.1);
    leds.write(0x04); wait(0.1);
    leds.write(0x08); wait(0.1);
    leds.write(0x04); wait(0.1);
    leds.write(0x02); wait(0.1);
  }
  wait(1.0);
}
int main() {
    _Bool answer;
    
    while (1) {
    
      InitSimon();
      do {
        PresentSimon();
        answer = AnswerSimon();
        if (answer) {
          simonLevel++;
          if (simonLevel == SIMON_MAX_SEQUENCE) {
            WinCeremony();
            answer = 0;
          } else {
            YesCeremony();            
          }
        } else {
          NoCeremony();
        }        
      } while (answer);
    } 
}

