#include "mbed.h"

#define TEMP130_CAL_ADDR ((uint16_t*) ((uint32_t) 0x1FF8007E))
#define TEMP30_CAL_ADDR ((uint16_t*) ((uint32_t) 0x1FF8007A))
#define VDD_CALIB ((uint16_t) (300))
#define VDD_APPLI ((uint16_t) (330))
Serial pcMain(USBTX, USBRX);


int32_t ComputeTemperature(uint32_t measure)
{
  int32_t temperature;
    pcMain.printf("TEMP130=%u TEMP30=%u\n", *TEMP130_CAL_ADDR, *TEMP30_CAL_ADDR);
  temperature = ((measure * VDD_APPLI / VDD_CALIB) - (int32_t)*TEMP30_CAL_ADDR );
    pcMain.printf("T1 %d\n", temperature);
  temperature = temperature *(int32_t)(130-30);
    pcMain.printf("T2 %d\n", temperature);
  temperature = temperature /(int32_t)(*TEMP130_CAL_ADDR - *TEMP30_CAL_ADDR);
    pcMain.printf("T3 %d\n", temperature);
  temperature = temperature + 30;
    pcMain.printf("T4 %d\n", temperature);
  return(temperature);
}


void ConfigTemperature(void){
    //Clock configuration
    RCC->APB2ENR |= RCC_APB2ENR_ADC1EN;
    ADC1->CFGR2 |= ADC_CFGR2_CKMODE;

    //*******************//NEW PART BEGIN//******************//
    //ADC Calibration
    if ((ADC1->CR & ADC_CR_ADEN) != 0) /* (1) */
    {
     ADC1->CR &= (uint32_t)(~ADC_CR_ADEN); /* (2) */
    }
    ADC1->CR |= ADC_CR_ADCAL; /* (3) */
    while ((ADC1->ISR & ADC_ISR_EOCAL) == 0) /* (4) */
    {
        pcMain.printf("Calib\n");
    }
    ADC1->ISR |= ADC_ISR_EOCAL;
    
    //Enable the ADC
    ADC1->ISR |= ADC_ISR_ADRDY; /* (1) */
    ADC1->CR |= ADC_CR_ADEN; /* (2) */
    if ((ADC1->CFGR1 & ADC_CFGR1_AUTOFF) == 0)
    {
     while ((ADC1->ISR & ADC_ISR_ADRDY) == 0) /* (3) */
     {
         pcMain.printf("Enable\n");
     }
    }
    //*******************//NEW PART END//******************//

    //Configuration of the temp sensor
    ADC1->CFGR1 |= ADC_CFGR1_CONT; /* (2) */
    ADC1->CHSELR = ADC_CHSELR_CHSEL18; /* (3) */
    ADC1->SMPR |= ADC_SMPR_SMP; /* (4) */
    wait_ms(10);
    ADC->CCR |= ADC_CCR_TSEN;
    ADC1->CR |= ADC_CR_ADSTART; /* start the ADC conversion */
    wait_ms(10);
    while(1) {
    wait_ms(300);
    uint32_t measure = ADC1->DR;
    pcMain.printf("Measure %u\n", measure);
    pcMain.printf("The temperature value is %i\n",ComputeTemperature(measure));
    }

}

/***************************************************************************//**
 * @fn main(void)
 * @brief Main of the project
 * @param void
 * @return int
 * @author Edson CALSIN, Francois DREVETON, Simon NOWAK
 *
 ******************************************************************************/
int main(void)
{
    ConfigTemperature();
}
