#include "stm32f103c8t6.h"
#include "main.h"
#include "math.h"
#include "mbed.h"

Ticker dynamic_indication_timer;
Ticker encoder_timer;

InterruptIn encoder_button(PB_12);

DigitalIn encoder_left(PB_13);
DigitalIn encoder_right(PB_14);

int encoder_state = 0;
int encoder_data = 50;


BusOut segments(segment_A, segment_B, segment_C, segment_D, segment_E, segment_F, segment_G, segment_DOT);
BusOut common(common_1, common_2);

I2C i2c(I2C_SDA, I2C_SCL);

uint8_t digits[] = {192, 207, 162, 134, 141, 148, 144, 199, 128, 132};

uint8_t inputs[] = {0x03, 0x02};
uint8_t input = 0;
uint8_t volume = 99;

uint8_t address = 0x88;

/*
I2C>[0x88 0x00 0x03] - enable edge input
I2C>[0x88 0x00 0x03] - enable middle input

I2C>[0x88 0x01 0x00] - input gain 0db

I2C>[0x88 0x02 0x6f] - lowest volume
I2C>[0x88 0x02 0x78] - mute
I2C>[0x88 0x02 0x00] - highest volume

I2C>[0x88 0x03 0x0f] - bass 0db
I2C>[0x88 0x04 0x0f] - treble 0db

I2C>[0x88 0x06 0x00] - speaker L att 0db
I2C>[0x88 0x07 0x00] - speaker R att 0db


*/

void encoder_button_pressed()
{
    input = ((input == 0) ? 1 : 0);
}

void encoder_timer_task()
{
    uint8_t new_state = !encoder_left * 2 + !encoder_right;

    switch(encoder_state) {
        case 2: {
            if((new_state == 3) && (encoder_data < 99)) encoder_data++;
            if((new_state == 0) && (encoder_data > 0)) encoder_data--;
            break;
        }

        case 0: {
            if((new_state == 2) && (encoder_data < 99)) encoder_data++;
            if((new_state == 1) && (encoder_data > 0)) encoder_data--;
            break;
        }
        case 1: {
            if((new_state == 0) && (encoder_data < 99)) encoder_data++;
            if((new_state == 3) && (encoder_data > 0)) encoder_data--;
            break;
        }
        case 3: {
            if((new_state == 1) && (encoder_data < 99)) encoder_data++;
            if((new_state == 2) && (encoder_data > 0)) encoder_data--;
            break;
        }
    }

    encoder_state = new_state;
}


void dynamic_indication_swapper()
{
    if (common != 0b01) { // lower is active
        common = 0b01;
        segments = digits[volume / 10] - ((input == 0) ? 128 : 0);
    } else {
        common = 0b10;
        segments = digits[volume % 10] - ((input == 1) ? 128 : 0);
    }
}

int main()
{
    encoder_button.fall(&encoder_button_pressed);
    encoder_button.mode(PullUp);

    common = 0b10;

    dynamic_indication_timer.attach(&dynamic_indication_swapper, 0.01);


    encoder_left.mode(PullUp);
    encoder_right.mode(PullUp);
    encoder_timer.attach(&encoder_timer_task, 0.01);

    char cmd[2];

    cmd[0] = 0x00;
    cmd[1] = inputs[input];
    i2c.write(address, cmd, 2);

    cmd[0] = 0x01;
    cmd[1] = 0x00;
    i2c.write(address, cmd, 2);

    cmd[0] = 0x02;
    cmd[1] = 0x00;
    i2c.write(address, cmd, 2);

    cmd[0] = 0x03;
    cmd[1] = 0x0f;
    i2c.write(address, cmd, 2);

    cmd[0] = 0x04;
    cmd[1] = 0x0f;
    i2c.write(address, cmd, 2);

    cmd[0] = 0x06;
    cmd[1] = 0x00;
    i2c.write(address, cmd, 2);

    cmd[0] = 0x07;
    cmd[1] = 0x00;
    i2c.write(address, cmd, 2);

    while (1) {
        volume = encoder_data;

        cmd[0] = 0x00;
        cmd[1] = inputs[input];
        i2c.write(address, cmd, 2);

        cmd[0] = 0x02;
        cmd[1] = (volume > 0) ? (0x2f - floor(0.47 * (volume + 1))) : 0x3f;
        i2c.write(address, cmd, 2);

        wait_ms(100);
    };
}
