// Do not remove the include below
#include "mbed.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"
#include "pb_decode.h"
#include "sitewhere.h"
#include "sitewhere.pb.h"

#define MQTTCLIENT_QOS2 1
int arrivedcount = 0;
bool registered = false;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

void messageArrived(MQTT::MessageData& md)
{
    uint8_t buffer[512];
    MQTT::Message &message = md.message;
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\n", message.qos, message.retained, message.dup, message.id);
    printf("Payload %.*s\n", message.payloadlen, (char*)message.payload);
    ++arrivedcount;
/*
    buffer = message.payload;
    Device_Header header;
    pb_istream_t stream = pb_istream_from_buffer(buffer, message.payloadlen);

    // Read header to find what type of command follows.
      if (pb_decode_delimited(&stream, Device_Header_fields, &header)) {
        // Handle a registration acknowledgement.
        if (header.command == Device_Command_REGISTER_ACK) {
          Device_RegistrationAck ack;
          if (pb_decode_delimited(&stream, Device_RegistrationAck_fields, &ack)) {
            if (ack.state == Device_RegistrationAckState_NEW_REGISTRATION) {
              printf("Registered new device.");
              registered = true;
            } else if (ack.state == Device_RegistrationAckState_ALREADY_REGISTERED) {
              printf("Device was already registered.");
              registered = true;
            } else if (ack.state == Device_RegistrationAckState_REGISTRATION_ERROR) {
              printf("Error registering device.");
            }
          }
        }
      } else {
        printf("Unable to decode system command.");
      }
    */
}


int main(int argc, char* argv[])
{
    MQTTEthernet ipstack = MQTTEthernet();
    float version = 0.5;
    char* topic = "SiteWhere/input/protobuf";
    char* hardwareId = "enno-device-mbed-id-2";
    char* specificationToken = "9556b504-52cc-4194-89c0-f301a782b286";
    char* system = "SiteWhere/system/mbed-test-A";
    char* hostname = "139.217.10.99";//sitewhere.chinacloudapp.cn:1883
    int port = 1883;

    led1=1;led2=1;led3=1;led4=1;
    wait(0.5);
    led1=!led1;led2=!led2;led3=!led3;led4=!led4;
    wait(0.5);
    led1=!led1;led2=!led2;led3=!led3;led4=!led4;

    printf("HelloMQTT: version is %f\n", version);
    MQTT::Client<MQTTEthernet, Countdown> client = MQTT::Client<MQTTEthernet, Countdown>(ipstack);
    printf("Connecting to %s:%d\n", hostname, port);
    int rc = ipstack.connect(hostname, port);

    if (rc != 0){                           //tcp connect error!
        printf("rc from TCP connect is %d\n", rc);
       }
    if (rc == 0){                            //tcp connected!
        led1=!led1;wait(1);led1=!led1;wait(1);led1=!led1;

         MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
         data.MQTTVersion = 3;
         data.clientID.cstring = "mbed-sample";
         data.username.cstring = NULL;
         data.password.cstring = NULL;
         if ((rc = client.connect(data)) != 0)
             printf("rc from MQTT connect is %d\n", rc);
         if (rc == 0){                      //MQTT Client connected!
             led2=!led2;wait(1);led2=!led2;wait(1);led2=!led2;

             if ((rc = client.subscribe(system, MQTT::QOS2, messageArrived)) != 0)
                 printf("rc from MQTT subscribe is %d\n", rc);
             if(rc == 0){                       //subscribe successed!
                 led3=!led3;wait(1);led3=!led3;wait(1);led3=!led3;

                 MQTT::Message message;

             // QoS 0
                 char buf[100];
                 //unsigned char buffer[512];
                 uint8_t buffer[512];                                // Caution: unsigned char cause an error!!!
                 unsigned int len = 0;
                 sprintf(buf, "Hello World!  QoS 0 message from app version %f\n", version);
                 message.qos = MQTT::QOS0;
                 message.retained = false;
                 message.dup = false;
                // message.payload = (void*)buf;
                // message.payloadlen = strlen(buf)+1;                //??
                 /*********** serialization ************/
                 len = sw_register(hardwareId, specificationToken, buffer, 512,NULL);
                 message.payload = buffer;
                 message.payloadlen = len;
                 /*************************************/
                 rc = client.publish(topic, message);
        //       while (arrivedcount < 1)
        //           client.yield(100);



 // QoS 1
                 /*********** serialization ************/
                // len = sw_alert(hardwareId, "enno.info","mbed is alive", NULL, buffer, 512, NULL);
                 len = sw_location(hardwareId, 27.59, 86.55, 8844.43, 0,buffer, 512, NULL);
                 message.payload = buffer;
                 message.payloadlen = len;
                 sprintf(buf, "Hello World!  QoS 1 message from app version %f\n", version);
                 message.qos = MQTT::QOS1;

                 while (0 == rc) {
                         client.yield(1000);
                         //sleep();
                         //wait(0.5);
                         client.publish(topic, message);
                         printf("Location updated.\n");
                         led4=!led4;

                     }
                 return 0;
             }
         }
    }
}
/*
    // QoS 2
    sprintf(buf, "Hello World!  QoS 2 message from app version %f\n", version);
    message.qos = MQTT::QOS2;
    message.payloadlen = strlen(buf)+1;
    rc = client.publish(topic, message);
    while (arrivedcount < 3)
        client.yield(100);
*/
/*
 if ((rc = client.unsubscribe(topic)) != 0)
         printf("rc from unsubscribe was %d\n", rc);

     if ((rc = client.disconnect()) != 0)
         printf("rc from disconnect was %d\n", rc);

     ipstack.disconnect();

     printf("Version %.2f: finish %d msgs\n", version, arrivedcount); */



//  Auto Added by "SMeshLink SMeshStudio"

