#include "mbed.h"

InterruptIn mybutton(USER_BUTTON);//generates an object named mybutton out of the class InterruptIn
DigitalOut myled(LED1); //

volatile float delay = 4.0; // 1 sec of delay in the delay
volatile bool Pressedornot=false; // global variable with is updated by the interrupt function

/*function pressed() is called than a interrupt is generated by the external interrupt  when the userbutton is pressed
it alters the Pressedornot variable from true to false
*/
void pressed()
{
    if (Pressedornot==false)
        Pressedornot=true;
    else
        Pressedornot=false;
}

int main()
{
    mybutton.fall(&pressed);//activates the interrupt then a falling edge is detected on the pin
    while (1) {
        while(Pressedornot==false) {
            myled = !myled;
            for(int i=0;i<1000000;i++)//
             {wait_us(1);
             if(Pressedornot==true)
             {break;}
                 }
        } while( Pressedornot==true )
         {
            myled=true;
        }

    }
}
