#include "PaceHeart.h"
#include "mbed.h"
#include "Hardware.h"


using namespace std;


PaceHeart::PaceHeart(){
    
    p_pacingState = 0;
    p_pacingMode = 0;
    p_hysteresis = 0;
    p_hysteresisInterval = 300;
    p_lowrateInterval = 1000.0;
    p_uprateInterval = 500.0; //upper rate limit
//Ventricle
    p_vPaceAmp = 3500.0;
    p_vPaceWidth = 0.4;
    p_VRP = 320;
//Atrium (change defaults)
    p_aPaceAmp = 3500.0;
    p_aPaceWidth = 0.4;
    p_ARP = 320;
}

PaceHeart::PaceHeart(int mode){
    p_pacingState = 0;
    p_pacingMode = mode;
    p_lowrateInterval = 1000.0; //30-50->5 50-90->1 90-175->5 ppm
    p_uprateInterval = 2000.0; //upper rate limit 50-175->5 ppm
    p_maxSensorRate = 2000.0; //50-175->5 ppm
    
//Ventricle
    p_vPaceAmp = 3500.0; //3500->0.1
    p_vPaceWidth = 0.4; //0.05->no change 0.1-1.9 0.1

    p_activityThresh = 4; //1-7 print out string with level ie. Med
    p_reactionTime = 30000; //10-50->10 seconds
    p_responseFactor = 8; //1-16->1
    p_recoveryTime = 300000; //2-16->1 minutes
    //acc stuff
    int numCount;
    int const MAX_NUM_COUNTS = 3;
    int const TIMING_PERIOD = 20; // Sensor polling interval
    
    uint8_t motion_exceeded_threshold = 0;

}
int PaceHeart::get_p_pacingState()
{
    return p_pacingState;
}

void PaceHeart::set_p_pacingMode(int x)
{
    p_pacingMode = x;
    return;
}

int PaceHeart::get_p_pacingMode()//lets make it string in future
{
    return p_pacingMode;
}
int PaceHeart::get_p_hysteresis()
{
    return p_hysteresis;
}
void PaceHeart::set_p_hysteresis(int x)
{
    p_hysteresis = x;
    return;
}
int PaceHeart::get_p_hysteresisInterval()
{
    return p_hysteresisInterval;
}
void PaceHeart::set_p_hysteresisInterval(int x)
{
    p_hysteresisInterval = x;
    return;
}
double PaceHeart::get_p_lowrateInterval()
{
    return p_lowrateInterval;
}
void PaceHeart::set_p_lowrateInterval(double x)
{
    if (p_pacingMode == 1) {
            
        if (dir ==1) // Change values to take into account for user inputs
        {
            if (p_lowrateInterval >=833.33 && p_lowrateInterval<=1483.33)
            {
                p_lowrateInterval += 16.67;
            }
            else if (p_lowrateInterval >2833.33)
            {
                return;
            }
            else
            {
                p_lowrateInterval += 83.33;
            }
        }
        else if (dir==0)
        {
            if (p_lowrateInterval >=850 && p_lowrateInterval<=1500)
            {
                p_lowrateInterval -= 16.67;
            }
            else if (p_lowrateInterval<583.33)
            {
                return;
            }
            else
            {
                p_lowrateInterval -= 83.33;
            }
        }
    }
    else {
        p_lowrateInterval = x;
    }
    return;
}
double PaceHeart::get_p_uprateInterval()
{
    return p_uprateInterval;
}
void PaceHeart::set_p_uprateInterval(double x)
{
    /*if (p_pacingMode == 1) {
        if (dir ==1) // Change values to take into account for user inputs
        {
            if (p_uprateInterval >=833.33 && p_uprateInterval<=2833.33)
            {
                p_uprateInterval += 83.33;
            }
            else if (p_uprateInterval >2833.33)
            {
                return;
            }
        }
        else if (dir==0)
        {
            if (p_uprateInterval >=916.67 && p_uprateInterval<=2916.67)
            {
                p_uprateInterval -= 83.33;
            }
            else if (p_uprateInterval<916.67)
            {
                return;
            }
        }
    }
    else {
        p_uprateInterval = x;
    } */
    p_uprateInterval = x;
    return;
}
double PaceHeart::get_p_maxSensorRate(){
    return p_maxSensorRate;
}
void PaceHeart::set_p_maxSensorRate(double x)
{
    /*if (p_pacingMode == 1) {
        if (dir ==1) // Change values to take into account for user inputs
        {
            if (p_maxSensorRate >=833.33 && p_maxSensorRate<=2833.33)
            {
                p_maxSensorRate += 83.33;
            }
            else if (p_maxSensorRate >2833.33)
            {
                return;
            }
        }
        else if (dir==0)
        {
            if (p_maxSensorRate >=916.67 && p_maxSensorRate<=2916.67)
            {
                p_maxSensorRate -= 83.33;
            }
            else if (p_maxSensorRate<916.67)
            {
                return;
            }
        }
    }
    else {
        p_maxSensorRate = x;
    } */
    
    p_maxSensorRate = x;
    return;
}
//Ventricle
double PaceHeart::get_p_vPaceAmp()
{
    return p_vPaceAmp;
}
void PaceHeart::set_p_vPaceAmp(double x) 
{
    /*if (p_pacingMode == 1) {
            
       if (dir ==1) // Change values to take into account for user inputs
        {
            if (p_vPaceAmp >=500 && p_vPaceAmp<=3100)
            {
                p_vPaceAmp += 100;
            }
            else if (p_vPaceAmp >= 3500 && p_vPaceAmp<=6500)
            {
                p_vPaceAmp += 500;
            }
            else
            {
                return;
            }
        }
        else if (dir==0)
        {
            if (p_vPaceAmp >=600 && p_vPaceAmp<3200)
            {
                p_vPaceAmp -= 100;
            }
            else if (p_vPaceAmp >= 4000 && p_vPaceAmp<=7000)
            {
                p_vPaceAmp -= 500;
            }
            else
            {
                return;
            }
        }
    }
    else {
    p_vPaceAmp = x;
    } */
    
    p_vPaceAmp= x;
    return;
}
 
double PaceHeart::get_p_vPaceWidth()
{
    return p_vPaceWidth;
}
void PaceHeart::set_p_vPaceWidth(double x)
{
   /* if (p_pacingMode == 1) {
        if (p_vPaceWidth == 0.05) {
            p_vPaceWidth = 0.4;   
        }
        if (dir ==1){
            if (p_vPaceWidth >= 0.1 && p_vPaceWidth <= 1.8){
                p_vPaceWidth += 0.1;
            }
            else {
                return;
            }
        }
        else if (dir ==0) {
            if (p_vPaceWidth >= 0.2 && p_vPaceWidth <= 1.9){
                p_vPaceWidth -= 0.1;
            }
            else {
                return;
            }
        }
    }
    else {
        p_vPaceWidth = x;
    } */
    
    p_vPaceWidth = x;
    return;
}
 
int PaceHeart::get_p_VRP()
{
    return p_VRP;
}
void PaceHeart::set_p_VRP(int x)
{
    p_VRP = x;
    return;
}
//Atrium
double PaceHeart::get_p_aPaceAmp()
{
    return p_aPaceAmp;
}
void PaceHeart::set_p_aPaceAmp(double x)
{
    p_aPaceAmp = x;
    return;
}
 
double PaceHeart::get_p_aPaceWidth()
{
    return p_aPaceWidth;
}
void PaceHeart::set_p_aPaceWidth(double x)
{
    p_aPaceWidth = x;
    return;
}
 
int PaceHeart::get_p_ARP()
{
    return p_ARP;
}
void PaceHeart::set_p_ARP(int x)
{
    p_ARP = x;
    return;
}



void PaceHeart::pace_A(double amp, double wid)
{   
    Output_A(amp,wid);
    return;
}

void PaceHeart::pace_A()
{
    double amplitude = get_p_aPaceAmp();
    double width = get_p_aPaceWidth();
    pace_A(amplitude,width);
    return;
}


void PaceHeart::pace_V(double amp, double wid)
{
    Output_V(amp,wid);
    return;
}

void PaceHeart::pace_V() 
{
    double amplitude = get_p_vPaceAmp();
    double width = get_p_vPaceWidth();
    pace_V(amplitude,width);
    return;
}

/*
void PaceHeart::pace(int mode)
{
    switch(mode){
    case 1:  //VOOR
           pace_V();
    case 0:  //VVI
           pace_V();
    }
    return;
} */
/*
void PaceHeart::pace()
{
    int mode = get_p_pacingMode();
    pace(mode);
    return;
} */
int PaceHeart::get_p_activityThresh()
{
    return p_activityThresh;
}
int PaceHeart::get_p_reactionTime()
{
    return p_reactionTime;
}
int PaceHeart::get_p_responseFactor()
{
    return p_responseFactor;
}
int PaceHeart::get_p_recoveryTime()
{
    return p_recoveryTime;
}
void PaceHeart::set_p_activityThresh(int x)
{
   /* if (p_pacingMode == 1) {
        p_activityThresh=x; //no increment set at beginning
    }
    else {
        p_activityThresh=x;
    } */
    p_activityThresh = x;
    return;
}
void PaceHeart::set_p_reactionTime(int x)
{
   /* if (p_pacingMode == 1) {
        
        if (dir ==1){
            if (p_reactionTime >= 10000 && p_reactionTime <= 40000) {
                p_reactionTime += 10000;
        }  
        else if (p_reactionTime >40000)
            {
                return;
            }
        }
        else if (dir==0)
        {
            if (p_reactionTime >=20000 && p_reactionTime <=50000)
            {
                p_reactionTime -= 10000;
            }
            else if (p_reactionTime < 20000)
            {
                return;
            }
        }
    }
    else {
        p_reactionTime = x;
    } */
    p_reactionTime = x;
    return;
}
void PaceHeart::set_p_responseFactor(int x)
{
   /* if (p_pacingMode == 1) {
            
        if (dir ==1){
            if (p_responseFactor >= 1 && p_responseFactor <= 15) {
                p_responseFactor += 1;
        }  
        else if (p_responseFactor >15)
            {
                return;
            }
        }
        else if (dir==0)
        {
            if (p_responseFactor >=2 && p_responseFactor <=16)
            {
                p_responseFactor -= 1;
            }
            else if (p_responseFactor < 2)
            {
                return;
            }
        }
    }
    else {
        p_responseFactor=x;
    } */
    p_responseFactor=x;
    return;
}
void PaceHeart::set_p_recoveryTime(int x)
{
   /* if (p_pacingMode == 1) {
            
        if (dir ==1){
            if (p_recoveryTime >= 120000 && p_recoveryTime <= 900000) {
                p_recoveryTime += 60000;
        }  
        else if (p_recoveryTime >900000)
            {
                return;
            }
        }
        else if (dir==0)
        {
            if (p_recoveryTime >=180000 && p_recoveryTime <=960000)
            {
                p_recoveryTime -= 60000;
            }
            else if (p_recoveryTime < 180000)
            {
                return;
            }
        }
    }
    else {
        p_recoveryTime=x;
    } */
    p_recoveryTime=x;
    return;
}
void PaceHeart::set_dir(int x)
{
    dir=x;
    return;
}