#include <string>
using namespace std;

#ifndef PACEHEART_H
#define PACEHEART_H
class PaceHeart{
    
    private:
    int p_pacingState;
    int p_pacingMode;
    int p_hysteresis;
    int p_hysteresisInterval;
    double p_lowrateInterval;
    double p_uprateInterval; //upper rate limit
    double p_maxSensorRate;
    //Ventricle
    double p_vPaceAmp;
    double p_vPaceWidth;
    int p_VRP;
    //Atrium (change defaults)
    double p_aPaceAmp;
    double p_aPaceWidth;
    int p_ARP;
    int p_activityThresh;
    int p_reactionTime;
    int p_responseFactor;
    int p_recoveryTime;
    int dir; // variable to track direction of increment    
    public:
PaceHeart();
PaceHeart(int mode);
void pace_A();
void pace_A(double amp, double wid);
void pace_V(double amp, double wid);
void pace_V();
void pace();
void pace(int x);
int get_p_pacingState();
int get_p_pacingMode();
void set_p_pacingMode(int x);
int get_p_hysteresis();
void set_p_hysteresis(int x);
int get_p_hysteresisInterval();
void set_p_hysteresisInterval(int x);
double get_p_lowrateInterval();
void set_p_lowrateInterval(double x);
double get_p_uprateInterval();
void set_p_uprateInterval(double x);
double get_p_maxSensorRate();
void set_p_maxSensorRate(double x);
double get_p_vPaceAmp();
void set_p_vPaceAmp(double x);
double get_p_vPaceWidth();
void set_p_vPaceWidth(double x);
int get_p_VRP();
void set_p_VRP(int x);
double get_p_aPaceAmp();
void set_p_aPaceAmp(double x);
double get_p_aPaceWidth();
void set_p_aPaceWidth(double x);
int get_p_ARP();
void set_p_ARP(int x);
int get_p_activityThresh();
int get_p_reactionTime();
int get_p_responseFactor();
int get_p_recoveryTime();
void set_p_activityThresh(int x);
void set_p_reactionTime(int x);
void set_p_responseFactor(int x);
void set_p_recoveryTime(int x);
void set_dir(int x);
};
#endif