#include "Hardware.h"
#include "mbed.h"

#define LOW  0
#define HIGH 1
DigitalOut output_pin_A(LED3);
DigitalOut output_pin_V(LED2);
/*=== Analog In ===*/
AnalogIn atrialIn           (A0);      // Pin A0
AnalogIn ventricleIn        (A1);      // Pin A1
AnalogIn leadImpedence      (A2);      // Pin A2
AnalogIn atr_rect_signal    (A3);      // Pin A3
AnalogIn vent_rect_signal   (A4);      // Pin A4

/*=== Digital In ===*/
DigitalIn atria_cmp_detect  (PTC16);   // Pin D0
DigitalIn vent_cmp_detect   (PTC17);   // Pin D1

/*=== PWM Out ===*/
/* DigitalOut is used for the REF Signal
 * due to absence of PWM capabilities of Pins D2 and D4
 * on the FRDM-K64F Board
 */
DigitalOut pacing_ref_pwm   (PTB9);    // Pin D2 (PTB9)
PwmOut vent_ref_pwm         (PTA1);    // Pin D3
DigitalOut atria_ref_pwm    (PTB23);   // Pin D4


/*=== Digital Out ===*/
DigitalOut pace_charge_ctrl (PTA2);    // Pin D5
DigitalOut z_atria_ctrl     (PTC2);    // Pin D6
DigitalOut z_vent_ctrl      (PTC3);    // Pin D7

DigitalOut atr_pace_ctrl    (PTC12);   // Pin D8
DigitalOut vent_pace_ctrl   (PTC4);    // Pin D9
DigitalOut pace_grnd_ctrl   (PTD0);    // Pin D10
DigitalOut atr_grnd_ctrl    (PTD2);    // Pin D11
DigitalOut vent_grnd_ctrl   (PTD3);    // Pin D12
DigitalOut frontend_ctrl    (PTD1);    // Pin D13

/*=== On-Board Tri-LED ===*/
DigitalOut rled (LED_RED);
DigitalOut gled (LED_GREEN);
DigitalOut bled (LED_BLUE);


void send_data(Serial &pc,PaceHeart &Pacer){
    
             pc.printf ("%c",(char)Pacer.get_p_pacingState());
             pc.printf ("%c",(char)Pacer.get_p_pacingMode());
             pc.printf ("%c",(char)Pacer.get_p_hysteresis());
             pc.printf ("%c%c",(char)((int)(Pacer.get_p_hysteresisInterval()/128)),(char)(Pacer.get_p_hysteresisInterval()%128));
             pc.printf ("%c%c",(char)((int)(Pacer.get_p_lowrateInterval()/128)),(char)((int)(Pacer.get_p_lowrateInterval())%128));
             pc.printf ("%c%c",(char)((int)(Pacer.get_p_vPaceAmp())/128),(char)((int)(Pacer.get_p_vPaceAmp())%128));
             pc.printf ("%c%c",(char)((int)(10.0*Pacer.get_p_vPaceWidth())/128),(char)((int)(10.0*Pacer.get_p_vPaceWidth())%128));//10*pace width
             pc.printf ("%c%c\n",(char)((int)(Pacer.get_p_VRP()/128)),(char)(Pacer.get_p_VRP()%128));
             return;
}
void request_data(Serial &pc,PaceHeart &Pacer){ //implement limit later
            char d[14];
            int e = 0;
            pc.scanf("%s",&d);
            pc.printf("%c",'e');//end
            e = (int)d[0];
            //Pacer.set_p_pacingState(e);
            e = (int)d[1];
           // Pacer.set_p_pacingMode(e);
            e = (int)d[2];
            Pacer.set_p_hysteresis(e);
            e = (int)d[3]*128+(int)d[4];
            Pacer.set_p_hysteresisInterval(e);
            e = (int)d[5]*128+(int)d[6];
            Pacer.set_p_lowrateInterval(e);
            e = (int)d[7]*128+(int)d[8];
            Pacer.set_p_vPaceAmp((double)e);
            e = (int)d[9]*128+(int)d[10];
            Pacer.set_p_vPaceWidth((double)e/10.0);
            e = (int)d[11]*128+(int)d[12];
            Pacer.set_p_VRP(e);
}


void stream_A(Serial &pc){
    int amp = (int)(3450*vent_rect_signal);
    pc.printf("%c%c\n",(char)(amp/128),(char)(amp%128));
}

void stream_V(Serial &pc){
    int amp = (int)(3450*ventricleIn);
    pc.printf("%c%c\n",(char)(amp/128),(char)(amp%128));
}

void stream(Serial &pc, char mode){
        char c;
    while(1){
        if(pc.readable()!=0){
                c = pc.getc();
                if(c=='q'){
                    stream_A(pc);
                    output_pin_V=!output_pin_V;
                }
                else if(c=='w'){
                return;
                }
            } 
        }
}

void Check_serial(Serial &pc,PaceHeart &Pacer){
            char c = pc.getc();
            if(c=='r'){//send params
                send_data(pc,Pacer);
                }
            else if(c=='s') {//set params
                request_data(pc,Pacer);
            }
            else if(c=='q'){ //stream egram
                stream(pc,c);
            }
}


void Output_A(double amp, double wid){
    vent_ref_pwm = 0.5f;
    vent_ref_pwm.pulsewidth(2);
    /*AnalogOut aout(p18);  //sets up pin 18 as an analogue output
        AnalogueIn ain(p15);  //sets up pin 15 and an analogue input
 
        int main(){
             aout=0.5;  //sets output to 0.5*VCC
            while(1){    //sets up a loop
             if (ain>0.3){   //tests whether the input is above 0.3
            aout=0;  //sets the output to 0
      }
      aout = 0.5;
      wait(1);
      aout = 0;*/
      // test the voltage on the initialized analog pin
        //  and if greater than 0.3 * VCC set the digital pin
        //  to a logic 1 otherwise a logic 0
}
void Output_V(double amp,double wid){
    //vent_ref_pwm = 0.5f;
    //vent_ref_pwm.pulsewidth(2);
    atr_grnd_ctrl  = LOW;
    vent_grnd_ctrl = LOW;
    
    /* Stage 1: Ref PWM On */
    pacing_ref_pwm = HIGH;
    wait_ms(10);

    /* Stage 2: Charge CTRL on */
    pace_charge_ctrl = HIGH;
    wait_ms(10);
    
    vent_pace_ctrl = HIGH;
    
    // Pace Duration
    wait_us(wid/10);
    
    // Shut off Pace
    vent_pace_ctrl = LOW;
    
    atr_pace_ctrl =  LOW;
    vent_pace_ctrl = LOW;
    atr_grnd_ctrl  = HIGH;
    vent_grnd_ctrl = HIGH;
    wait_ms(50);
    

    /* Stage 2: Ref PWM LOW */
    pacing_ref_pwm = LOW;
    wait_ms(100);

    /* Stage 3: Charge CTRL off */
    pace_charge_ctrl = LOW;
    wait_ms(10);
    
    /* Stage 4: Ground OFF */
    atr_grnd_ctrl  = LOW;
    vent_grnd_ctrl = LOW;
    
    output_pin_V=!output_pin_V;
    /*AnalogOut aout(p18);  //sets up pin 18 as an analogue output
        AnalogueIn ain(p15);  //sets up pin 15 and an analogue input
 
        int main(){
             aout=0.5;  //sets output to 0.5*VCC
            while(1){    //sets up a loop
             if (ain>0.3){   //tests whether the input is above 0.3
            aout=0;  //sets the output to 0
      }
      aout = 0.5;
      wait(1);
      aout = 0;*/
}