#include "PaceHeart.h"
#include "mbed.h"
#include "Hardware.h"
using namespace std;



PaceHeart::PaceHeart(){
    
    p_pacingState = 0;
    p_pacingMode = 0;
    int p_hysteresis = 0;
    int p_hysteresisInterval = 300;
    int lowrateInterval = 1000;
    int uprateInterval = 500; //upper rate limit
//Ventricle
    double p_vPaceAmp = 3500.0;
    double p_vPaceWidth = 0.4;
    int p_VRP = 320;
//Atrium (change defaults)
    double p_aPaceAmp = 3500.0;
    double p_aPaceWidth = 0.4;
    int p_ARP = 320;
}

PaceHeart::PaceHeart(int mode){
    p_pacingState = 0;
    p_pacingMode = mode;
    int lowrateInterval = 1000; //30-50->5 50-90->1 90-175->5 ppm
    int uprateInterval = 500; //upper rate limit 50-175->5 ppm
    int maxSensorRate = 500; //50-175->5 ppm
    
//Ventricle
    double p_vPaceAmp = 3750.0; //3750 can change to 0, 1250, 2500, 3750, 5000
    double p_vPaceWidth = 0.4; //0.05->no change 0.1-1.9 0.1

    int p_activityThresh = 4; //1-7 print out string with level ie. Med
    int p_reactionTime = 30; //10-50->10
    int p_responseFactor = 8; //1-16->1
    int p_recoveryTime = 5; //2-16->1
}
int PaceHeart::get_p_pacingState()
{
    return p_pacingState;
}
int PaceHeart::get_p_pacingMode()
{
    return p_pacingMode;
}
int PaceHeart::get_p_hysteresis()
{
    return p_hysteresis;
}
void PaceHeart::set_p_hysteresis(int x)
{
    p_hysteresis = x;
    return;
}
int PaceHeart::get_p_hysteresisInterval()
{
    return p_hysteresisInterval;
}
void PaceHeart::set_p_hysteresisInterval(int x)
{
    p_hysteresisInterval = x;
    return;
}
int PaceHeart::get_lowrateInterval()
{
    return lowrateInterval;
}
void PaceHeart::set_lowrateInterval(int x)
{
    lowrateInterval = x;
    return;
}
int PaceHeart::get_uprateInterval()
{
    return uprateInterval;
}
void PaceHeart::set_uprateInterval(int x)
{
    uprateInterval = x;
    return;
}
//Ventricle
double PaceHeart::get_p_vPaceAmp()
{
    return p_vPaceAmp;
}
void PaceHeart::set_p_vPaceAmp(double x)
{
    p_vPaceAmp = x;
    return;
}
 
double PaceHeart::get_p_vPaceWidth()
{
    return p_vPaceWidth;
}
void PaceHeart::set_p_vPaceWidth(double x)
{
    p_vPaceWidth = x;
    return;
}
 
int PaceHeart::get_p_VRP()
{
    return p_VRP;
}
void PaceHeart::set_p_VRP(int x)
{
    p_VRP = x;
    return;
}
//Atrium
double PaceHeart::get_p_aPaceAmp()
{
    return p_aPaceAmp;
}
void PaceHeart::set_p_aPaceAmp(double x)
{
    p_aPaceAmp = x;
    return;
}
 
double PaceHeart::get_p_aPaceWidth()
{
    return p_aPaceWidth;
}
void PaceHeart::set_p_aPaceWidth(double x)
{
    p_aPaceWidth = x;
    return;
}
 
int PaceHeart::get_p_ARP()
{
    return p_ARP;
}
void PaceHeart::set_p_ARP(int x)
{
    p_ARP = x;
    return;
}



void PaceHeart::pace_A(double amp, double wid,int pin)
{   
    output_pin_A = !output_pin_A ;
    wait(1);
   
    
   
    return;
}

void PaceHeart::pace_A()
{
    double amplitude = get_p_aPaceAmp();
    double width = get_p_aPaceWidth();
    // int output_pin = hardware.get_output_pin; //include the hardware module
    pace_A(amplitude,width,output_pin_A);
    return;
}


void PaceHeart::pace_V(double amp, double wid, int pin)
{
    output_pin_V = !output_pin_V ;
    wait(2);
   
    return;
}

void PaceHeart::pace_V()
{
    double amplitude = get_p_vPaceAmp();
    double width = get_p_vPaceWidth();
    // int output_pin = hardware.get_output_pin; //include the hardware module
    pace_V(amplitude,width,output_pin_V);
    return;
}


void PaceHeart::pace(int mode)
{
    switch(mode){
    case 1:  //AOO
           pace_A();
    case 2:  //VOO
           pace_V();
    }
    return;
}

void PaceHeart::pace()
{
    int mode = get_p_pacingMode();
    pace(mode);
    return;
}
int PaceHeart::get_activityThresh()
{
    return p_activityThresh;
}
int PaceHeart::get_reactionTime()
{
    return p_reactionTime;
}
int PaceHeart::get_responseFactor()
{
    return p_responseFactor;
}
int PaceHeart::get_recoveryTime()
{
    return p_recoveryTime;
}
void PaceHeart::set_activityThresh(int x)
{
    p_activityThresh=x;
    return;
}
void PaceHeart::set_reactionTime(int x)
{
    p_reactionTime=x;
    return;
}
void PaceHeart::set_responseFactor(int x)
{
    p_responseFactor=x;
    return;
}
void PaceHeart::set_recoveryTime(int x)
{
    p_recoveryTime=x;
    return;
}