#include "RequestHandler.h"
#include "mbed_rpc.h"
#include "RPCObjectManager.h"
#include "RPCCommand.h"

const char* INVALID_CMD = "Invalid RPC command";
const char* DELETE_ERROR = "You must send a DELETE request to remove an object ";
const char* CREATE_ERROR = "You must send a PUT request to create an object";
const char* FUNC_CALL_ERROR = "You must send a GET request to call a function";

void GetRequestHandler::handle(const RPCCommand& cmd, char *reply)
{
    printf("in getrequesthandler\n\r");
    switch(cmd.get_type())
    {
        case DELETE:
            printf("Error: %s\n", DELETE_ERROR);
            strcat(reply, DELETE_ERROR);
            break;
        case FUNCTION_CALL:
            RPC::call(cmd.get_cmd(), reply);
            break;
        case CREATE:
            printf("Error: %s\n", CREATE_ERROR);
            strcat(reply, CREATE_ERROR);
            break;
        default:
            printf("Error: %s\n", INVALID_CMD);
            strcat(reply, INVALID_CMD);
            break;
    }
}

void PutRequestHandler::handle(const RPCCommand& cmd, char *reply)
{
    switch(cmd.get_type())
    {
        case DELETE:
            printf("Error: %s\n", DELETE_ERROR);
            strcat(reply, DELETE_ERROR);
            break;
        case FUNCTION_CALL:
            printf("Error: %s\n", FUNC_CALL_ERROR);
            strcat(reply, FUNC_CALL_ERROR);
            break;
        case CREATE:
            RPC::call(cmd.get_cmd(), reply);
            if(strlen(reply) > 0)
            {
                RPCObjectManager::instance().store_object(reply);
                strcat(reply, " has been created");
            }
            else
            {
                printf("Error while creating object\n");
                strcat(reply, "Error while creating object.");
            }
            break;
        default:
            printf("Error: %s\n", INVALID_CMD);
            strcat(reply, INVALID_CMD);
            break;
    }
}

void DeleteRequestHandler::handle(const RPCCommand& cmd, char *reply)
{
    switch(cmd.get_type())
    {
        case CREATE:
            printf("Error: %s\n", CREATE_ERROR);
            strcat(reply, CREATE_ERROR);
            break;
        case FUNCTION_CALL:
            printf("Error: %s\n", FUNC_CALL_ERROR);
            strcat(reply, FUNC_CALL_ERROR);
            break;
        case DELETE:
            RPC::call(cmd.get_cmd(), reply);
            RPCObjectManager::instance().remove_object(cmd.get_obj_name());
            strcat(reply, "Deleted object ");
            strcat(reply, cmd.get_obj_name());
            break;
        default:
            printf("Error: %s\n", INVALID_CMD);
            strcat(reply, INVALID_CMD);
            break;
    }
}

void ComplexRequestHandler::handle(const RPCCommand& cmd, char *reply)
{
    switch(cmd.get_type())
    {
        case CREATE :
            putHandler.handle(cmd, reply);
            break;
        case DELETE :
            deleteHandler.handle(cmd, reply);
            break;
        case FUNCTION_CALL :
            getHandler.handle(cmd, reply);
            break;
        default :
            printf("Error: %s\n", INVALID_CMD);
            strcat(reply, INVALID_CMD);
            break;
    }
}

