#ifndef REQUEST_HANDLER
#define REQUEST_HANDLER

#include "RPCCommand.h"

class RequestHandler
{
    public :
        
        virtual void handle(const RPCCommand& cmd, char* reply) = 0;
};

class GetRequestHandler : public RequestHandler
{
    public :
    
        virtual void handle(const RPCCommand& cmd, char* reply);
};

class PutRequestHandler : public RequestHandler
{
    public :
        
        virtual void handle(const RPCCommand& cmd, char* reply);

};


class DeleteRequestHandler : public RequestHandler
{
    public :
            
        virtual void handle(const RPCCommand& cmd, char* reply);

};

class ComplexRequestHandler : public RequestHandler
{
    public :
        
        virtual void handle(const RPCCommand& cmd, char* reply);
        
    private :
        
        GetRequestHandler getHandler;
        PutRequestHandler putHandler;
        DeleteRequestHandler deleteHandler;
};

#endif

