#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPServer.h"
#include <stdio.h>
#include <string.h>
//#include "webpage.h"


#include "Adafruit_Sensor.h"
#include "Adafruit_LSM303_U.h"
#include "Adafruit_BMP085_U.h"
#include "Adafruit_L3GD20_U.h"
#include "Adafruit_10DOF.h"


#define PORT   80
#include <string>


/* Assign a unique ID to the sensors */
Adafruit_10DOF                dof   = Adafruit_10DOF();
Adafruit_LSM303_Accel_Unified accel = Adafruit_LSM303_Accel_Unified(30301L);
Adafruit_LSM303_Mag_Unified   mag   = Adafruit_LSM303_Mag_Unified(30302L);
Adafruit_BMP085_Unified       bmp   = Adafruit_BMP085_Unified(18001L);
Adafruit_L3GD20_Unified       gyro  = Adafruit_L3GD20_Unified(20L);


// Update this with the correct SLP for accurate altitude measurements
float seaLevelPressure = SENSORS_PRESSURE_SEALEVELHPA;

mbed::I2C* i2c;
Timer timer;

EthernetInterface eth;

TCPSocketServer svr;
bool serverIsListening = false;

TCPSocketConnection client;
bool clientIsConnected = false;

DigitalOut led1(LED1); //server listning status
DigitalOut led2(LED2); //socket connecting status
DigitalOut led3(LED3); //last color

Ticker ledTick;
HTTPServer create_simple_server()
{    
    HTTPServer srv;
    srv.add_request_handler("DELETE", new DeleteRequestHandler());
    srv.add_request_handler("GET", new GetRequestHandler());
    srv.add_request_handler("PUT", new PutRequestHandler());
    return srv;
}
HTTPServer create_interactive_server()
{
    HTTPServer srv(new InteractiveHTMLFormatter());
    srv.add_request_handler("GET", new ComplexRequestHandler());
    return srv;
}
HTTPServer create_simple_interactive_server()
{
    HTTPServer srv(new InteractiveHTMLFormatter());
    srv.add_request_handler("GET", new GetRequestHandler());
    return srv;
}

void ledTickfunc()
{
    if(serverIsListening)  {
        led1 = !led1;
    } else {
        led1 = false;
    }
}

void setup(void)
{

  printf("Adafruit 10DOF Tester \r\n");

  /* Initialise the sensors */
  if(!accel.begin())
  {
    /* There was a problem detecting the ADXL345 ... check your connections */
    printf("Ooops, no LSM303 detected ... Check your wiring!\r\n");
    //while(1);
  }
   printf("Adafruit 10DOF Accel setup complete \r\n");
 if(!mag.begin())
  {
    /* There was a problem detecting the LSM303 ... check your connections */
    printf("Ooops, no LSM303 detected ... Check your wiring!\r\n");
    //while(1);
  }
   printf("Adafruit 10DOF Mag setup complete \r\n");
  if(!gyro.begin())
  {
    /* There was a problem detecting the L3GD20 ... check your connections */
    printf("Ooops, no L3GD20 detected ... Check your wiring or I2C ADDR!\r\n");
    //while(1);
  }
   printf("Adafruit 10DOF Gyro setup complete \r\n");

  /* Display some basic information on this sensor */
  //displaySensorDetails();
}

/**************************************************************************/
/*!
    @brief  Constantly check the roll/pitch/heading/altitude/temperature
*/
/**************************************************************************/
void loop(void)
{
  sensors_event_t accel_event;
  sensors_event_t mag_event;
  sensors_vec_t   orientation;


  /* Calculate pitch and roll from the raw accelerometer data */
  accel.getEvent(&accel_event);
  if (dof.accelGetOrientation(&accel_event, &orientation))
  {
    /* 'orientation' should have valid .roll and .pitch fields */
    printf("Roll: %f \n\r",orientation.roll);
    printf("Pitch: %f \n\r",orientation.pitch);
  }
  
  /* Calculate the heading using the magnetometer */
  mag.getEvent(&mag_event);
  if (dof.magGetOrientation(SENSOR_AXIS_Z, &mag_event, &orientation))
  {
    /* 'orientation' should have valid .heading data now */
    printf("Heading: %f\n\r", orientation.heading);
  }
 
  printf("\n\r");  
}

void getOrientation(char * xmlHeader){
    sensors_event_t accel_event;
    sensors_event_t mag_event;
    sensors_event_t bmp_event;
    sensors_vec_t   orientation;
    //float horizontal;
    //float vertical;
    uint32_t altitude = 1000;//rand() % 300 +1;
    uint32_t horizontal = 30;//rand() % 300 +1;
    uint32_t vertical = 45;//rand() % 300 +1;
    uint32_t heading = 33;//rand() % 300 +1;
    uint32_t switch1 = 0;//rand() % 1;
    uint32_t switch2 = 1;//rand() % 1;
    //char echoHeader[256] = {};

    //accel.getEvent(&accel_event);
    //if (dof.accelGetOrientation(&accel_event, &orientation)){
    //    horizontal = (uint32_t) orientation.roll;
    //    vertical   = (uint32_t) orientation.pitch;
    //}
    sprintf(xmlHeader, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\r");
    sprintf(xmlHeader, "<AHRS>\n\r");
    sprintf(xmlHeader, "    <DATA>\n\r");
    sprintf(xmlHeader, "        <HORIZONTAL>%d</HORIZONTAL>\n\r",horizontal);
    sprintf(xmlHeader, "        <VERTICAL>%d</VERTICAL>\n\r",vertical);
    sprintf(xmlHeader, "        <HEADING>%d</HEADING>\n\r",heading);
    sprintf(xmlHeader, "        <SWITCH1>%d</SWITCH1>\n\r",switch1);
    sprintf(xmlHeader, "        <SWITCH2>%d</SWITCH2>\n\r",switch2);
    sprintf(xmlHeader, "        <COLOR>purple</COLOR>\n\r");
    sprintf(xmlHeader, "    </DATA>\n\r");
    sprintf(xmlHeader, "</AHRS>\n\r");
    sprintf(xmlHeader, "\n\r");
 //return echoHeader;
 
}

int main (void)
{
    ledTick.attach(&ledTickfunc,0.5);

    i2c = new mbed::I2C(I2C_SDA, I2C_SCL);
   
    setup();
    loop();
     
    EthernetInterface eth;
    //setup ethernet interface
    eth.init(); //Use DHCP
    eth.connect();

    printf("IP Address is %s\n\r", eth.getIPAddress());

    HTTPServer srv = create_simple_interactive_server();//create_interactive_server();//create_simple_server();
 
    if(!srv.init(PORT))
    {
        printf("Error while initializing the server\n");
        eth.disconnect();
        return -1;
    }
    srv.run();
 
}
