
#include "mbed.h"

PwmOut out0(P0_8);


Serial host(USBTX, USBRX);





int main(void)
{
    host.baud(57600);  // TODO read a digital input to select high/low baud
    out0.period_ms(20);
    out0.pulsewidth_us(2600);

    while(1)
    {
        unsigned int n=200;
        host.scanf("%d",&n);  // read from PC
        if (n>100) continue;  // make sure in range 0-100
        n=((unsigned int) (1600.0*n/100.0));  // get a number from 0 to 1600
        n=1600-n;  // reverse motion direction  so now it is 1600 to 0
        out0.pulsewidth_us(n+1000);  // add 1000 so that total number is 1000 to 2600 (or 1mS to 2.6mS)
    }
}


