#include "mbed.h"

// Simple driver for Si5351 -- Williams
// Expects you to use the desktop configuration tool at
// https://www.silabs.com/products/clocksoscillators/pages/timing-software-development-tools.aspx

I2C i2c(dp5, dp27);  // change to suit your i2c -- I used an LPC1114

DigitalOut myled(LED1);
const int addr = 0xC0;  // note: address is x2 so really 0x60 shifted over

// The SI tool for generating a clock plan will dump a large
// text file (select export plan for others)
// In there will be 232 lines of register "map"
// You need entries 15-92 and 149-170
// The entries will look like:
// 15,00h
// I used regular expressions in my editor (emacs)
// to convert ,\(..\)h -> ,0x\1
// Then I copy paste the lines I want to another buffer
// and then replace
// [0-9]+, -> ,
// That is relace the nubers ahead of the commas with nothing
// Then you can paste it below in map0 (15-92) and map1 (149-170)
// You actually don't even need all of these for the little 3 channel
// breakout board, but it is fast and simple to just blow it all out
// NOTE: Do not replace the first byte of each array (15 and 149) as
// these are the register addresses.

char map0[] = { 15,   // registers 15-92
                0x00
                ,0x4F
                ,0x6F
                ,0x4F
                ,0x80
                ,0x80
                ,0x80
                ,0xC0
                ,0xC0
                ,0x00
                ,0x00
                ,0x00
                ,0x01
                ,0x00
                ,0x10
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x01
                ,0x00
                ,0x0E
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x01
                ,0x01
                ,0xC0
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x01
                ,0x43
                ,0xE6
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x01
                ,0x03
                ,0x82
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
                ,0x00
              };

char map1[] = {
    149,     // registers 149-170
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00
};


// Easily send a byte to a register
void send(int r,int x)
{
    char cmd[2];
    cmd[0]=r;
    cmd[1]=x;
    i2c.write(addr,cmd,2);
}

// Once the map arrays are set up, call this to load the chip with those values
int updatemap(void)
{
    char cmd[5];
    send(3,0xFF);  // disable everything
    cmd[0]=16;
    cmd[1]=cmd[2]=cmd[3]=0x80;
    i2c.write(addr,cmd,4);
    i2c.write(addr,map0,sizeof(map0));  // blow register map to chip
    i2c.write(addr,map1,sizeof(map1));
    send(3,0);  // turn everything back on
    send(177,0xAC);  // reset PLLs

    // To do: ought to make accessors to the map arrays to set different parameters
    return 0; // To do: error checking
}

int main()
{


    // Blink a light so as to not be boring
    updatemap();
    while(1) {

        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
