#include "mbed.h"
#include "ds1621.hpp"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define VERSION 25
//#define DEBUGPF(x) printf((x));
#define DEBUGPF(x)
Serial pc(USBTX,USBRX);


char c='.';
void callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    
    c = pc.getc();
    printf("%c:",c );

    
 }

I2C    i2cT(SDA, SCL);
#define THIST 20
#define NRSENS 2
int main(void) {
    
    i2cT.frequency(100000);
    pc.attach(&callback);
    
    DS1621 digT1(&i2cT,0x90);
    DS1621 digT2(&i2cT,0x96);
    
    DS1621* digT[NRSENS]={&digT1,&digT2};
    float tmpsum[NRSENS];
    float temphist[NRSENS][THIST];
    float digTemp[NRSENS];
    DEBUGPF("init hw done   \n\r");     
    int lc=0;
    while (true) {
        for (int ns=0; ns<NRSENS; ns++) digT[ns]->init_meassure();
        DEBUGPF("init meas ");
        for (int ns=0; ns<NRSENS; ns++) digT[ns]->init_read();
                   
        wait(0.1);
        
        for (int ns=0; ns<NRSENS; ns++){
            digTemp[ns]= digT[ns]->read_T();
            temphist[ns][lc]=digTemp[ns];
            tmpsum[ns]=0;
                for (int  lc2=0; lc2 < THIST;lc2++) {
                    tmpsum[ns]+=temphist[ns][lc2];
            }
            tmpsum[ns]/=THIST;
        }
        switch (c)  {
        case 't' :
                 { for (int ns=0; ns<NRSENS; ns++) {   printf("ch %03d %2.4f %2.4f ",ns,  digTemp[ns], tmpsum[ns] );}
                    printf("\n\r" );
                    
                    }
        break;
        case 'v' : printf("version: %02d compiled date  %s time :%s  \n\r",VERSION,__DATE__,__TIME__);
        break;
        case 'i' : 
        case 'h' :
                    printf("DS1621 readout\n\r");
                    printf("\tt: gives for each channel current temperture\n\r\t\tand average temperature over last 10 sampels, format:\n\r");
                    printf("\t\tt:ch 000 26.5000 26.5000 ch 001 26.0000 26.0000\n\r\tv gives version\n\r");
                    printf("(C) Wim Beaumont Universiteit Antwerpen  Belgium\n\r");
                    printf(" mail : Wim.Beaumont_AT_uantwerpen.be\n\r");
        break;
        default: ;// nothing 
        };
        c='.';
        lc++; if (lc >= THIST) lc=0;
        
    }
}
