/* SWSPI, Software SPI library
 * Copyright (c) 2012-2014, David R. Van Wagner, http://techwithdave.blogspot.com
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 
 
  * modified the software for adapt to the AD9249 ADC  ( bi directional ) with LVDS interface 
  * Software adapted for the SM1 project of the SOLID colaboration 
  * (C) Wim Beaumont Univeristeit Antwerpen  2014 , 2015  
    
 */ 

#include <mbed.h>
#include "SWSPI_BI.h"
#include "S_SCTRL_SM1_hwfunct.h"

#define SWSPI_BI_SRC_VER  "1.50"

/** 
    PARAM
    @misopin pointer to the input / output pin for the data communication
    @rdir_pin  pointer to the output pin that sets the remote LVDS buffer to read / write 
    @ldir_pin  pointer to the output pin that sets the local  LVDS buffer to read / write  
    @sclk_pin  pointer to the output pin that act as the clock signal for the interface 
    
*/
SWSPI_BI::SWSPI_BI(DigitalInOut *msio_pin, DigitalOut *rdir_pin,DigitalOut *ldir_pin, DigitalOut *sclk_pin) 
    :getVersion( SWSPI_BI_HDR_VER , SWSPI_BI_SRC_VER , __TIME__, __DATE__)
{
    
    msio = msio_pin;
    rdir = rdir_pin;
    ldir = ldir_pin;
    sclk = sclk_pin;
    set_bi_spi_mo(1, msio,ldir,rdir);
    
    format(8);
    frequency(500000);
}

SWSPI_BI::~SWSPI_BI()
{
}

void SWSPI_BI::format( int bitsin, int modein ){
    bits = bitsin;
    mode = modein;
    polarity = !((modein >> 1) & 1);
    phase = modein & 1;
    sclk->write(polarity);
}

void SWSPI_BI::frequency(int hz)
{
    this->freq = hz;
}

void  SWSPI_BI::write(unsigned int value, DigitalOut * cs, bool lastdata, int cs_pol,bool nxtrd ){

    // write data to output 
    // assumption is that the cs line was just set from high to low so that the SPI slave is in read mode 
        value= ~value;    
        set_bi_spi_mo(1,msio,ldir,rdir);        
        cs->write(cs_pol); 
        for (int bit = bits-1; bit >= 0; --bit)    {
            msio->write(((value >> bit) & 0x01) != 0);
            if(phase) {   sclk->write(!polarity);   wait(1.0/freq/2); sclk->write(polarity); 
                    if(!bit and nxtrd) set_bi_spi_mo(0,msio,ldir,rdir); // set already to input mode 
                     wait(1.0/freq/2);    }
            else  { wait(1.0/freq/2);  sclk->write(!polarity);  wait(1.0/freq/2);  sclk->write(polarity);      }
          
          
        }
        if( lastdata) {
            set_bi_spi_mo(0,msio,ldir,rdir); 
            cs->write(!cs_pol); 
        }
        else {
        }
}        

unsigned int  SWSPI_BI::read( DigitalOut * cs, bool lastdata, int cs_pol ){
    unsigned int read = 0;    
    set_bi_spi_mo(0,msio,ldir,rdir);        
    cs->write(cs_pol); 
    wait(1.0/freq/2);
    for (int bit = bits-1; bit >= 0; --bit)  {
        if (phase == 0) {
            if (msio->read())  read |= (1 << bit);
               
        }
        sclk->write(!polarity);
        wait(1.0/freq/2);
        if (phase == 1) {
            if (msio->read()) read |= (1 << bit);            
        }

        sclk->write(polarity);
        wait(1.0/freq/2);
    }
    if( lastdata) {    
            cs->write(!cs_pol); 
    }
    // else keep current io config 
   
    
    return ~read;
}

