#include <mbed.h>
/*
 * (C) Wim Beaumont Univeristeit Antwerpen  2014 , 2015
*/ 

#include "AD9249.h"
#include "SWSPI_BI.h"


#define AD9249_SRC_VER  "1.22" 

#define CS_POL 1
#define NCS_POL 0
/*
 const u16 AD9249::configreg=           0x0;
    const u16 AD9249::chip_id_reg=         0x1;
    const u16 AD9249::chip_grade_reg=      0x2;
   // const u16 AD9249::unused_reg= { 0x3, 0x07, 0xA, 0xE, 0xF ,0x11, 0x12,0x13, 0x17, 0x1D, 0x1E, 0x1F,0x20 };
    const u16 AD9249::dev_index2_reg=      0x4;
    const u16 AD9249::dev_index1_reg=      0x4;
    const u16 AD9249::transfer_reg=      0xFF;
    const u16 AD9249::power_mode_reg=      0x8;
    const u16 AD9249::clock_gobal_reg=      0x9;
    const u16 AD9249::clock_divide_reg=      0xB;
    const u16 AD9249::enhancement_ctr_reg=      0xC;
    const u16 AD9249::test_mode_reg=      0xD;
    const u16 AD9249::offset_adj_reg=      0x10;
    const u16 AD9249::output_mode_reg=      0x14;
    const u16 AD9249::output_adj_reg=      0x15;
    const u16 AD9249::output_phase_reg=      0x16;
    const u16 AD9249::vref_reg=      0x18;
    const u16 AD9249::usserpatt1_LSB_reg=      0x19;
    const u16 AD9249::usserpatt1_MSB_reg=      0x1A;
    const u16 AD9249::usserpatt2_LSB_reg=      0x1B;
    const u16 AD9249::usserpatt2_MSB_reg=      0x1C;
    const u16 AD9249::serial_out_cntr_reg=      0x21;
    const u16 AD9249::serial_status_reg=      0x22;
    const u16 AD9249::sample_rate_reg=      0x100;
    const u16 AD9249::user_io_ctr2_reg=      0x101;
    const u16 AD9249::user_io_ctr3_reg=      0x102;
    const u16 AD9249::sync_reg=      0x109;
  */ 


AD9249::AD9249( SWSPI_BI* spi_dev, DigitalOut* csb_pin):getVersion( AD9249_HDR_VER,AD9249_SRC_VER, __TIME__, __DATE__) {  
    spi=spi_dev;csb=csb_pin;
}


AD9249::u32 AD9249::spi_cycle( u16 reg , bool rw , u16 nrbytes, u32 data){
    // format instruction 
        u32 read =0;
        reg = 0x1FFF & reg;  
        if (rw) reg |=0x8000;
        if (nrbytes > 2) return 0; // this function doesn't support stream 
        u32 stnrbytes = (nrbytes-1);
        stnrbytes =stnrbytes  <<13;
        reg|=stnrbytes;  // reg is now the instruction 
        spi->format(16,0); // should make sure the sclk is high 
        printf("send %04X \n\r",reg);
        
    
        
        if (rw) {
            spi->write(reg, csb , false ,CS_POL,true );
            spi->format((nrbytes)*8 ,0);
            read=spi->read(csb , true ,CS_POL );                                        
         }
         else{
            spi->write(reg, csb , false ,CS_POL );
            spi->format((nrbytes)*8 ,0);
            spi->write(data, csb , true ,CS_POL );
            
        }
                
        return read;
    }
    
    
     bool AD9249::getDevInfo(u8&chipid,u8& grade ,u16 &rb ){
            u32 data=spi_cycle( chip_grade_reg, true , 2 , 0);
            rb=data;
            chipid= data & 0XFF;
            grade= (data >> 8) & 0xFF;
            return true;
         }
         
     bool AD9249::getDevId(u8&chipid ){
            bool rv=readReg8(chip_id_reg,chipid); 
            return rv;
         }
     bool AD9249::getGrade(u8&chipid ){          
            bool rv=readReg8(chip_grade_reg,chipid);                       
            return rv;
         }      
  
   bool AD9249::readReg16( u16 regaddr, u16& data){
       u32 datai=spi_cycle( regaddr , true , 2 , 0);
       data=(u16)( datai & 0XFFFF);
       return true;
  }
       
   bool AD9249::readReg8 ( u16 regaddr, u8& data){
        u32 datai=spi_cycle( regaddr, true , 1 , 0);
       data=(u8)( datai & 0XFF);
       return true;
  }         
 
 
         
   bool AD9249::setReg16( u16 regaddr, u16 data){
        u32 datai=spi_cycle( regaddr, false , 2 , (u32)data);
        return true;
    }
    
   bool AD9249::setReg8 ( u16 regaddr, u8 data){
       u32 datai=spi_cycle( regaddr, false , 1 , (u32)data);
       return true;
    }
    
         
    bool AD9249::setPattern1(u16 pattern){
        bool rv=setReg16( usserpatt1_MSB_reg,pattern);
        return rv;
        }
   bool AD9249::setPattern2(u16 pattern){
       bool rv=setReg16( usserpatt2_MSB_reg,pattern);
       return rv;
       }
   
   bool AD9249::readPattern1(u16& pattern){
        bool rv= readReg16( usserpatt1_MSB_reg,pattern);
        return rv;
       }
   bool AD9249::readPattern2(u16& pattern){
         bool rv= readReg16( usserpatt2_MSB_reg,pattern);
        return rv;
       
       }
       
       void AD9249::init1(){}
       void AD9249::init2(){}
