#ifndef ADT7320_H
#define ADT7320_H

/* 
 * class to read the  adt7320 temperature sensor via SPI 
 * 
 * v1.20 implemented float temperature readout 
 *
 * (C) Wim Beaumont Univeristeit Antwerpen  2014 , 2015
*/ 

#include "solid_sctrl_def.h" 
#include "getVersion.h"
#include "SWSPI.h"

#define ADT7320_HDR_VER "1.20" 

class adt7320 : public getVersion{

void set_spi_mode(u8 nrbyte);

private:
    SWSPI* spi;
    DigitalOut* cs;
    
    u8   format_cmd( u8 reg, bool rw);
    u8   getR08( u8 addr);
    void setR08( u8 addr, u8 datain);
    u16  getR16( u8 addr);
    void  setR16( u8 addr, u16 datain);
    u8 Tmode ;
        
public:

    adt7320(SWSPI *spiinterface ,DigitalOut* chipselect );
    float getTemperature();
    u8  getId();
    u16 get_TcritSP();
    void set_TcritSP(u16 tcrit);
    u16 get_T(); //  get the temperature register
    u16 get_hdr_ver();// returns the hdr version nr 
    u16 get_src_ver();// returns the src version nr 
    void init1();
    void init2();
    void serial_line_rst();
   
};




#endif 