#include "adt7320.h"


/* ***************************************************
 * class implementation to read the  adt7320 temperature sensor via SPI 
 *
 * 
 * (C) Wim Beaumont Univeristeit Antwerpen  2014 , 2015

 ************************************************** */



#define  CS_ACTIVE 1
#define  CS_DEACTIVE 0

#define ADT7320_SRC_VER "1.20" 




adt7320::adt7320(SWSPI *spiinterface ,DigitalOut* chipselect )
:getVersion( ADT7320_HDR_VER ,ADT7320_SRC_VER , __TIME__, __DATE__)
{
    spi=spiinterface;
    cs=chipselect;
    Tmode=13 ; // 13 bits temperature reading 
    }

void adt7320::set_spi_mode(u8 nrbyte){
    spi->format(nrbyte,1);
    spi->frequency(10000000);             
}


u8   adt7320::format_cmd( u8 reg, bool rw){
    u8  cmd=0; ;
    reg= reg & 0x7;
    cmd = reg << 3;
    if ( rw)  cmd |= 0x40;  // write bit 6 
    return cmd; 
}    
    


u8   adt7320::getR08( u8 reg){
    set_spi_mode(16);
    u16 data=0x00FF;
    u16 cmd = (u16) format_cmd(reg,true);
    cmd = cmd <<8;
    data= data | cmd;
     cs->write(CS_ACTIVE);
     data= spi->write(data);
     cs->write(CS_DEACTIVE);
     return (u8)(0x00FF &data);         
    
}


void   adt7320::setR08( u8 reg, u8 datain){
    set_spi_mode(16);
    u16 data=0x0000;
    u16 cmd = (u16) format_cmd(reg,false);
    cmd = cmd <<8;
    data= datain | cmd;
    cs->write(CS_ACTIVE);
    data= spi->write(data);
    cs->write(CS_DEACTIVE);    
}

u16   adt7320::getR16( u8 reg){
    set_spi_mode(24);
    u32 data=0x0000FFFF;
    u32 cmd =(u32) format_cmd(reg,true);
    cmd = cmd <<16;
    data= data | cmd;
     cs->write(CS_ACTIVE);
     data= spi->write(data);
     cs->write(CS_DEACTIVE);
     return (u16)(0x0000FFFF &data);             
}

void  adt7320::setR16( u8 reg,u16 datain){
        set_spi_mode(24);
        u32 data=0x00000000;
        u32 cmd =(u32) format_cmd(reg,false);
        cmd = cmd <<16;
        data= datain | cmd;
        cs->write(CS_ACTIVE);
        data= spi->write(data);
        cs->write(CS_DEACTIVE);
}



void adt7320::serial_line_rst() {
    set_spi_mode(32);
        u32 data=0xFFFFFFFF;
        cs->write(CS_ACTIVE);  // needed ? 
        data= spi->write(data);
        cs->write(CS_DEACTIVE);
        set_spi_mode(24);
}



u8  adt7320::getId(){
    return getR08(0x03);
}

u16 adt7320::get_TcritSP(){
    return getR16(0x04);   
}    

void adt7320::set_TcritSP(u16 tcrit){
    
    setR16(0x04,tcrit );   
}    



u16 adt7320::get_T(){
    return getR16(0x02);   
}    


float adt7320::getTemperature(){
    u16 Td = get_T(); bool neg=false;
    if ( Tmode== 13) Td=Td & 0xFFF8;    
    if ( Td & 0x8000 ) { // negative 
        neg =true;         
        Td= ~Td+1;
    }
    float temp = (float)Td /128 ;  // same for 16 and 13 bits mode 
    if( neg     ) temp=-temp;                    

    return temp; 
}    


void adt7320::init1(){}
void adt7320::init2(){}



