/* program to test the hardware connection of the Slow control board 
 * for the SM1 of SOLID
 *
 * v1.x   used for testing first board
 * v2.01    make use of libs and structure for io, not tested with hw. 
 * v2.08    tested with hw, publised used for mod 1 and 2 
 * v2.09    corrected the  command help
 * (C)  2014  W. Beaumont  Universitieit Antwerpen
 */


#include "mbed.h"
#include "S_SCTRL_SM1_PinDef.h"
#include "S_SCTRL_SM1_hwfunct.h" 
#define VERSION  "2.09"
#define RELDATE "19 Sept 2014"
#define ORGANISATION "(C) Universiteit Antwerpen" 
#define AUTHOR  "wim.beaumont@uantwerpen.be" 


Serial pc(USBTX,USBRX);


char c='.';
void callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt  
    c = pc.getc();
    //printf("%c:",c );    
 }



void printhelp(){
    printf("program to test IO lines for the Solid Slow control  \n\r");
    printf("version : %s\n\r%s  %s  \n\rAuthor %s\n\r",VERSION, ORGANISATION,RELDATE,AUTHOR );
    printf("in terminal push t to see the commands\n\r");
    printf("the assigned output will toggle,  z will stop toggling outputs \n\r");
    printf("inputs will be read each cycle,  also the bi directional inputs \n\r");
    printf("no protection for the directions signals (c,d,m,l)  so use with care\n\r");
    printf("startup values:\n\r\tmsio(2) input\n\r\tdirection(2) set to input\n\r\tstio_mo to input (adc output)\n\r");   
    
} 



void printcommands(int consel, DigitalOut* caldir) {
    int localcaldir=caldir->read();
printf("T means toggle output\n\r");
printf("connector 1 or connector 2 signal generation \n\r");
printf("a: T sclk\tb: T direction\n\r");
printf("c: stio to 1\td: T csb1_1\n\r");
printf("e: T csb2_1\tf: T mosi\n\r");
printf("g: T t_cs\ti: T tc_cs1\n\r");
printf("h: help\n\r");
printf("j: T tc_cs2\tk: T dac_cs\n\r");
printf("l: T dac_rst\tm: T cal_13\n\r");
printf("n: T cal_24\to: T genextcal\n\r");
printf("p: set stio to 0\n\r");
printf("\n\rcommon\n\r");
printf("q: sel int cal\tr: sel ext cal\n\r");
printf("s: setdefault direction, cal int \n\r");
printf("u: set STIO of current con to output \n\r");
printf("t: this table\t");
printf("v: version, serialnr ");
printf("x: sel con1\ty: sel con2\n\r");
printf("z: stop toggling\n\r");
printf("con sel=%d cal dir=%d\n\r",consel, localcaldir);

}    
           



int main(){
    
    pc.attach(&callback);// handles the input on the RS232 interface 
     HWlines  hwl ;
    assignports( &hwl );
    DigitalOut* dout = 0; // active signal 
    hwl.ledred->write(1);
    hwl.ledgreen->write(1);
    int consel=1; //active connector
    setdefault(hwl);
    printhelp();
    while (true) {
        int con_idx=consel-1;
        if( con_idx <0 or con_idx>1 ){ printf("no valid connector %d\n\r",consel); continue;}
        
        switch( c) {
                case 'a'    : dout=hwl.sclk[con_idx];     break;
                case 'b'    : dout=hwl.direction[con_idx];    break;
                case 'c'    : dout=NULL; hwl.msio[con_idx]->write(1);    break;
                case 'd'    : dout=hwl.csb1[con_idx];  break;
                case 'e'    : dout=hwl.csb2[con_idx];  break;
                case 'f'    : dout=hwl.mosi[con_idx];  break;
                case 'g'    : dout=hwl.t_cs[con_idx];  break;
                case 'i'    : dout=hwl.tc_cs1[con_idx];  break; 
                case 'j'    : dout=hwl.tc_cs2[con_idx];  break; 
                case 'k'    : dout=hwl.dac_cs[con_idx];  break; 
                case 'l'    : dout=hwl.dac_rst[con_idx];  break; 
                case 'm'    : dout=hwl.cal13[con_idx];  break; 
                case 'n'    : dout=hwl.cal24[con_idx];  break; 
                case 'o'    : dout=hwl.calgenext;  break; 
                 case 'p'    : dout=NULL; hwl.msio[con_idx]->write(0);    break;
                default :    break;
                
                
                
                
            }
        
            
        //common 
        switch( c) {        
            case 'h'    : printhelp();wait(5);
            case 'q'    : setcalsource(0,hwl); break; 
            case 'r'    : setcalsource(1,hwl); break; 
            case 's'    : setdefault(hwl); break;
            case 't'    : printcommands(consel, hwl.calint[0] ); wait(5);break;
            case 'u'    : set_bi_spi_mo(1,hwl.msio[con_idx],hwl.stio_mo[con_idx],hwl.direction[con_idx]);
                          break;
            case 'v'    : printf ("version %s  comiled at %s %s\n\r" , VERSION,__DATE__,__TIME__);
                          printf("%s",hwfunct_lib_version());
                          printf("board serialnr = %d\n\r", get_serialnr(  &hwl ));
                          wait(2);
                        break;
            case 'x'    : consel=1;break;
            case 'y'    : consel=2;break;            
            case 'z'    : dout=NULL;  break;
            
            default :         break;
            };
        c='.';// reset input to default
        if ( dout != NULL ) {   
            *dout = !(*dout); // toggle pin       ;
            //ledgreen!=ledgreen;
        }
        //ledred!=ledred;
        printf( "miso1:%d msio1:%d miso2:%d msio:%d adc1:%f adc2:%f\n\r", 
            hwl.miso[0]->read(),hwl.msio[0]->read(), hwl.miso[1]->read(),
            hwl.msio[1]->read(),hwl.ain[0]->read(),hwl.ain[1]->read() );                

        wait(0.2f);
    }
}