#ifndef S_SCTRL_SM1_hwfunct_H
#define S_SCTRL_SM1_hwfunct_H


#define HW_LIB_HDR_VERSION "1.33"

/* hardware functions 
 * ver 1.0  
 * ver 1.1x   connectors signal working   
 * ver 1.20   added serialnr read
 * ver 1.31   added CAL line lvl  function   
 * ver 1.32  added bias2dac voltage  and dac2bias
 * ver 1.33  removed bias2dac voltage  and dac2bias
 *
 * (C) Wim Beaumont Univeristeit Antwerpen  2014 , 2015
 */
typedef struct  {
// BI-SPI 
DigitalInOut*  msio[2];
DigitalOut*  sclk[2];
DigitalOut*  direction[2];
DigitalOut*  stio_mo[2];
DigitalOut*   csb1[2];
DigitalOut*   csb2[2];

// SPI pins
DigitalOut*  mosi[2]; 
DigitalIn* miso[2]; 
DigitalOut*  t_cs[2];
DigitalOut*  tc_cs1[2];
DigitalOut*  tc_cs2[2];
DigitalOut*   dac_cs[2];
DigitalOut*   dac_rst[2];

//cal 
DigitalOut*   cal13[2]; // physical the same so will point to the same port
DigitalOut*   cal24[2]; // physical the same so will point to the same port
DigitalOut*   calint[2];
// not related to connector 1 /2 
DigitalOut*   calext; 
DigitalOut*   calgenext;

DigitalOut*  ledred;
DigitalOut*  ledgreen;

DigitalIn* snr[5];



AnalogIn*  ain[2];
} HWlines;

void assignports(HWlines  *hwlines );    
void setcalsource( int extcal, HWlines hwl);    
void set_bi_spi_mo(int masterout, DigitalInOut* msio, DigitalOut* ldir, DigitalOut* rdir);
void setdefault(HWlines hwl ) ;
char*   hwfunct_lib_version(); // returns this lib version info    
int get_serialnr(HWlines  *hwlines ); // get the electronic serial nr of the board

// generate a cal pulse, duration 10us  
// no connector selection parameter as these signals a common for both connectors  
// @PARAM HWlines  structure of the hardware line 
// @PARAM calline  , 0 fire both ( processor minimum delay , 1 for CAL signal 1& 3, 2 for CAL signal 2&4
void toggle_cal(HWlines  hwl, int calline);
// set the cal line ( to the FED ) active or not active
// no connector selection parameter as these signals a common for both connectors  
// @PARAM HWlines  structure of the hardware line 
// @PARAM calline  , 0 fire both ( processor minimum delay , 1 for CAL signal 1& 3, 2 for CAL signal 2&4
// @PARAM level   if level = 1 CAL signal is set to active else set to deactive 
void set_cal_line(HWlines  hwl, int calline ,int level );

#endif    